/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.persistence;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import oracle.ide.persistence.StorageFile;

final class DataPage {
    int _address;
    int _nstag;
    byte _tag;
    byte[] _buffer;
    byte _flags;
    int _sz;
    int _idxlpge;
    int _fullsize;
    int _nidxs;
    int _nextidx;
    int[] _idxs;
    private static final byte ISFIRST = 1;
    private static final byte ISPGINDEXMAP = 2;

    DataPage(int address, byte[] datas) {
        int cp = 10;
        this._address = address;
        this._tag = datas[0];
        this._flags = datas[1];
        this._nstag = StorageFile.intFromArray(datas, 2);
        this._sz = StorageFile.intFromArray(datas, 6);
        if ((this._flags & 1) != 0) {
            this._idxlpge = StorageFile.intFromArray(datas, 10);
            this._fullsize = StorageFile.intFromArray(datas, 14);
            cp = 18;
        }
        this._buffer = new byte[this._sz];
        System.arraycopy(datas, cp, this._buffer, 0, this._sz);
        cp += this._sz;
        if ((this._flags & 2) != 0) {
            this._nidxs = StorageFile.intFromArray(datas, cp);
            this._nextidx = StorageFile.intFromArray(datas, cp += 4);
            cp += 4;
            this._idxs = new int[this._nidxs];
            int i = 0;
            while (i < this._nidxs) {
                this._idxs[i] = StorageFile.intFromArray(datas, cp);
                cp += 4;
                ++i;
            }
        }
    }

    DataPage() {
    }

    static DataPage getPageFromStorage(StorageFile store, int addr) throws IOException {
        byte[] buff = new byte[1024];
        store.readBytesFromOffset(buff, addr * 1024);
        return new DataPage(addr, buff);
    }

    private static void freePageGroup(StorageFile store, int addr, boolean deleteFirst) throws IOException {
        DataPage firstPage;
        DataPage idxPage = firstPage = DataPage.getPageFromStorage(store, addr);
        if (firstPage._idxlpge != addr) {
            idxPage = DataPage.getPageFromStorage(store, firstPage._idxlpge);
        }
        while (idxPage != null) {
            int i = 0;
            while (i < idxPage._nidxs) {
                if (deleteFirst || idxPage._idxs[i] != addr) {
                    store.releasePage(idxPage._idxs[i]);
                }
                ++i;
            }
            idxPage = idxPage._nextidx != 0 ? DataPage.getPageFromStorage(store, idxPage._nextidx) : null;
        }
    }

    static ArrayList getPageGroup(int namegroup, int addr) {
        ArrayList<DataPage> grp = new ArrayList<DataPage>();
        DataPage cp = new DataPage();
        grp.add(cp);
        cp._flags = (byte)(cp._flags | 1);
        cp._nstag = namegroup;
        cp._address = addr;
        cp._buffer = new byte[1006];
        cp._tag = (byte)3;
        return grp;
    }

    static OutputStream newPageGroup(StorageFile store, int namegroup, int addr) {
        return new BlobWriter(store, namegroup, addr);
    }

    static OutputStream updatePageGroup(StorageFile store, int namegroup, int addr) throws IOException {
        DataPage.freePageGroup(store, addr, false);
        return new BlobWriter(store, namegroup, addr);
    }

    static InputStream readPageGroup(StorageFile store, int addr) throws IOException {
        DataPage fp = null;
        if (addr != 0) {
            fp = DataPage.getPageFromStorage(store, addr);
        }
        BlobReader br = new BlobReader(store, fp);
        return br;
    }

    static byte[] readFullPageGroup(StorageFile store, int addr) throws IOException {
        DataPage fp = DataPage.getPageFromStorage(store, addr);
        byte[] buff = new byte[fp._fullsize];
        BlobReader br = new BlobReader(store, fp);
        try {
            br.read(buff);
        }
        finally {
            try {
                br.close();
            }
            catch (IOException ex) {}
        }
        return buff;
    }

    static void deletePageGroup(StorageFile store, int addr) throws IOException {
        DataPage.freePageGroup(store, addr, true);
    }

    static void writeBytesToGroup(StorageFile store, int namegroup, ArrayList group, byte[] datas) {
        DataPage.writeBytesToGroup(store, namegroup, group, datas, 0, datas.length);
    }

    static void writeBytesToGroup(StorageFile store, int namegroup, ArrayList group, byte[] datas, int offset, int len) {
        DataPage cpg = (DataPage)group.get(group.size() - 1);
        while (len > cpg.availableBytes()) {
            int avail = cpg.availableBytes();
            System.arraycopy(datas, offset, cpg._buffer, cpg._sz, avail);
            offset += avail;
            cpg._sz += avail;
            len -= avail;
            cpg = new DataPage();
            group.add(cpg);
            cpg._nstag = namegroup;
            cpg._address = store.getFreePage();
            cpg._buffer = new byte[1014];
            cpg._tag = (byte)3;
        }
        System.arraycopy(datas, offset, cpg._buffer, cpg._sz, len);
        cpg._sz += len;
    }

    static void writeByteToGroup(StorageFile store, int namegroup, ArrayList group, int val) {
        DataPage cpg = (DataPage)group.get(group.size() - 1);
        while (1 > cpg.availableBytes()) {
            cpg = new DataPage();
            group.add(cpg);
            cpg._nstag = namegroup;
            cpg._address = store.getFreePage();
            cpg._buffer = new byte[1014];
            cpg._tag = (byte)3;
        }
        cpg._buffer[cpg._sz] = (byte)(val & 0xFF);
        ++cpg._sz;
    }

    static void finalizeGroup(StorageFile store, int namegroup, ArrayList group) {
        int idxAvail;
        DataPage cpg = (DataPage)group.get(group.size() - 1);
        int lpindex = group.size() - 1;
        int needed = group.size();
        int avail = cpg.availableBytes();
        DataPage curpage = cpg;
        if (avail < 12) {
            idxAvail = 0;
            curpage = null;
            ++lpindex;
        } else {
            idxAvail = (avail - 8) / 4;
            curpage._idxs = new int[idxAvail];
        }
        while (needed > idxAvail) {
            needed -= idxAvail;
            DataPage newPage = new DataPage();
            group.add(newPage);
            ++needed;
            newPage._nstag = namegroup;
            newPage._flags = (byte)(newPage._flags | 2);
            newPage._address = store.getFreePage();
            if (curpage != null) {
                curpage._nextidx = newPage._address;
            } else {
                cpg = newPage;
            }
            curpage = newPage;
            avail = 1014;
            idxAvail = (avail - 8) / 4;
            newPage._idxs = new int[idxAvail];
        }
        DataPage firstPage = (DataPage)group.get(0);
        firstPage._idxlpge = cpg._address;
        curpage = cpg;
        curpage._flags = (byte)(curpage._flags | 2);
        int inpage = 0;
        int i = 0;
        while (i < group.size()) {
            DataPage pg = (DataPage)group.get(i);
            firstPage._fullsize += pg._sz;
            if (inpage >= curpage._idxs.length) {
                curpage = (DataPage)group.get(++lpindex);
                curpage._flags = (byte)(curpage._flags | 2);
                inpage = 0;
            }
            ++curpage._nidxs;
            curpage._idxs[inpage++] = pg._address;
            ++i;
        }
    }

    static void saveGroup(StorageFile store, ArrayList group) throws IOException {
        int i = 0;
        while (i < group.size()) {
            DataPage datapage = (DataPage)group.get(i);
            datapage.saveToStorage(store);
            ++i;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("NameGroup : ");
        sb.append(this._nstag);
        sb.append(" DataSize : ");
        sb.append(this._sz);
        if ((this._flags & 1) != 0) {
            sb.append(" MapIdx : ");
            sb.append(this._idxlpge);
            sb.append(" FullSize : ");
            sb.append(this._fullsize);
        }
        if ((this._flags & 2) != 0) {
            sb.append(" Nidx : ");
            sb.append(this._nidxs);
            sb.append(" Next : ");
            sb.append(this._nextidx);
            sb.append("\n    Map : ");
            int i = 0;
            while (i < this._nidxs) {
                sb.append(this._idxs[i]);
                sb.append(", ");
                ++i;
            }
        }
        return sb.toString();
    }

    void saveToStorage(StorageFile store) throws IOException {
        int hsize = 10;
        if ((this._flags & 1) != 0) {
            hsize += 8;
        }
        byte[] buff = new byte[hsize];
        buff[0] = 3;
        buff[1] = this._flags;
        StorageFile.intToArray(this._nstag, buff, 2);
        StorageFile.intToArray(this._sz, buff, 6);
        if ((this._flags & 1) != 0) {
            StorageFile.intToArray(this._idxlpge, buff, 10);
            StorageFile.intToArray(this._fullsize, buff, 14);
        }
        int coff = this._address * 1024;
        store.writeBytesFromOffset(buff, coff);
        coff += hsize;
        if (this._sz != 0) {
            store.writeBytesFromOffset(this._buffer, 0, this._sz, coff);
            coff += this._sz;
        }
        if ((this._flags & 2) != 0) {
            buff = new byte[8 + this._nidxs * 4];
            int cp = 0;
            StorageFile.intToArray(this._nidxs, buff, cp);
            StorageFile.intToArray(this._nextidx, buff, cp += 4);
            cp += 4;
            int i = 0;
            while (i < this._nidxs) {
                StorageFile.intToArray(this._idxs[i], buff, cp);
                cp += 4;
                ++i;
            }
            store.writeBytesFromOffset(buff, coff);
        }
    }

    private int availableBytes() {
        return this._buffer.length - this._sz;
    }

    static class BlobReader
    extends InputStream {
        private DataPage _cdp;
        private DataPage _cip;
        private int _curOfs;
        private int _curIdx;
        private StorageFile _store;

        BlobReader(StorageFile store, DataPage fp) {
            this._store = store;
            this._cdp = fp;
            this._curOfs = 0;
            this._curIdx = 1;
        }

        private void getNextPage() throws IOException {
            if (this._cip == null) {
                this._cip = this._cdp;
                if (this._cdp != null && this._cdp._idxlpge != this._cdp._address) {
                    this._cip = DataPage.getPageFromStorage(this._store, this._cdp._idxlpge);
                }
            }
            if (this._curIdx == this._cip._nidxs) {
                if (this._cip._nextidx == 0) {
                    this._cdp = null;
                    return;
                }
                this._cip = DataPage.getPageFromStorage(this._store, this._cip._nextidx);
                this._curIdx = 0;
            }
            if ((this._cip._flags & 2) == 0 || this._cip._idxs == null) {
                throw new IOException("Invalid index map page: " + this._cip.toString());
            }
            this._cdp = DataPage.getPageFromStorage(this._store, this._cip._idxs[this._curIdx]);
            this._curOfs = 0;
            if (this._cdp._sz == 0) {
                this._cdp = null;
            }
            ++this._curIdx;
        }

        public int read() throws IOException {
            while (this._cdp != null) {
                int avail = this._cdp._sz - this._curOfs;
                if (1 <= avail) {
                    int res = this._cdp._buffer[this._curOfs] & 0xFF;
                    ++this._curOfs;
                    return res;
                }
                this.getNextPage();
            }
            return -1;
        }

        public int read(byte[] buff, int offs, int len) throws IOException {
            int sofar = 0;
            if (this._cdp == null) {
                return -1;
            }
            do {
                int avail;
                if (len <= (avail = this._cdp._sz - this._curOfs)) {
                    System.arraycopy(this._cdp._buffer, this._curOfs, buff, offs, len);
                    this._curOfs += len;
                    return sofar += len;
                }
                System.arraycopy(this._cdp._buffer, this._curOfs, buff, offs, avail);
                sofar += avail;
                len -= avail;
                offs += avail;
                this.getNextPage();
            } while (this._cdp != null);
            return sofar;
        }
    }

    static class BlobWriter
    extends OutputStream {
        private int _nameSpace;
        private StorageFile _store;
        private ArrayList _blobMap;
        private boolean _closed;

        BlobWriter(StorageFile store, int nameSpace, int addr) {
            this._blobMap = DataPage.getPageGroup(nameSpace, addr);
            this._store = store;
            this._nameSpace = nameSpace;
            this._closed = false;
        }

        public void write(int b) throws IOException {
            if (this._closed) {
                throw new IOException("Storage Stream closed");
            }
            DataPage.writeByteToGroup(this._store, this._nameSpace, this._blobMap, b);
        }

        public void write(byte[] buff, int ofs, int len) throws IOException {
            if (this._closed) {
                throw new IOException("Storage Stream closed");
            }
            DataPage.writeBytesToGroup(this._store, this._nameSpace, this._blobMap, buff, ofs, len);
        }

        public void close() throws IOException {
            if (this._closed) {
                throw new IOException("Storage Stream already closed");
            }
            DataPage.finalizeGroup(this._store, this._nameSpace, this._blobMap);
            DataPage.saveGroup(this._store, this._blobMap);
        }
    }
}

