/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.persistence;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import oracle.ide.persistence.NameSpace;
import oracle.ide.persistence.UniqueIdFactory;

class CrossIndex {
    private UniqueIdFactory _uid;
    private NameSpace _directNS;
    private NameSpace _reverseNS;
    private char _sep;
    private String[] _directPool;
    private int _directPoolSize;
    private String[] _reversePool;
    private int _reversePoolSize;
    private HashMap _keyMap;
    private static final int DPOOLSIZE = 200;
    private static final int RPOOLSIZE = 150000;
    private String SEPS;
    private int total;

    CrossIndex(String suid, String s) {
        this.$init$();
        this._sep = (char)124;
        this._uid = new UniqueIdFactory(suid + "_UID", '|');
        this._directNS = NameSpace.getNameSpace(s + "_DAT_D");
        this._reverseNS = NameSpace.getNameSpace(s + "_DAT_R");
        this._directPool = new String[200];
        this._reversePool = new String[150000];
        this._keyMap = new HashMap();
    }

    private void flushDirectPool() {
        System.out.println(">> Flushing " + this._directPoolSize + " records in direct pool ");
        Arrays.sort(this._directPool, 0, this._directPoolSize);
        int i = 0;
        while (i < this._directPoolSize) {
            this._directNS.putRecord(this._directPool[i], null);
            ++i;
        }
        System.out.println("<< done");
        this._directPoolSize = 0;
    }

    private void addInDirectPool(String s) {
        if (this._directPoolSize == 200) {
            this.flushDirectPool();
        }
        this._directPool[this._directPoolSize++] = s;
    }

    private void flushReversePool() {
        System.out.println(">> Flushing " + this._reversePoolSize + " records in reverse pool ");
        Arrays.sort(this._reversePool, 0, this._reversePoolSize);
        int i = 0;
        while (i < this._reversePoolSize) {
            this._reverseNS.putRecord(this._reversePool[i], null);
            ++i;
        }
        System.out.println("<< done");
        this._reversePoolSize = 0;
    }

    private void addInReversePool(String s) {
        if (this._reversePoolSize == 150000) {
            this.flushReversePool();
        }
        this._reversePool[this._reversePoolSize++] = s;
    }

    private String getKeyUid(String s) {
        String res = (String)this._keyMap.get(s);
        if (res == null) {
            res = this._uid.getUID(s);
            this._keyMap.put(s, res);
        }
        return res;
    }

    private HashSet getFileKeys(String fname) {
        String fuid = this._uid.getUID(fname);
        HashSet<String> res = new HashSet<String>();
        Iterator<String> it = this._directNS.getKeyIterator(fuid + this._sep);
        while (it.hasNext()) {
            String k = it.next();
            StringTokenizer st = new StringTokenizer(k, "|", false);
            fuid = st.nextToken();
            while (st.hasMoreTokens()) {
                String kuid = st.nextToken();
                res.add(kuid);
            }
            this._directNS.delRecord(k);
        }
        return res;
    }

    void printKeyRef(String key) {
        String kuid = this._uid.getUID(key);
        Iterator<String> it = this._reverseNS.getKeyIterator(kuid + this._sep);
        System.out.println(" key [" + key + "] in : -------");
        while (it.hasNext()) {
            String k = it.next();
            int ind = k.indexOf(this._sep);
            String fuid = k.substring(ind + 1);
            System.out.println(this._uid.keyFromUID(fuid));
        }
    }

    private void $init$() {
        this.SEPS = " \t\r\n1234567890!@#$%^&*()|\\/+-=\"'<>,.;':{}[]?";
        this.total = 0;
    }

    void parseFile(String s) {
        HashSet oldones = this.getFileKeys(s);
        HashSet<String> hs = new HashSet<String>();
        try {
            BufferedReader br = new BufferedReader(new FileReader(s));
            String line = br.readLine();
            while (line != null) {
                StringTokenizer st = new StringTokenizer(line, this.SEPS, false);
                while (st.hasMoreTokens()) {
                    hs.add(st.nextToken());
                }
                line = br.readLine();
            }
            br.close();
            HashSet<String> newones = new HashSet<String>();
            String fuid = this._uid.getUID(s);
            Iterator it = hs.iterator();
            this.total += hs.size();
            StringBuffer sb = new StringBuffer(6 * hs.size());
            sb.append(fuid);
            while (it.hasNext()) {
                String key = (String)it.next();
                String kuid = this.getKeyUid(key);
                newones.add(kuid);
                sb.append(this._sep);
                sb.append(kuid);
                if (oldones.contains(kuid)) continue;
                this.addInReversePool(kuid + this._sep + fuid);
            }
            this.addInDirectPool(sb.toString());
            for (String kuid : oldones) {
                if (newones.contains(kuid)) continue;
                this._reverseNS.delRecord(kuid + this._sep + fuid);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void parseDirectory(String s) {
        HashSet<String> hs = new HashSet<String>();
        try {
            File f = new File(s);
            File[] childs = f.listFiles();
            if (childs != null) {
                int i = 0;
                while (i < childs.length) {
                    if (childs[i].isFile() && childs[i].getName().endsWith(".java")) {
                        BufferedReader br = new BufferedReader(new FileReader(childs[i]));
                        String line = br.readLine();
                        while (line != null) {
                            StringTokenizer st = new StringTokenizer(line, this.SEPS, false);
                            while (st.hasMoreTokens()) {
                                hs.add(st.nextToken());
                            }
                            line = br.readLine();
                        }
                        br.close();
                    }
                    ++i;
                }
            }
            String fuid = this._uid.getUID(s);
            Iterator it = hs.iterator();
            this.total += hs.size();
            while (it.hasNext()) {
                String key = (String)it.next();
                String kuid = this.getKeyUid(key);
                this.addInDirectPool(fuid + this._sep + kuid);
                this.addInReversePool(kuid + this._sep + fuid);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void flush() {
        this.flushDirectPool();
        this.flushReversePool();
        this._uid.flush();
        this._directNS.flush();
        this._reverseNS.flush();
    }
}

