/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.net;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.ide.natives.DirectoryWatcher;
import oracle.ide.natives.NativeHandler;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemHelper;
import oracle.ide.net.URLFileSystemHelperDecorator;
import oracle.ide.net.URLFileSystemListener;
import oracle.ide.net.URLFilter;
import oracle.ide.persistence.NameSpace;
import oracle.javatools.assembly.AssemblyException;
import oracle.javatools.assembly.AssemblyFactory;
import oracle.javatools.assembly.ObjectArrayFactory;
import oracle.javatools.assembly.ObjectFactory;
import oracle.javatools.assembly.StringFactory;
import oracle.javatools.util.Maps;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VirtualFileSystemHelper
extends URLFileSystemHelperDecorator {
    private static boolean ENABLED;
    private static boolean USE_UNVERIFIED;
    private static boolean SKIP_PERSISTENCE;
    private static boolean CHECK_EXISTENCE;
    private static final boolean VERBOSE_ENTRY;
    private static final boolean VERBOSE_HELPER;
    private static final boolean VERBOSE_WATCHER;
    private static final boolean VERBOSE_LISTENER;
    private static final boolean VERBOSE_PERSIST;
    private static final boolean VERBOSE_CACHE;
    private static final boolean VERBOSE_FILTER;
    private static final String VERBOSE_ENTRY_PREFIX = "VFS/ENTRY: ";
    private static final Object ENABLED_LOCK;
    private static boolean _enabled;
    private static boolean _watcherEnabled;
    private static List<VirtualFileSystemHelper> vfsList;
    private static final String VERBOSE_HELPER_PREFIX = "VFS/HELPER: ";
    private final Collection<URL> _pendingUrlList;
    private final Collection<URL> _disableUrlList;
    private final HashMap<URL, DirectoryWatcher> _urlToWatchMap;
    private final HashSet<URL> _failedURLSet;
    private static final String VERBOSE_WATCHER_PREFIX = "VFS/WATCHER: ";
    private DWListener _listener;
    private static final String VERBOSE_LISTENER_PREFIX = "VFS/LISTENER: ";
    private boolean _loaded;
    private static final String NS_KEY_PREFIX = "$VFSData$";
    private static final String DATA_KEY = "VFSData";
    private static final String VERBOSE_PERSIST_PREFIX = "VFS/PERSIST: ";
    private boolean _isFile;
    private static final String VERBOSE_CACHE_PREFIX = "VFS/CACHE: ";
    private static final DirEntry DIR_NON_EXISTENT;
    private static final URLFileSystem.FileInfo FILE_NON_EXISTENT;
    private static final String VERBOSE_FILTER_PREFIX = "VFS/FILTER: ";
    private final HashMap<URL, Set<Object>> _activeRootMap;
    private static final int CACHE_SIZE = 500;
    private final Map<URL, URL> _activeRootCache;
    private final HashMap<URL, DirEntry> _urlToDirEntryMap;
    private static final int PROCESS_REMOVE = 1;
    private static final int PROCESS_INVALIDATE = 2;
    private static final int PROCESS_UNVERIFIED = 3;
    private static final AssemblyFactory FILE_INFO_FACTORY;
    private static final AssemblyFactory FP_FILE_INFO_FACTORY;
    private static final AssemblyFactory DIR_ENTRY_FACTORY;
    private static final AssemblyFactory FP_DIR_ENTRY_FACTORY;
    private static final AssemblyFactory DIR_ENTRY_ARRAY_FACTORY;
    private static final AssemblyFactory FP_DIR_ENTRY_ARRAY_FACTORY;

    public VirtualFileSystemHelper(URLFileSystemHelper helper) {
        super(helper);
        this.$init$();
        VirtualFileSystemHelper.registerVFS(this);
    }

    static {
        boolean isWindows;
        ENABLED = true;
        USE_UNVERIFIED = false;
        SKIP_PERSISTENCE = false;
        CHECK_EXISTENCE = true;
        String osProperty = System.getProperty("os.name").toLowerCase();
        boolean enableDefault = isWindows = osProperty.indexOf("windows") != -1;
        String enableDefaultString = isWindows ? "true" : "false";
        String property = System.getProperty("VFS_ENABLE", enableDefaultString);
        boolean bl = ENABLED = property != null && Boolean.valueOf(property) != false;
        if (ENABLED != enableDefault) {
            // empty if block
        }
        boolean bl2 = USE_UNVERIFIED = (property = System.getProperty("VFS_USE_UNVERIFIED", "false")) != null && Boolean.valueOf(property) != false;
        if (USE_UNVERIFIED) {
            // empty if block
        }
        boolean bl3 = SKIP_PERSISTENCE = (property = System.getProperty("VFS_SKIP_PERSISTENCE", "false")) != null && Boolean.valueOf(property) != false;
        if (SKIP_PERSISTENCE) {
            // empty if block
        }
        if (CHECK_EXISTENCE = Boolean.valueOf(System.getProperty("VFS_CHECK_EXISTENCE", "false")).booleanValue()) {
            // empty if block
        }
        VERBOSE_ENTRY = Boolean.getBoolean("VFS.VERBOSE_ENTRY");
        VERBOSE_HELPER = Boolean.getBoolean("VFS.VERBOSE_HELPER");
        VERBOSE_WATCHER = Boolean.getBoolean("VFS.VERBOSE_WATCHER");
        VERBOSE_LISTENER = Boolean.getBoolean("VFS.VERBOSE_LISTENER");
        VERBOSE_PERSIST = Boolean.getBoolean("VFS.VERBOSE_PERSIST");
        VERBOSE_CACHE = Boolean.getBoolean("VFS.VERBOSE_CACHE");
        VERBOSE_FILTER = Boolean.getBoolean("VFS.VERBOSE_FILTER");
        ENABLED_LOCK = new Object();
        _enabled = false;
        _watcherEnabled = false;
        vfsList = new ArrayList<VirtualFileSystemHelper>();
        DIR_NON_EXISTENT = new DirEntry(null);
        DirEntry.wa$_dirURL(DIR_NON_EXISTENT, URLFactory.newFileURL((String)"non_existing_directory"));
        DirEntry.wa$_files(DIR_NON_EXISTENT, new URLFileSystem.FileInfo[0]);
        URL fileURL = URLFactory.newFileURL((String)"non_existing_file");
        FILE_NON_EXISTENT = new URLFileSystem.FileInfo(fileURL, 0, 0L, 0L);
        FILE_INFO_FACTORY = new FileInfoFactory(false, null);
        FP_FILE_INFO_FACTORY = new FileInfoFactory(true, null);
        DIR_ENTRY_FACTORY = new DirEntryFactory(false, null);
        FP_DIR_ENTRY_FACTORY = new DirEntryFactory(true, null);
        DIR_ENTRY_ARRAY_FACTORY = new ObjectArrayFactory(DIR_ENTRY_FACTORY);
        FP_DIR_ENTRY_ARRAY_FACTORY = new ObjectArrayFactory(FP_DIR_ENTRY_FACTORY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void enableVFS() {
        if (ENABLED) {
            if (VERBOSE_ENTRY) {
                // empty if block
            }
            Object object = ENABLED_LOCK;
            synchronized (object) {
                _enabled = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void enableNativeWatching() {
        if (ENABLED) {
            if (VERBOSE_ENTRY) {
                // empty if block
            }
            Object object = ENABLED_LOCK;
            synchronized (object) {
                _watcherEnabled = true;
            }
            int numHelpers = vfsList.size();
            int i = 0;
            while (i < numHelpers) {
                VirtualFileSystemHelper vfsHelper = vfsList.get(i);
                vfsHelper.updateDirectoryTracking();
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void shutdownVFS() {
        if (ENABLED) {
            if (VERBOSE_ENTRY) {
                // empty if block
            }
            Object object = ENABLED_LOCK;
            synchronized (object) {
                _enabled = false;
            }
            int numHelpers = vfsList.size();
            int i = 0;
            while (i < numHelpers) {
                VirtualFileSystemHelper vfsHelper = vfsList.get(i);
                vfsHelper.saveDirData();
                ++i;
            }
        }
    }

    public static synchronized void invalidateDirectory(URL dirURL) {
        VirtualFileSystemHelper.invalidateDirectoryImpl(dirURL, false);
    }

    public static synchronized void invalidateDirectoryTree(URL rootDirURL) {
        VirtualFileSystemHelper.invalidateDirectoryImpl(rootDirURL, true);
    }

    public static synchronized void setVerifyPersistedData(boolean verify) {
        String property = System.getProperty("VFS_USE_UNVERIFIED");
        if (property != null) {
            return;
        }
        USE_UNVERIFIED = verify ^ true;
    }

    private static synchronized void cacheDirectoryTree(URL rootDirURL, Object cookie) {
        if (ENABLED) {
            VirtualFileSystemHelper vfsHelper;
            if (VERBOSE_ENTRY) {
                // empty if block
            }
            if ((vfsHelper = VirtualFileSystemHelper.findVFSHelper(rootDirURL)) != null) {
                vfsHelper.activateDirectory(rootDirURL, cookie);
                vfsHelper.addToDirectoryTracking(rootDirURL);
            }
        }
    }

    private static synchronized void uncacheDirectoryTree(URL rootDirURL, Object cookie) {
        if (ENABLED) {
            VirtualFileSystemHelper vfsHelper;
            if (VERBOSE_ENTRY) {
                // empty if block
            }
            if ((vfsHelper = VirtualFileSystemHelper.findVFSHelper(rootDirURL)) != null) {
                vfsHelper.deactivateDirectory(rootDirURL, cookie);
                vfsHelper.resyncDirectoryTracking();
            }
        }
    }

    private static void invalidateDirectoryImpl(URL dirURL, boolean recurse) {
        if (ENABLED) {
            VirtualFileSystemHelper vfsHelper;
            if (VERBOSE_ENTRY) {
                // empty if block
            }
            if ((vfsHelper = VirtualFileSystemHelper.findVFSHelper(dirURL)) != null) {
                vfsHelper.invalidateDirEntry(dirURL, recurse);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isEnabled() {
        Object object = ENABLED_LOCK;
        synchronized (object) {
            boolean bl = _enabled;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isWatcherEnabled() {
        Object object = ENABLED_LOCK;
        synchronized (object) {
            boolean bl = _watcherEnabled && NativeHandler.isLoaded();
            return bl;
        }
    }

    private static synchronized void registerVFS(VirtualFileSystemHelper vfsHelper) {
        if (VERBOSE_ENTRY) {
            // empty if block
        }
        vfsList.add(vfsHelper);
    }

    public void delete(URL url) throws IOException {
        if (VERBOSE_HELPER) {
            // empty if block
        }
        if (VirtualFileSystemHelper.isEnabled()) {
            this.disableDirectoryTrackingFor(url, true);
        }
        try {
            this._helper.delete(url);
            if (VirtualFileSystemHelper.isEnabled()) {
                this.removeCachedDirEntry(url);
                this.markParentDirty(url);
            }
        }
        finally {
            if (VirtualFileSystemHelper.isEnabled()) {
                this.updateDirectoryTracking();
            }
        }
    }

    public boolean exists(URL url) {
        URLFileSystem.FileInfo fileInfo;
        if (VERBOSE_HELPER) {
            // empty if block
        }
        if (VirtualFileSystemHelper.isEnabled() && (fileInfo = this.findCachedFileInfo(url)) != null) {
            return fileInfo != FILE_NON_EXISTENT;
        }
        return this._helper.exists(url);
    }

    public long getLength(URL url) {
        URLFileSystem.FileInfo fileInfo;
        if (VERBOSE_HELPER) {
            // empty if block
        }
        if (VirtualFileSystemHelper.isEnabled() && (fileInfo = this.findCachedFileInfo(url)) != null) {
            if (fileInfo == FILE_NON_EXISTENT) {
                return -1;
            }
            return fileInfo.length();
        }
        return this._helper.getLength(url);
    }

    public boolean isDirectory(URL url) {
        URLFileSystem.FileInfo fileInfo;
        if (VERBOSE_HELPER) {
            // empty if block
        }
        if (VirtualFileSystemHelper.isEnabled() && (fileInfo = this.findCachedFileInfo(url)) != null) {
            if (fileInfo == FILE_NON_EXISTENT) {
                return false;
            }
            return fileInfo.isDirectory();
        }
        return this._helper.isDirectory(url);
    }

    public boolean isHidden(URL url) {
        URLFileSystem.FileInfo fileInfo;
        if (VERBOSE_HELPER) {
            // empty if block
        }
        if (VirtualFileSystemHelper.isEnabled() && (fileInfo = this.findCachedFileInfo(url)) != null) {
            if (fileInfo == FILE_NON_EXISTENT) {
                return false;
            }
            return fileInfo.isHidden();
        }
        return this._helper.isHidden(url);
    }

    public boolean isRegularFile(URL url) {
        URLFileSystem.FileInfo fileInfo;
        if (VERBOSE_HELPER) {
            // empty if block
        }
        if (VirtualFileSystemHelper.isEnabled() && (fileInfo = this.findCachedFileInfo(url)) != null) {
            if (fileInfo == FILE_NON_EXISTENT) {
                return false;
            }
            return fileInfo.isFile();
        }
        return this._helper.isRegularFile(url);
    }

    public long lastModified(URL url) {
        URLFileSystem.FileInfo fileInfo;
        if (VERBOSE_HELPER) {
            // empty if block
        }
        if (VirtualFileSystemHelper.isEnabled() && (fileInfo = this.findCachedFileInfo(url)) != null) {
            if (fileInfo == FILE_NON_EXISTENT) {
                return -1;
            }
            return fileInfo.lastModified();
        }
        return this._helper.lastModified(url);
    }

    public URL[] list(URL url) {
        return this.list(url, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL[] list(URL url, URLFilter filter) {
        if (VERBOSE_HELPER) {
            // empty if block
        }
        if (VirtualFileSystemHelper.isEnabled()) {
            ArrayList<URL> results;
            DirEntry foundEntry = this.findOrFetchDirEntry(url);
            if (foundEntry == null || this.isDirEntryNonExistent(foundEntry)) {
                return null;
            }
            DirEntry dirEntry = foundEntry;
            synchronized (dirEntry) {
                int numInfos = DirEntry.ra$_files(foundEntry).length;
                results = new ArrayList<URL>(numInfos);
                int i = 0;
                while (i < numInfos) {
                    results.add(DirEntry.ra$_files(foundEntry)[i].getURL());
                    ++i;
                }
            }
            if (filter != null) {
                Iterator iterator = results.iterator();
                while (iterator.hasNext()) {
                    URL infoUrl = (URL)iterator.next();
                    if (filter.accept(infoUrl)) continue;
                    iterator.remove();
                }
            }
            return results.toArray(new URL[results.size()]);
        }
        return this._helper.list(url, filter);
    }

    public URLFileSystem.FileInfo[] ls(URL url) {
        return this.ls(url, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URLFileSystem.FileInfo[] ls(URL url, URLFilter filter) {
        if (VERBOSE_HELPER) {
            // empty if block
        }
        if (VirtualFileSystemHelper.isEnabled()) {
            ArrayList<URLFileSystem.FileInfo> results;
            DirEntry foundEntry = this.findOrFetchDirEntry(url);
            if (foundEntry == null || this.isDirEntryNonExistent(foundEntry)) {
                return null;
            }
            DirEntry dirEntry = foundEntry;
            synchronized (dirEntry) {
                int numInfos = DirEntry.ra$_files(foundEntry).length;
                results = new ArrayList<URLFileSystem.FileInfo>(numInfos);
                int i = 0;
                while (i < numInfos) {
                    URLFileSystem.FileInfo info = DirEntry.ra$_files(foundEntry)[i];
                    if (info != null) {
                        results.add(info);
                    }
                    ++i;
                }
            }
            if (filter != null) {
                Iterator iterator = results.iterator();
                while (iterator.hasNext()) {
                    URLFileSystem.FileInfo info = (URLFileSystem.FileInfo)iterator.next();
                    if (filter.accept(info.getURL())) continue;
                    iterator.remove();
                }
            }
            return results.toArray(new URLFileSystem.FileInfo[results.size()]);
        }
        return this._helper.ls(url, filter);
    }

    public URLFileSystem.FileInfo[] lsCached(URL url) {
        return this.ls(url);
    }

    public URLFileSystem.FileInfo[] lsCached(URL url, URLFilter filter) {
        return this.ls(url, filter);
    }

    public boolean mkdir(URL url) {
        if (VERBOSE_HELPER) {
            // empty if block
        }
        boolean success = this._helper.mkdir(url);
        if (VirtualFileSystemHelper.isEnabled() && success) {
            this.markParentDirty(url);
            this.updateDirectoryTracking();
        }
        return success;
    }

    public boolean mkdirs(URL url) {
        if (VERBOSE_HELPER) {
            // empty if block
        }
        boolean success = this._helper.mkdirs(url);
        if (VirtualFileSystemHelper.isEnabled() && success) {
            this.markClosestParentDirty(url);
            this.updateDirectoryTracking();
        }
        return success;
    }

    public URL createTempFile(String prefix, String suffix, URL directory) throws IOException {
        return this._helper.createTempFile(prefix, suffix, directory);
    }

    public OutputStream openOutputStream(URL url) throws IOException {
        if (VERBOSE_HELPER) {
            // empty if block
        }
        OutputStream os = this._helper.openOutputStream(url);
        if (VirtualFileSystemHelper.isEnabled() && os != null) {
            this.markClosestParentDirty(url);
        }
        return os;
    }

    public void rename(URL oldURL, URL newURL) throws IOException {
        if (VERBOSE_HELPER) {
            // empty if block
        }
        if (VirtualFileSystemHelper.isEnabled()) {
            this.disableDirectoryTrackingFor(oldURL, true);
        }
        try {
            this._helper.rename(oldURL, newURL);
            if (VirtualFileSystemHelper.isEnabled()) {
                this.removeCachedDirEntry(oldURL);
                this.markParentDirty(oldURL);
                this.markClosestParentDirty(newURL);
            }
        }
        finally {
            if (VirtualFileSystemHelper.isEnabled()) {
                this.updateDirectoryTracking();
            }
        }
    }

    public boolean setLastModified(URL url, long time) {
        if (VERBOSE_HELPER) {
            // empty if block
        }
        boolean success = this._helper.setLastModified(url, time);
        if (VirtualFileSystemHelper.isEnabled() && success) {
            this.markParentDirty(url);
        }
        return success;
    }

    public boolean setReadOnly(URL url, boolean readOnly) {
        if (VERBOSE_HELPER) {
            // empty if block
        }
        boolean success = this._helper.setReadOnly(url, readOnly);
        if (VirtualFileSystemHelper.isEnabled() && success) {
            this.markParentDirty(url);
        }
        return success;
    }

    public void addURLFileSystemListener(URL rootURL, URLFileSystemListener listener) {
        VirtualFileSystemHelper.cacheDirectoryTree(rootURL, listener);
        this._helper.addURLFileSystemListener(rootURL, listener);
    }

    public void removeURLFileSystemListener(URL rootURL, URLFileSystemListener listener) {
        VirtualFileSystemHelper.uncacheDirectoryTree(rootURL, listener);
        this._helper.removeURLFileSystemListener(rootURL, listener);
    }

    private void $init$() {
        this._pendingUrlList = new HashSet<URL>();
        this._disableUrlList = new HashSet<URL>();
        this._urlToWatchMap = new HashMap(50);
        this._failedURLSet = new HashSet();
        this._listener = new DWListener(null);
        this._loaded = false;
        this._isFile = false;
        this._activeRootMap = new HashMap(50);
        this._activeRootCache = new Maps.CacheMap(500, Maps.CacheMap.NONCANONICAL);
        this._urlToDirEntryMap = new HashMap(1000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToDirectoryTracking(URL dirURL) {
        if (VERBOSE_WATCHER) {
            // empty if block
        }
        Collection<URL> collection = this._pendingUrlList;
        synchronized (collection) {
            this._pendingUrlList.add(dirURL);
        }
        this.updateDirectoryTracking();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resyncDirectoryTracking() {
        if (VERBOSE_WATCHER) {
            // empty if block
        }
        URL[] activeURLs = this.getActiveDirectories();
        Collection<URL> collection = this._pendingUrlList;
        synchronized (collection) {
            Collection<URL> collection2 = this._disableUrlList;
            synchronized (collection2) {
                HashMap<URL, DirectoryWatcher> hashMap = this._urlToWatchMap;
                synchronized (hashMap) {
                    ArrayList<URL> activeList = new ArrayList<URL>(Arrays.asList(activeURLs));
                    HashSet<URL> watchList = new HashSet<URL>();
                    watchList.addAll(this._pendingUrlList);
                    watchList.addAll(this._disableUrlList);
                    watchList.addAll(this._failedURLSet);
                    watchList.addAll(this._urlToWatchMap.keySet());
                    HashSet<URL> removeList = watchList;
                    removeList.removeAll(activeList);
                    for (URL url : removeList) {
                        if (VERBOSE_WATCHER) {
                            // empty if block
                        }
                        this.disableDirectoryTrackingFor(url, false);
                    }
                    this._pendingUrlList.removeAll(removeList);
                    this._disableUrlList.removeAll(removeList);
                    this._failedURLSet.removeAll(removeList);
                }
            }
        }
    }

    private void updateDirectoryTracking() {
        if (VERBOSE_WATCHER) {
            // empty if block
        }
        if (!VirtualFileSystemHelper.isWatcherEnabled() || !this.isFileProtocol()) {
            return;
        }
        if (VERBOSE_WATCHER) {
            // empty if block
        }
        this.enableDirectoryTrackingFor(this._pendingUrlList);
        if (VERBOSE_WATCHER) {
            // empty if block
        }
        this.enableDirectoryTrackingFor(this._disableUrlList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enableDirectoryTrackingFor(Collection<URL> urlList) {
        if (VERBOSE_WATCHER) {
            // empty if block
        }
        Collection<URL> collection = urlList;
        synchronized (collection) {
            if (urlList.isEmpty()) {
                return;
            }
            Iterator<URL> iterator = urlList.iterator();
            while (iterator.hasNext()) {
                this.enableDirectoryTrackingFor(iterator.next());
            }
            urlList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enableDirectoryTrackingFor(URL dirURL) {
        if (this._urlToWatchMap.containsKey(dirURL)) {
            if (VERBOSE_WATCHER) {
                // empty if block
            }
            HashSet<URL> hashSet = this._failedURLSet;
            synchronized (hashSet) {
                this._failedURLSet.remove(dirURL);
            }
            return;
        }
        DirectoryWatcher watcher = DirectoryWatcher.createDirectoryWatcher(dirURL, this._listener);
        if (watcher != null) {
            if (VERBOSE_WATCHER) {
                // empty if block
            }
            HashMap<URL, DirectoryWatcher> hashMap = this._urlToWatchMap;
            synchronized (hashMap) {
                this._urlToWatchMap.put(dirURL, watcher);
            }
            HashSet<URL> hashSet = this._failedURLSet;
            synchronized (hashSet) {
                this._failedURLSet.remove(dirURL);
            }
        }
        if (VERBOSE_WATCHER) {
            // empty if block
        }
        HashSet<URL> hashSet = this._failedURLSet;
        synchronized (hashSet) {
            this._failedURLSet.add(dirURL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disableDirectoryTrackingFor(URL dirURL, boolean includeNested) {
        DirectoryWatcher watcher;
        if (!URLFileSystem.isDirectoryPath((URL)dirURL)) {
            return;
        }
        if (VERBOSE_WATCHER) {
            // empty if block
        }
        int disabledCount = 0;
        HashMap<URL, DirectoryWatcher> hashMap = this._urlToWatchMap;
        synchronized (hashMap) {
            watcher = this._urlToWatchMap.remove(dirURL);
        }
        if (watcher != null) {
            this.disableDirectoryWatcher(watcher);
            ++disabledCount;
        }
        if (includeNested) {
            HashMap<URL, DirectoryWatcher> hashMap2 = this._urlToWatchMap;
            synchronized (hashMap2) {
                Iterator<URL> enabledIterator = this._urlToWatchMap.keySet().iterator();
                while (enabledIterator.hasNext()) {
                    URL checkURL = enabledIterator.next();
                    if (!URLFileSystem.isBaseURLFor((URL)dirURL, (URL)checkURL)) continue;
                    watcher = this._urlToWatchMap.get(checkURL);
                    enabledIterator.remove();
                    this.disableDirectoryWatcher(watcher);
                    ++disabledCount;
                }
            }
        }
        if (!VERBOSE_WATCHER || disabledCount == 0) {
            // empty if block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disableDirectoryWatcher(DirectoryWatcher watcher) {
        URL dirURL = watcher.getRootURL();
        if (VERBOSE_WATCHER) {
            // empty if block
        }
        DirectoryWatcher.destroyDirectoryWatcher(watcher);
        Collection<URL> collection = this._disableUrlList;
        synchronized (collection) {
            this._disableUrlList.add(dirURL);
        }
    }

    protected String getNameSpaceKey() {
        return NS_KEY_PREFIX + this._helper.getClass().getName();
    }

    private NameSpace getNameSpace() {
        NameSpace namespace;
        String keyName = this.getNameSpaceKey();
        if (VERBOSE_PERSIST) {
            // empty if block
        }
        if ((namespace = NameSpace.getNameSpace(keyName)) != null || VERBOSE_PERSIST) {
            // empty if block
        }
        return namespace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureDataLoaded() {
        if (!this._loaded && VirtualFileSystemHelper.isEnabled()) {
            HashMap<URL, DirEntry> hashMap = this._urlToDirEntryMap;
            synchronized (hashMap) {
                if (!this._loaded) {
                    this.loadDirData();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDirData() {
        if (VERBOSE_PERSIST) {
            // empty if block
        }
        HashMap<URL, DirEntry> hashMap = this._urlToDirEntryMap;
        synchronized (hashMap) {
            if (!this._loaded) {
                NameSpace namespace;
                this.checkIfIsFileProtocol();
                if (VERBOSE_PERSIST) {
                    // empty if block
                }
                this._urlToDirEntryMap.clear();
                if (!SKIP_PERSISTENCE && (namespace = this.getNameSpace()) != null) {
                    try {
                        long start = System.currentTimeMillis();
                        byte[] data = namespace.getRecord(DATA_KEY);
                        long total = System.currentTimeMillis() - start;
                        if (data != null) {
                            if (VERBOSE_PERSIST) {
                                // empty if block
                            }
                            start = System.currentTimeMillis();
                            Object[] dirEntries = (Object[])(this.isFileProtocol() ? FP_DIR_ENTRY_ARRAY_FACTORY.assemble(data) : DIR_ENTRY_ARRAY_FACTORY.assemble(data));
                            int numEntries = dirEntries != null ? dirEntries.length : 0;
                            int i = 0;
                            while (i < numEntries) {
                                DirEntry dirEntry = (DirEntry)dirEntries[i];
                                if (dirEntry != null) {
                                    URL dirURL = DirEntry.ra$_dirURL(dirEntry);
                                    DirEntry dirEntry2 = dirEntry;
                                    DirEntry.wa$_flags(dirEntry2, (byte)(DirEntry.ra$_flags(dirEntry2) | 4));
                                    this._urlToDirEntryMap.put(dirURL, dirEntry);
                                }
                                ++i;
                            }
                            total = System.currentTimeMillis() - start;
                            if (VERBOSE_PERSIST) {
                                // empty if block
                            }
                        } else if (VERBOSE_PERSIST) {
                            // empty if block
                        }
                    }
                    catch (AssemblyException e) {
                        namespace.delRecord(DATA_KEY);
                        namespace.flush();
                    }
                }
                this._loaded = true;
                this.updateDirectoryTracking();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveDirData() {
        if (VERBOSE_PERSIST) {
            // empty if block
        }
        HashMap<URL, DirEntry> hashMap = this._urlToDirEntryMap;
        synchronized (hashMap) {
            if (VERBOSE_PERSIST) {
                // empty if block
            }
            if (!SKIP_PERSISTENCE) {
                try {
                    NameSpace namespace = this.getNameSpace();
                    if (namespace != null) {
                        long start = System.currentTimeMillis();
                        Object[] dirEntries = this._urlToDirEntryMap.values().toArray();
                        byte[] data = this.isFileProtocol() ? FP_DIR_ENTRY_ARRAY_FACTORY.disassemble((Object)dirEntries) : DIR_ENTRY_ARRAY_FACTORY.disassemble((Object)dirEntries);
                        long total = System.currentTimeMillis() - start;
                        if (VERBOSE_PERSIST) {
                            // empty if block
                        }
                        start = System.currentTimeMillis();
                        namespace.putRecord(DATA_KEY, data);
                        namespace.flush();
                        total = System.currentTimeMillis() - start;
                        if (VERBOSE_PERSIST) {
                            // empty if block
                        }
                    }
                }
                catch (AssemblyException e) {
                    // empty catch block
                }
            }
        }
    }

    private boolean isFileProtocol() {
        return this._isFile;
    }

    private void checkIfIsFileProtocol() {
        URLFileSystemHelper fileHelper = URLFileSystem.findHelper((String)"file");
        VirtualFileSystemHelper vfsHelper = VirtualFileSystemHelper.findVFSHelper(fileHelper);
        if (vfsHelper == this) {
            this._isFile = true;
        }
        if (VERBOSE_PERSIST) {
            // empty if block
        }
    }

    private static VirtualFileSystemHelper findVFSHelper(URL url) {
        return VirtualFileSystemHelper.findVFSHelper(URLFileSystem.findHelper((URL)url));
    }

    private static VirtualFileSystemHelper findVFSHelper(URLFileSystemHelper helper) {
        while (true) {
            if (helper instanceof VirtualFileSystemHelper) {
                return (VirtualFileSystemHelper)helper;
            }
            if (!(helper instanceof URLFileSystemHelperDecorator)) break;
            helper = ((URLFileSystemHelperDecorator)helper).getHelper();
        }
        return null;
    }

    private void markDirDirty(URL dirURL) {
        DirEntry foundEntry;
        if (dirURL != null && (foundEntry = this.lookupCacheImpl(dirURL)) != null) {
            this.markDirEntryDirty(foundEntry);
        }
    }

    private void markParentDirty(URL url) {
        URL dirURL;
        if (VERBOSE_CACHE) {
            // empty if block
        }
        if ((dirURL = this.getParent(url)) != null) {
            this.markDirDirty(dirURL);
            URL parentURL = this.getParent(dirURL);
            if (parentURL != null) {
                this.markDirDirty(parentURL);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markClosestParentDirty(URL url) {
        if (VERBOSE_CACHE) {
            // empty if block
        }
        URL currentURL = url;
        HashMap<URL, DirEntry> hashMap = this._urlToDirEntryMap;
        synchronized (hashMap) {
            while (currentURL != null) {
                DirEntry foundEntry = this.lookupCacheImpl(currentURL);
                if (foundEntry != null) {
                    this.markDirEntryDirty(foundEntry);
                    URL parentURL = this.getParent(currentURL);
                    if (parentURL == null) break;
                    this.markDirDirty(parentURL);
                    break;
                }
                currentURL = this.getParent(currentURL);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidateDirEntry(URL dirURL, boolean recurse) {
        if (VERBOSE_CACHE) {
            // empty if block
        }
        HashMap<URL, DirEntry> hashMap = this._urlToDirEntryMap;
        synchronized (hashMap) {
            if (!recurse) {
                DirEntry foundEntry = this.lookupCacheImpl(dirURL);
                if (foundEntry != null) {
                    this.markDirEntryDirty(foundEntry);
                }
            } else {
                this.processChildrenCacheImpl(dirURL, 2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URLFileSystem.FileInfo findCachedFileInfo(URL url) {
        DirEntry dirEntry;
        URL dirURL;
        if (VERBOSE_CACHE) {
            // empty if block
        }
        if ((dirURL = this.getParent(url)) != null && (dirEntry = this.findCachedDirEntry(dirURL)) != null) {
            if (this.isDirEntryNonExistent(dirEntry)) {
                return FILE_NON_EXISTENT;
            }
            DirEntry dirEntry2 = dirEntry;
            synchronized (dirEntry2) {
                URLFileSystem.FileInfo[] infos = DirEntry.ra$_files(dirEntry);
                int numInfos = infos.length;
                int i = 0;
                while (i < numInfos) {
                    if (url.equals(infos[i].getURL())) {
                        if (VERBOSE_CACHE) {
                            // empty if block
                        }
                        URLFileSystem.FileInfo fileInfo = infos[i];
                        return fileInfo;
                    }
                    ++i;
                }
                if (CHECK_EXISTENCE && this.isFileProtocol()) {
                    String dirPath = dirURL.getPath();
                    boolean possibleMatch = false;
                    int i2 = 0;
                    while (i2 < numInfos) {
                        if (dirPath.equalsIgnoreCase(infos[i2].getURL().getPath())) {
                            possibleMatch = true;
                        }
                        ++i2;
                    }
                    if (!possibleMatch) {
                        URLFileSystem.FileInfo fileInfo = FILE_NON_EXISTENT;
                        return fileInfo;
                    }
                }
            }
        }
        return null;
    }

    private boolean couldExist(URL url, URL rootURL) {
        if (this.isFileProtocol()) {
            String path;
            String topPath = rootURL.getPath();
            int barrierLength = topPath.length();
            while ((path = url.getPath()).length() > barrierLength) {
                URL parent = this.getParent(url);
                DirEntry dirEntry = this.lookupCacheImpl(parent);
                if (dirEntry != null) {
                    if (this.isDirEntryValid(dirEntry)) {
                        URLFileSystem.FileInfo[] fileInfos = DirEntry.ra$_files(dirEntry);
                        int length = fileInfos.length;
                        int i = 0;
                        while (i < length) {
                            URLFileSystem.FileInfo fileInfo = fileInfos[i];
                            URL infoUrl = fileInfo.getURL();
                            if (path.equalsIgnoreCase(infoUrl.getPath())) {
                                return true;
                            }
                            ++i;
                        }
                        return false;
                    }
                    return true;
                }
                url = parent;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DirEntry findCachedDirEntry(URL dirURL) {
        URL activeRoot;
        if (VERBOSE_CACHE) {
            // empty if block
        }
        if ((activeRoot = this.getActiveRoot(dirURL)) == null) {
            return null;
        }
        DirEntry foundEntry = this.lookupCacheImpl(dirURL);
        if (foundEntry == null) {
            if (VERBOSE_CACHE) {
                // empty if block
            }
            if (CHECK_EXISTENCE && !this.couldExist(dirURL, activeRoot)) {
                return DIR_NON_EXISTENT;
            }
            return null;
        }
        DirEntry dirEntry = foundEntry;
        synchronized (dirEntry) {
            if (!this.isDirEntryValid(foundEntry)) {
                if (VERBOSE_CACHE) {
                    // empty if block
                }
                DirEntry dirEntry2 = null;
                return dirEntry2;
            }
        }
        if (VERBOSE_CACHE) {
            // empty if block
        }
        return foundEntry;
    }

    private void removeCachedDirEntry(URL dirURL) {
        if (VERBOSE_CACHE) {
            // empty if block
        }
        this.processChildrenCacheImpl(dirURL, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DirEntry findOrFetchDirEntry(URL dirURL) {
        URL reuseURL;
        DirEntry returnEntry;
        URL activeRoot;
        if (VERBOSE_CACHE) {
            // empty if block
        }
        boolean isActiveDir = (activeRoot = this.getActiveRoot(dirURL)) != null;
        DirEntry cachedEntry = this.lookupCacheImpl(dirURL);
        if (isActiveDir) {
            if (cachedEntry != null) {
                DirEntry dirEntry = cachedEntry;
                synchronized (dirEntry) {
                    if (this.isDirEntryValid(cachedEntry)) {
                        if (VERBOSE_CACHE) {
                            // empty if block
                        }
                        DirEntry dirEntry2 = cachedEntry;
                        return dirEntry2;
                    }
                    if (VERBOSE_CACHE) {
                        // empty if block
                    }
                }
            } else if (CHECK_EXISTENCE && !this.couldExist(dirURL, activeRoot)) {
                return null;
            }
        }
        if ((returnEntry = this.fetchDirFromHelper(reuseURL = cachedEntry != null ? DirEntry.ra$_dirURL(cachedEntry) : dirURL)) == null) {
            if (VERBOSE_CACHE) {
                // empty if block
            }
            if (cachedEntry != null) {
                if (VERBOSE_CACHE) {
                    // empty if block
                }
                this.processChildrenCacheImpl(dirURL, 1);
            }
            if (isActiveDir && !activeRoot.equals(dirURL)) {
                DirEntry nonExistentEntry = new DirEntry(null);
                DirEntry.wa$_dirURL(nonExistentEntry, reuseURL);
                DirEntry.wa$_flags(nonExistentEntry, (byte)8);
                DirEntry.wa$_files(nonExistentEntry, DirEntry.ra$_files(DIR_NON_EXISTENT));
                this.storeCacheImpl(nonExistentEntry);
                return nonExistentEntry;
            }
        } else {
            if (VERBOSE_CACHE) {
                // empty if block
            }
            if (isActiveDir || cachedEntry != null) {
                this.storeCacheImpl(returnEntry);
            }
            if (isActiveDir) {
                HashSet<URL> hashSet = this._failedURLSet;
                synchronized (hashSet) {
                    if (this._failedURLSet.contains(dirURL)) {
                        this.enableDirectoryTrackingFor(dirURL);
                    }
                }
            }
            if (cachedEntry != null) {
                if (VERBOSE_CACHE) {
                    // empty if block
                }
                HashSet<URL> oldSet = new HashSet<URL>();
                URLFileSystem.FileInfo[] cachedFileInfos = DirEntry.ra$_files(cachedEntry);
                int numCachedInfos = cachedFileInfos.length;
                int i = 0;
                while (i < numCachedInfos) {
                    URLFileSystem.FileInfo cachedInfo = cachedFileInfos[i];
                    if (cachedInfo.isDirectory()) {
                        oldSet.add(cachedFileInfos[i].getURL());
                    }
                    ++i;
                }
                URLFileSystem.FileInfo[] fetchedFileInfos = DirEntry.ra$_files(returnEntry);
                int numFetchedInfos = fetchedFileInfos.length;
                int i2 = 0;
                while (i2 < numFetchedInfos) {
                    URLFileSystem.FileInfo fetchedInfo = fetchedFileInfos[i2];
                    if (fetchedInfo.isDirectory()) {
                        oldSet.remove(fetchedFileInfos[i2].getURL());
                    }
                    ++i2;
                }
                for (URL obseleteURL : oldSet) {
                    this.processChildrenCacheImpl(obseleteURL, 1);
                    if (!VERBOSE_CACHE) continue;
                }
            }
        }
        return returnEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void activateDirectory(URL rootDirURL, Object cookie) {
        if (VERBOSE_FILTER) {
            // empty if block
        }
        HashMap<URL, Set<Object>> hashMap = this._activeRootMap;
        synchronized (hashMap) {
            Set<Object> cookieSet = this._activeRootMap.get(rootDirURL);
            if (cookieSet == null) {
                cookieSet = new HashSet<Object>(5);
                this._activeRootMap.put(rootDirURL, cookieSet);
                this.processChildrenCacheImpl(rootDirURL, 3);
            }
            cookieSet.add(cookie);
            this._activeRootCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deactivateDirectory(URL rootDirURL, Object cookie) {
        if (VERBOSE_FILTER) {
            // empty if block
        }
        HashMap<URL, Set<Object>> hashMap = this._activeRootMap;
        synchronized (hashMap) {
            Set<Object> cookieSet = this._activeRootMap.get(rootDirURL);
            if (cookieSet != null) {
                cookieSet.remove(cookie);
                if (cookieSet.isEmpty()) {
                    this._activeRootMap.remove(rootDirURL);
                }
                this._activeRootCache.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URL[] getActiveDirectories() {
        HashMap<URL, Set<Object>> hashMap = this._activeRootMap;
        synchronized (hashMap) {
            Set<URL> keySet = this._activeRootMap.keySet();
            URL[] uRLArray = keySet.toArray(new URL[keySet.size()]);
            return uRLArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URL getActiveRoot(URL dirURL) {
        URL activeURL = null;
        HashMap<URL, Set<Object>> hashMap = this._activeRootMap;
        synchronized (hashMap) {
            if (this._activeRootMap.containsKey(dirURL)) {
                URL uRL = dirURL;
                return uRL;
            }
            activeURL = this._activeRootCache.get(dirURL);
            if (activeURL != null || this._activeRootCache.containsKey(dirURL)) {
                URL uRL = activeURL;
                return uRL;
            }
            activeURL = this.getParent(dirURL);
            while (activeURL != null) {
                if (this._activeRootMap.containsKey(activeURL)) break;
                activeURL = this.getParent(activeURL);
            }
            this._activeRootCache.put(dirURL, activeURL);
        }
        if (VERBOSE_FILTER) {
            // empty if block
        }
        return activeURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markDirEntryDirty(DirEntry dirEntry) {
        if (VERBOSE_CACHE) {
            // empty if block
        }
        DirEntry dirEntry2 = dirEntry;
        synchronized (dirEntry2) {
            DirEntry dirEntry3 = dirEntry;
            DirEntry.wa$_flags(dirEntry3, (byte)(DirEntry.ra$_flags(dirEntry3) | 1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markDirEntryUnverified(DirEntry dirEntry) {
        if (VERBOSE_CACHE) {
            // empty if block
        }
        DirEntry dirEntry2 = dirEntry;
        synchronized (dirEntry2) {
            DirEntry dirEntry3 = dirEntry;
            DirEntry.wa$_flags(dirEntry3, (byte)(DirEntry.ra$_flags(dirEntry3) | 4));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DirEntry lookupCacheImpl(URL dirURL) {
        DirEntry foundEntry;
        if (VERBOSE_CACHE) {
            // empty if block
        }
        this.ensureDataLoaded();
        HashMap<URL, DirEntry> hashMap = this._urlToDirEntryMap;
        synchronized (hashMap) {
            foundEntry = this._urlToDirEntryMap.get(dirURL);
        }
        return foundEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeCacheImpl(DirEntry dirEntry) {
        if (VERBOSE_CACHE) {
            // empty if block
        }
        this.ensureDataLoaded();
        HashMap<URL, DirEntry> hashMap = this._urlToDirEntryMap;
        synchronized (hashMap) {
            if (dirEntry != null) {
                if (VERBOSE_CACHE) {
                    // empty if block
                }
                this._urlToDirEntryMap.put(DirEntry.ra$_dirURL(dirEntry), dirEntry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processChildrenCacheImpl(URL rootDirURL, int howToProcess) {
        if (VERBOSE_CACHE) {
            // empty if block
        }
        this.ensureDataLoaded();
        HashMap<URL, DirEntry> hashMap = this._urlToDirEntryMap;
        synchronized (hashMap) {
            String dirPath = rootDirURL.getPath();
            Collection<DirEntry> entries = this._urlToDirEntryMap.values();
            Iterator<DirEntry> entryIterator = entries.iterator();
            while (entryIterator.hasNext()) {
                DirEntry entry = entryIterator.next();
                URL checkURL = DirEntry.ra$_dirURL(entry);
                boolean process = false;
                if (this.isFileProtocol()) {
                    String checkPath = checkURL.getPath();
                    if (checkPath.startsWith(dirPath)) {
                        process = true;
                    }
                } else if (checkURL.equals(rootDirURL) || this.isBaseURLFor(rootDirURL, checkURL)) {
                    process = true;
                }
                if (!process) continue;
                if (VERBOSE_CACHE) {
                    // empty if block
                }
                switch (howToProcess) {
                    case 1: {
                        entryIterator.remove();
                        break;
                    }
                    case 2: {
                        this.markDirEntryDirty(entry);
                        break;
                    }
                    case 3: {
                        this.markDirEntryUnverified(entry);
                        break;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDirEntryDirty(DirEntry dirEntry) {
        DirEntry dirEntry2 = dirEntry;
        synchronized (dirEntry2) {
            boolean bl = VirtualFileSystemHelper.isFlagSet(DirEntry.ra$_flags(dirEntry), 1);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDirEntryUnverified(DirEntry dirEntry) {
        DirEntry dirEntry2 = dirEntry;
        synchronized (dirEntry2) {
            boolean bl = VirtualFileSystemHelper.isFlagSet(DirEntry.ra$_flags(dirEntry), 4);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDirEntryNonExistent(DirEntry dirEntry) {
        DirEntry dirEntry2 = dirEntry;
        synchronized (dirEntry2) {
            boolean bl = dirEntry == DIR_NON_EXISTENT || VirtualFileSystemHelper.isFlagSet(DirEntry.ra$_flags(dirEntry), 8);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDirEntryValid(DirEntry dirEntry) {
        DirEntry dirEntry2 = dirEntry;
        synchronized (dirEntry2) {
            boolean dirty = this.isDirEntryDirty(dirEntry);
            boolean unverified = this.isDirEntryUnverified(dirEntry);
            boolean bl = (dirty || !USE_UNVERIFIED && unverified) ^ true;
            return bl;
        }
    }

    private DirEntry fetchDirFromHelper(URL dirURL) {
        URLFileSystem.FileInfo[] fileInfos;
        if (!VirtualFileSystemHelper.isEnabled()) {
            // empty if block
        }
        if (VERBOSE_CACHE) {
            // empty if block
        }
        if ((fileInfos = this._helper.ls(dirURL)) != null) {
            if (VERBOSE_CACHE) {
                // empty if block
            }
            DirEntry entry = new DirEntry(null);
            DirEntry.wa$_dirURL(entry, dirURL);
            DirEntry.wa$_flags(entry, (byte)0);
            DirEntry.wa$_files(entry, fileInfos);
            return entry;
        }
        return null;
    }

    private static boolean isFlagSet(int value, int flag) {
        return (value & flag) != 0;
    }

    static boolean ra$VERBOSE_LISTENER() {
        return VERBOSE_LISTENER;
    }

    static void mav$disableDirectoryTrackingFor(VirtualFileSystemHelper virtualFileSystemHelper, URL uRL, boolean bl) {
        virtualFileSystemHelper.disableDirectoryTrackingFor(uRL, bl);
    }

    static void mav$removeCachedDirEntry(VirtualFileSystemHelper virtualFileSystemHelper, URL uRL) {
        virtualFileSystemHelper.removeCachedDirEntry(uRL);
    }

    static void mav$markParentDirty(VirtualFileSystemHelper virtualFileSystemHelper, URL uRL) {
        virtualFileSystemHelper.markParentDirty(uRL);
    }

    static AssemblyFactory ra$FP_FILE_INFO_FACTORY() {
        return FP_FILE_INFO_FACTORY;
    }

    static AssemblyFactory ra$FILE_INFO_FACTORY() {
        return FILE_INFO_FACTORY;
    }

    private class DWListener
    implements DirectoryWatcher.DirectoryListener {
        public void directoryUpdate(DirectoryWatcher.DirectoryEvent event) {
            int type = event.getEventType();
            URL rootURL = event.getRootURL();
            switch (type) {
                case 2: {
                    String filename = event.getFileName().replace('\\', '/');
                    URL fileURL = URLFactory.newURL((URL)rootURL, (String)filename);
                    if (VirtualFileSystemHelper.ra$VERBOSE_LISTENER()) {
                        // empty if block
                    }
                    VirtualFileSystemHelper.mav$removeCachedDirEntry(VirtualFileSystemHelper.this, fileURL);
                    VirtualFileSystemHelper.mav$markParentDirty(VirtualFileSystemHelper.this, fileURL);
                    break;
                }
                case 4: {
                    String filename = event.getOldFileName().replace('\\', '/');
                    URL fileURL = URLFactory.newURL((URL)rootURL, (String)filename);
                    if (VirtualFileSystemHelper.ra$VERBOSE_LISTENER()) {
                        // empty if block
                    }
                    VirtualFileSystemHelper.mav$removeCachedDirEntry(VirtualFileSystemHelper.this, fileURL);
                    VirtualFileSystemHelper.mav$markParentDirty(VirtualFileSystemHelper.this, fileURL);
                    break;
                }
                case 1: 
                case 3: {
                    String filename = event.getFileName().replace('\\', '/');
                    URL fileURL = URLFactory.newURL((URL)rootURL, (String)filename);
                    if (VirtualFileSystemHelper.ra$VERBOSE_LISTENER()) {
                        // empty if block
                    }
                    if (type == 1) {
                        VirtualFileSystemHelper.mav$removeCachedDirEntry(VirtualFileSystemHelper.this, fileURL);
                    }
                    VirtualFileSystemHelper.mav$markParentDirty(VirtualFileSystemHelper.this, fileURL);
                    break;
                }
            }
        }

        public void watchCancelled(DirectoryWatcher.DirectoryEvent event) {
            URL rootURL = event.getRootURL();
            if (VirtualFileSystemHelper.ra$VERBOSE_LISTENER()) {
                // empty if block
            }
            VirtualFileSystemHelper.mav$disableDirectoryTrackingFor(VirtualFileSystemHelper.this, rootURL, false);
        }

        private DWListener() {
        }

        DWListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private static final class DirEntry {
        private URL _dirURL;
        private static final int FLAGS_NONE = 0;
        private static final int FLAGS_DIRTY = 1;
        private static final int FLAGS_UNVERIFIED = 4;
        private static final int FLAGS_NONEXISTENT = 8;
        private byte _flags;
        private URLFileSystem.FileInfo[] _files;

        private DirEntry() {
        }

        DirEntry(1 var1_1) {
            this();
        }

        static void wa$_dirURL(DirEntry dirEntry, URL uRL) {
            dirEntry._dirURL = uRL;
        }

        static void wa$_flags(DirEntry dirEntry, byte by) {
            dirEntry._flags = by;
        }

        static void wa$_files(DirEntry dirEntry, URLFileSystem.FileInfo[] fileInfoArray) {
            dirEntry._files = fileInfoArray;
        }

        static byte ra$_flags(DirEntry dirEntry) {
            return dirEntry._flags;
        }

        static URL ra$_dirURL(DirEntry dirEntry) {
            return dirEntry._dirURL;
        }

        static URLFileSystem.FileInfo[] ra$_files(DirEntry dirEntry) {
            return dirEntry._files;
        }

        public final class 1 {
        }
    }

    private static final class FileInfoFactory
    extends ObjectFactory {
        private boolean _isFileProtocol;
        public static final byte FILE_INFO_CODE = -15;
        public static final byte FP_FILE_INFO_CODE = -5;

        private FileInfoFactory(boolean isFileProtocol) {
            this._isFileProtocol = isFileProtocol;
        }

        public byte getObjectCode() {
            return this._isFileProtocol ? (byte)-5 : -15;
        }

        public Object assembleImpl(DataInput input) throws IOException, AssemblyException {
            String urlString = (String)StringFactory.STRING_FACTORY.assemble(input);
            URL fileURL = this._isFileProtocol ? URLFactory.newFileURL((String)urlString) : URLFactory.newURL((String)urlString);
            int attributes = input.readInt();
            long modified = input.readLong();
            long length = input.readLong();
            return new URLFileSystem.FileInfo(fileURL, attributes, modified, length);
        }

        public void disassembleImpl(Object object, DataOutput output) throws IOException, ClassCastException, AssemblyException {
            URLFileSystem.FileInfo fileInfo = (URLFileSystem.FileInfo)object;
            URL fileURL = fileInfo.getURL();
            String urlString = this._isFileProtocol ? fileURL.getPath() : fileURL.toString();
            int attributes = fileInfo.attributes;
            long modified = fileInfo.lastModified;
            long length = fileInfo.length;
            StringFactory.STRING_FACTORY.disassemble((Object)urlString, output);
            output.writeInt(attributes);
            output.writeLong(modified);
            output.writeLong(length);
        }

        FileInfoFactory(boolean bl, 1 var2_2) {
            this(bl);
        }

        public final class 1 {
        }
    }

    private static final class DirEntryFactory
    extends ObjectFactory {
        private boolean _isFileProtocol;
        public static final byte DIR_ENTRY_CODE = -34;
        public static final byte FP_DIR_ENTRY_CODE = -37;

        private DirEntryFactory(boolean isFileProtocol) {
            this._isFileProtocol = isFileProtocol;
        }

        public byte getObjectCode() {
            return this._isFileProtocol ? (byte)-37 : -34;
        }

        public Object assembleImpl(DataInput input) throws IOException, AssemblyException {
            String urlString = (String)StringFactory.STRING_FACTORY.assemble(input);
            URL dirURL = this._isFileProtocol ? URLFactory.newFileURL((String)urlString) : URLFactory.newURL((String)urlString);
            byte flags = input.readByte();
            int numInfos = input.readInt();
            URLFileSystem.FileInfo[] fileInfos = new URLFileSystem.FileInfo[numInfos];
            int i = 0;
            while (i < numInfos) {
                fileInfos[i] = (URLFileSystem.FileInfo)(this._isFileProtocol ? VirtualFileSystemHelper.ra$FP_FILE_INFO_FACTORY().assemble(input) : VirtualFileSystemHelper.ra$FILE_INFO_FACTORY().assemble(input));
                ++i;
            }
            DirEntry dirEntry = new DirEntry(null);
            DirEntry.wa$_dirURL(dirEntry, dirURL);
            DirEntry.wa$_flags(dirEntry, flags);
            DirEntry.wa$_files(dirEntry, fileInfos);
            return dirEntry;
        }

        public void disassembleImpl(Object object, DataOutput output) throws IOException, ClassCastException, AssemblyException {
            DirEntry dirEntry = (DirEntry)object;
            URL dirURL = DirEntry.ra$_dirURL(dirEntry);
            String urlString = this._isFileProtocol ? dirURL.getPath() : dirURL.toString();
            byte flags = DirEntry.ra$_flags(dirEntry);
            URLFileSystem.FileInfo[] fileInfos = DirEntry.ra$_files(dirEntry);
            int numInfos = fileInfos != null ? fileInfos.length : 0;
            StringFactory.STRING_FACTORY.disassemble((Object)urlString, output);
            output.writeByte(flags);
            output.writeInt(numInfos);
            int i = 0;
            while (i < numInfos) {
                if (this._isFileProtocol) {
                    VirtualFileSystemHelper.ra$FP_FILE_INFO_FACTORY().disassemble((Object)fileInfos[i], output);
                } else {
                    VirtualFileSystemHelper.ra$FILE_INFO_FACTORY().disassemble((Object)fileInfos[i], output);
                }
                ++i;
            }
        }

        DirEntryFactory(boolean bl, 1 var2_2) {
            this(bl);
        }

        public final class 1 {
        }
    }
}

