/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.navigator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.docking.DockableFactory;
import oracle.ide.docking.DockableView;
import oracle.ide.explorer.ChildFilter;
import oracle.ide.explorer.ChildFilterFactory;
import oracle.ide.help.HelpInfo;
import oracle.ide.layout.ViewId;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.navigator.Extension;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.net.URLFilter;
import oracle.ide.view.MultiManager;
import oracle.ide.view.View;
import oracle.javatools.jndi.Names;

public abstract class NavigatorManager
extends MultiManager {
    protected static final String SOURCE_NAVIGATOR_PROPERTY = "NavigatorWindow";
    private static final String APP_NAV_NAME = "ide/application-navigator";
    private static final String WORKSPACE_NAV_NAME = "ide/workspace-navigator";
    private static final String CONN_NAV_NAME = "ide/connection-navigator";
    private NavigatorWindow _navigatorWindow;
    private final HashMap _childFilters;
    private final HashMap _urlFilters;
    private final ArrayList _hostedViewIds;
    private static NullNavigatorManager nullNavigatorManager = null;

    private void $init$() {
        this._childFilters = new HashMap();
        this._urlFilters = new HashMap();
        this._hostedViewIds = new ArrayList();
    }

    public static NavigatorManager getApplicationNavigatorManager() {
        return (NavigatorManager)Names.lookup((javax.naming.Context)Names.newInitialContext(), (String)APP_NAV_NAME);
    }

    public static void setApplicationNavigatorManager(NavigatorManager navMgr) {
        Names.bind((javax.naming.Context)Names.newInitialContext(), (String)APP_NAV_NAME, (Object)navMgr);
    }

    public static NavigatorManager getWorkspaceNavigatorManager() {
        if (!Ide.getIdeArgs().getCreateUI()) {
            if (nullNavigatorManager == null) {
                nullNavigatorManager = new NullNavigatorManager(null);
            }
            return nullNavigatorManager;
        }
        return (NavigatorManager)Names.lookup((javax.naming.Context)Names.newInitialContext(), (String)WORKSPACE_NAV_NAME);
    }

    public static void setWorkspaceNavigatorManager(NavigatorManager navMgr) {
        Names.bind((javax.naming.Context)Names.newInitialContext(), (String)WORKSPACE_NAV_NAME, (Object)navMgr);
    }

    public static NavigatorManager getConnectionNavigatorManager() {
        return (NavigatorManager)Names.lookup((javax.naming.Context)Names.newInitialContext(), (String)CONN_NAV_NAME);
    }

    public static void setConnectionNavigatorManager(NavigatorManager navMgr) {
        Names.bind((javax.naming.Context)Names.newInitialContext(), (String)CONN_NAV_NAME, (Object)navMgr);
    }

    public abstract ContextMenu getContextMenu();

    public final boolean isSystemNavigator(ViewId viewId) {
        return viewId != null ? this.getDefaultName().equals(viewId.getName()) : false;
    }

    public final synchronized NavigatorWindow getNavigatorWindow() {
        if (this._navigatorWindow == null) {
            this._navigatorWindow = this.createNavigatorWindow();
        }
        return this._navigatorWindow;
    }

    protected abstract NavigatorWindow createNavigatorWindow();

    public NavigatorWindow openNavigator(Context context) {
        if (context == null) {
            throw new NullPointerException("context is null");
        }
        NavigatorWindow navigator = this.findNavigatorWindow(context);
        if (navigator != null) {
            NavigatorWindow navigatorToCall = navigator.getManager().getNavigatorWindow();
            return navigatorToCall.openContext(context) ? navigator : null;
        }
        return null;
    }

    public final NavigatorWindow showNavigator(Context context) {
        return (NavigatorWindow)this.showView(context);
    }

    public abstract void addContextMenuListener(ContextMenuListener var1, Class var2);

    public abstract void removeContextMenuListener(ContextMenuListener var1);

    public final void registerHostedDockable(ViewId viewId) {
        this._hostedViewIds.add(viewId);
    }

    public final List getHostedDockables() {
        return Collections.unmodifiableList(this._hostedViewIds);
    }

    public final void registerFilter(Class elementClass, Class childFilterClass, URLFilter urlFilter) {
        if (elementClass != null) {
            if (childFilterClass != null) {
                this._childFilters.put(elementClass, NavigatorManager.newFactoryFromClass(childFilterClass));
            }
            if (urlFilter != null) {
                this._urlFilters.put(elementClass, urlFilter);
            }
        }
    }

    public final void registerFilter(Class elementClass, ChildFilterFactory childFilterFactory) {
        if (elementClass != null && childFilterFactory != null) {
            this._childFilters.put(elementClass, childFilterFactory);
        }
    }

    public final ChildFilterFactory getChildFilterFactoryForType(Class elementClass) {
        return (ChildFilterFactory)this._childFilters.get(elementClass);
    }

    public final URLFilter getURLFilter(Class elementClass) {
        return (URLFilter)this._urlFilters.get(elementClass);
    }

    public abstract void registerExtension(Extension var1, Class var2);

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_idesystemnavigator_html");
    }

    public static final Element getFolderFromContext(Context context) {
        Element element = context.getElement();
        if (!(element != null && element.mayHaveChildren() || (element = context.getProject()) != null || (element = context.getWorkspace()) != null)) {
            return Ide.getWorkspaces();
        }
        return element;
    }

    private static ChildFilterFactory newFactoryFromClass(Class childFilterClass) {
        return new 1(childFilterClass);
    }

    protected ViewId newViewId(Element folder) {
        String base = folder instanceof Locatable ? ((Locatable)((Object)folder)).getURL().getFile() : Long.toString(System.currentTimeMillis());
        return new ViewId(this.getViewCategory(), base);
    }

    private NavigatorWindow findNavigatorWindow(Context context) {
        View navigator = null;
        Object navigatorValue = context.getProperty(SOURCE_NAVIGATOR_PROPERTY);
        if (navigatorValue instanceof String) {
            String navigatorId = (String)navigatorValue;
            ViewId viewId = new ViewId(navigatorId);
            navigator = this.findView(viewId);
        }
        if (navigator == null) {
            Workspace workspace;
            Project project;
            ViewId viewId = null;
            Element element = context.getElement();
            if (element != null && element.mayHaveChildren()) {
                viewId = this.newViewId(element);
            }
            if (viewId == null && (project = context.getProject()) != null) {
                viewId = this.newViewId(project);
            }
            if (viewId == null && (workspace = context.getWorkspace()) != null) {
                viewId = this.newViewId(workspace);
            }
            if (viewId != null) {
                navigator = this.findView(viewId);
            }
            if (navigator == null) {
                navigator = this.getNavigatorWindow();
            }
        }
        if (navigator == null) {
            navigator = this.getNavigatorWindow();
        }
        if (navigator != null) {
            navigator = ((View)navigator).getViewWithoutDecoration();
        }
        return navigator;
    }

    public NavigatorManager() {
        this.$init$();
    }

    static final class 1
    extends ChildFilterFactory {
        private final /* synthetic */ Class v$childFilterClass;

        public ChildFilter newChildFilter() {
            try {
                ChildFilter childFilter = (ChildFilter)this.v$childFilterClass.newInstance();
                return childFilter;
            }
            catch (Exception e) {
                e.printStackTrace();
                ChildFilter childFilter = null;
                return childFilter;
            }
        }

        public 1(Class clazz) {
            this.v$childFilterClass = clazz;
        }
    }

    private static class NullNavigatorManager
    extends NavigatorManager {
        public ContextMenu getContextMenu() {
            return null;
        }

        protected NavigatorWindow createNavigatorWindow() {
            return null;
        }

        public void addContextMenuListener(ContextMenuListener l, Class cls) {
        }

        public void removeContextMenuListener(ContextMenuListener l) {
        }

        public void registerExtension(Extension ext, Class cls) {
        }

        protected String getViewCategory() {
            return null;
        }

        protected String getDefaultName() {
            return null;
        }

        protected DockableView createDockableView(Context ctx, ViewId viewId) {
            return null;
        }

        protected IdeAction createShowAction() {
            return null;
        }

        protected DockableFactory getDockableFactory() {
            return null;
        }

        private NullNavigatorManager() {
        }

        NullNavigatorManager(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

