/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.natives;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import oracle.ide.natives.DirectoryWatcher;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFileSystem;

public class FileWatcher {
    private URL _fileURL;
    private String _filename;
    private FileListener _listener;
    private boolean _active;
    private static final boolean DEBUG_VERBOSE = false;
    static Object WATCH_LOCK = DirectoryWatcher.WATCH_LOCK;
    private static List _watchEntryList = new ArrayList();

    public static FileWatcher createFileWatcher(URL fileURL, FileListener listener) {
        return FileWatcher.createFileWatcherImpl(fileURL, listener);
    }

    public static void destroyFileWatcher(FileWatcher watcher) {
        FileWatcher.destroyFileWatcherImpl(watcher);
    }

    private FileWatcher(URL fileURL, String filename, FileListener listener) {
        this._fileURL = fileURL;
        this._filename = filename;
        this._listener = listener;
        this._active = true;
    }

    public URL getFileURL() {
        return this._fileURL;
    }

    public String getFileName() {
        return this._filename;
    }

    public boolean isActive() {
        return this._active;
    }

    public String toString() {
        String platformName = URLFileSystem.getPlatformPathName((URL)this.getFileURL());
        return "FW: " + platformName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static FileWatcher createFileWatcherImpl(URL fileURL, FileListener listener) {
        if (fileURL == null) {
            return null;
        }
        URL normalizedURL = fileURL;
        while (JarUtil.isJarURL((URL)normalizedURL)) {
            normalizedURL = FileWatcher.getFileURLFor(normalizedURL);
        }
        URL rootURL = FileWatcher.getRootURLFor(normalizedURL);
        if (!"file".equals(normalizedURL.getProtocol())) {
            return null;
        }
        Object object = WATCH_LOCK;
        synchronized (object) {
            WatchEntry entry = FileWatcher.findWatchEntry(rootURL);
            if (entry == null) {
                WatchEntry tmpEntry = new WatchEntry(new ArrayList(), rootURL, null);
                DirectoryWatcher dirWatcher = DirectoryWatcher.createDirectoryWatcherImpl(rootURL, false, tmpEntry);
                if (dirWatcher == null) {
                    FileWatcher fileWatcher = null;
                    return fileWatcher;
                }
                WatchEntry.wa$dirWatcher(tmpEntry, dirWatcher);
                entry = tmpEntry;
                _watchEntryList.add(entry);
            }
            String filename = URLFileSystem.getFileName((URL)normalizedURL);
            FileWatcher watcher = new FileWatcher(fileURL, filename, listener);
            WatchEntry.ra$watchers(entry).add(watcher);
            FileWatcher fileWatcher = watcher;
            return fileWatcher;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void destroyFileWatcherImpl(FileWatcher watcher) {
        Object object = WATCH_LOCK;
        synchronized (object) {
            watcher._active = false;
            URL rootURL = FileWatcher.getRootURLFor(watcher.getFileURL());
            WatchEntry entry = FileWatcher.findWatchEntry(rootURL);
            if (entry != null) {
                WatchEntry.ra$watchers(entry).remove(watcher);
                if (WatchEntry.ra$watchers(entry).size() == 0) {
                    _watchEntryList.remove(entry);
                    DirectoryWatcher.destroyDirectoryWatcher(WatchEntry.ra$dirWatcher(entry));
                }
            }
        }
    }

    private static URL getFileURLFor(URL url) {
        if (JarUtil.isJarURL((URL)url)) {
            return JarUtil.getJarFileURL((URL)url);
        }
        return url;
    }

    private static URL getRootURLFor(URL url) {
        URL fileURL = FileWatcher.getFileURLFor(url);
        return URLFileSystem.getParent((URL)fileURL);
    }

    private static WatchEntry findWatchEntry(URL rootURL) {
        int size = _watchEntryList.size();
        int i = 0;
        while (i < size) {
            WatchEntry entry = (WatchEntry)_watchEntryList.get(i);
            if (entry != null && WatchEntry.ra$rootURL(entry).equals(rootURL)) {
                return entry;
            }
            ++i;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fireWatchEvent(WatchEntry entry, DirectoryWatcher.DirectoryEvent event) {
        ArrayList<FileListener> listenerList = new ArrayList<FileListener>();
        ArrayList<FileEvent> eventList = new ArrayList<FileEvent>();
        Object object = WATCH_LOCK;
        synchronized (object) {
            String filename = event.getFileName();
            String oldname = event.getOldFileName();
            int watcherCount = WatchEntry.ra$watchers(entry).size();
            int i = 0;
            while (i < watcherCount) {
                FileWatcher watcher = (FileWatcher)WatchEntry.ra$watchers(entry).get(i);
                String watchName = watcher.getFileName();
                int type = -1;
                int eventType = event.getEventType();
                switch (eventType) {
                    case 1: 
                    case 2: 
                    case 3: {
                        if (!filename.equals(watchName)) break;
                        type = eventType;
                        break;
                    }
                    case 4: {
                        if (filename.equals(watchName)) {
                            type = 1;
                            break;
                        }
                        if (!oldname.equals(watchName)) break;
                        type = 2;
                        break;
                    }
                }
                if (type != -1) {
                    FileWatcher fileWatcher = watcher;
                    fileWatcher.getClass();
                    FileEvent fileEvent = fileWatcher.new FileEvent(type, null);
                    FileListener listener = watcher._listener;
                    eventList.add(fileEvent);
                    listenerList.add(listener);
                }
                ++i;
            }
        }
        int numEvents = listenerList.size();
        int i = 0;
        while (i < numEvents) {
            FileListener listener = (FileListener)listenerList.get(i);
            FileEvent fileEvent = (FileEvent)eventList.get(i);
            if (listener != null && fileEvent != null) {
                try {
                    listener.fileUpdate(fileEvent);
                }
                catch (RuntimeException e) {
                    // empty catch block
                }
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fireCancelledEvent(WatchEntry entry, DirectoryWatcher.DirectoryEvent event) {
        ArrayList<FileListener> listenerList = new ArrayList<FileListener>();
        ArrayList<FileEvent> eventList = new ArrayList<FileEvent>();
        Object object = WATCH_LOCK;
        synchronized (object) {
            int watcherCount = WatchEntry.ra$watchers(entry).size();
            int i = 0;
            while (i < watcherCount) {
                FileWatcher watcher = (FileWatcher)WatchEntry.ra$watchers(entry).get(i);
                watcher._active = false;
                FileWatcher fileWatcher = watcher;
                fileWatcher.getClass();
                FileEvent fileEvent = fileWatcher.new FileEvent(15, null);
                FileListener listener = watcher._listener;
                eventList.add(fileEvent);
                listenerList.add(listener);
                ++i;
            }
            _watchEntryList.remove(entry);
        }
        int numEvents = listenerList.size();
        int i = 0;
        while (i < numEvents) {
            FileListener listener = (FileListener)listenerList.get(i);
            FileEvent fileEvent = (FileEvent)eventList.get(i);
            if (listener != null && fileEvent != null) {
                try {
                    listener.watchCancelled(fileEvent);
                }
                catch (RuntimeException e) {
                    // empty catch block
                }
            }
            ++i;
        }
    }

    static void maS$fireCancelledEvent(WatchEntry watchEntry, DirectoryWatcher.DirectoryEvent directoryEvent) {
        FileWatcher.fireCancelledEvent(watchEntry, directoryEvent);
    }

    static void maS$fireWatchEvent(WatchEntry watchEntry, DirectoryWatcher.DirectoryEvent directoryEvent) {
        FileWatcher.fireWatchEvent(watchEntry, directoryEvent);
    }

    public class FileEvent {
        public static final int FILE_ADDED = 1;
        public static final int FILE_REMOVED = 2;
        public static final int FILE_MODIFIED = 3;
        public static final int WATCH_CANCELLED = 15;
        private int _type;

        private FileEvent(int type) {
            this._type = type;
        }

        public int getEventType() {
            return this._type;
        }

        public FileWatcher getFileWatcher() {
            return FileWatcher.this;
        }

        public URL getFileURL() {
            return this.getFileWatcher().getFileURL();
        }

        FileEvent(int n, 1 var3_3) {
            this(n);
        }

        public final class 1 {
        }
    }

    public static interface FileListener {
        public void fileUpdate(FileEvent var1);

        public void watchCancelled(FileEvent var1);
    }

    private static class WatchEntry
    implements DirectoryWatcher.DirectoryListener {
        private List watchers;
        private URL rootURL;
        private DirectoryWatcher dirWatcher;

        private WatchEntry(List watchers, URL rootURL) {
            this.watchers = watchers;
            this.rootURL = rootURL;
        }

        public void directoryUpdate(DirectoryWatcher.DirectoryEvent event) {
            FileWatcher.maS$fireWatchEvent(this, event);
        }

        public void watchCancelled(DirectoryWatcher.DirectoryEvent event) {
            FileWatcher.maS$fireCancelledEvent(this, event);
        }

        static List ra$watchers(WatchEntry watchEntry) {
            return watchEntry.watchers;
        }

        static URL ra$rootURL(WatchEntry watchEntry) {
            return watchEntry.rootURL;
        }

        static DirectoryWatcher ra$dirWatcher(WatchEntry watchEntry) {
            return watchEntry.dirWatcher;
        }

        WatchEntry(List list, URL uRL, 1 var3_3) {
            this(list, uRL);
        }

        static void wa$dirWatcher(WatchEntry watchEntry, DirectoryWatcher directoryWatcher) {
            watchEntry.dirWatcher = directoryWatcher;
        }

        public final class 1 {
        }
    }
}

