/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.natives;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import oracle.ide.natives.NativeHandler;
import oracle.ide.net.URLFileSystem;

public class DirectoryWatcher {
    private URL _rootURL;
    private boolean _recursive;
    private DirectoryListener _listener;
    private boolean _active;
    private static final boolean DEBUG_VERBOSE = false;
    static Object WATCH_LOCK = new int[0];
    private static List _watchEntryList = new ArrayList();
    private static boolean _watchThreadStarted = false;

    public static DirectoryWatcher createDirectoryWatcher(URL rootURL, DirectoryListener listener) {
        return DirectoryWatcher.createDirectoryWatcherImpl(rootURL, true, listener);
    }

    public static void destroyDirectoryWatcher(DirectoryWatcher watcher) {
        DirectoryWatcher.destroyDirectoryWatcherImpl(watcher);
    }

    private DirectoryWatcher(URL rootURL, boolean recursive, DirectoryListener listener) {
        this._rootURL = rootURL;
        this._recursive = recursive;
        this._listener = listener;
        this._active = true;
    }

    public URL getRootURL() {
        return this._rootURL;
    }

    public boolean isActive() {
        return this._active;
    }

    public String toString() {
        String platformName = URLFileSystem.getPlatformPathName((URL)this.getRootURL());
        return "DW: " + platformName + " recurse(" + this._recursive + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DirectoryWatcher createDirectoryWatcherImpl(URL rootURL, boolean recursive, DirectoryListener listener) {
        if (!NativeHandler.isLoaded()) {
            return null;
        }
        if (rootURL == null) {
            return null;
        }
        if (!"file".equals(rootURL.getProtocol())) {
            return null;
        }
        DirectoryWatcher.startWatchThread();
        Object object = WATCH_LOCK;
        synchronized (object) {
            WatchEntry entry = DirectoryWatcher.findWatchEntry(rootURL, recursive);
            if (entry == null) {
                String platformName = URLFileSystem.getPlatformPathName((URL)rootURL);
                int cookie = NativeHandler.startDirectoryWatch(platformName, recursive);
                if (cookie == -1) {
                    DirectoryWatcher directoryWatcher = null;
                    return directoryWatcher;
                }
                entry = new WatchEntry(new ArrayList(), rootURL, cookie, recursive, null);
                _watchEntryList.add(entry);
            }
            DirectoryWatcher watcher = new DirectoryWatcher(rootURL, recursive, listener);
            WatchEntry.ra$watchers(entry).add(watcher);
            DirectoryWatcher directoryWatcher = watcher;
            return directoryWatcher;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void destroyDirectoryWatcherImpl(DirectoryWatcher watcher) {
        Object object = WATCH_LOCK;
        synchronized (object) {
            watcher._active = false;
            WatchEntry entry = DirectoryWatcher.findWatchEntry(watcher._rootURL, watcher._recursive);
            if (entry != null) {
                WatchEntry.ra$watchers(entry).remove(watcher);
                if (WatchEntry.ra$watchers(entry).size() == 0) {
                    _watchEntryList.remove(entry);
                    String platformName = URLFileSystem.getPlatformPathName((URL)WatchEntry.ra$rootURL(entry));
                    NativeHandler.stopDirectoryWatch(platformName, WatchEntry.ra$cookie(entry));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void startWatchThread() {
        Object object = WATCH_LOCK;
        synchronized (object) {
            if (!_watchThreadStarted) {
                NativeHandler.startWatcherThread(new WatchEventRedirector(null));
                _watchThreadStarted = true;
            }
        }
    }

    private static WatchEntry findWatchEntry(int cookie) {
        int size = _watchEntryList.size();
        int i = 0;
        while (i < size) {
            WatchEntry entry = (WatchEntry)_watchEntryList.get(i);
            if (entry != null && WatchEntry.ra$cookie(entry) == cookie) {
                return entry;
            }
            ++i;
        }
        return null;
    }

    private static WatchEntry findWatchEntry(URL rootURL, boolean recursive) {
        int size = _watchEntryList.size();
        int i = 0;
        while (i < size) {
            WatchEntry entry = (WatchEntry)_watchEntryList.get(i);
            if (entry != null && WatchEntry.ra$recursive(entry) == recursive && WatchEntry.ra$rootURL(entry).equals(rootURL)) {
                return entry;
            }
            ++i;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fireWatchEvent(int cookie, int action, String filename) {
        ArrayList<DirectoryListener> listenerList = new ArrayList<DirectoryListener>();
        ArrayList<DirectoryEvent> eventList = new ArrayList<DirectoryEvent>();
        Object object = WATCH_LOCK;
        synchronized (object) {
            WatchEntry entry = DirectoryWatcher.findWatchEntry(cookie);
            if (entry == null) {
                return;
            }
            if (WatchEntry.ra$oldFilenameForRename(entry) == null || action != 5) {
                // empty if block
            }
            int type = -1;
            String oldName = null;
            switch (action) {
                case 1: {
                    type = 1;
                    break;
                }
                case 2: {
                    type = 2;
                    break;
                }
                case 3: {
                    type = 3;
                    break;
                }
                case 4: {
                    WatchEntry.wa$oldFilenameForRename(entry, filename);
                    return;
                }
                case 5: {
                    type = 4;
                    oldName = WatchEntry.ra$oldFilenameForRename(entry);
                    WatchEntry.wa$oldFilenameForRename(entry, null);
                    if (oldName != null) break;
                    return;
                }
            }
            if (type == -1) {
                return;
            }
            int watcherCount = WatchEntry.ra$watchers(entry).size();
            int i = 0;
            while (i < watcherCount) {
                DirectoryWatcher watcher;
                DirectoryWatcher directoryWatcher = watcher = (DirectoryWatcher)WatchEntry.ra$watchers(entry).get(i);
                directoryWatcher.getClass();
                DirectoryEvent event = directoryWatcher.new DirectoryEvent(type, filename, null);
                DirectoryEvent.mav$setOldFileName(event, oldName);
                DirectoryListener listener = watcher._listener;
                eventList.add(event);
                listenerList.add(listener);
                ++i;
            }
        }
        int numEvents = listenerList.size();
        int i = 0;
        while (i < numEvents) {
            DirectoryListener listener = (DirectoryListener)listenerList.get(i);
            DirectoryEvent event = (DirectoryEvent)eventList.get(i);
            if (listener != null && event != null) {
                try {
                    listener.directoryUpdate(event);
                }
                catch (RuntimeException e) {
                    // empty catch block
                }
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fireCancelledEvent(int cookie) {
        ArrayList<DirectoryListener> listenerList = new ArrayList<DirectoryListener>();
        ArrayList<DirectoryEvent> eventList = new ArrayList<DirectoryEvent>();
        Object object = WATCH_LOCK;
        synchronized (object) {
            WatchEntry entry = DirectoryWatcher.findWatchEntry(cookie);
            if (entry == null) {
                return;
            }
            int watcherCount = WatchEntry.ra$watchers(entry).size();
            int i = 0;
            while (i < watcherCount) {
                DirectoryWatcher watcher = (DirectoryWatcher)WatchEntry.ra$watchers(entry).get(i);
                watcher._active = false;
                DirectoryWatcher directoryWatcher = watcher;
                directoryWatcher.getClass();
                DirectoryEvent event = directoryWatcher.new DirectoryEvent(15, null);
                DirectoryListener listener = watcher._listener;
                eventList.add(event);
                listenerList.add(listener);
                ++i;
            }
            _watchEntryList.remove(entry);
        }
        int numEvents = listenerList.size();
        int i = 0;
        while (i < numEvents) {
            DirectoryListener listener = (DirectoryListener)listenerList.get(i);
            DirectoryEvent event = (DirectoryEvent)eventList.get(i);
            if (listener != null && event != null) {
                try {
                    listener.watchCancelled(event);
                }
                catch (RuntimeException e) {
                    // empty catch block
                }
            }
            ++i;
        }
    }

    static void maS$fireCancelledEvent(int n) {
        DirectoryWatcher.fireCancelledEvent(n);
    }

    static void maS$fireWatchEvent(int n, int n2, String string) {
        DirectoryWatcher.fireWatchEvent(n, n2, string);
    }

    public class DirectoryEvent {
        public static final int FILE_ADDED = 1;
        public static final int FILE_REMOVED = 2;
        public static final int FILE_MODIFIED = 3;
        public static final int FILE_RENAMED = 4;
        public static final int WATCH_CANCELLED = 15;
        private String _filename;
        private int _type;
        private String _oldname;

        private DirectoryEvent(int type) {
            this._filename = null;
            this._oldname = null;
            this._type = type;
        }

        private DirectoryEvent(int type, String filename) {
            this._filename = filename;
            this._oldname = null;
            this._type = type;
        }

        private void setOldFileName(String oldname) {
            this._oldname = oldname;
        }

        public int getEventType() {
            return this._type;
        }

        public String getFileName() {
            return this._filename;
        }

        public String getOldFileName() {
            return this._oldname;
        }

        public DirectoryWatcher getDirectoryWatcher() {
            return DirectoryWatcher.this;
        }

        public URL getRootURL() {
            return this.getDirectoryWatcher().getRootURL();
        }

        DirectoryEvent(int n, 1 var3_3) {
            this(n);
        }

        DirectoryEvent(int n, String string, 1 var4_4) {
            this(n, string);
        }

        static void mav$setOldFileName(DirectoryEvent directoryEvent, String string) {
            directoryEvent.setOldFileName(string);
        }

        public final class 1 {
        }
    }

    public static interface DirectoryListener {
        public void directoryUpdate(DirectoryEvent var1);

        public void watchCancelled(DirectoryEvent var1);
    }

    private static class WatchEventRedirector
    implements NativeHandler.WatchListener {
        public void notifyWatchEvent(int cookie, int action, String filename) {
            DirectoryWatcher.maS$fireWatchEvent(cookie, action, filename);
        }

        public void notifyWatchEnded(int cookie) {
            DirectoryWatcher.maS$fireCancelledEvent(cookie);
        }

        private WatchEventRedirector() {
        }

        WatchEventRedirector(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static class WatchEntry {
        private List watchers;
        private URL rootURL;
        private int cookie;
        private boolean recursive;
        private String oldFilenameForRename;

        private WatchEntry(List watchers, URL rootURL, int cookie, boolean recursive) {
            this.$init$();
            this.watchers = watchers;
            this.rootURL = rootURL;
            this.cookie = cookie;
            this.recursive = recursive;
        }

        private void $init$() {
            this.oldFilenameForRename = null;
        }

        static List ra$watchers(WatchEntry watchEntry) {
            return watchEntry.watchers;
        }

        static String ra$oldFilenameForRename(WatchEntry watchEntry) {
            return watchEntry.oldFilenameForRename;
        }

        static void wa$oldFilenameForRename(WatchEntry watchEntry, String string) {
            watchEntry.oldFilenameForRename = string;
        }

        static boolean ra$recursive(WatchEntry watchEntry) {
            return watchEntry.recursive;
        }

        static URL ra$rootURL(WatchEntry watchEntry) {
            return watchEntry.rootURL;
        }

        static int ra$cookie(WatchEntry watchEntry) {
            return watchEntry.cookie;
        }

        WatchEntry(List list, URL uRL, int n, boolean bl, 1 var5_5) {
            this(list, uRL, n, bl);
        }

        public final class 1 {
        }
    }
}

