/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model.concurrent;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import oracle.ide.model.concurrent.CallableResultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AsynchronousCallableCompletionService<T> {
    private final CompletionService<T> completionService;
    private final ExecutorService executorService;
    private final Set<Future<T>> futuresInProgress;
    private final ExecutorService futuresProcessingExecutor;
    private volatile CallableResultHandler<T> onDequeue;
    private Thread futuresProcessor;

    private void $init$() {
        this.futuresProcessingExecutor = Executors.newSingleThreadExecutor();
        this.futuresProcessor = new 1();
    }

    public AsynchronousCallableCompletionService(ExecutorService executor, CallableResultHandler<T> asyncContentLevelCallback) {
        this.$init$();
        this.onDequeue = asyncContentLevelCallback;
        this.executorService = executor;
        this.completionService = new ExecutorCompletionService<T>(executor);
        this.futuresInProgress = Collections.synchronizedSet(new HashSet());
        this.futuresProcessingExecutor.execute(this.futuresProcessor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submit(Callable<T> task) {
        if (this.isShutdown()) {
            throw new RejectedExecutionException("Service is shut down. No further tasks may be submitted");
        }
        Set<Future<T>> set = this.futuresInProgress;
        synchronized (set) {
            this.futuresInProgress.add(this.completionService.submit(task));
            this.futuresInProgress.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownNow(boolean mayInterruptIfRunning) {
        Set<Future<T>> set = this.futuresInProgress;
        synchronized (set) {
            this.futuresProcessor.interrupt();
            this.executorService.shutdownNow();
            this.cancelAllQueuedFutures(mayInterruptIfRunning);
        }
    }

    public boolean isShutdown() {
        return this.executorService == null ? true : this.executorService.isShutdown();
    }

    public boolean isTerminated() {
        return this.executorService == null ? true : this.executorService.isTerminated();
    }

    private void cancelAllQueuedFutures(boolean mayInterruptIfRunning) {
        for (Future<T> nextUncancelledFuture : this.futuresInProgress) {
            nextUncancelledFuture.cancel(mayInterruptIfRunning);
        }
        this.futuresInProgress.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int operationsInProgressSize() {
        Set<Future<T>> set = this.futuresInProgress;
        synchronized (set) {
            int n = this.futuresInProgress.size();
            return n;
        }
    }

    static Set ra$futuresInProgress(AsynchronousCallableCompletionService asynchronousCallableCompletionService) {
        return asynchronousCallableCompletionService.futuresInProgress;
    }

    static ExecutorService ra$executorService(AsynchronousCallableCompletionService asynchronousCallableCompletionService) {
        return asynchronousCallableCompletionService.executorService;
    }

    static CompletionService ra$completionService(AsynchronousCallableCompletionService asynchronousCallableCompletionService) {
        return asynchronousCallableCompletionService.completionService;
    }

    static CallableResultHandler ra$onDequeue(AsynchronousCallableCompletionService asynchronousCallableCompletionService) {
        return asynchronousCallableCompletionService.onDequeue;
    }

    final class 1
    extends Thread {
        static final /* synthetic */ boolean $assertionsDisabled;

        static {
            $assertionsDisabled = 1.class.desiredAssertionStatus() ^ true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!Thread.currentThread().isInterrupted()) {
                Future future;
                Set set = AsynchronousCallableCompletionService.ra$futuresInProgress(AsynchronousCallableCompletionService.this);
                synchronized (set) {
                    while (AsynchronousCallableCompletionService.ra$futuresInProgress(AsynchronousCallableCompletionService.this).isEmpty()) {
                        try {
                            AsynchronousCallableCompletionService.ra$futuresInProgress(AsynchronousCallableCompletionService.this).wait();
                        }
                        catch (InterruptedException e) {
                            System.out.println("The current thread has been interrupted while waiting.\nDrop what you're doing and return. ");
                            return;
                        }
                    }
                }
                if (AsynchronousCallableCompletionService.ra$executorService(AsynchronousCallableCompletionService.this).isShutdown()) continue;
                try {
                    future = AsynchronousCallableCompletionService.ra$completionService(AsynchronousCallableCompletionService.this).take();
                }
                catch (InterruptedException e) {
                    System.out.println("The current thread has been interrupted while dequeuing a\nFuture off the queue completion service. Return.");
                    return;
                }
                if (!$assertionsDisabled && future == null) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && !future.isDone()) {
                    throw new AssertionError();
                }
                if (!future.isCancelled()) {
                    try {
                        AsynchronousCallableCompletionService.ra$onDequeue(AsynchronousCallableCompletionService.this).onCompletion(future.get());
                    }
                    catch (InterruptedException e) {
                        System.out.println("Interrupted while invoking Future.get. Returning");
                        e.printStackTrace();
                        return;
                    }
                    catch (ExecutionException e) {
                        AsynchronousCallableCompletionService.ra$onDequeue(AsynchronousCallableCompletionService.this).onException(e);
                    }
                }
                boolean removedSuceeded = false;
                Set set2 = AsynchronousCallableCompletionService.ra$futuresInProgress(AsynchronousCallableCompletionService.this);
                synchronized (set2) {
                    removedSuceeded = AsynchronousCallableCompletionService.ra$futuresInProgress(AsynchronousCallableCompletionService.this).remove(future);
                }
                if (!$assertionsDisabled && !removedSuceeded) {
                    throw new AssertionError();
                }
            }
        }
    }
}

