/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.ide.Version;
import oracle.ide.migration.MigrationInfo;
import oracle.ide.migration.NodeMigrator;
import oracle.ide.model.Element;
import oracle.ide.model.HashStructureNodeMigrator;
import oracle.ide.model.Node;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.TraversableContext;
import oracle.ide.resource.IdeArb;

public class WorkspaceMigrator
extends HashStructureNodeMigrator {
    public static final String MIGRATOR_NAME = Workspace.class.getName();
    public static final String WORKSPACE_NODE = "workspace-node-instance";

    public List getPages(MigrationInfo[] infos, TraversableContext context) {
        List pages = this.getChildrenPages(infos, context);
        pages.addAll(super.getPages(infos, context));
        return pages;
    }

    String getRootQname() {
        return "jws:workspace";
    }

    protected final void preMigrate(MigrationInfo[] infos, TraversableContext context) {
        int i = 0;
        while (i < infos.length) {
            Node node = infos[i].getNode();
            node.setMigrating();
            ++i;
        }
        this.initContext(infos, context);
        Map map = this.getInfoToMigratorMap(context);
        for (Map.Entry entry : map.entrySet()) {
            List list = (List)entry.getValue();
            MigrationInfo[] cinfos = list.toArray(new MigrationInfo[list.size()]);
            int j = 0;
            while (j < cinfos.length) {
                Node node = cinfos[j].getNode();
                node.setMigrating();
                ++j;
            }
        }
    }

    protected final void postMigrate(MigrationInfo[] infos, TraversableContext context) {
        boolean fireEvents = false;
        int i = 0;
        while (i < infos.length) {
            Node node = infos[i].getNode();
            fireEvents = infos[i].getMigrationStatus() == MigrationInfo.MIGRATION_DONE;
            node.unsetMigrating(fireEvents);
            ++i;
        }
        Map map = this.getInfoToMigratorMap(context);
        for (Map.Entry entry : map.entrySet()) {
            List list = (List)entry.getValue();
            MigrationInfo[] cinfos = list.toArray(new MigrationInfo[list.size()]);
            int j = 0;
            while (j < cinfos.length) {
                Node node = cinfos[j].getNode();
                node.unsetMigrating(fireEvents);
                ++j;
            }
        }
    }

    protected String getMsg(MigrationInfo[] infos) {
        String product = IdeArb.format(405, Version.NAME_SHORT, Version.VER);
        if (infos.length > 1) {
            return IdeArb.format(46, product);
        }
        URL nodeURL = infos[0].getNode().getURL();
        String fname = URLFileSystem.getPlatformPathName((URL)nodeURL);
        return IdeArb.format(315, fname, product);
    }

    protected String getTitle() {
        return IdeArb.getString(443);
    }

    protected String getSummaryMsg(MigrationInfo[] infos) {
        if (infos.length > 1) {
            return IdeArb.getString(115);
        }
        URL nodeURL = infos[0].getNode().getURL();
        String fname = URLFileSystem.getPlatformPathName((URL)nodeURL);
        return IdeArb.format(36, fname);
    }

    private void initContext(MigrationInfo[] infos, TraversableContext context) {
        int i = 0;
        int n = infos.length;
        while (i < n) {
            this.initContext(infos[i], context);
            ++i;
        }
    }

    private List getChildrenPages(MigrationInfo[] infos, TraversableContext context) {
        ArrayList pages = new ArrayList();
        Map map = this.getInfoToMigratorMap(context);
        for (Map.Entry entry : map.entrySet()) {
            NodeMigrator migrator = (NodeMigrator)entry.getKey();
            List list = (List)entry.getValue();
            MigrationInfo[] cinfos = list.toArray(new MigrationInfo[list.size()]);
            pages.addAll(migrator.getPages(cinfos, context));
        }
        return pages;
    }

    private void initContext(MigrationInfo info, TraversableContext context) {
        Workspace workspace = (Workspace)info.getNode();
        Iterator<Element> children = workspace.getChildren();
        Map map = this.getInfoToMigratorMap(context);
        context.put(WORKSPACE_NODE, (Object)workspace);
        while (children.hasNext()) {
            Element child = children.next();
            if (!(child instanceof Node)) continue;
            Node node = (Node)child;
            if (URLFileSystem.exists((URL)node.getURL())) {
                String key = NodeMigrator.getLookupKey(node);
                NodeMigrator migrator = NodeMigrator.getNodeMigrator(key);
                if (migrator == null) continue;
                MigrationInfo childInfo = migrator.getMigrationInfo(node);
                this.mapInfoToMigrator(migrator, childInfo, map);
                continue;
            }
            workspace.remove(node);
        }
    }
}

