/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.awt.Window;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.text.Segment;
import javax.swing.undo.UndoableEdit;
import oracle.ide.Ide;
import oracle.ide.config.EnvironOptions;
import oracle.ide.history.HistoryManager;
import oracle.ide.model.Attributes;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Node;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFileSystem;
import oracle.ide.resource.IdeArb;
import oracle.ide.resource.ModelArb;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.TextBufferStreamFactory;
import oracle.javatools.buffer.AbstractTextBuffer;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.OffsetMark;
import oracle.javatools.buffer.ReadOnlyException;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.ReadWriteLock;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.buffer.TextBufferListener;
import oracle.javatools.buffer.Utilities;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.util.Log;

public class TextNode
extends Node {
    private static final Logger LOG;
    private static final Log EXPIRATION_LOG;
    private static final Log EXPIRATION_DETAIL_LOG;
    private AbstractTextBuffer realBuffer;
    private FacadeTextBuffer facadeBuffer;
    private FacadeBufferReference facadeBufferReference;
    private Object facadeBufferLock;
    private volatile boolean isDirty;
    private FacadeTextBufferListener realBufferListener;
    private boolean isLoading;
    private boolean autoClosing;
    private AbstractTextBuffer.UndoState undoState;
    private AbstractTextBuffer.UndoState unmodifiedUndoState;
    static final /* synthetic */ boolean $assertionsDisabled;
    private boolean lastReadOnly;
    private String _loadEncoding;
    private String _saveEncoding;

    public TextNode() {
        this(null);
    }

    public TextNode(URL url) {
        super(url);
        this.$init$();
        this.getAttributes().set(ElementAttributes.DELETEABLE | ElementAttributes.RENAMEABLE | ElementAttributes.SAVEABLE | ElementAttributes.EDITOR_SAVEABLE_AS | ElementAttributes.CLOSEABLE | ElementAttributes.PRINTABLE);
    }

    private void $init$() {
        this.facadeBufferLock = new Object();
        this.realBufferListener = new FacadeTextBufferListener(this);
        this.isLoading = false;
        this.autoClosing = false;
        this.lastReadOnly = false;
    }

    protected void readUnlock() {
        if (!this.isDirty && this.lockCount() == 1) {
            this.clearFacadeBuffer();
        }
        super.readUnlock();
    }

    protected void writeUnlock() {
        if (!this.isDirty && this.lockCount() == 1) {
            this.clearFacadeBuffer();
        }
        super.writeUnlock();
    }

    protected void upgradeUnlock() {
        if (!this.isDirty && this.lockCount() == 1) {
            this.clearFacadeBuffer();
        }
        super.writeUnlock();
    }

    static {
        $assertionsDisabled = TextNode.class.desiredAssertionStatus() ^ true;
        LOG = Logger.getLogger(TextBuffer.class.getName());
        EXPIRATION_LOG = new Log("expiration", "expiration-detail");
        EXPIRATION_DETAIL_LOG = new Log("expiration-detail");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FacadeTextBuffer facadeBuffer() {
        if (!$assertionsDisabled && !this.isReadOrWriteLocked()) {
            throw new AssertionError();
        }
        if (this.realBuffer == null) {
            return null;
        }
        Object object = this.facadeBufferLock;
        synchronized (object) {
            if (this.facadeBuffer != null) {
                FacadeTextBuffer facadeTextBuffer = this.facadeBuffer;
                return facadeTextBuffer;
            }
            if (this.facadeBufferReference != null) {
                this.facadeBuffer = (FacadeTextBuffer)this.facadeBufferReference.get();
                if (this.facadeBuffer != null) {
                    FacadeTextBuffer facadeTextBuffer = this.facadeBuffer;
                    return facadeTextBuffer;
                }
            }
            this.facadeBuffer = new FacadeTextBuffer((TextBuffer)this.realBuffer, this.realBufferListener, this.nodeLock());
            this.facadeBufferReference = new FacadeBufferReference(this, this.facadeBuffer);
            EXPIRATION_LOG.trace("created facade {0}", (Object)this.facadeBufferReference);
            FacadeTextBuffer facadeTextBuffer = this.facadeBuffer;
            return facadeTextBuffer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearFacadeBuffer() {
        Object object = this.facadeBufferLock;
        synchronized (object) {
            this.facadeBuffer = null;
        }
    }

    private void loadTextBuffer() throws IOException {
        if (!$assertionsDisabled && !this.isWriteLocked()) {
            throw new AssertionError();
        }
        FacadeTextBuffer textBuffer = this.facadeBuffer();
        this.isLoading = true;
        try {
            block20: {
                try {
                    URL url = this.getURL();
                    if (url == null) {
                        throw new NullPointerException("null URL, cannot load data");
                    }
                    Reader reader = this.createReader(url);
                    if (reader != null) {
                        try {
                            textBuffer.read(reader);
                            break block20;
                        }
                        finally {
                            try {
                                reader.close();
                            }
                            catch (IOException e) {}
                        }
                    }
                    if (!textBuffer.isReadOnly()) {
                        textBuffer.removeToEnd(0);
                    }
                }
                catch (FileNotFoundException e) {
                }
                catch (IOException e) {
                    if (!textBuffer.isReadOnly()) {
                        textBuffer.removeToEnd(0);
                    }
                    throw e;
                }
            }
            if (textBuffer.isReadOnly() != super.isReadOnly()) {
                textBuffer.setReadOnly(super.isReadOnly());
            }
        }
        finally {
            textBuffer.clearModified();
            this.isLoading = false;
        }
        if (!Utilities.attachUndoState((AbstractTextBuffer)this.realBuffer, (AbstractTextBuffer.UndoState)this.undoState)) {
            Utilities.attachUndoState((AbstractTextBuffer)this.realBuffer, (AbstractTextBuffer.UndoState)this.unmodifiedUndoState);
        }
        this.unmodifiedUndoState = Utilities.copyUndoState((AbstractTextBuffer)this.realBuffer);
        this.undoState = null;
    }

    public boolean setReadOnly(boolean readOnly) {
        URL url;
        if (!this.getAttributes().isSet(ElementAttributes.NON_EDITABLE) && (url = this.getURL()) != null) {
            return URLFileSystem.setReadOnly((URL)url, (boolean)readOnly);
        }
        return false;
    }

    public boolean isReadOnly() {
        boolean readOnly = super.isReadOnly();
        if (this.nodeLock().tryReadLock()) {
            try {
                if (this.realBuffer != null && this.realBuffer.isReadOnly() != readOnly) {
                    this.realBuffer.setReadOnly(readOnly);
                }
            }
            finally {
                this.readUnlock();
            }
        }
        Attributes attributes = null;
        if (readOnly != this.lastReadOnly) {
            this.lastReadOnly = readOnly;
            attributes = this.getAttributes();
            if (readOnly) {
                attributes.set(ElementAttributes.READ_ONLY);
            } else {
                attributes.unset(ElementAttributes.READ_ONLY);
            }
            attributes = this.getAttributes().duplicate();
        }
        if (attributes != null) {
            UpdateMessage.fireAttributeChanged(this, attributes);
        }
        return readOnly;
    }

    public boolean isDirty() {
        return super.isDirty();
    }

    public void markDirty(boolean dirty) {
        super.markDirty(dirty);
    }

    protected void markDirtyImpl(boolean dirty) {
        this.isDirty = dirty;
        if (!dirty && this.realBuffer != null) {
            this.realBuffer.clearModified();
        }
    }

    protected void openImpl() throws IOException {
        if (!$assertionsDisabled && !this.isWriteLocked()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.realBuffer != null) {
            throw new AssertionError((Object)(this.getClass().getName() + " " + this.getLongLabel() + ", facade " + this.facadeBuffer));
        }
        this.realBuffer = (AbstractTextBuffer)TextBufferFactory.createTextBuffer((ReadWriteLock)this.nodeLock());
        this.setDefaultLineTerminator((TextBuffer)this.realBuffer);
        this.realBuffer.addTextBufferListener((TextBufferListener)this.realBufferListener);
        try {
            this.loadTextBuffer();
        }
        catch (IOException e) {
            this.realBuffer.removeTextBufferListener((TextBufferListener)this.realBufferListener);
            this.realBuffer = null;
            throw e;
        }
        catch (Throwable e) {
            this.realBuffer.removeTextBufferListener((TextBufferListener)this.realBufferListener);
            this.realBuffer = null;
            IOException ioe = new IOException("exception loading " + this.getLongLabel());
            ioe.initCause(e);
            throw ioe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeImpl() throws IOException {
        if (!$assertionsDisabled && !this.isWriteLocked()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.realBuffer == null) {
            throw new AssertionError();
        }
        this.realBufferListener.clear();
        this.realBuffer.removeTextBufferListener((TextBufferListener)this.realBufferListener);
        Object object = this.facadeBufferLock;
        synchronized (object) {
            FacadeTextBuffer facade = (FacadeTextBuffer)this.facadeBufferReference.get();
            if (facade != null) {
                FacadeTextBuffer.mav$dispose(facade, this.autoClosing);
            }
            this.facadeBufferReference.clear();
            this.facadeBufferReference = null;
            this.facadeBuffer = null;
        }
        this.undoState = Utilities.detachUndoState((AbstractTextBuffer)this.realBuffer);
        this.realBuffer = null;
    }

    protected void saveImpl() throws IOException {
        if (!$assertionsDisabled && !this.isWriteLocked()) {
            throw new AssertionError();
        }
        boolean isNew = this.isNew();
        if (this.isDirty() || isNew) {
            FacadeTextBuffer facadeBuffer;
            HistoryManager history = null;
            URL[] urls = null;
            if (Ide.isRunning()) {
                history = HistoryManager.getHistoryManager();
                urls = new URL[]{this.getURL()};
                if (history != null && !isNew) {
                    try {
                        history.persistInitialState(urls);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            if ((facadeBuffer = this.facadeBuffer()) == null) {
                throw new IllegalStateException("on save, no buffer available");
            }
            OutputStream outputStream = null;
            Writer writer = null;
            try {
                outputStream = URLFileSystem.openOutputStream((URL)this.getURL());
                writer = this.createOutputStreamWriter(outputStream);
                facadeBuffer.write(writer);
            }
            finally {
                try {
                    if (writer != null) {
                        writer.close();
                    } else if (outputStream != null) {
                        outputStream.close();
                    }
                }
                catch (IOException e) {}
            }
            this.unmodifiedUndoState = Utilities.copyUndoState((AbstractTextBuffer)this.realBuffer);
            if (history != null) {
                try {
                    String historyText = isNew ? IdeArb.getString(183) : IdeArb.getString(85);
                    history.persist(urls, historyText);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected void revertImpl() throws IOException {
        if (!$assertionsDisabled && !this.isWriteLocked()) {
            throw new AssertionError();
        }
        this.loadTextBuffer();
    }

    protected void setDefaultLineTerminator(TextBuffer textBuffer) {
        int terminator;
        try {
            EnvironOptions options = Ide.getEnvironOptions();
            terminator = options.getLineTerminator();
        }
        catch (NullPointerException e) {
            terminator = 0;
        }
        switch (terminator) {
            case 1: {
                textBuffer.setEOLType("\r\n");
                break;
            }
            case 2: {
                textBuffer.setEOLType("\n");
                break;
            }
            case 3: {
                textBuffer.setEOLType("\r");
                break;
            }
        }
    }

    public final TextBuffer acquireTextBuffer() {
        this.readLock();
        try {
            this.ensureOpen();
            FacadeTextBuffer facadeTextBuffer = this.facadeBuffer();
            return facadeTextBuffer;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            this.readUnlock();
        }
    }

    public final TextBuffer acquireTextBufferOrThrow() throws IOException {
        this.readLock();
        try {
            this.open();
            FacadeTextBuffer facadeTextBuffer = this.facadeBuffer();
            return facadeTextBuffer;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            this.readUnlock();
        }
    }

    public final TextBuffer tryAcquireTextBuffer() {
        ReadWriteLock lock = this.nodeLock();
        if (lock.tryReadLock()) {
            block12: {
                try {
                    if (this.isOpen()) {
                        FacadeTextBuffer facadeTextBuffer = this.facadeBuffer();
                        return facadeTextBuffer;
                    }
                    if (!lock.isWriteLockHeld()) break block12;
                    this.ensureOpen();
                    FacadeTextBuffer facadeTextBuffer = this.facadeBuffer();
                    return facadeTextBuffer;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    this.readUnlock();
                }
            }
            if (!lock.isReadLockHeld() && lock.tryWriteLock()) {
                try {
                    this.ensureOpen();
                    FacadeTextBuffer facadeTextBuffer = this.facadeBuffer();
                    return facadeTextBuffer;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    lock.writeUnlock();
                }
            }
        }
        return null;
    }

    public final void releaseTextBuffer() {
    }

    protected TextBuffer getTextBufferDirectly() {
        this.readLock();
        try {
            FacadeTextBuffer facadeTextBuffer = this.facadeBuffer();
            return facadeTextBuffer;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            this.readUnlock();
        }
    }

    public boolean addTextBufferListener(TextBufferListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener null");
        }
        return this.realBufferListener.addIfAbsent(listener);
    }

    public void removeTextBufferListener(TextBufferListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener null");
        }
        this.realBufferListener.remove(listener);
    }

    public Reader getReader() throws IOException {
        TextBuffer textBuffer = this.acquireTextBuffer();
        if (textBuffer == null) {
            throw new IllegalStateException("getReader(): null text buffer");
        }
        return TextBufferFactory.createReader((ReadTextBuffer)textBuffer);
    }

    public boolean hasEmptyTextBuffer() {
        try {
            boolean bl = this.acquireTextBuffer().getLength() == 0;
            return bl;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            this.releaseTextBuffer();
        }
    }

    public String getLoadEncoding() {
        return this._loadEncoding != null ? this._loadEncoding : IdeUtil.getIdeEncoding();
    }

    public String getSaveEncoding() {
        return this._saveEncoding != null ? this._saveEncoding : IdeUtil.getIdeEncoding();
    }

    public void setLoadEncoding(String loadEncoding) {
        this._loadEncoding = loadEncoding;
    }

    public void setSaveEncoding(String saveEncoding) {
        this._saveEncoding = saveEncoding;
    }

    protected Reader createReader(URL url) throws IOException {
        return URLFileSystem.createReader((URL)url, (String)this.getLoadEncoding());
    }

    protected OutputStreamWriter createOutputStreamWriter(OutputStream outStream) throws UnsupportedEncodingException {
        return new OutputStreamWriter(outStream, this.getSaveEncoding());
    }

    public InputStream getInputStream() throws IOException {
        return this.getInputStream(true);
    }

    public InputStream getInputStream(boolean warn) throws IOException {
        TextBuffer textBuffer;
        if (warn) {
            // empty if block
        }
        if ((textBuffer = this.acquireTextBuffer()) != null) {
            return TextBufferStreamFactory.getInputStream(textBuffer, this.getSaveEncoding());
        }
        throw new IllegalStateException("getInputStream(): null text buffer");
    }

    protected void reportOpenException(Exception e) {
        super.reportOpenException(e);
        String message = ModelArb.format(39, this.getURL());
        if (!Ide.getIdeArgs().getCreateUI()) {
            System.err.println(message);
            e.printStackTrace();
            return;
        }
        1 showErrorRunnable = new 1(this, e, message);
        if (SwingUtilities.isEventDispatchThread()) {
            showErrorRunnable.run();
        } else {
            SwingUtilities.invokeLater(showErrorRunnable);
        }
    }

    static boolean ra$isLoading(TextNode textNode) {
        return textNode.isLoading;
    }

    static FacadeTextBuffer mav$facadeBuffer(TextNode textNode) {
        return textNode.facadeBuffer();
    }

    static Logger ra$LOG() {
        return LOG;
    }

    static void wa$autoClosing(TextNode textNode, boolean bl) {
        textNode.autoClosing = bl;
    }

    static FacadeBufferReference ra$facadeBufferReference(TextNode textNode) {
        return textNode.facadeBufferReference;
    }

    static Log ra$EXPIRATION_LOG() {
        return EXPIRATION_LOG;
    }

    static Log ra$EXPIRATION_DETAIL_LOG() {
        return EXPIRATION_DETAIL_LOG;
    }

    private static final class FacadeTextBuffer
    implements TextBuffer {
        private TextBuffer realBuffer;
        private FacadeTextBufferListener realBufferListener;
        private ReadWriteLock lock;
        private boolean autoClosed;

        public FacadeTextBuffer(TextBuffer realBuffer, FacadeTextBufferListener realBufferListener, ReadWriteLock lock) {
            this.realBuffer = realBuffer;
            this.realBufferListener = realBufferListener;
            this.lock = lock;
        }

        private void dispose(boolean autoClosed) {
            this.autoClosed = autoClosed;
            this.realBuffer = null;
        }

        private String expirationMessage() {
            return this.autoClosed ? this.lock.getName() + " (auto-closed)" : this.lock.getName();
        }

        public void addTextBufferListener(TextBufferListener listener) {
            if (this.realBuffer == null) {
                throw new ExpiredTextBufferException(this.expirationMessage());
            }
            this.realBufferListener.addIfAbsent(listener);
        }

        public void removeTextBufferListener(TextBufferListener listener) {
            if (this.realBuffer != null) {
                this.realBufferListener.remove(listener);
            }
        }

        public OffsetMark addOffsetMark(int offset) {
            TextBuffer buffer = this.realBuffer;
            if (buffer != null) {
                return buffer.addOffsetMark(offset, true);
            }
            throw new ExpiredTextBufferException(this.expirationMessage());
        }

        public OffsetMark addOffsetMark(int offset, boolean bias) {
            TextBuffer buffer = this.realBuffer;
            if (buffer != null) {
                return buffer.addOffsetMark(offset, bias);
            }
            throw new ExpiredTextBufferException(this.expirationMessage());
        }

        public void removeOffsetMark(OffsetMark offsetMark) {
            TextBuffer buffer = this.realBuffer;
            if (buffer != null) {
                buffer.removeOffsetMark(offsetMark);
            }
        }

        public UndoableEdit append(char[] data) throws IndexOutOfBoundsException, ReadOnlyException {
            TextBuffer buffer = this.realBuffer;
            if (buffer != null) {
                return buffer.append(data);
            }
            throw new ExpiredTextBufferException(this.expirationMessage());
        }

        public void beginEdit() throws ReadOnlyException {
            TextBuffer buffer = this.realBuffer;
            if (buffer == null) {
                throw new ExpiredTextBufferException(this.expirationMessage());
            }
            buffer.beginEdit();
        }

        public void clearModified() {
            TextBuffer buffer = this.realBuffer;
            if (buffer == null) {
                throw new ExpiredTextBufferException(this.expirationMessage());
            }
            buffer.clearModified();
        }

        public UndoableEdit endEdit() {
            TextBuffer buffer = this.realBuffer;
            if (buffer != null) {
                return buffer.endEdit();
            }
            throw new ExpiredTextBufferException(this.expirationMessage());
        }

        public int getChangeId() {
            TextBuffer buffer = this.realBuffer;
            if (buffer != null) {
                return buffer.getChangeId();
            }
            throw new ExpiredTextBufferException(this.expirationMessage());
        }

        public String getEOLType() {
            TextBuffer buffer = this.realBuffer;
            if (buffer != null) {
                return buffer.getEOLType();
            }
            throw new ExpiredTextBufferException(this.expirationMessage());
        }

        public LineMap getLineMap() {
            TextBuffer buffer = this.realBuffer;
            if (buffer != null) {
                return buffer.getLineMap();
            }
            throw new ExpiredTextBufferException(this.expirationMessage());
        }

        public String getPlatformEOLType() {
            TextBuffer buffer = this.realBuffer;
            if (buffer != null) {
                return buffer.getPlatformEOLType();
            }
            throw new ExpiredTextBufferException(this.expirationMessage());
        }

        public UndoableEdit insert(int offset, char[] data) throws IndexOutOfBoundsException, ReadOnlyException {
            TextBuffer buffer = this.realBuffer;
            if (buffer != null) {
                return buffer.insert(offset, data);
            }
            throw new ExpiredTextBufferException(this.expirationMessage());
        }

        public UndoableEdit insert(int offset, Reader reader) throws IndexOutOfBoundsException, IOException, ReadOnlyException {
            TextBuffer buffer = this.realBuffer;
            if (buffer != null) {
                return buffer.insert(offset, reader);
            }
            throw new ExpiredTextBufferException(this.expirationMessage());
        }

        public boolean isModified() {
            TextBuffer buffer = this.realBuffer;
            if (buffer != null) {
                return buffer.isModified();
            }
            throw new ExpiredTextBufferException(this.expirationMessage());
        }

        public boolean isReadOnly() {
            TextBuffer buffer = this.realBuffer;
            if (buffer != null) {
                return buffer.isReadOnly();
            }
            throw new ExpiredTextBufferException(this.expirationMessage());
        }

        public void read(Reader reader) throws IOException {
            TextBuffer buffer = this.realBuffer;
            if (buffer == null) {
                throw new ExpiredTextBufferException(this.expirationMessage());
            }
            buffer.read(reader);
        }

        public UndoableEdit remove(int offset, int count) throws IndexOutOfBoundsException, ReadOnlyException {
            TextBuffer buffer = this.realBuffer;
            if (buffer != null) {
                return buffer.remove(offset, count);
            }
            throw new ExpiredTextBufferException(this.expirationMessage());
        }

        public UndoableEdit removeToEnd(int offset) throws IndexOutOfBoundsException, ReadOnlyException {
            TextBuffer buffer = this.realBuffer;
            if (buffer != null) {
                return buffer.removeToEnd(offset);
            }
            throw new ExpiredTextBufferException(this.expirationMessage());
        }

        public void setEOLType(String eolType) throws ReadOnlyException {
            TextBuffer buffer = this.realBuffer;
            if (buffer == null) {
                throw new ExpiredTextBufferException(this.expirationMessage());
            }
            buffer.setEOLType(eolType);
        }

        public void setReadOnly(boolean readOnly) {
            TextBuffer buffer = this.realBuffer;
            if (buffer == null) {
                throw new ExpiredTextBufferException(this.expirationMessage());
            }
            buffer.setReadOnly(readOnly);
        }

        public void write(Writer writer) throws IOException {
            TextBuffer buffer = this.realBuffer;
            if (buffer == null) {
                throw new ExpiredTextBufferException(this.expirationMessage());
            }
            buffer.write(writer);
        }

        public void write(Writer writer, boolean clearModified) throws IOException {
            TextBuffer buffer = this.realBuffer;
            if (buffer == null) {
                throw new ExpiredTextBufferException(this.expirationMessage());
            }
            buffer.write(writer, clearModified);
        }

        public int getLength() {
            TextBuffer buffer = this.realBuffer;
            if (buffer != null) {
                return buffer.getLength();
            }
            throw new ExpiredTextBufferException(this.expirationMessage());
        }

        public char getChar(int offset) throws IndexOutOfBoundsException {
            TextBuffer buffer = this.realBuffer;
            if (buffer != null) {
                return buffer.getChar(offset);
            }
            throw new IndexOutOfBoundsException("ExpiredTextBufferException: " + this.expirationMessage());
        }

        public char[] getChars(int offset, int length) throws IndexOutOfBoundsException {
            TextBuffer buffer = this.realBuffer;
            if (buffer != null) {
                return buffer.getChars(offset, length);
            }
            throw new IndexOutOfBoundsException("ExpiredTextBufferException: " + this.expirationMessage());
        }

        public String getString(int offset, int length) throws IndexOutOfBoundsException {
            TextBuffer buffer = this.realBuffer;
            if (buffer != null) {
                return buffer.getString(offset, length);
            }
            throw new IndexOutOfBoundsException("ExpiredTextBufferException: " + this.expirationMessage());
        }

        public void getText(int offset, int length, Segment segment) throws IndexOutOfBoundsException {
            TextBuffer buffer = this.realBuffer;
            if (buffer == null) {
                throw new ExpiredTextBufferException(this.expirationMessage());
            }
            buffer.getText(offset, length, segment);
        }

        public void writeLock() throws ReadOnlyException {
            TextBuffer buffer = this.realBuffer;
            if (buffer != null) {
                buffer.writeLock();
            } else {
                this.lock.writeLock();
            }
        }

        public void writeLock(boolean checkIfReadOnly) throws ReadOnlyException {
            TextBuffer buffer = this.realBuffer;
            if (buffer != null) {
                buffer.writeLock(checkIfReadOnly);
            } else {
                this.lock.writeLock();
            }
        }

        public boolean tryWriteLock() throws ReadOnlyException {
            TextBuffer buffer = this.realBuffer;
            if (buffer != null) {
                return buffer.tryWriteLock();
            }
            return this.lock.tryWriteLock();
        }

        public void writeUnlock() {
            TextBuffer buffer = this.realBuffer;
            if (buffer != null) {
                buffer.writeUnlock();
            } else {
                this.lock.writeUnlock();
            }
        }

        public void readLock() {
            TextBuffer buffer = this.realBuffer;
            if (buffer != null) {
                buffer.readLock();
            } else {
                this.lock.readLock();
            }
        }

        public int getLockStatus() {
            TextBuffer buffer = this.realBuffer;
            if (buffer != null) {
                return buffer.getLockStatus();
            }
            if (this.lock.isWriteLockHeld()) {
                return 2;
            }
            if (this.lock.isReadLockHeld()) {
                return 1;
            }
            return 0;
        }

        public boolean tryReadLock() {
            TextBuffer buffer = this.realBuffer;
            if (buffer != null) {
                return buffer.tryReadLock();
            }
            return this.lock.tryReadLock();
        }

        public void readUnlock() {
            TextBuffer buffer = this.realBuffer;
            if (buffer != null) {
                buffer.readUnlock();
            } else {
                this.lock.readUnlock();
            }
        }

        static void mav$dispose(FacadeTextBuffer facadeTextBuffer, boolean bl) {
            facadeTextBuffer.dispose(bl);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FacadeTextBufferListener
    extends CopyOnWriteArrayList<TextBufferListener>
    implements TextBufferListener {
        private TextNode node;

        public FacadeTextBufferListener(TextNode node) {
            this.node = node;
        }

        public void insertUpdate(TextBuffer buffer, int offset, int count, char[] insertedData) {
            if (!TextNode.ra$isLoading(this.node)) {
                this.node.setTimestampDirectly(System.currentTimeMillis());
            }
            FacadeTextBuffer facadeBuffer = TextNode.mav$facadeBuffer(this.node);
            for (TextBufferListener listener : this) {
                try {
                    listener.insertUpdate((TextBuffer)facadeBuffer, offset, count, insertedData);
                }
                catch (Throwable e) {
                    TextNode.ra$LOG().log(Level.SEVERE, "Exception thrown by TextBufferListener " + listener + " inserting " + insertedData.length + " at " + offset, e);
                }
            }
        }

        public void removeUpdate(TextBuffer buffer, int offset, int count, char[] removedData) {
            if (!TextNode.ra$isLoading(this.node)) {
                this.node.setTimestampDirectly(System.currentTimeMillis());
            }
            FacadeTextBuffer facadeBuffer = TextNode.mav$facadeBuffer(this.node);
            for (TextBufferListener listener : this) {
                try {
                    listener.removeUpdate((TextBuffer)facadeBuffer, offset, count, removedData);
                }
                catch (Throwable e) {
                    TextNode.ra$LOG().log(Level.SEVERE, "Exception thrown by TextBufferListener " + listener + " removing " + removedData.length + " from " + offset, e);
                }
            }
        }

        public void attributeUpdate(TextBuffer buffer, int attribute) {
            if (!TextNode.ra$isLoading(this.node) && attribute == 5) {
                this.node.markDirty(buffer.isModified());
            }
            FacadeTextBuffer facadeBuffer = TextNode.mav$facadeBuffer(this.node);
            for (TextBufferListener listener : this) {
                try {
                    listener.attributeUpdate((TextBuffer)facadeBuffer, attribute);
                }
                catch (Throwable e) {
                    TextNode.ra$LOG().log(Level.SEVERE, "Exception thrown by TextBufferListener " + listener + " updating attribute " + attribute, e);
                }
            }
        }
    }

    final class 1
    implements Runnable {
        private final /* synthetic */ Exception v$e;
        private final /* synthetic */ String v$message;
        final /* synthetic */ TextNode this$0;

        public void run() {
            ExceptionDialog.showExceptionDialog((Window)IdeUtil.getMainWindow(), (Exception)this.v$e, (String)ModelArb.getString(60), (String)this.v$message);
        }

        public 1(TextNode textNode, Exception exception, String string) {
            this.v$message = string;
            this.v$e = exception;
            this.this$0 = textNode;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FacadeBufferReference
    extends WeakReference<FacadeTextBuffer>
    implements Runnable {
        private static ReferenceQueue<FacadeTextBuffer> queue;
        private TextNode node;

        public FacadeBufferReference(TextNode node, FacadeTextBuffer buffer) {
            super(buffer, FacadeBufferReference.getQueue());
            this.node = node;
        }

        @Override
        public synchronized void clear() {
            super.clear();
            this.node = null;
        }

        public String toString() {
            return (this.node != null ? this.node.getShortLabel() : "") + "(" + System.identityHashCode(this) + ")";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            TextNode node;
            FacadeBufferReference facadeBufferReference = this;
            synchronized (facadeBufferReference) {
                node = this.node;
                if (node == null) {
                    return;
                }
            }
            ReadWriteLock lock = node.nodeLock();
            if (!lock.isLockHeld() && lock.tryWriteLock()) {
                TextNode.wa$autoClosing(node, true);
                try {
                    try {
                        if (this == TextNode.ra$facadeBufferReference(node) && !node.isDirty()) {
                            TextNode.ra$EXPIRATION_LOG().trace("auto-closing node {0}", (Object)this);
                            node.close();
                            TextNode.ra$EXPIRATION_LOG().trace("auto-closed node {0}", (Object)this);
                        }
                        TextNode.ra$EXPIRATION_LOG().trace("skipped auto-closing dirty node {0}", (Object)this);
                    }
                    catch (IOException e) {
                        TextNode.ra$LOG().log(Level.WARNING, "Unexpected exception auto-closing " + node, e);
                        TextNode.ra$EXPIRATION_LOG().trace("closing facade reference {0} failed: {1}", (Object)this, (Object)e);
                    }
                }
                finally {
                    TextNode.wa$autoClosing(node, false);
                    lock.writeUnlock();
                }
            } else if (TextNode.ra$EXPIRATION_DETAIL_LOG().isEnabled()) {
                StringBuilder buffer = new StringBuilder();
                lock.appendSnapshot(buffer);
                TextNode.ra$EXPIRATION_DETAIL_LOG().trace("auto-closing node {0} failed because lock was unavailable:\n{0}", (Object)buffer);
            } else {
                TextNode.ra$EXPIRATION_LOG().trace("auto-closing node {0} failed because lock was unavailable", (Object)this);
            }
        }

        private static final synchronized ReferenceQueue<FacadeTextBuffer> getQueue() {
            if (queue == null) {
                queue = new ReferenceQueue();
                new PollingThread().start();
            }
            return queue;
        }

        static ReferenceQueue ra$queue() {
            return queue;
        }

        private static final class PollingThread
        extends Thread {
            public PollingThread() {
                super("TextBufferScavenger");
            }

            public void run() {
                while (true) {
                    try {
                        while (true) {
                            FacadeBufferReference referer = (FacadeBufferReference)FacadeBufferReference.ra$queue().remove();
                            TextNode.ra$EXPIRATION_LOG().trace("dequed facade reference {0}", (Object)referer);
                            SwingUtilities.invokeLater(referer);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
        }
    }
}

