/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.net.URL;
import java.util.Map;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeListener;
import oracle.ide.model.TextNode;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferListener;
import oracle.javatools.compare.CompareContributor;
import oracle.javatools.compare.CompareFailedException;
import oracle.javatools.compare.CompareModelFactory;
import oracle.javatools.compare.CompareType;
import oracle.javatools.compare.ContributorKind;
import oracle.javatools.compare.algorithm.chararray.CharArrayCompareContributor;
import oracle.javatools.compare.algorithm.sequence.SequenceCompareDifference;
import oracle.javatools.compare.algorithm.sequence.SequenceCompareModel;
import oracle.javatools.util.Log;
import oracle.javatools.util.Maps;

public class TextBufferTracker
extends NodeListener
implements TextBufferListener {
    private static Map<URL, TextBufferTracker> instances;
    private static Edit[] NO_EDITS;
    private URL url;
    private int initialId;
    private int initialLength;
    private boolean reloading;
    private char[] removedText;
    private char[] insertedText;
    private int version;
    private Edit[] edits;
    private static final Object LOCK;
    private static final Log LOG;
    static final /* synthetic */ boolean $assertionsDisabled;
    private static final int LIMIT = 32768;

    private void $init$() {
        this.initialId = -1;
        this.initialLength = -1;
        this.reloading = false;
        this.version = 0;
        this.edits = NO_EDITS;
    }

    static {
        $assertionsDisabled = TextBufferTracker.class.desiredAssertionStatus() ^ true;
        instances = new Maps.WeakHashMap();
        NO_EDITS = new Edit[0];
        LOCK = new Object();
        LOG = new Log("tracker");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TextBufferTracker getTracker(TextNode node) {
        TextBufferTracker newTracker;
        if (!$assertionsDisabled && !LOG.trace("getting tracker for {0}", (Object)node)) {
            throw new AssertionError();
        }
        URL url = node.getURL();
        Object object = LOCK;
        synchronized (object) {
            TextBufferTracker tracker = instances.get(url);
            if (tracker != null) {
                TextBufferTracker textBufferTracker = tracker;
                return textBufferTracker;
            }
            newTracker = new TextBufferTracker(node);
            instances.put(url, newTracker);
        }
        node.runUnderReadLock(new 1(newTracker, node));
        return newTracker;
    }

    private TextBufferTracker(TextNode node) {
        this.$init$();
        if (!$assertionsDisabled && !LOG.trace("creating tracker for {0}", (Object)node)) {
            throw new AssertionError();
        }
        this.url = node.getURL();
        node.addNodeListener(this);
    }

    public int getVersion() {
        return this.version;
    }

    public boolean adjustOffsetLength(int offset, int length, int version, int[] adjusted) {
        boolean modified = false;
        int i = version;
        while (i < this.version) {
            Edit edit = this.edits[i];
            if (edit.offset <= offset + length) {
                if (edit.delta >= 0) {
                    if (edit.offset <= offset) {
                        offset += edit.delta;
                    } else {
                        length += edit.delta;
                        modified = true;
                    }
                } else {
                    int delta = edit.delta;
                    int endOffset = edit.offset - delta;
                    if (edit.offset <= offset) {
                        if (endOffset <= offset) {
                            offset += delta;
                        } else {
                            int excess = endOffset - offset;
                            offset += delta + excess;
                            if ((length -= excess) < 0) {
                                length = 0;
                            }
                            modified = true;
                        }
                    } else {
                        int markOffset = offset + length;
                        if (endOffset <= markOffset) {
                            length += delta;
                        } else {
                            int excess = endOffset - markOffset;
                            if ((length -= excess) < 0) {
                                length = 0;
                            }
                        }
                        modified = true;
                    }
                }
            }
            ++i;
        }
        adjusted[0] = offset;
        adjusted[1] = length;
        return modified;
    }

    public boolean isModified(int version) {
        return this.id(version) != this.id(this.version);
    }

    public boolean isModified(int offset, int length, int version) {
        return this.adjustOffsetLength(offset, length, version, new int[]{offset, length});
    }

    public String toString() {
        return "tracker (" + URLFileSystem.getPlatformPathName((URL)this.url) + ", version " + this.version + ", id " + this.id(this.version) + ", length " + this.length(this.version) + ")";
    }

    public void nodeWillOpen(NodeEvent e) {
        if (!$assertionsDisabled && !LOG.trace("node will open, {0}", (Object)this)) {
            throw new AssertionError();
        }
    }

    public void nodeOpened(NodeEvent event) {
        if (!$assertionsDisabled && !LOG.trace("node opened, {0}", (Object)this)) {
            throw new AssertionError();
        }
        this.nodeOpened((TextNode)event.getNode());
    }

    private void nodeOpened(TextNode node) {
        TextBuffer buffer = node.acquireTextBuffer();
        if (!$assertionsDisabled && !TextBufferTracker.isLocked(buffer)) {
            throw new AssertionError();
        }
        if (this.initialLength < 0) {
            this.initialId = buffer.getChangeId();
            this.initialLength = buffer.getLength();
        } else {
            this.reconcileReload(buffer, null, null);
        }
        buffer.addTextBufferListener((TextBufferListener)this);
        if (!$assertionsDisabled && !LOG.trace("started tracking {2}, initial id {0}, initial length {1}", this.initialId, this.initialLength, (Object)this)) {
            throw new AssertionError();
        }
    }

    public void nodeDirtyStateChanged(NodeEvent e, boolean dirty) {
        if (!$assertionsDisabled && !LOG.trace("node dirty state changed to {0}, {1}", dirty, (Object)this)) {
            throw new AssertionError();
        }
    }

    public void nodeWillClose(NodeEvent e) {
        if (!$assertionsDisabled && !LOG.trace("node will close, {0}", (Object)this)) {
            throw new AssertionError();
        }
    }

    public void nodeClosed(NodeEvent event) {
        if (!$assertionsDisabled && !LOG.trace("node closed, {0}", (Object)this)) {
            throw new AssertionError();
        }
        TextNode node = (TextNode)event.getNode();
        node.removeTextBufferListener(this);
        this.reloading = false;
        this.removedText = null;
        this.insertedText = null;
    }

    public void nodeWillBeSaved(NodeEvent e) {
        if (!$assertionsDisabled && !LOG.trace("node will be saved, {0}", (Object)this)) {
            throw new AssertionError();
        }
    }

    public void nodeSaved(NodeEvent e) {
        if (!$assertionsDisabled && !LOG.trace("node saved, {0}", (Object)this)) {
            throw new AssertionError();
        }
    }

    public void nodeReverted(NodeEvent e) {
        if (!$assertionsDisabled && !LOG.trace("node reverted, {0}", (Object)this)) {
            throw new AssertionError();
        }
    }

    public void nodeDeleted(NodeEvent e) {
        if (!$assertionsDisabled && !LOG.trace("node deleted, {0}", (Object)this)) {
            throw new AssertionError();
        }
    }

    public void nodeRenamed(NodeEvent e, URL oldURL, URL newURL) {
        if (!$assertionsDisabled && !LOG.trace("node renamed to {0}, {1}", (Object)this)) {
            throw new AssertionError();
        }
        this.url = newURL;
    }

    public void attributeUpdate(TextBuffer buffer, int attribute) {
        switch (attribute) {
            case 1: {
                if (!$assertionsDisabled && !LOG.trace("buffer attribute EOL changed, id {0}, {1}", buffer.getChangeId(), (Object)this)) {
                    throw new AssertionError();
                }
                break;
            }
            case 5: {
                if (!$assertionsDisabled && !LOG.trace("buffer attribute modified changed to {1}, id {0}, {2}", buffer.getChangeId(), (Object)buffer.isModified(), (Object)this)) {
                    throw new AssertionError();
                }
                break;
            }
            case 2: {
                if (!$assertionsDisabled && !LOG.trace("buffer attribute read-only changed to {1}, id {0}, {2}", buffer.getChangeId(), (Object)buffer.isReadOnly(), (Object)this)) {
                    throw new AssertionError();
                }
                break;
            }
            case 3: {
                if (!$assertionsDisabled && !LOG.trace("buffer reload start, id {0}, {1}", buffer.getChangeId(), (Object)this)) {
                    throw new AssertionError();
                }
                this.reloading = true;
                break;
            }
            case 4: {
                if (!$assertionsDisabled && !LOG.trace("buffer reload end, id {0}, {1}", buffer.getChangeId(), (Object)this)) {
                    throw new AssertionError();
                }
                this.reconcileReload(buffer, this.removedText, this.insertedText);
                this.reloading = false;
                this.removedText = null;
                this.insertedText = null;
                break;
            }
            default: {
                if (!$assertionsDisabled && !LOG.trace("buffer attribute {0} changed, id {1}, {2}", attribute, buffer.getChangeId(), (Object)this)) {
                    throw new AssertionError();
                }
                break;
            }
        }
    }

    private void reconcileReload(TextBuffer buffer, char[] removedText, char[] insertedText) {
        if (!$assertionsDisabled && !TextBufferTracker.isLocked(buffer)) {
            throw new AssertionError();
        }
        int newId = buffer.getChangeId();
        int targetVersion = this.version;
        while (targetVersion >= 0) {
            if (newId == this.id(targetVersion)) {
                int count = this.version - targetVersion;
                LOG.trace("reloading to tracked id {0}, reversing {1} edits", newId, count);
                if (this.version + count >= this.edits.length) {
                    this.edits = new Edit[this.version * 2 + 4];
                    System.arraycopy(this.edits, 0, this.edits, 0, this.version);
                }
                int index = this.version;
                while (index-- > targetVersion) {
                    int offset = this.edits[index].offset;
                    int delta = -this.edits[index].delta;
                    int id = index > 0 ? this.edits[index - 1].id : this.initialId;
                    int length = index > 0 ? this.edits[index - 1].length : this.initialLength;
                    this.edits[this.version++] = new Edit(offset, delta, id, length);
                }
                if (!$assertionsDisabled && !this.verifyLength(buffer)) {
                    throw new AssertionError();
                }
                return;
            }
            --targetVersion;
        }
        if (insertedText != null) {
            if (removedText != null) {
                if (!$assertionsDisabled && !LOG.trace("buffer normal reload: inserting {0} at {1}, id {2}, {3}", insertedText.length, newId, (Object)this)) {
                    throw new AssertionError();
                }
                this.replaceText(buffer, removedText, insertedText);
            } else {
                int length = this.length(this.version);
                if (length == 0) {
                    if (!$assertionsDisabled && !LOG.trace("buffer normal load: inserting {0} at 0, id {1}, {2})", insertedText.length, newId, (Object)this)) {
                        throw new AssertionError();
                    }
                    this.textEdited(buffer, 0, insertedText.length);
                } else {
                    int difference = buffer.getLength() - length;
                    if (!$assertionsDisabled && !LOG.trace("gc reload, no digest match: adjusting length by {0}, id {1}, {2})", difference, newId, (Object)this)) {
                        throw new AssertionError();
                    }
                    if (difference != 0) {
                        this.textEdited(buffer, 0, difference);
                    }
                }
            }
        } else if (removedText != null) {
            if (!$assertionsDisabled && !LOG.trace("normal reload to empty: removing {0} at 0, id {1}, {2})", removedText.length, newId, (Object)this)) {
                throw new AssertionError();
            }
            this.textEdited(buffer, 0, -removedText.length);
        } else {
            int difference = buffer.getLength() - this.length(this.version);
            if (!$assertionsDisabled && !LOG.trace("node reopen, no digest match: adjusting length by {0}, id {1}, {2})", difference, newId, (Object)this)) {
                throw new AssertionError();
            }
            if (difference != 0) {
                this.textEdited(buffer, 0, difference);
            }
        }
        if (!$assertionsDisabled && !this.verifyLength(buffer)) {
            throw new AssertionError();
        }
    }

    public void insertUpdate(TextBuffer buffer, int offset, int count, char[] text) {
        if (this.reloading) {
            if (!$assertionsDisabled && !LOG.trace("reloading: buffer inserting {0} at {1}, id {2}, {3})", count, offset, buffer.getChangeId(), (Object)this)) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && offset != 0) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && count != text.length) {
                throw new AssertionError();
            }
            this.insertedText = text;
        } else {
            if (!$assertionsDisabled && !LOG.trace("buffer inserting {0} at {1}, id {2}, {3})", count, offset, buffer.getChangeId(), (Object)this)) {
                throw new AssertionError();
            }
            this.textEdited(buffer, offset, count);
            if (!$assertionsDisabled && !this.verifyLength(buffer)) {
                throw new AssertionError();
            }
        }
    }

    public void removeUpdate(TextBuffer buffer, int offset, int count, char[] text) {
        if (this.reloading) {
            if (!$assertionsDisabled && !LOG.trace("reloading: buffer removing {0} at {1}, id {2}, {3})", count, offset, buffer.getChangeId(), (Object)this)) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && offset != 0) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && count != text.length) {
                throw new AssertionError();
            }
            this.removedText = text;
        } else {
            if (!$assertionsDisabled && !LOG.trace("buffer removing {0} at {1}, id {2}, {3})", count, offset, buffer.getChangeId(), (Object)this)) {
                throw new AssertionError();
            }
            this.textEdited(buffer, offset, -count);
            if (!$assertionsDisabled && !this.verifyLength(buffer)) {
                throw new AssertionError();
            }
        }
    }

    private void textEdited(TextBuffer buffer, int offset, int count) {
        if (!$assertionsDisabled && !TextBufferTracker.isLocked(buffer)) {
            throw new AssertionError();
        }
        if (this.version == this.edits.length) {
            this.edits = new Edit[this.version * 2 + 4];
            System.arraycopy(this.edits, 0, this.edits, 0, this.version);
        }
        this.edits[this.version++] = new Edit(offset, count, buffer.getChangeId(), buffer.getLength());
    }

    private static boolean isLocked(TextBuffer buffer) {
        switch (buffer.getLockStatus()) {
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    private boolean verifyLength(TextBuffer buffer) {
        int bufferLength = buffer.getLength();
        int[] adjusted = new int[2];
        this.adjustOffsetLength(this.initialLength, 0, 0, adjusted);
        int derivedLength = adjusted[0];
        if (bufferLength != derivedLength) {
            Log.error((String)"buffer length {0}, derived length {1}, initial length {2}, initial id {3}, edits {4}", (Object)bufferLength, (Object)derivedLength, (Object)this.initialLength, (Object)this.initialId, (Object)this.edits);
        }
        return true;
    }

    private int id(int version) {
        if (version == 0) {
            return this.initialId;
        }
        return this.edits[version - 1].id;
    }

    private int length(int version) {
        if (version == 0) {
            return this.initialLength;
        }
        return this.edits[version - 1].length;
    }

    public void replaceText(TextBuffer buffer, char[] fromText, char[] toText) {
        if (fromText.length > 0 && toText.length > 0 && fromText.length < 32768 && toText.length < 32768) {
            SequenceCompareModel model = null;
            try {
                model = (SequenceCompareModel)CompareModelFactory.createCompareModel((CompareContributor)new CharArrayCompareContributor(fromText), (CompareContributor)new CharArrayCompareContributor(toText), (CompareType)CompareType.CHARACTER);
            }
            catch (CompareFailedException cfe) {
                cfe.printStackTrace();
            }
            if (model != null) {
                SequenceCompareDifference[] blocks = model.getDifferenceBlocks();
                int count = blocks.length;
                if (count > 0) {
                    int i = count - 1;
                    while (i >= 0) {
                        SequenceCompareDifference thing = blocks[i];
                        int fromBlockOffset = thing.getStart(ContributorKind.FIRST);
                        int fromBlockLength = thing.getLength(ContributorKind.FIRST);
                        int toBlockLength = thing.getLength(ContributorKind.SECOND);
                        if (fromBlockLength > 0) {
                            this.textEdited(buffer, fromBlockOffset, -fromBlockLength);
                        }
                        if (toBlockLength > 0) {
                            this.textEdited(buffer, fromBlockOffset, toBlockLength);
                        }
                        --i;
                    }
                }
                return;
            }
        }
        if (fromText.length > 0) {
            this.textEdited(buffer, 0, -fromText.length);
        }
        if (toText.length > 0) {
            this.textEdited(buffer, 0, toText.length);
        }
    }

    static int ra$initialLength(TextBufferTracker textBufferTracker) {
        return textBufferTracker.initialLength;
    }

    static void mav$nodeOpened(TextBufferTracker textBufferTracker, TextNode textNode) {
        textBufferTracker.nodeOpened(textNode);
    }

    static final class 1
    implements Runnable {
        private final /* synthetic */ TextBufferTracker v$newTracker;
        private final /* synthetic */ TextNode v$node;

        public void run() {
            if (TextBufferTracker.ra$initialLength(this.v$newTracker) < 0 && this.v$node.isOpen()) {
                TextBufferTracker.mav$nodeOpened(this.v$newTracker, this.v$node);
            }
        }

        public 1(TextBufferTracker textBufferTracker, TextNode textNode) {
            this.v$node = textNode;
            this.v$newTracker = textBufferTracker;
        }
    }

    private static class Edit {
        public int offset;
        public int delta;
        public int id;
        public int length;

        public Edit(int offset, int delta, int id, int length) {
            this.offset = offset;
            this.delta = delta;
            this.id = id;
            this.length = length;
        }

        public Edit(Edit edit) {
            this(edit.offset, edit.delta, edit.id, edit.length);
        }

        public String toString() {
            return "{" + this.delta + " at " + this.offset + " (length " + this.length + ", id" + this.id + ")}";
        }
    }
}

