/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.beans.PropertyChangeEvent;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import oracle.ide.model.NodeListener;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectChangeEvent;
import oracle.ide.model.ProjectChangeListener;
import oracle.ide.model.TechId;
import oracle.ide.model.TechnologyRegistry;
import oracle.ide.model.TechnologyScope;
import oracle.ide.model.UpdateMessage;
import oracle.ide.util.ModelUtil;
import oracle.javatools.data.ChangeInfo;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;

public class TechnologyScopeConfiguration
extends HashStructureAdapter {
    public static final String DATA_KEY = TechnologyScopeConfiguration.class.getName();
    public static final String TECHNOLOGY_SCOPE_PROPERTY = "technologyScope";
    public static final String TECHNOLOGY_SCOPE_KEY = DATA_KEY + "/" + "technologyScope";
    private static ProjectChangeListener _listener;

    private TechnologyScopeConfiguration(HashStructure hash) {
        super(hash);
    }

    public static TechnologyScopeConfiguration getInstance(PropertyStorage propertyData) {
        return new TechnologyScopeConfiguration(TechnologyScopeConfiguration.findOrCreate((PropertyStorage)propertyData, (String)DATA_KEY));
    }

    public static void init() {
        if (_listener == null) {
            _listener = new 1();
            Project.addProjectChangeListener(DATA_KEY + "/" + TECHNOLOGY_SCOPE_PROPERTY, _listener);
        }
    }

    private ListStructure getTechnologies() {
        return this._hash.getOrCreateListStructure(TECHNOLOGY_SCOPE_PROPERTY);
    }

    private static TechnologyScope getTechnologyScope(ListStructure techKeys) {
        TechnologyScope techScope = new TechnologyScope();
        if (techKeys != null) {
            techScope.setTechnologyKeys((String[])techKeys.toArray((Object[])new String[techKeys.size()]));
        }
        return techScope;
    }

    public TechnologyScope getTechnologyScope() {
        return TechnologyScopeConfiguration.getTechnologyScope(this.getTechnologies());
    }

    public boolean setTechnologyScope(TechnologyScope scope) {
        boolean result = false;
        TechnologyScope oldScope = this.getTechnologyScope();
        if (ModelUtil.areDifferent((Object)oldScope, (Object)scope)) {
            String[] keys = scope != null ? scope.getTechnologyKeys() : null;
            ListStructure techKeys = this.getTechnologies();
            if (keys != null && keys.length > 0) {
                List<String> keyList = Arrays.asList(keys);
                Iterator iter = techKeys.iterator();
                while (iter.hasNext()) {
                    if (keyList.contains(iter.next())) continue;
                    iter.remove();
                    result = true;
                }
                for (String keyObj : keyList) {
                    if (keyObj == null || techKeys.contains((Object)keyObj)) continue;
                    techKeys.add((Object)keyObj);
                    result = true;
                }
            } else if (techKeys.size() > 0) {
                techKeys.clear();
                result = true;
            }
        }
        return result;
    }

    public final boolean updateTechnologyScope(String[] technologyKeys) {
        boolean ret = false;
        TechnologyScope scope = this.getTechnologyScope();
        if (scope != null && !scope.isEmpty() && technologyKeys != null) {
            TechnologyRegistry techRegistry = TechnologyRegistry.getInstance();
            int i = 0;
            while (i < technologyKeys.length) {
                TechId techId = techRegistry.getTechId(technologyKeys[i]);
                if (techId != null && !scope.contains(techId)) {
                    scope.add(techId);
                    ret = true;
                }
                ++i;
            }
        }
        if (ret) {
            this.setTechnologyScope(scope);
        }
        return ret;
    }

    static TechnologyScope maS$getTechnologyScope(ListStructure listStructure) {
        return TechnologyScopeConfiguration.getTechnologyScope(listStructure);
    }

    static final class oracle.ide.model.TechnologyScopeConfiguration$1
    extends ProjectChangeListener {
        public void projectPropertiesChanged(ProjectChangeEvent e) {
            ChangeInfo detail = e.getChangeDetails()[0];
            detail.getPropertyName();
            if (detail.isEventForList(TECHNOLOGY_SCOPE_KEY)) {
                ListStructure newList = detail.getParentAsListStructure();
                TechnologyScope newScope = TechnologyScopeConfiguration.maS$getTechnologyScope(newList);
                TechnologyScope oldScope = new TechnologyScope();
                newScope.copyTo(oldScope);
                String oldValue = detail.getOldValueAsString();
                String newValue = detail.getNewValueAsString();
                switch (detail.getChangeType()) {
                    case 1: 
                    case 2: {
                        oldScope.remove(TechnologyRegistry.getInstance().getTechId(newValue));
                        break;
                    }
                    case 3: {
                        oldScope.add(TechnologyRegistry.getInstance().getTechId(oldValue));
                        break;
                    }
                    case 0: {
                        oldScope.remove(TechnologyRegistry.getInstance().getTechId(newValue));
                        oldScope.add(TechnologyRegistry.getInstance().getTechId(oldValue));
                        break;
                    }
                }
                Project project = e.getProject();
                PropertyChangeEvent pce = new PropertyChangeEvent(project, TechnologyScopeConfiguration.TECHNOLOGY_SCOPE_PROPERTY, oldScope, newScope);
                PropertyChangeEvent[] pces = new PropertyChangeEvent[]{pce};
                NodeListener.invokeLaterIfNeeded(new 1(this, project, pces));
            }
        }

        final class 1
        implements Runnable {
            private final /* synthetic */ Project v$project;
            private final /* synthetic */ PropertyChangeEvent[] v$pces;
            final /* synthetic */ oracle.ide.model.TechnologyScopeConfiguration$1 this$0;

            public void run() {
                UpdateMessage.firePropertiesChanged(this.v$project, this.v$pces, TechnologyScopeConfiguration.class);
            }

            public 1(oracle.ide.model.TechnologyScopeConfiguration$1 var1_1, Project project, PropertyChangeEvent[] propertyChangeEventArray) {
                this.v$pces = propertyChangeEventArray;
                this.v$project = project;
                this.this$0 = var1_1;
            }
        }
    }
}

