/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import oracle.ide.model.PseudoTechnologyCallback;
import oracle.ide.model.TechId;

public final class TechnologyRegistry {
    private static final TechnologyRegistry INSTANCE = new TechnologyRegistry();
    private static final TechId[] NO_DEPENDENCIES = new TechId[0];
    private Map _technologyMap;

    private void $init$() {
        this._technologyMap = new HashMap();
    }

    private TechnologyRegistry() {
        this.$init$();
    }

    public static TechnologyRegistry getInstance() {
        return INSTANCE;
    }

    public void registerTechnology(String key, String name, String description) {
        this.registerTechnology(key, name, description, NO_DEPENDENCIES);
    }

    public void registerTechnology(String key, String name, String description, TechId parent) {
        TechId[] techIdArray;
        if (parent != null) {
            TechId[] techIdArray2 = new TechId[1];
            techIdArray = techIdArray2;
            techIdArray2[0] = parent;
        } else {
            techIdArray = NO_DEPENDENCIES;
        }
        TechId[] dependencies = techIdArray;
        this.registerTechnology(key, name, description, dependencies);
    }

    public void registerTechnology(String key, String name, String description, TechId[] dependencies) {
        TechId techId = this.getTechId(key);
        if (techId == null) {
            techId = TechId.createTechId(key, name, description);
            int i = 0;
            while (i < dependencies.length) {
                TechId dependency = dependencies[i];
                techId.addDependency(dependency);
                ++i;
            }
            this._technologyMap.put(key, techId);
        }
        techId.addRef();
    }

    public void registerPseudoTechnology(String key, PseudoTechnologyCallback callback) {
        TechId techId = this.getTechId(key);
        if (techId == null) {
            techId = TechId.createPseudoTechId(key, callback);
            this._technologyMap.put(key, techId);
        }
        techId.addRef();
    }

    public void unregisterTechnology(String key) {
        TechId techId = this.getTechId(key);
        if (techId != null) {
            techId.release();
            if (techId.refCount() <= 0) {
                this._technologyMap.remove(key);
            }
        }
    }

    public TechId getTechId(String key) {
        return (TechId)this._technologyMap.get(key);
    }

    public TechId[] getAllTechIds() {
        Collection values = this._technologyMap.values();
        return values.toArray(new TechId[values.size()]);
    }

    public TechId[] getVisibleTechIds() {
        ArrayList<TechId> ret = new ArrayList<TechId>();
        for (TechId techId : this._technologyMap.values()) {
            if (!techId.isVisible()) continue;
            ret.add(techId);
        }
        return ret.toArray(new TechId[ret.size()]);
    }

    public TechId[] getDependenciesFor(TechId techId) {
        if (techId == null) {
            return NO_DEPENDENCIES;
        }
        HashSet<TechId> ret = new HashSet<TechId>();
        for (TechId t : this._technologyMap.values()) {
            if (!techId.dependsOn(t)) continue;
            ret.add(t);
        }
        return ret.toArray(new TechId[ret.size()]);
    }

    public TechId[] getDependentsFor(TechId techId) {
        if (techId == null) {
            return NO_DEPENDENCIES;
        }
        HashSet<TechId> ret = new HashSet<TechId>();
        for (TechId t : this._technologyMap.values()) {
            if (!t.dependsOn(techId)) continue;
            ret.add(t);
        }
        return ret.toArray(new TechId[ret.size()]);
    }
}

