/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.net.URL;
import oracle.ide.Version;
import oracle.ide.migration.MigrationInfo;
import oracle.ide.model.HashStructureNodeMigrator;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.TraversableContext;
import oracle.ide.resource.IdeArb;

public class ProjectMigrator
extends HashStructureNodeMigrator {
    public static final String MIGRATOR_NAME = Project.class.getName();

    private final void super_callHelpersMigrate(MigrationInfo info, TraversableContext context) {
        super.callHelpersMigrate(info, context);
    }

    protected void callHelpersMigrate(MigrationInfo info, TraversableContext context) {
        Node node = info.getNode();
        if (node instanceof Project) {
            Project project = (Project)node;
            try {
                project.getTransientProperties().put("blockOpenOnDirty", Boolean.TRUE);
                project.applyBatchChanges(new 1(this, info, context));
            }
            finally {
                project.getTransientProperties().remove("blockOpenOnDirty");
            }
        } else {
            super.callHelpersMigrate(info, context);
        }
    }

    String getRootQname() {
        return "jpr:project";
    }

    protected void preMigrate(MigrationInfo[] infos, TraversableContext context) {
        int i = 0;
        while (i < infos.length) {
            Node node = infos[i].getNode();
            node.setMigrating();
            ++i;
        }
    }

    protected void postMigrate(MigrationInfo[] infos, TraversableContext context) {
        int i = 0;
        while (i < infos.length) {
            Node node = infos[i].getNode();
            boolean fireEvents = infos[i].getMigrationStatus() == MigrationInfo.MIGRATION_DONE;
            node.unsetMigrating(fireEvents);
            ++i;
        }
    }

    protected String getMsg(MigrationInfo[] infos) {
        String product = IdeArb.format(405, Version.NAME_SHORT, Version.VER);
        if (infos.length > 1) {
            return IdeArb.format(143, product);
        }
        URL nodeURL = infos[0].getNode().getURL();
        String fname = URLFileSystem.getPlatformPathName((URL)nodeURL);
        return IdeArb.format(440, fname, product);
    }

    protected String getTitle() {
        return IdeArb.getString(443);
    }

    protected String getSummaryMsg(MigrationInfo[] infos) {
        if (infos.length > 1) {
            return IdeArb.getString(258);
        }
        URL nodeURL = infos[0].getNode().getURL();
        String fname = URLFileSystem.getPlatformPathName((URL)nodeURL);
        return IdeArb.format(250, fname);
    }

    static void mav$super_callHelpersMigrate(ProjectMigrator projectMigrator, MigrationInfo migrationInfo, TraversableContext traversableContext) {
        projectMigrator.super_callHelpersMigrate(migrationInfo, traversableContext);
    }

    final class 1
    implements Runnable {
        private final /* synthetic */ MigrationInfo v$info;
        private final /* synthetic */ TraversableContext v$context;
        final /* synthetic */ ProjectMigrator this$0;

        public void run() {
            ProjectMigrator.mav$super_callHelpersMigrate(this.this$0, this.v$info, this.v$context);
        }

        public 1(ProjectMigrator projectMigrator, MigrationInfo migrationInfo, TraversableContext traversableContext) {
            this.v$context = traversableContext;
            this.v$info = migrationInfo;
            this.this$0 = projectMigrator;
        }
    }
}

