/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.Icon;
import oracle.ide.model.Attributes;
import oracle.ide.model.Dirtyable;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.IdeSubject;
import oracle.ide.model.LazyLoadable;
import oracle.ide.model.Locatable;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.NodeListener;
import oracle.ide.model.Observer;
import oracle.ide.model.Recognizer;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemHelper;
import oracle.ide.net.URLFileSystemHelperDecorator;
import oracle.ide.performance.PerformanceLogger;
import oracle.javatools.buffer.ReadWriteLock;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.Log;
import oracle.javatools.util.UnexpectedExceptionError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Node
implements Locatable,
Element,
Subject,
Dirtyable,
LazyLoadable {
    private static final boolean STRICT = Boolean.getBoolean("ide.node.state.strict");
    private final Attributes _attributes;
    private transient long _unmodifiedTimestamp;
    private transient long _timestamp;
    private URL _url;
    private transient String _shortLabel;
    private transient String _longLabel;
    private volatile transient boolean _dirty;
    private transient boolean _migrating;
    private Subject _subjectDelegate;
    private CopyOnWriteArrayList<NodeListener> _listeners;
    private static final HashMap<Class, CopyOnWriteArrayList<NodeListener>> _listenersForType = new HashMap();
    private static final HashMap<Class, CopyOnWriteArrayList<NodeListener>> _listenersForTypeHierarchy = new HashMap();
    private volatile transient NodeState state;
    private volatile transient boolean isLoaded;
    private volatile transient boolean isOpen;
    private transient ReadWriteLock _nodeLock;
    private transient Object unsafeLock;
    private transient boolean _isFiring;
    private transient boolean _isFiringNodeOpened;
    private transient boolean _markedDirtyFromNodeOpened;
    private transient boolean _openingFromMarkDirty;
    private transient Map _transientProperties;
    private static final ThreadLocal<ThreadUsageTracker> threadUsageTrackers = new 1();

    private void $init$() {
        this._attributes = new ElementAttributes(ElementAttributes.DELETEABLE);
        this._listeners = new CopyOnWriteArrayList();
        this.state = NodeState.CLOSED;
        this.isLoaded = false;
        this.isOpen = false;
        this.unsafeLock = new Object();
    }

    protected ReadWriteLock nodeLock() {
        return this._nodeLock;
    }

    protected void readLock() {
        this._nodeLock.readLock();
    }

    protected void readUnlock() {
        this._nodeLock.readUnlock();
    }

    protected void writeLock() {
        this._nodeLock.writeLock();
    }

    protected void writeUnlock() {
        this._nodeLock.writeUnlock();
    }

    protected void upgradeLock() {
        this._nodeLock.writeLockFromReadLock();
    }

    protected void upgradeUnlock() {
        this.writeUnlock();
    }

    protected final boolean isReadOrWriteLocked() {
        return this._nodeLock.isLockHeld();
    }

    protected final boolean isReadLocked() {
        return this._nodeLock.isReadLockHeld();
    }

    protected final boolean isWriteLocked() {
        return this._nodeLock.isWriteLockHeld();
    }

    protected final int lockCount() {
        return this.readLockCount() + this.writeLockCount();
    }

    protected final int readLockCount() {
        return this._nodeLock.getReadHoldCount();
    }

    protected final int writeLockCount() {
        return this._nodeLock.getWriteHoldCount();
    }

    public Node() {
        this.$init$();
        this._nodeLock = new ReadWriteLock(this.getClass().getSimpleName() + "#" + this.hashCode());
    }

    public Node(URL url) {
        this.$init$();
        this._nodeLock = new ReadWriteLock(url != null ? URLFileSystem.getFileName((URL)url) : this.getClass().getSimpleName() + "#" + this.hashCode());
        this.setURL(url);
    }

    public static final void addNodeListenerForType(Class type, NodeListener listener) {
        Node.mapTypeToListener(_listenersForType, listener, type);
    }

    public static final void removeNodeListenerForType(Class type, NodeListener listener) {
        Node.unmapListenerFromType(_listenersForType, listener, type);
    }

    public static final void addNodeListenerForTypeHierarchy(Class type, NodeListener listener) {
        Node.mapTypeToListener(_listenersForTypeHierarchy, listener, type);
    }

    public static final void removeNodeListenerForTypeHierarchy(Class type, NodeListener listener) {
        Node.unmapListenerFromType(_listenersForTypeHierarchy, listener, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void mapTypeToListener(HashMap<Class, CopyOnWriteArrayList<NodeListener>> listeners, NodeListener listener, Class type) {
        if (listener != null && type != null && Node.class.isAssignableFrom(type)) {
            HashMap<Class, CopyOnWriteArrayList<NodeListener>> hashMap = listeners;
            synchronized (hashMap) {
                CopyOnWriteArrayList<NodeListener> listenerList = listeners.get(type);
                if (listenerList == null) {
                    listenerList = new CopyOnWriteArrayList();
                    listeners.put(type, listenerList);
                }
                listenerList.addIfAbsent(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unmapListenerFromType(HashMap<Class, CopyOnWriteArrayList<NodeListener>> listeners, NodeListener listener, Class type) {
        if (listener != null && type != null) {
            HashMap<Class, CopyOnWriteArrayList<NodeListener>> hashMap = listeners;
            synchronized (hashMap) {
                CopyOnWriteArrayList<NodeListener> listenerList = listeners.get(type);
                if (listenerList != null && listenerList.remove(listener) && listenerList.isEmpty()) {
                    listeners.remove(type);
                }
            }
        }
    }

    public final void addNodeListener(NodeListener listener) {
        this._listeners.addIfAbsent(listener);
    }

    public final void removeNodeListener(NodeListener listener) {
        this._listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URL getURL() {
        Object object = this.unsafeLock;
        synchronized (object) {
            URL uRL = this._url;
            return uRL;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setURL(URL newURL) {
        Object object = this.unsafeLock;
        synchronized (object) {
            if (this.isTrackedInNodeCache()) {
                URL oldURL = this._url;
                this._url = newURL;
                NodeFactory.recache(oldURL, newURL, this);
            } else {
                this._url = newURL;
            }
            this._shortLabel = null;
            this._longLabel = null;
            this._nodeLock.setName(newURL != null ? URLFileSystem.getFileName((URL)newURL) : this.getClass().getSimpleName() + "#" + this.hashCode());
        }
    }

    protected boolean isTrackedInNodeCache() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDirty() {
        Object object = this.unsafeLock;
        synchronized (object) {
            boolean bl = this._dirty;
            return bl;
        }
    }

    public void markDirty(boolean dirty) {
        block18: {
            block17: {
                this.readLock();
                try {
                    if (dirty != this.getAttributes().isSet(ElementAttributes.DIRTY)) break block17;
                    return;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    this.readUnlock();
                }
            }
            this.writeLock();
            try {
                if (this._isFiringNodeOpened && dirty) {
                    this._markedDirtyFromNodeOpened = true;
                    return;
                }
                if (this._openingFromMarkDirty && !dirty) {
                    throw new IllegalStateException("markDirty(true) is forcing " + this.getShortLabel() + " open, but a node opened listener called markDirty(false)");
                }
                Attributes attributes = this.getAttributes();
                if (dirty == this.getAttributes().isSet(ElementAttributes.DIRTY)) break block18;
                if (dirty && this.isLoaded() && !Boolean.TRUE.equals(this.getTransientProperties().get("blockOpenOnDirty"))) {
                    this._openingFromMarkDirty = true;
                    try {
                        this.ensureOpen();
                    }
                    finally {
                        this._openingFromMarkDirty = false;
                    }
                }
                this._dirty = dirty;
                Attributes oldAttributes = attributes.duplicate();
                if (dirty) {
                    attributes.set(ElementAttributes.DIRTY);
                } else {
                    attributes.unset(ElementAttributes.DIRTY);
                }
                this.markDirtyImpl(dirty);
                if (!this._openingFromMarkDirty) {
                    this.fireNodeDirtyStateChanged(dirty, oldAttributes);
                }
            }
            finally {
                this.writeUnlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getShortLabel() {
        Object object = this.unsafeLock;
        synchronized (object) {
            if (this._shortLabel == null) {
                URL url = this.getURL();
                this._shortLabel = url == null ? "<null>" : URLFileSystem.getFileName((URL)url);
            }
            String string = this._shortLabel;
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getLongLabel() {
        Object object = this.unsafeLock;
        synchronized (object) {
            if (this._longLabel == null) {
                URL url = this.getURL();
                this._longLabel = url == null ? "<null>" : URLFileSystem.getPlatformPathName((URL)url);
            }
            String string = this._longLabel;
            return string;
        }
    }

    @Override
    public Icon getIcon() {
        return OracleIcons.getIcon((String)"file.png");
    }

    @Override
    public String getToolTipText() {
        return URLFileSystem.toDisplayString((URL)this.getURL());
    }

    @Override
    public final void attach(Observer observer) {
        this.getSubject().attach(observer);
    }

    @Override
    public final void detach(Observer observer) {
        this.getSubject().detach(observer);
    }

    @Override
    public void notifyObservers(Object observed, UpdateMessage change) {
        this.getSubject().notifyObservers(observed, change);
    }

    protected final Subject getSubject() {
        if (this._subjectDelegate == null) {
            this._subjectDelegate = this.createSubject();
        }
        return this._subjectDelegate;
    }

    protected Subject createSubject() {
        return new IdeSubject();
    }

    @Override
    public Object getData() {
        return this;
    }

    @Override
    public boolean mayHaveChildren() {
        return false;
    }

    public Iterator getChildren() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Attributes getAttributes() {
        Object object = this.unsafeLock;
        synchronized (object) {
            Attributes attributes = this._attributes;
            return attributes;
        }
    }

    public final Map getTransientProperties() {
        block12: {
            ThreadUsageTracker.mav$loadInvoked(threadUsageTrackers.get(), this);
            this.readLock();
            try {
                if (this._transientProperties == null) break block12;
                Map map = this._transientProperties;
                return map;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                this.readUnlock();
            }
        }
        this.upgradeLock();
        try {
            if (this._transientProperties == null) {
                switch (15.$sm$oracle$ide$model$Node$NodeState[this.state.ordinal()]) {
                    case 2: {
                        break;
                    }
                    default: {
                        this.ensureLoad();
                    }
                }
                this._transientProperties = new ConcurrentHashMap();
            }
            Map map = this._transientProperties;
            return map;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            this.upgradeUnlock();
        }
    }

    public final void open() throws IOException {
        this.open(true);
    }

    private void open(boolean invokeOpenImpl) throws IOException {
        ThreadUsageTracker.mav$openInvoked(threadUsageTrackers.get(), this);
        if (this.isOpen()) {
            return;
        }
        this.upgradeLock();
        try {
            switch (15.$sm$oracle$ide$model$Node$NodeState[this.state.ordinal()]) {
                case 1: {
                    if (STRICT) {
                        throw new IllegalStateException(this.getClass().getName() + ".loadImpl() recursively invokes open for " + this.getLongLabel());
                    }
                    break;
                }
                case 2: {
                    throw new IllegalStateException(this.getClass().getName() + ".unloadImpl() recursively invokes open for " + this.getLongLabel());
                }
                case 3: {
                    if (this._isFiring) {
                        throw new IllegalStateException("nodeWillOpen listener for " + this.getClass().getName() + " invokes open for " + this.getLongLabel());
                    }
                    if (STRICT) {
                        throw new IllegalStateException(this.getClass().getName() + ".openImpl() recursively invokes open for " + this.getLongLabel());
                    }
                    break;
                }
                case 5: {
                    throw new IllegalStateException(this.getClass().getName() + ".closeImpl() recursively invokes open for " + this.getLongLabel());
                }
                case 7: {
                    this.load(invokeOpenImpl);
                    if (this.state != NodeState.LOADED) {
                        throw new IllegalStateException("unexpected state after load");
                    }
                }
                case 6: {
                    this.state = NodeState.OPENING;
                    try {
                        this.fireNodeWillOpen();
                        if (invokeOpenImpl) {
                            this.openImpl();
                        }
                        this.refreshTimestamp();
                    }
                    finally {
                        this.state = NodeState.LOADED;
                    }
                    this.state = NodeState.OPEN;
                    this.isOpen = true;
                    this.fireNodeOpened();
                    break;
                }
                case 4: {
                    break;
                }
            }
        }
        finally {
            this.upgradeUnlock();
        }
    }

    public final void close() throws IOException {
        this.close(true);
    }

    private void close(boolean invokeCloseImpl) throws IOException {
        if (!this.isLoaded()) {
            return;
        }
        this.writeLock();
        try {
            switch (15.$sm$oracle$ide$model$Node$NodeState[this.state.ordinal()]) {
                case 1: {
                    throw new IllegalStateException(this.getClass().getName() + ".loadImpl() invokes close for " + this.getLongLabel());
                }
                case 2: {
                    throw new IllegalStateException(this.getClass().getName() + ".unloadImpl() invokes close for " + this.getLongLabel());
                }
                case 3: {
                    if (this._isFiring) {
                        throw new IllegalStateException("nodeWillOpen listener for " + this.getClass().getName() + " invokes close for " + this.getLongLabel());
                    }
                    throw new IllegalStateException(this.getClass().getName() + ".openImpl() invokes close for " + this.getLongLabel());
                }
                case 5: {
                    if (this._isFiring) {
                        throw new IllegalStateException("nodeWillClose listener for " + this.getClass().getName() + " invokes close for " + this.getLongLabel());
                    }
                    if (STRICT) {
                        throw new IllegalStateException(this.getClass().getName() + ".closeImpl() invokes close for " + this.getLongLabel());
                    }
                    break;
                }
                case 4: {
                    this.state = NodeState.CLOSING;
                    try {
                        this.fireNodeWillClose();
                        this.isOpen = false;
                        if (invokeCloseImpl) {
                            this.closeImpl();
                        }
                        this.markDirty(false);
                    }
                    finally {
                        this.state = NodeState.OPEN;
                    }
                    this.state = NodeState.LOADED;
                    this.fireNodeClosed();
                }
                case 6: {
                    this.unload(invokeCloseImpl);
                    break;
                }
                case 7: {
                    break;
                }
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    public final void save() throws IOException {
        this.writeLock();
        try {
            if (this.isLoaded() && (this.isDirty() || this.isNew())) {
                this.fireNodeWillBeSaved();
                this.saveImpl();
                this.markDirty(false);
                this.refreshTimestamp();
                this.fireNodeSaved();
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    public final void revert() throws IOException {
        this.writeLock();
        try {
            if (this.isOpen()) {
                this.revertImpl();
                this.refreshTimestamp();
                this.markDirty(false);
                this.fireNodeReverted();
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    public final void delete() {
        URLFileSystem.delete((URL)this.getURL());
    }

    public final Node rename(URL newURL) throws IOException {
        URLFileSystem.renameEx((URL)this.getURL(), (URL)newURL);
        return NodeFactory.find(newURL);
    }

    @Override
    public final boolean isOpen() {
        this.readLock();
        try {
            boolean bl = this.isOpen;
            return bl;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            this.readUnlock();
        }
    }

    public final boolean isOpenUnsafe() {
        return this.isOpen;
    }

    public boolean isReadOnly() {
        if (this.supportsLoaded() && this.isLoaded && !this.isOpen) {
            return true;
        }
        if (this.getAttributes().isSet(ElementAttributes.NON_EDITABLE)) {
            return true;
        }
        return URLFileSystem.isReadOnly((URL)this.getURL());
    }

    public final boolean isMigrating() {
        this.readLock();
        try {
            boolean bl = this._migrating;
            return bl;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            this.readUnlock();
        }
    }

    protected final void setMigrating() {
        block7: {
            this.readLock();
            try {
                if (!this._migrating) break block7;
                return;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                this.readUnlock();
            }
        }
        this.writeLock();
        try {
            this._migrating = true;
        }
        finally {
            this.writeUnlock();
        }
    }

    protected final void unsetMigrating(boolean fireEvents) {
        block9: {
            this.readLock();
            try {
                if (this._migrating) break block9;
                return;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                this.readUnlock();
            }
        }
        this.writeLock();
        try {
            this._migrating = false;
        }
        finally {
            this.writeUnlock();
        }
        if (fireEvents && this.isLoaded()) {
            this.fireNodeLoaded();
            if (this.isOpen()) {
                this.fireNodeWillOpen();
                this.fireNodeOpened();
            }
        }
    }

    boolean supportsLoaded() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getTimestamp() {
        this.readLock();
        try {
            Object object = this.unsafeLock;
            synchronized (object) {
                if (this._timestamp <= 0L) {
                    this._timestamp = URLFileSystem.lastModified((URL)this.getURL());
                }
                long l = this._timestamp;
                // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var1_1
                this.readUnlock();
                return l;
            }
        }
        catch (Throwable throwable) {
            this.readUnlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getUnmodifiedTimestamp() {
        Object object = this.unsafeLock;
        synchronized (object) {
            if (this._unmodifiedTimestamp <= 0L) {
                this._unmodifiedTimestamp = URLFileSystem.lastModified((URL)this.getURL());
            }
            long l = this._unmodifiedTimestamp;
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final long refreshTimestamp() {
        URL url = this.getURL();
        Object object = this.unsafeLock;
        synchronized (object) {
            long l = this._timestamp = (this._unmodifiedTimestamp = URLFileSystem.lastModified((URL)url));
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setTimestampDirectly(long timestamp) {
        this.readLock();
        try {
            Object object = this.unsafeLock;
            synchronized (object) {
                this._timestamp = timestamp;
            }
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getTimestampLoadedUnsafe() {
        Object object = this.unsafeLock;
        synchronized (object) {
            if (this.isLoaded) {
                if (this._timestamp <= 0L) {
                    this._timestamp = URLFileSystem.lastModified((URL)this.getURL());
                }
                long l = this._timestamp;
                return l;
            }
            long l = -1;
            return l;
        }
    }

    public InputStream getInputStream() throws IOException {
        try {
            URL url = this.getURL();
            InputStream inputStream = URLFileSystem.openInputStream((URL)url);
            return inputStream;
        }
        catch (FileNotFoundException e) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(new byte[0]);
            return byteArrayInputStream;
        }
    }

    public final boolean isNew() {
        return URLFileSystem.exists((URL)this.getURL()) ^ true;
    }

    @Override
    public String toString() {
        return this.getShortLabel();
    }

    public final void runUnderReadLock(Runnable runnable) {
        this.readLock();
        try {
            runnable.run();
        }
        finally {
            this.readUnlock();
        }
    }

    public final void runUnderWriteLock(Runnable runnable) {
        this.writeLock();
        try {
            runnable.run();
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * Unable to fully structure code
     */
    public final <V> V callUnderReadLock(Callable<V> callable) throws Exception {
        this.readLock();
        try {
            var2_2 = callable.call();
            ** try [egrp 1[TRYBLOCK] [1 : 15->17)] { 
        }
lbl6:
        // 1 sources

        catch (Throwable var3_3) {
            throw var3_3;
        }
        finally {
            this.readUnlock();
        }
lbl5:
        // 1 sources

        return var2_2;
    }

    /*
     * Unable to fully structure code
     */
    public final <V> V callUnderWriteLock(Callable<V> callable) throws Exception {
        this.writeLock();
        try {
            var2_2 = callable.call();
            ** try [egrp 1[TRYBLOCK] [1 : 15->17)] { 
        }
lbl6:
        // 1 sources

        catch (Throwable var3_3) {
            throw var3_3;
        }
        finally {
            this.writeUnlock();
        }
lbl5:
        // 1 sources

        return var2_2;
    }

    public final boolean tryRunUnderReadLock(Runnable runnable) {
        boolean result = this._nodeLock.tryReadLock();
        if (result) {
            try {
                runnable.run();
            }
            finally {
                this._nodeLock.readUnlock();
            }
        }
        return result;
    }

    public static void beginThreadNodeUsageCycle() {
        ThreadUsageTracker.mav$begin(threadUsageTrackers.get());
    }

    public static void endThreadNodeUsageCycle() {
        ThreadUsageTracker.mav$end(threadUsageTrackers.get());
    }

    public static void endThreadNodeUsage(Node node) {
        ThreadUsageTracker.mav$end(threadUsageTrackers.get(), node);
    }

    protected void openImpl() throws IOException {
    }

    protected void closeImpl() throws IOException {
    }

    protected void markDirtyImpl(boolean dirty) {
    }

    protected void saveImpl() throws IOException {
    }

    protected void revertImpl() throws IOException {
        this.closeImpl();
        this.openImpl();
    }

    protected void deleteImpl() throws IOException {
    }

    protected void renameImpl(URL oldURL, URL newURL) throws IOException {
    }

    protected final boolean equalsImpl(Node node) {
        URL thisUrl = this.getURL();
        URL thatUrl = node.getURL();
        return thisUrl == null ? thatUrl == null : thisUrl.equals(thatUrl);
    }

    protected final void setOpen(boolean open) {
        try {
            if (open) {
                this.open(false);
            } else {
                this.close(false);
            }
        }
        catch (IOException e) {
            throw new UnexpectedExceptionError((Throwable)e);
        }
    }

    public final boolean ensureOpen() {
        try {
            this.open();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            this.reportOpenException(e);
            boolean bl = false;
            return bl;
        }
    }

    protected void reportOpenException(Exception e) {
        e.printStackTrace();
    }

    final void load() throws IOException {
        this.load(true);
    }

    final void load(boolean invokeLoadImpl) throws IOException {
        ThreadUsageTracker.mav$loadInvoked(threadUsageTrackers.get(), this);
        if (this.isLoaded()) {
            return;
        }
        this.upgradeLock();
        try {
            switch (15.$sm$oracle$ide$model$Node$NodeState[this.state.ordinal()]) {
                case 1: {
                    if (STRICT) {
                        throw new IllegalStateException(this.getClass().getName() + ".loadImpl() invokes load for " + this.getLongLabel());
                    }
                    break;
                }
                case 2: {
                    throw new IllegalStateException(this.getClass().getName() + ".unloadImpl() invokes load for " + this.getLongLabel());
                }
                case 7: {
                    this.state = NodeState.LOADING;
                    try {
                        if (invokeLoadImpl) {
                            this.loadImpl();
                        }
                        this.refreshTimestamp();
                    }
                    finally {
                        this.state = NodeState.CLOSED;
                    }
                    this.state = NodeState.LOADED;
                    this.isLoaded = true;
                    this.fireNodeLoaded();
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
            }
        }
        finally {
            this.upgradeUnlock();
        }
    }

    void loadImpl() throws IOException {
    }

    public final boolean isLoaded() {
        this.readLock();
        try {
            boolean bl = this.isLoaded;
            return bl;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            this.readUnlock();
        }
    }

    public final boolean isLoadedUnsafe() {
        return this.isLoaded;
    }

    final boolean ensureLoad() {
        try {
            this.load();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
    }

    final void unload() {
        this.unload(true);
    }

    final void unload(boolean invokeUnloadImpl) {
        this.writeLock();
        try {
            switch (15.$sm$oracle$ide$model$Node$NodeState[this.state.ordinal()]) {
                case 1: {
                    throw new IllegalStateException(this.getClass().getName() + ".loadImpl() invokes unload for " + this.getLongLabel());
                }
                case 2: {
                    if (STRICT) {
                        throw new IllegalStateException(this.getClass().getName() + ".unloadImpl() invokes unload for " + this.getLongLabel());
                    }
                    break;
                }
                case 3: {
                    if (this._isFiring) {
                        throw new IllegalStateException("nodeWillOpen listener for " + this.getClass().getName() + " invokes unload for " + this.getLongLabel());
                    }
                    throw new IllegalStateException(this.getClass().getName() + ".openImpl() invokes unload for " + this.getLongLabel());
                }
                case 4: {
                    throw new IllegalStateException("open invoked " + this.getClass().getName() + " invokes unload for " + this.getLongLabel());
                }
                case 5: {
                    throw new IllegalStateException(this.getClass().getName() + ".closeImpl() invokes unload for " + this.getLongLabel());
                }
                case 6: {
                    this.isLoaded = false;
                    this.state = NodeState.UNLOADING;
                    if (invokeUnloadImpl) {
                        try {
                            this.unloadImpl();
                        }
                        finally {
                            this.state = NodeState.LOADED;
                        }
                    }
                    this.state = NodeState.CLOSED;
                    this.fireNodeUnloaded();
                    this._transientProperties = null;
                    break;
                }
                case 7: {
                    break;
                }
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    void unloadImpl() {
    }

    final void copyToImpl(Node copy) {
        copy._url = this._url;
        copy.isOpen = this.isOpen;
        copy.isLoaded = this.isLoaded;
        copy.state = this.state;
    }

    private void deleteInternal(URLFileSystemHelper helper) throws IOException {
        this.writeLock();
        try {
            this.close();
            this.deleteImpl();
            URL url = this.getURL();
            helper.delete(url);
            this.fireNodeDeleted();
            NodeFactory.uncache(url);
        }
        finally {
            this.writeUnlock();
        }
    }

    private void renameInternal(URL newURL, URLFileSystemHelper helper) throws IOException {
        this.writeLock();
        try {
            Class<? extends Node> newNodeType;
            Class<?> oldNodeType;
            URL oldURL = this.getURL();
            this.renameImpl(oldURL, newURL);
            helper.rename(oldURL, newURL);
            Node replacedNode = NodeFactory.find(newURL);
            if (replacedNode != null) {
                NodeFactory.uncache(newURL);
            }
            if ((oldNodeType = this.getClass()) == (newNodeType = Recognizer.recognizeURL(newURL))) {
                this.setURL(newURL);
            } else {
                try {
                    NodeFactory.findOrCreate(newURL);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.fireNodeRenamed(oldURL, newURL);
            if (oldNodeType != newNodeType) {
                NodeFactory.uncache(oldURL);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    private boolean checkEventFiringConditions() {
        if (this.isMigrating()) {
            return false;
        }
        if (this._isFiring) {
            throw new IllegalStateException("reentrant node change");
        }
        return true;
    }

    private void fireNodeEvent(String description, NodeEventClosure closure) {
        this._isFiring = true;
        try {
            NodeEvent event = null;
            NodeListenerIterator i = new NodeListenerIterator(null);
            while (i.hasNext()) {
                if (event == null) {
                    event = new NodeEvent(this);
                }
                NodeListener listener = (NodeListener)i.next();
                try {
                    long startTime = System.nanoTime();
                    closure.run(listener, event);
                    long endTime = System.nanoTime();
                    PerformanceLogger.get().log("NodeListener." + description, listener.getClass().getName(), endTime - startTime);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
        finally {
            this._isFiring = false;
        }
    }

    private void fireNodeLoaded() {
        if (!this.checkEventFiringConditions()) {
            return;
        }
        this.fireNodeEvent("nodeLoaded()", new 2());
    }

    private void fireNodeUnloaded() {
        if (!this.checkEventFiringConditions()) {
            return;
        }
        this.fireNodeEvent("nodeUnloaded()", new 3());
    }

    private void fireNodeWillOpen() {
        if (!this.checkEventFiringConditions()) {
            return;
        }
        this.fireNodeEvent("nodeWillOpen()", new 4());
    }

    private void fireNodeOpened() {
        if (!this.checkEventFiringConditions()) {
            return;
        }
        this._markedDirtyFromNodeOpened = false;
        this._isFiringNodeOpened = true;
        try {
            this.fireNodeEvent("nodeOpened()", new 5());
        }
        finally {
            this._isFiringNodeOpened = false;
        }
        if (this._markedDirtyFromNodeOpened) {
            this.markDirty(true);
        }
    }

    private void fireNodeDirtyStateChanged(boolean isNowDirty, Attributes oldAttributes) {
        if (!this.checkEventFiringConditions()) {
            return;
        }
        this.fireNodeEvent("nodeDirtyStateChanged()", new 6(this, isNowDirty));
        UpdateMessage.fireAttributeChanged(this, oldAttributes);
    }

    private void fireNodeWillBeSaved() {
        if (!this.checkEventFiringConditions()) {
            return;
        }
        this.fireNodeEvent("nodeWillBeSaved()", new 7());
    }

    private void fireNodeWillClose() {
        if (!this.checkEventFiringConditions()) {
            return;
        }
        this.fireNodeEvent("nodeWillClose()", new 8());
    }

    private void fireNodeClosed() {
        if (!this.checkEventFiringConditions()) {
            return;
        }
        this.fireNodeEvent("nodeClosed()", new 9());
    }

    private void fireNodeSaved() {
        if (!this.checkEventFiringConditions()) {
            return;
        }
        this.fireNodeEvent("nodeSaved()", new 10());
    }

    private void fireNodeReverted() {
        if (!this.checkEventFiringConditions()) {
            return;
        }
        this.fireNodeEvent("nodeReverted()", new 11());
    }

    private void fireNodeDeleted() {
        if (!this.checkEventFiringConditions()) {
            return;
        }
        this.fireNodeEvent("nodeDeleted()", new 12());
    }

    private void fireNodeRenamed(URL oldURL, URL newURL) {
        if (!this.checkEventFiringConditions()) {
            return;
        }
        this.fireNodeEvent("nodeRenamed()", new 13(this, oldURL, newURL));
    }

    private static void addDeleteRenameInterceptor(String protocol) {
        URLFileSystemHelper helper = URLFileSystem.findHelper((String)protocol);
        DeleteRenameInterceptor interceptor = new DeleteRenameInterceptor(helper, null);
        URLFileSystem.registerHelper((String)protocol, (URLFileSystemHelper)interceptor);
    }

    public void setEventLog(Log log) {
        this._nodeLock.setEventLog(log);
    }

    static {
        Node.addDeleteRenameInterceptor("file");
        Node.addDeleteRenameInterceptor("http");
        Node.addDeleteRenameInterceptor("https");
        Node.addNodeListenerForTypeHierarchy(Node.class, new 14());
    }

    static CopyOnWriteArrayList ra$_listeners(Node node) {
        return node._listeners;
    }

    static HashMap ra$_listenersForType() {
        return _listenersForType;
    }

    static HashMap ra$_listenersForTypeHierarchy() {
        return _listenersForTypeHierarchy;
    }

    static void mav$renameInternal(Node node, URL uRL, URLFileSystemHelper uRLFileSystemHelper) {
        node.renameInternal(uRL, uRLFileSystemHelper);
    }

    static void mav$deleteInternal(Node node, URLFileSystemHelper uRLFileSystemHelper) {
        node.deleteInternal(uRLFileSystemHelper);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class NodeState
    extends Enum<NodeState> {
        private static final /* synthetic */ NodeState[] $v;
        public static final /* enum */ NodeState CLOSED;
        public static final /* enum */ NodeState LOADING;
        public static final /* enum */ NodeState UNLOADING;
        public static final /* enum */ NodeState LOADED;
        public static final /* enum */ NodeState OPENING;
        public static final /* enum */ NodeState CLOSING;
        public static final /* enum */ NodeState OPEN;

        public static NodeState valueOf(String string) {
            return Enum.valueOf(NodeState.class, string);
        }

        public static final NodeState[] values() {
            return (NodeState[])$v.clone();
        }

        static {
            NodeState[] nodeStateArray = new NodeState[7];
            nodeStateArray[6] = OPEN = new NodeState("OPEN", 6);
            nodeStateArray[5] = CLOSING = new NodeState("CLOSING", 5);
            nodeStateArray[4] = OPENING = new NodeState("OPENING", 4);
            nodeStateArray[3] = LOADED = new NodeState("LOADED", 3);
            nodeStateArray[2] = UNLOADING = new NodeState("UNLOADING", 2);
            nodeStateArray[1] = LOADING = new NodeState("LOADING", 1);
            nodeStateArray[0] = CLOSED = new NodeState("CLOSED", 0);
            $v = nodeStateArray;
        }

        private NodeState(String string2, int n2) {
        }
    }

    static final class 1
    extends ThreadLocal {
        protected ThreadUsageTracker initialValue() {
            return new ThreadUsageTracker(null);
        }
    }

    private static final class ThreadUsageTracker
    extends NodeListener {
        private final Thread thread;
        private volatile boolean tracking;
        private Set<Node> loaded;
        private Set<Node> tainted;
        private static final Log LOG;
        static final /* synthetic */ boolean $assertionsDisabled;

        private void $init$() {
            this.thread = Thread.currentThread();
        }

        static {
            $assertionsDisabled = ThreadUsageTracker.class.desiredAssertionStatus() ^ true;
            LOG = new Log("node-thread-usage");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void begin() {
            ThreadUsageTracker threadUsageTracker = this;
            synchronized (threadUsageTracker) {
                if (!$assertionsDisabled && !LOG.trace("begin processing cycle")) {
                    throw new AssertionError();
                }
                if (this.tracking) {
                    throw new IllegalStateException();
                }
                this.loaded = new HashSet<Node>();
                this.tainted = new HashSet<Node>();
                this.tracking = true;
                Node.addNodeListenerForTypeHierarchy(Node.class, this);
            }
        }

        private final synchronized void loadInvoked(Node node) {
            if (this.tracking) {
                if (this.thread == Thread.currentThread()) {
                    boolean added = this.loaded.add(node);
                    if (!($assertionsDisabled || added && LOG.trace("node load invoked: {0}", (Object)node))) {
                        throw new AssertionError();
                    }
                } else {
                    boolean added = this.tainted.add(node);
                    if (!($assertionsDisabled || added && LOG.trace("node load invoked, tainted: {0}", (Object)node))) {
                        throw new AssertionError();
                    }
                }
            }
        }

        private final synchronized void openInvoked(Node node) {
            if (this.tracking && this.thread != Thread.currentThread()) {
                boolean added = this.tainted.add(node);
                if (!($assertionsDisabled || added && LOG.trace("node open invoked, tainted: {0}", (Object)node))) {
                    throw new AssertionError();
                }
            }
        }

        synchronized void nodeLoaded(NodeEvent e) {
            if (this.tracking) {
                Node node = e.getNode();
                if (this.thread == Thread.currentThread()) {
                    boolean added = this.loaded.add(node);
                    if (!($assertionsDisabled || added && LOG.trace("node loaded: {0}", (Object)node))) {
                        throw new AssertionError();
                    }
                } else {
                    boolean added = this.tainted.add(node);
                    if (!($assertionsDisabled || added && LOG.trace("node loaded, tainted: {0}", (Object)node))) {
                        throw new AssertionError();
                    }
                }
            }
        }

        public synchronized void nodeOpened(NodeEvent e) {
            if (this.tracking && this.thread != Thread.currentThread()) {
                Node node = e.getNode();
                boolean added = this.tainted.add(node);
                if (!($assertionsDisabled || added && LOG.trace("node opened, tainted: {0}", (Object)node))) {
                    throw new AssertionError();
                }
            }
        }

        final synchronized void nodeUnloaded(NodeEvent e) {
            if (this.tracking) {
                Node node = e.getNode();
                boolean removed = this.loaded.remove(node) | this.tainted.remove(node);
                if (!($assertionsDisabled || removed && LOG.trace("node unloaded: {0}", (Object)node))) {
                    throw new AssertionError();
                }
            }
        }

        private final synchronized void nodeChanged(NodeEvent event) {
            if (this.tracking && this.thread != Thread.currentThread()) {
                Node node = event.getNode();
                boolean added = this.tainted.add(node);
                if (!($assertionsDisabled || added && LOG.trace("node tainted: {0}", (Object)node))) {
                    throw new AssertionError();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void end() {
            ArrayList<Node> untainted;
            ThreadUsageTracker threadUsageTracker = this;
            synchronized (threadUsageTracker) {
                if (!this.tracking) {
                    throw new IllegalStateException();
                }
                untainted = new ArrayList<Node>(this.loaded.size());
                for (Node node : this.loaded) {
                    if (this.tainted.contains(node)) continue;
                    untainted.add(node);
                }
                if (!$assertionsDisabled && !LOG.trace("end processing cycle: {0} untainted of {1} loaded, {2} tainted", untainted.size(), this.loaded.size(), this.tainted.size())) {
                    throw new AssertionError();
                }
                this.loaded.clear();
                this.tainted.clear();
            }
            for (Node node : untainted) {
                try {
                    this.close(node);
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            ThreadUsageTracker threadUsageTracker2 = this;
            synchronized (threadUsageTracker2) {
                this.tracking = false;
                Node.removeNodeListenerForTypeHierarchy(Node.class, this);
                this.loaded = null;
                this.tainted = null;
                if (!$assertionsDisabled && !LOG.trace("end processing cycle completed")) {
                    throw new AssertionError();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void end(Node node) {
            ThreadUsageTracker threadUsageTracker = this;
            synchronized (threadUsageTracker) {
                if (!$assertionsDisabled && !LOG.trace("end node usage: {0}", (Object)node)) {
                    throw new AssertionError();
                }
                if (!this.tracking) {
                    throw new IllegalStateException();
                }
                if (!this.loaded.contains(node) || this.tainted.contains(node)) {
                    return;
                }
            }
            try {
                this.close(node);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void close(Node node) throws IOException {
            ReadWriteLock lock = node.nodeLock();
            if (!lock.tryWriteLock()) {
                return;
            }
            try {
                Set<Node> set = this.tainted;
                synchronized (set) {
                    if (this.tainted.contains(node)) {
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 6] lbl9 : MonitorExitStatement: MONITOREXIT : var3_3
                        node.writeUnlock();
                        return;
                    }
                }
                node.close();
            }
            finally {
                node.writeUnlock();
            }
        }

        public void nodeDirtyStateChanged(NodeEvent e, boolean isNowDirty) {
            this.nodeChanged(e);
        }

        public void nodeWillOpen(NodeEvent e) {
            this.nodeChanged(e);
        }

        public void nodeWillClose(NodeEvent e) {
            this.nodeChanged(e);
        }

        public void nodeClosed(NodeEvent e) {
            this.nodeChanged(e);
        }

        public void nodeWillBeSaved(NodeEvent e) {
            this.nodeChanged(e);
        }

        public void nodeSaved(NodeEvent e) {
            this.nodeChanged(e);
        }

        public void nodeReverted(NodeEvent e) {
            this.nodeChanged(e);
        }

        public void nodeDeleted(NodeEvent e) {
            this.nodeChanged(e);
        }

        public void nodeRenamed(NodeEvent e, URL oldURL, URL newURL) {
            this.nodeChanged(e);
        }

        private ThreadUsageTracker() {
            this.$init$();
        }

        static void mav$loadInvoked(ThreadUsageTracker threadUsageTracker, Node node) {
            threadUsageTracker.loadInvoked(node);
        }

        static void mav$end(ThreadUsageTracker threadUsageTracker, Node node) {
            threadUsageTracker.end(node);
        }

        static void mav$end(ThreadUsageTracker threadUsageTracker) {
            threadUsageTracker.end();
        }

        static void mav$begin(ThreadUsageTracker threadUsageTracker) {
            threadUsageTracker.begin();
        }

        static void mav$openInvoked(ThreadUsageTracker threadUsageTracker, Node node) {
            threadUsageTracker.openInvoked(node);
        }

        ThreadUsageTracker(1 var1_1) {
            this();
        }
    }

    private interface NodeEventClosure {
        public void run(NodeListener var1, NodeEvent var2);
    }

    final class 2
    implements NodeEventClosure {
        public void run(NodeListener listener, NodeEvent e) {
            listener.nodeLoaded(e);
        }
    }

    final class 3
    implements NodeEventClosure {
        public void run(NodeListener listener, NodeEvent e) {
            listener.nodeUnloaded(e);
        }
    }

    final class 4
    implements NodeEventClosure {
        public void run(NodeListener listener, NodeEvent e) {
            listener.nodeWillOpen(e);
        }
    }

    final class 5
    implements NodeEventClosure {
        public void run(NodeListener listener, NodeEvent e) {
            listener.nodeOpened(e);
        }
    }

    final class 6
    implements NodeEventClosure {
        private final /* synthetic */ boolean v$isNowDirty;
        final /* synthetic */ Node this$0;

        public void run(NodeListener listener, NodeEvent e) {
            listener.nodeDirtyStateChanged(e, this.v$isNowDirty);
        }

        public 6(Node node, boolean bl) {
            this.v$isNowDirty = bl;
            this.this$0 = node;
        }
    }

    final class 7
    implements NodeEventClosure {
        public void run(NodeListener listener, NodeEvent e) {
            listener.nodeWillBeSaved(e);
        }
    }

    final class 8
    implements NodeEventClosure {
        public void run(NodeListener listener, NodeEvent e) {
            listener.nodeWillClose(e);
        }
    }

    final class 9
    implements NodeEventClosure {
        public void run(NodeListener listener, NodeEvent e) {
            listener.nodeClosed(e);
        }
    }

    final class 10
    implements NodeEventClosure {
        public void run(NodeListener listener, NodeEvent e) {
            listener.nodeSaved(e);
        }
    }

    final class 11
    implements NodeEventClosure {
        public void run(NodeListener listener, NodeEvent e) {
            listener.nodeReverted(e);
        }
    }

    final class 12
    implements NodeEventClosure {
        public void run(NodeListener listener, NodeEvent e) {
            listener.nodeDeleted(e);
        }
    }

    final class 13
    implements NodeEventClosure {
        private final /* synthetic */ URL v$oldURL;
        private final /* synthetic */ URL v$newURL;
        final /* synthetic */ Node this$0;

        public void run(NodeListener listener, NodeEvent e) {
            listener.nodeRenamed(e, this.v$oldURL, this.v$newURL);
        }

        public 13(Node node, URL uRL, URL uRL2) {
            this.v$newURL = uRL2;
            this.v$oldURL = uRL;
            this.this$0 = node;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NodeListenerIterator
    implements Iterator<NodeListener> {
        private NodeListener _curListener;
        private Object[] _curListeners;
        private int _i;
        private int _n;
        private boolean _instanceListRead;
        private boolean _typeListRead;
        private boolean _typeHierarchyListRead;
        private Class _curType;

        @Override
        public boolean hasNext() {
            this.tryNext();
            return this._curListener != null;
        }

        @Override
        public NodeListener next() {
            this.tryNext();
            NodeListener listener = this._curListener;
            this._curListener = null;
            return listener;
        }

        private void tryNext() {
            if (this._curListener == null) {
                this._curListener = this.nextImpl();
            }
        }

        private void resetCurListeners(CopyOnWriteArrayList listenerList) {
            if (listenerList != null) {
                this._curListeners = listenerList.toArray();
            }
            this._i = 0;
            this._n = this._curListeners != null ? this._curListeners.length : 0;
        }

        private NodeListener nextListenerImpl() {
            if (this._curListeners != null) {
                if (this._i < this._n) {
                    this._curListener = (NodeListener)this._curListeners[this._i++];
                    return this._curListener;
                }
                this._curListeners = null;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private NodeListener nextImpl() {
            NodeListener next;
            NodeListener next2;
            if (!this._instanceListRead) {
                this._instanceListRead = true;
                if (this._curListeners == null) {
                    this.resetCurListeners(Node.ra$_listeners(Node.this));
                }
            }
            if ((next2 = this.nextListenerImpl()) != null) {
                return next2;
            }
            if (!this._typeListRead) {
                this._typeListRead = true;
                if (this._curListeners == null) {
                    Class<?> nodeType = Node.this.getClass();
                    HashMap hashMap = Node.ra$_listenersForType();
                    synchronized (hashMap) {
                        CopyOnWriteArrayList listenerListObj = (CopyOnWriteArrayList)Node.ra$_listenersForType().get(nodeType);
                        if (listenerListObj != null) {
                            CopyOnWriteArrayList listenerList = listenerListObj;
                            this.resetCurListeners(listenerList);
                        }
                    }
                }
            }
            if ((next = this.nextListenerImpl()) != null) {
                return next;
            }
            if (!this._typeHierarchyListRead) {
                this._typeHierarchyListRead = true;
                this._curType = Node.this.getClass();
            }
            while (this._curType != null) {
                NodeListener next3;
                if (this._curListeners == null) {
                    HashMap hashMap = Node.ra$_listenersForTypeHierarchy();
                    synchronized (hashMap) {
                        CopyOnWriteArrayList listenerListObj = (CopyOnWriteArrayList)Node.ra$_listenersForTypeHierarchy().get(this._curType);
                        if (listenerListObj != null) {
                            CopyOnWriteArrayList listenerList = listenerListObj;
                            this.resetCurListeners(listenerList);
                        }
                    }
                    Class clazz = this._curType = this._curType == Node.class ? null : this._curType.getSuperclass();
                }
                if ((next3 = this.nextListenerImpl()) == null) continue;
                return next3;
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private NodeListenerIterator() {
        }

        NodeListenerIterator(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private static final class DeleteRenameInterceptor
    extends URLFileSystemHelperDecorator {
        private DeleteRenameInterceptor(URLFileSystemHelper helper) {
            super(helper);
        }

        public void delete(URL url) throws IOException {
            Node node = this.tryGetNode(url);
            if (node != null) {
                Node.mav$deleteInternal(node, this._helper);
            } else {
                super.delete(url);
            }
        }

        public void rename(URL oldURL, URL newURL) throws IOException {
            Node node = this.tryGetNode(oldURL);
            if (node != null) {
                Node.mav$renameInternal(node, newURL, this._helper);
            } else {
                super.rename(oldURL, newURL);
            }
        }

        private Node tryGetNode(URL url) {
            try {
                Node node = NodeFactory.find(url);
                return node;
            }
            catch (Exception e) {
                e.printStackTrace();
                Node node = null;
                return node;
            }
        }

        DeleteRenameInterceptor(URLFileSystemHelper uRLFileSystemHelper, 1 var2_2) {
            this(uRLFileSystemHelper);
        }

        public final class 1 {
        }
    }

    static final class 14
    extends NodeListener {
        public void nodeOpened(NodeEvent e) {
            14.invokeLaterIfNeeded(new 1(this, e));
        }

        public void nodeWillClose(NodeEvent e) {
            14.invokeLaterIfNeeded(new 2(this, e));
        }

        public void nodeClosed(NodeEvent e) {
            14.invokeLaterIfNeeded(new 3(this, e));
        }

        public void nodeReverted(NodeEvent e) {
            14.invokeLaterIfNeeded(new 4(this, e));
        }

        final class 1
        implements Runnable {
            private final /* synthetic */ NodeEvent v$e;
            final /* synthetic */ 14 this$0;

            public void run() {
                Node node = this.v$e.getNode();
                String key = node.getClass().getName() + ".fireObjectOpened";
                PerformanceLogger.get().startTiming(key);
                try {
                    UpdateMessage.fireObjectOpened(node);
                }
                finally {
                    PerformanceLogger.get().stopTiming(key, "Opened " + node.getLongLabel(), 10);
                }
            }

            public 1(14 var1_1, NodeEvent nodeEvent) {
                this.v$e = nodeEvent;
                this.this$0 = var1_1;
            }
        }

        final class 2
        implements Runnable {
            private final /* synthetic */ NodeEvent v$e;
            final /* synthetic */ 14 this$0;

            public void run() {
                UpdateMessage mesg = new UpdateMessage(UpdateMessage.OBJECT_CLOSING, null);
                Node node = this.v$e.getNode();
                node.notifyObservers(node, mesg);
            }

            public 2(14 var1_1, NodeEvent nodeEvent) {
                this.v$e = nodeEvent;
                this.this$0 = var1_1;
            }
        }

        final class 3
        implements Runnable {
            private final /* synthetic */ NodeEvent v$e;
            final /* synthetic */ 14 this$0;

            public void run() {
                UpdateMessage.fireObjectClosed(this.v$e.getNode());
            }

            public 3(14 var1_1, NodeEvent nodeEvent) {
                this.v$e = nodeEvent;
                this.this$0 = var1_1;
            }
        }

        final class 4
        implements Runnable {
            private final /* synthetic */ NodeEvent v$e;
            final /* synthetic */ 14 this$0;

            public void run() {
                UpdateMessage.fireObjectReloaded(this.v$e.getNode());
            }

            public 4(14 var1_1, NodeEvent nodeEvent) {
                this.v$e = nodeEvent;
                this.this$0 = var1_1;
            }
        }
    }

    static class 15 {
        static final /* synthetic */ int[] $sm$oracle$ide$model$Node$NodeState;

        static {
            int[] nArray = new int[NodeState.values().length];
            $sm$oracle$ide$model$Node$NodeState = nArray;
            try {
                nArray[NodeState.LOADING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                15.$sm$oracle$ide$model$Node$NodeState[NodeState.UNLOADING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                15.$sm$oracle$ide$model$Node$NodeState[NodeState.OPENING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                15.$sm$oracle$ide$model$Node$NodeState[NodeState.OPEN.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                15.$sm$oracle$ide$model$Node$NodeState[NodeState.CLOSING.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                15.$sm$oracle$ide$model$Node$NodeState[NodeState.LOADED.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                15.$sm$oracle$ide$model$Node$NodeState[NodeState.CLOSED.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
        }
    }
}

