/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.io.File;
import java.net.URL;
import java.util.Map;
import oracle.ide.Ide;
import oracle.ide.migration.XMLMigrator;
import oracle.ide.model.IdeSystem;
import oracle.ide.model.Preferences;
import oracle.ide.model.Workspaces;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.resource.ModelArb;

public final class IdeSystemMigrator
extends XMLMigrator {
    private static final String DEFAULT_WORKSPACE_DIR = "DefaultWorkspace";
    private static final String DEFAULT_WORKSPACE_NAME = "DefaultWorkspace.jws";
    private static final String DEFAULT_PROJECT_NAME = "Project1.jpr";
    public static final int SYSTEM_SETTINGS = 0;
    public static final int DEFAULT_PROJECT = 1;
    public static final int DEFAULT_WORKSPACE = 2;

    public IdeSystemMigrator() {
        super(new int[]{0, 1});
    }

    public String getDescription(int category) {
        switch (category) {
            case 0: {
                return ModelArb.getString(0);
            }
            case 1: {
                return ModelArb.getString(65);
            }
            case 2: {
                return ModelArb.getString(9);
            }
        }
        return null;
    }

    protected String getFileName() {
        return "System.sys";
    }

    protected String getNamespaceURI() {
        return IdeSystem.NAMESPACE_URI;
    }

    protected String getRootTag() {
        return "system";
    }

    protected void prepareToMigrate() {
        Class<IdeSystem> cls = IdeSystem.class;
    }

    protected Object adjustObject(File sourceDir, File destDir, Object obj) throws Exception {
        Workspaces migratedWorkspaces;
        URL url;
        File dfltDir = new File(destDir, DEFAULT_WORKSPACE_DIR);
        if (!dfltDir.exists()) {
            dfltDir.mkdirs();
        }
        IdeSystem inSys = (IdeSystem)obj;
        Preferences inPrefs = inSys.getPreferences();
        Map inMap = inPrefs.getPreferencesMap();
        IdeSystem outSys = this.isSelected(0) ? inSys : this.getSettings(destDir);
        Preferences outPrefs = outSys.getPreferences();
        if (outPrefs == null) {
            outPrefs = (Preferences)outSys.getChild(Preferences.class);
        }
        Map outMap = outPrefs.getPreferencesMap();
        File file = new File(dfltDir, DEFAULT_PROJECT_NAME);
        if (this.isSelected(1)) {
            url = (URL)inMap.get("DefaultProject");
            URLFileSystem.copy((URL)url, (File)file);
        }
        outMap.put("DefaultProject", URLFactory.newFileURL((File)file));
        file = new File(dfltDir, DEFAULT_WORKSPACE_NAME);
        if (this.isSelected(2)) {
            url = (URL)inMap.get(DEFAULT_WORKSPACE_DIR);
            URLFileSystem.copy((URL)url, (File)file);
        }
        outMap.put(DEFAULT_WORKSPACE_DIR, URLFactory.newFileURL((File)file));
        outPrefs.setPreferencesMap(outMap);
        Workspaces workspaces = Ide.getWorkspaces();
        if (workspaces != null && (migratedWorkspaces = (Workspaces)outSys.getChild(Workspaces.class)) != null) {
            migratedWorkspaces.copyTo(workspaces);
        }
        return super.adjustObject(sourceDir, destDir, outSys);
    }

    private IdeSystem getSettings(File destDir) throws Exception {
        File file = this.getDestFile(null, destDir);
        URL url = URLFactory.newFileURL((File)file);
        return (IdeSystem)this.getObjectStore().toObject(url);
    }

    public String[] migrate(File sourceDir, File destDir) {
        this.getLogger().logInformation(ModelArb.getString(20));
        return super.migrate(sourceDir, destDir);
    }
}

