/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.io.FileNotFoundException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import oracle.ide.Version;
import oracle.ide.marshal.xml.HashStructureIO;
import oracle.ide.migration.MigrationInfo;
import oracle.ide.migration.NodeMigrator;
import oracle.ide.migration.NodeMigratorHelper;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.model.ProjectVersion;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.VersionNumber;
import oracle.ide.xml.StartElementPacket;
import oracle.ide.xml.XMLUtil;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;

abstract class HashStructureNodeMigrator
extends NodeMigrator {
    HashStructureNodeMigrator() {
        this.addHelper(new 1());
    }

    public MigrationInfo getMigrationInfo(Node node) {
        return new HSNodeMigrationInfo(node, this.getHelpers(), this.getRootQname());
    }

    abstract String getRootQname();

    protected NodeMigratorHelper[] getHelpers(MigrationInfo info) {
        ArrayList helpers = new ArrayList();
        if (info instanceof HSNodeMigrationInfo) {
            HSNodeMigrationInfo hsInfo = (HSNodeMigrationInfo)info;
            helpers.addAll(hsInfo.getActiveHelpers());
        }
        return helpers.toArray(new NodeMigratorHelper[helpers.size()]);
    }

    private static boolean isSkipMigration(HashStructure hash) {
        ProjectVersion jwsVersion;
        VersionNumber ideVersionNumber;
        if (hash.getBoolean("doNoMigration")) {
            return true;
        }
        return hash.getBoolean("doLimitedMigration") && (ideVersionNumber = new VersionNumber(Version.VER)).isBefore((jwsVersion = new ProjectVersion(hash)).getCurrentVersion(), true);
    }

    static boolean maS$isSkipMigration(HashStructure hashStructure) {
        return HashStructureNodeMigrator.isSkipMigration(hashStructure);
    }

    final class 1
    extends NodeMigratorHelper {
        public void migrate(MigrationInfo[] infos, TraversableContext tc) {
        }

        public String getNodeMigratorHelperKey() {
            return "oracle.ide.model.Project";
        }
    }

    private static class HSNodeMigrationInfo
    extends MigrationInfo {
        private final ArrayList _helpers;
        private final String _rootQname;

        private void $init$() {
            this._helpers = new ArrayList();
        }

        HSNodeMigrationInfo(Node node, NodeMigratorHelper[] helpers, String rootQname) {
            super(node);
            this.$init$();
            if (helpers != null) {
                this._helpers.addAll(Arrays.asList(helpers));
            }
            this._rootQname = rootQname;
        }

        protected void ensureVersionInfo() {
            if (this.getVersionDirectly() == null) {
                this.ensureVersionInfoImpl();
            }
        }

        private void ensureVersionInfoImpl() {
            this.setVersionStatusDirectly(MigrationInfo.VERSION_UNKNOWN);
            this.setMigrationStatus(MigrationInfo.MIGRATION_NOT_POSSIBLE);
            this.setVersionDirectly("");
            try {
                Node node = this.getNode();
                URL url = node.getURL();
                StartElementPacket sep = XMLUtil.getXMLRootElement((URL)url);
                if (sep != null && sep.namespaceURI != null && sep.namespaceURI.length() > 0) {
                    String uriVersion = HSNodeMigrationInfo.getVersionFromNamespaceURI(sep.namespaceURI);
                    if (uriVersion != null) {
                        if (uriVersion.equals("10130") || !uriVersion.matches("^\\d+$")) {
                            List missingContentSetKeys;
                            HashStructureIO io = new HashStructureIO("http://xmlns.oracle.com/ide/project", this._rootQname);
                            HashStructure hash = (HashStructure)io.load(url);
                            ProjectVersion hashVersion = new ProjectVersion(hash);
                            Iterator helpersIter = this._helpers.iterator();
                            while (helpersIter.hasNext()) {
                                int compare;
                                NodeMigratorHelper helper = (NodeMigratorHelper)helpersIter.next();
                                VersionNumber migratorVersion = new VersionNumber(helper.getNodeMigratorHelperVersion());
                                String migratorKey = helper.getNodeMigratorHelperKey();
                                VersionNumber versionInHash = migratorKey != null ? hashVersion.getCurrentVersion(migratorKey) : hashVersion.getCurrentVersion();
                                if (versionInHash == null || (compare = migratorVersion.compareTo(versionInHash)) > 0) continue;
                                if (compare == 0) {
                                    helpersIter.remove();
                                    continue;
                                }
                                helpersIter.remove();
                            }
                            if (node instanceof Project && (missingContentSetKeys = ProjectContent.getInstance(hash).getMissingContentSetKeys()).size() > 0) {
                                this._helpers.add(new ProjectContentHelper(null));
                            }
                            boolean skipMigration = false;
                            if (node instanceof Workspace) {
                                Workspace workspace = (Workspace)node;
                                HashStructure jwsHash = workspace.getProperties();
                                skipMigration = HashStructureNodeMigrator.maS$isSkipMigration(jwsHash);
                            }
                            if (this._helpers.size() > 0 && !skipMigration) {
                                this.setMigrationStatus(MigrationInfo.MIGRATION_PENDING);
                                this.setVersionStatusDirectly(MigrationInfo.VERSION_OLDER);
                                this.setVersionDirectly("1013");
                            } else if (node instanceof Workspace) {
                                ListStructure listOfChildren;
                                Workspace workspace = (Workspace)node;
                                HashStructure jwsHash = workspace.getProperties();
                                boolean atLeastOneProjectNeedsMigration = false;
                                if (!skipMigration && (listOfChildren = hash.getListStructure("listOfChildren")) != null) {
                                    block4: for (Object childObj : listOfChildren) {
                                        List missingContentSetKeys2;
                                        NodeMigratorHelper[] projectHelpers;
                                        HashStructureIO projectIO;
                                        HashStructure projectHash;
                                        if (!(childObj instanceof HashStructure)) continue;
                                        HashStructure child = (HashStructure)childObj;
                                        URL projectURL = child.getURL("URL");
                                        if (url == null || !URLFileSystem.hasSuffix((URL)projectURL, (String)".jpr") || HashStructureNodeMigrator.maS$isSkipMigration(projectHash = (HashStructure)(projectIO = new HashStructureIO("http://xmlns.oracle.com/ide/project", "jpr:project")).load(projectURL))) continue;
                                        NodeMigrator projectMigrator = NodeMigrator.getNodeMigrator(Project.class.getName());
                                        if (projectMigrator != null && (projectHelpers = projectMigrator.getHelpers()).length > 0) {
                                            ProjectVersion projectVersion = new ProjectVersion(projectHash);
                                            int i = 0;
                                            while (i < projectHelpers.length) {
                                                String migratorKey;
                                                VersionNumber versionInProject;
                                                NodeMigratorHelper projectHelper = projectHelpers[i];
                                                VersionNumber migratorVersion = new VersionNumber(projectHelper.getNodeMigratorHelperVersion());
                                                int compare = migratorVersion.compareTo(versionInProject = (migratorKey = projectHelper.getNodeMigratorHelperKey()) != null ? projectVersion.getCurrentVersion(migratorKey) : projectVersion.getCurrentVersion());
                                                if (compare > 0) {
                                                    atLeastOneProjectNeedsMigration = true;
                                                    break block4;
                                                }
                                                ++i;
                                            }
                                        }
                                        if ((missingContentSetKeys2 = ProjectContent.getInstance(projectHash).getMissingContentSetKeys()).size() <= 0) continue;
                                        atLeastOneProjectNeedsMigration = true;
                                        break;
                                    }
                                }
                                if (atLeastOneProjectNeedsMigration) {
                                    this.setMigrationStatus(MigrationInfo.MIGRATION_PENDING);
                                    this.setVersionStatusDirectly(MigrationInfo.VERSION_OLDER);
                                    this.setVersionDirectly("1013");
                                } else {
                                    this.setVersionStatusDirectly(MigrationInfo.VERSION_CURRENT);
                                    this.setMigrationStatus(MigrationInfo.MIGRATION_NOT_NEEDED);
                                    this.setVersionDirectly(Version.BASE_NAMESPACE_URI);
                                }
                            } else {
                                this.setVersionStatusDirectly(MigrationInfo.VERSION_CURRENT);
                                this.setMigrationStatus(MigrationInfo.MIGRATION_NOT_NEEDED);
                                this.setVersionDirectly(Version.BASE_NAMESPACE_URI);
                            }
                        } else {
                            this.setMigrationStatus(MigrationInfo.MIGRATION_PENDING);
                            this.setVersionStatusDirectly(MigrationInfo.VERSION_OLDER);
                            this.setVersionDirectly(uriVersion);
                            if (node instanceof Project) {
                                this._helpers.add(new ProjectContentHelper(null));
                            }
                        }
                    }
                } else {
                    this.setMigrationStatus(MigrationInfo.MIGRATION_PENDING);
                    this.setVersionStatusDirectly(MigrationInfo.VERSION_OLDER);
                    this.setVersionDirectly("900");
                    if (node instanceof Project) {
                        this._helpers.add(new ProjectContentHelper(null));
                    }
                }
            }
            catch (FileNotFoundException e) {
                this.setVersionStatusDirectly(MigrationInfo.VERSION_CURRENT);
                this.setMigrationStatus(MigrationInfo.MIGRATION_NOT_NEEDED);
                this.setVersionDirectly(Version.BASE_NAMESPACE_URI);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        List getActiveHelpers() {
            return this._helpers;
        }

        public NodeMigratorHelper[] getHelpers() {
            return this._helpers.toArray(new NodeMigratorHelper[this._helpers.size()]);
        }

        final class 1
        implements Runnable {
            private final /* synthetic */ List v$missingContentSetKeys;
            private final /* synthetic */ URL v$url;
            final /* synthetic */ HSNodeMigrationInfo this$0;

            public void run() {
                Iterator keyIter = this.v$missingContentSetKeys.iterator();
                while (keyIter.hasNext()) {
                }
            }

            public 1(HSNodeMigrationInfo hSNodeMigrationInfo, List list, URL uRL) {
                this.v$url = uRL;
                this.v$missingContentSetKeys = list;
                this.this$0 = hSNodeMigrationInfo;
            }
        }
    }

    private static class ProjectContentHelper
    extends NodeMigratorHelper {
        public void migrate(MigrationInfo[] infos, TraversableContext context) {
            int n = infos.length;
            int i = 0;
            while (i < n) {
                MigrationInfo info = infos[i];
                Node node = info.getNode();
                if (node instanceof Project) {
                    ProjectContent.initializeContentSets((Project)node);
                }
                ++i;
            }
        }

        public String getNodeMigratorHelperKey() {
            return null;
        }

        private ProjectContentHelper() {
        }

        ProjectContentHelper(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

