/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import javax.ide.extension.ExtensionRegistry;
import oracle.ide.marshal.xml.HashStructureIO;
import oracle.ide.model.DataContainer;
import oracle.ide.model.UserProperties;
import oracle.ide.net.URLFileSystem;
import oracle.ide.resource.ModelArb;
import oracle.javatools.data.Dirtyable;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.marshal.ObjectStore;
import oracle.javatools.util.ModelUtil;

public abstract class HashStructureNode
extends DataContainer
implements PropertyStorage {
    private UserProperties _userProperties;

    HashStructureNode() {
    }

    public final void setURL(URL url) {
        super.setURL(url);
        this.initUserProperties();
    }

    public abstract Object copyTo(Object var1);

    protected final void copyToImpl(HashStructureNode copy) {
        if (this.ensureLoad()) {
            super.copyToImpl(copy);
            if (this.isUserPropertiesEnabled()) {
                if (this._userProperties != null) {
                    if (copy._userProperties != null) {
                        this._userProperties.copyTo(copy._userProperties);
                    } else {
                        copy._userProperties = (UserProperties)this._userProperties.copyTo(null);
                    }
                } else {
                    copy._userProperties = null;
                }
            }
        }
        this.handlePropertiesCopied(copy);
    }

    public final HashStructure getProperties() {
        return this.getPropertiesImpl(true);
    }

    public final HashStructure getPropertiesForOverriding() {
        return this.getPropertiesImpl(false);
    }

    public final HashStructure getUserPropertiesOnly() {
        this.ensureLoad();
        return this._userProperties != null ? this._userProperties.getProperties() : null;
    }

    void loadImpl() throws IOException {
        URL url = this.getURL();
        if (url != null && this.getObjectStore().open(url, this.getObjectStoreTarget())) {
            this.markDirty(false);
        }
        this._hash.setParentDirtyable((Dirtyable)this._hashDirtyTracker);
        this.initListOfChildren();
        this.initUserProperties();
    }

    protected void openImpl() throws IOException {
        super.openImpl();
        this.handleAttachStructureChangeListener(this._hash);
    }

    protected void closeImpl() throws IOException {
        if (this.isUserPropertiesEnabled()) {
            try {
                this.saveUserProperties();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (this._userProperties != null) {
                this._userProperties.getProperties().setParentDirtyable(null);
                this._userProperties = null;
            }
            this.handleCustomPropsClosed();
        }
        this.handleDetachStructureChangeListener();
        super.closeImpl();
    }

    protected void saveImpl() throws IOException {
        HashStructureIO io;
        block19: {
            io = (HashStructureIO)this.getObjectStore();
            try {
                if (!io.isLastLoadUsedFallback()) break block19;
                InputStream in = null;
                BufferedReader br = null;
                try {
                    in = URLFileSystem.openInputStream((URL)this.getURL());
                    InputStreamReader isr = new InputStreamReader(in, "UTF-8");
                    br = new BufferedReader(isr);
                    while (br.ready()) {
                        String line = br.readLine();
                        if (line == null || !line.startsWith("<<<<<<<")) continue;
                        throw new IOException(ModelArb.format(49, URLFileSystem.getPlatformPathName((URL)this.getURL())));
                    }
                }
                finally {
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            catch (IOException ioe) {
                throw ioe;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.saveUserProperties();
        if (this._hashDirtyTracker.isDirty()) {
            io.save(this.getURL(), this.getObjectStoreTarget());
            this._hashDirtyTracker.clearDirty();
        }
    }

    public final void saveUserProperties() throws IOException {
        if (this.isUserPropertiesEnabled() && this._userProperties != null) {
            this._userProperties.save();
        }
    }

    protected final ObjectStore newObjectStore() {
        return this.newHashStructureIO();
    }

    protected HashStructureIO newHashStructureIO() {
        return new HashStructureIO(this.getNamespaceURI(), this.getRootQName());
    }

    protected String getNamespaceURI() {
        return null;
    }

    protected String getRootQName() {
        return "hash";
    }

    protected final Object getObjectStoreTarget() {
        return this._hash;
    }

    public boolean isDefault() {
        return false;
    }

    protected boolean isUserPropertiesEnabled() {
        return true;
    }

    public final void applyBatchChanges(Runnable runnable) {
        HashStructure hash = this.getSharedPropertiesOnly();
        if (this.isUserPropertiesEnabled()) {
            HashStructure userHash = this.getUserPropertiesOnly();
            if (userHash != null) {
                userHash.applyBatchChanges((Runnable)new 1(this, hash, runnable));
            }
        } else {
            hash.applyBatchChanges(runnable);
        }
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        HashStructureNode other = (HashStructureNode)o;
        return this.equalsImpl(other);
    }

    protected final boolean equalsImpl(HashStructureNode other) {
        return super.equalsImpl(other) && ModelUtil.areEqual((Object)this._userProperties, (Object)other._userProperties);
    }

    boolean supportsLoaded() {
        return true;
    }

    void handleCustomPropsClosed() {
    }

    void handleCustomPropsOpened(HashStructure customProperties) {
    }

    void handleAttachStructureChangeListener(HashStructure hash) {
    }

    void handleDetachStructureChangeListener() {
    }

    void handlePropertiesCopied(HashStructureNode copy) {
    }

    private void initUserProperties() {
        if (this.isUserPropertiesEnabled()) {
            if (!HashStructureNode.isExtensionRegistryAvailable()) {
                new Exception("Extension registry not available").printStackTrace();
            } else {
                URL url = this.getURL();
                if (url != null) {
                    this.handleCustomPropsClosed();
                    this._userProperties = new UserProperties(url, this.getNamespaceURI(), this.getRootQName());
                    this.handleCustomPropsOpened(this._userProperties.getProperties());
                } else {
                    this._userProperties = null;
                }
            }
        }
    }

    private HashStructure getPropertiesImpl(boolean biasTowardShared) {
        HashStructure sharedProperties = this.getSharedPropertiesOnly();
        if (this.isUserPropertiesEnabled() && this._userProperties != null) {
            HashStructure userProperties = this.getUserPropertiesOnly();
            HashStructure[] hashes = new HashStructure[]{userProperties, sharedProperties};
            if (biasTowardShared) {
                return HashStructure.newChainForStatusQuo((HashStructure[])hashes);
            }
            return HashStructure.newChainForOverriding((HashStructure[])hashes);
        }
        return sharedProperties;
    }

    private static boolean isExtensionRegistryAvailable() {
        try {
            ExtensionRegistry.getExtensionRegistry();
            boolean bl = true;
            return bl;
        }
        catch (Throwable e) {
            boolean bl = false;
            return bl;
        }
    }

    final class 1
    implements Runnable {
        private final /* synthetic */ HashStructure v$hash;
        private final /* synthetic */ Runnable v$runnable;
        final /* synthetic */ HashStructureNode this$0;

        public void run() {
            this.v$hash.applyBatchChanges(this.v$runnable);
        }

        public 1(HashStructureNode hashStructureNode, HashStructure hashStructure, Runnable runnable) {
            this.v$runnable = runnable;
            this.v$hash = hashStructure;
            this.this$0 = hashStructureNode;
        }
    }
}

