/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import oracle.ide.model.Dependable;
import oracle.ide.model.DependableFactory;
import oracle.ide.model.Element;
import oracle.ide.model.Project;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.data.StructureChangeListener;

public class DependencyConfiguration
extends HashStructureAdapter {
    public static final String DATA_KEY = DependencyConfiguration.class.getName();
    private final Project _project;
    public static final String DEPENDENCY_LIST = "dependencyList";

    private DependencyConfiguration(HashStructure hash, Project project) {
        super(hash);
        this._project = project;
    }

    public static DependencyConfiguration getInstance(Project project) {
        return new DependencyConfiguration(DependencyConfiguration.findOrCreate((PropertyStorage)project, (String)DATA_KEY), project);
    }

    public static DependencyConfiguration getInstance(PropertyStorage project) {
        return new DependencyConfiguration(DependencyConfiguration.findOrCreate((PropertyStorage)project, (String)DATA_KEY), null);
    }

    private ListStructure getDependenciesListStructure() {
        return this._hash.getListStructure(DEPENDENCY_LIST);
    }

    public void attachDependencyChangeListener(StructureChangeListener listener) {
        this._hash.getOrCreateListStructure(DEPENDENCY_LIST);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getDependencyList() {
        ListStructure depList = this.getDependenciesListStructure();
        if (depList != null) {
            ArrayList<Dependable> dependencies = new ArrayList<Dependable>();
            ListStructure listStructure = depList;
            synchronized (listStructure) {
                Iterator iter = depList.iterator();
                while (iter.hasNext()) {
                    HashStructure hash = (HashStructure)iter.next();
                    try {
                        Dependable dependable = DependableFactory.toDependable(hash);
                        if (dependable != null) {
                            dependencies.add(dependable);
                            continue;
                        }
                        iter.remove();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            return dependencies;
        }
        return null;
    }

    public void setDependencyList(List dependencies) {
        ArrayList<HashStructure> depList = new ArrayList<HashStructure>();
        if (dependencies != null) {
            for (Object dep : dependencies) {
                try {
                    HashStructure depHash = DependableFactory.toHashStructure((Dependable)dep);
                    if (depHash == null) continue;
                    depList.add(depHash);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        ListStructure deps = this.getDependencyListStructure();
        deps.mirror(depList);
    }

    private ListStructure getDependencyListStructure() {
        return this._hash.getOrCreateListStructure(DEPENDENCY_LIST);
    }

    public void addDependency(Dependable dependable) {
        if (dependable != null) {
            ListStructure list = this.getDependencyListStructure();
            try {
                HashStructure hash = DependableFactory.toHashStructure(dependable);
                if (!list.contains((Object)hash)) {
                    list.add((Object)hash);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void removeDependency(Dependable dependable) {
        ListStructure dependencyList;
        if (dependable != null && (dependencyList = this.getDependencyListStructure()) != null) {
            try {
                HashStructure hash = DependableFactory.toHashStructure(dependable);
                Iterator iter = dependencyList.iterator();
                while (iter.hasNext()) {
                    Object next = iter.next();
                    if (next == null || !next.equals(hash)) continue;
                    iter.remove();
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public Iterator getDependencies() {
        List list = this.getDependencyList();
        if (list != null) {
            return list.iterator();
        }
        return Collections.EMPTY_LIST.iterator();
    }

    public List getAllDependenciesList() {
        ArrayList all = new ArrayList();
        ArrayList<Project> seenSources = new ArrayList<Project>();
        if (this._project != null) {
            seenSources.add(this._project);
        } else {
            new Exception("*** Warning: Project not specified to DependencyConfiguration.  Cycles will not be detected properly.").printStackTrace();
        }
        this.collectDependencies(this.getDependencies(), all, seenSources);
        return all;
    }

    private void collectDependencies(Iterator deps, List output, List seenSources) {
        while (deps.hasNext()) {
            Dependable dependable = (Dependable)deps.next();
            if (DependencyConfiguration.wasSourceSeen(dependable.getSource(), seenSources)) continue;
            seenSources.add(dependable.getSource());
            this.collectDependencies(dependable.getDependencies(), output, seenSources);
            output.add(dependable);
        }
    }

    private static boolean wasSourceSeen(Element element, List seenSources) {
        int i = 0;
        while (i < seenSources.size()) {
            Element source = (Element)seenSources.get(i);
            if (source == element) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

