/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import oracle.ide.dialogs.ProgressBar;
import oracle.ide.model.ContentSet;
import oracle.ide.model.ProjectContent;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.util.PatternFilter;
import oracle.ide.util.PatternFilters;
import oracle.javatools.data.HashStructure;

public class ContentSetHelper {
    private String _key;
    protected ProjectContent _projectContent;

    public ContentSetHelper(String key) {
        this._key = key;
    }

    public boolean canAddContent(URL url, ProjectContent projectContent) {
        this._projectContent = projectContent;
        return url != null && projectContent != null;
    }

    public final void addContent(URL url, ProjectContent projectContent, boolean includeSubFolders, ProgressBar progressBar) {
        this._projectContent = projectContent;
        if (this.restoreContent(url, projectContent)) {
            return;
        }
        ContentSet primaryContentSet = this.getBaseContentSet(projectContent);
        if (primaryContentSet.getAllRootDirs().size() == 0) {
            this.addContentImpl(url, primaryContentSet, includeSubFolders, progressBar);
        } else {
            ContentSet newContentSet = this.newContentSet();
            this.addContentImpl(url, newContentSet, includeSubFolders, progressBar);
            this.postProcess(primaryContentSet);
        }
    }

    protected void addContentImpl(URL url, ContentSet contentSet, boolean includeSubFolders, ProgressBar progressBar) {
        if (URLFileSystem.isDirectory((URL)url) || URLFileSystem.isDirectoryPath((URL)url)) {
            URL[] entries = new URL[]{url};
            contentSet.getURLPath().setEntries(entries);
            if (!includeSubFolders) {
                contentSet.getPatternFilters().addInclude("*");
            }
        } else {
            URL containingFolder = URLFileSystem.getParent((URL)url);
            URL[] entries = new URL[]{containingFolder};
            contentSet.getURLPath().setEntries(entries);
            String pattern = contentSet.getURLPath().toRelativePath(url);
            contentSet.getPatternFilters().addInclude(pattern);
        }
    }

    public final boolean restoreContent(URL url, ProjectContent projectContent) {
        this._projectContent = projectContent;
        ContentSet contentSet = this.getBaseContentSet(projectContent);
        if (contentSet.getAllRootDirs().toRelativePath(url) != null) {
            return this.restoreContentImpl(url, contentSet);
        }
        return false;
    }

    protected boolean restoreContentImpl(URL url, ContentSet contentSet) {
        String rel;
        URLPath urlPath = contentSet.getURLPath();
        if (urlPath != null && urlPath.size() > 0 && (rel = contentSet.getURLPath().toRelativePath(url)) != null && this.unExclude(rel, contentSet)) {
            return true;
        }
        int i = 0;
        while (i < contentSet.countContentSets()) {
            if (this.restoreContentImpl(url, contentSet.getContentSet(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected final boolean unExclude(String pattern, ContentSet contentSet) {
        PatternFilter[] pfArray = contentSet.getPatternFilters().getFilters();
        if (pfArray == null) {
            return true;
        }
        List<PatternFilter> originalFilters = Arrays.asList(pfArray);
        ArrayList<PatternFilter> filters = new ArrayList<PatternFilter>(originalFilters);
        int length = filters.size();
        if (length == 0) {
            filters.add(PatternFilter.newInclude(pattern));
        } else {
            boolean containsIncludeFilter = false;
            PatternFilter ex = PatternFilter.newExclude(pattern);
            Iterator iterator = filters.iterator();
            while (iterator.hasNext()) {
                PatternFilter pf = (PatternFilter)iterator.next();
                if (ex.equals(pf)) {
                    iterator.remove();
                    continue;
                }
                if (!pf.isInclude() || pf.containsWildcard()) continue;
                containsIncludeFilter = true;
            }
            if (containsIncludeFilter && filters.size() == length) {
                filters.add(0, PatternFilter.newInclude(pattern));
            }
        }
        if (length != filters.size()) {
            PatternFilter[] newFilters = new PatternFilter[filters.size()];
            filters.toArray(newFilters);
            contentSet.getPatternFilters().setFilters(newFilters);
            return true;
        }
        return false;
    }

    public final void removeContent(URL url, ProjectContent projectContent) {
        this._projectContent = projectContent;
        ContentSet primaryContentSet = this.getBaseContentSet(projectContent);
        if (primaryContentSet.canHaveMember(url)) {
            this.removeContentImpl(url, primaryContentSet);
        }
    }

    protected void removeContentImpl(URL url, ContentSet contentSet) {
        String pattern = contentSet.getURLPath().toRelativePath(url);
        if (pattern != null) {
            PatternFilters filters = contentSet.getPatternFilters();
            if (filters.getFilters() != null) {
                filters.addExclude(pattern);
            } else {
                PatternFilter[] newFilters = new PatternFilter[]{PatternFilter.newExclude(pattern), PatternFilter.newInclude("**")};
                contentSet.getPatternFilters().setFilters(newFilters);
            }
        }
        int count = contentSet.countContentSets();
        int i = 0;
        while (i < count) {
            this.removeContentImpl(url, contentSet.getContentSet(i));
            ++i;
        }
    }

    protected final ContentSet newContentSet() {
        ContentSet parent = this._projectContent.getContentSet(this._key);
        ContentSet child = new ContentSet(HashStructure.newInstance());
        parent.addContentSet(child);
        return child;
    }

    protected final ContentSet getBaseContentSet(ProjectContent projectContent) {
        return projectContent.getContentSet(this._key);
    }

    private void postProcess(ContentSet contentSet) {
        URL[] paths;
        int count = contentSet.countContentSets();
        if (count > 0 && (paths = contentSet.getURLPath().getEntries()).length > 0) {
            URL extraURL = contentSet.getContentFolderURL();
            int i = 0;
            while (i < paths.length) {
                ContentSet newContentSet = new ContentSet(HashStructure.newInstance());
                newContentSet.getURLPath().setEntries(new URL[]{paths[i]});
                if (extraURL != null) {
                    newContentSet.setContentFolderURL(extraURL);
                }
                newContentSet.getPatternFilters().setFilters(contentSet.getPatternFilters().getFilters());
                contentSet.addContentSet(newContentSet);
                ++i;
            }
            contentSet.getURLPath().setEntries(null);
            contentSet.getPatternFilters().setFilters(null);
        }
    }
}

