/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.util.ArrayList;
import java.util.List;
import oracle.ide.Context;
import oracle.ide.model.AutoExpandable;
import oracle.ide.model.ContentElement;
import oracle.ide.model.ContentLevel;
import oracle.ide.model.ContentSet;
import oracle.ide.net.URLPath;

final class ContentSetFolder
extends ContentElement
implements AutoExpandable {
    private final ContentSet _contentSet;
    private final Context _context;

    ContentSetFolder(ContentSet contentSet, String shortLabel, Context context) {
        super(shortLabel, shortLabel, ContentLevel.getFolderIcon());
        this._contentSet = contentSet;
        this._context = context;
        this.getContentSetKeys();
    }

    public URLPath getRootDirectories() {
        return this._contentSet.getAllRootDirs();
    }

    public String getRelativePath() {
        return "";
    }

    public List getContentSetKeys() {
        ArrayList keys = new ArrayList();
        ContentSetFolder.getContentSetKeysImpl(keys, this._contentSet);
        return keys;
    }

    private static void getContentSetKeysImpl(ArrayList keys, ContentSet cs) {
        String key = cs.getContentSetName();
        if (key != null) {
            if (!keys.contains(key)) {
                keys.add(key);
            }
            return;
        }
        int n = cs.countContentSets();
        int i = 0;
        while (i < n) {
            ContentSet cur = cs.getContentSet(i);
            ContentSetFolder.getContentSetKeysImpl(keys, cur);
            ++i;
        }
    }

    List getChildrenList() {
        ArrayList children = new ArrayList();
        if (this._context.getBoolean("show-root-dirs")) {
            ContentLevel.initSourceRootFolders(this._contentSet, this._context, children);
        } else {
            ContentLevel.initMergedChildren(this._contentSet, this._context, children);
        }
        return children;
    }

    public boolean shouldAutoExpand(Context expansionContext) {
        return true;
    }
}

