/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.tree.TreeNode;
import oracle.ide.Context;
import oracle.ide.explorer.ChildFilter;
import oracle.ide.explorer.ChildFilterHelper;
import oracle.ide.explorer.ExplorerContext;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TNodeConstants;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.model.ContentFilterCustomizer;
import oracle.ide.model.ContentLevelFolder;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Project;
import oracle.ide.model.RelativeDirectoryContextFolder;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.view.View;
import oracle.javatools.util.CopyOnWriteList;

final class ContentFilter
extends ChildFilter {
    private final CopyOnWriteList _helpers;
    private final Class _type;
    private final boolean _isProject;
    private final Object _lock;
    private ArrayList _children;
    private static final Logger LOG = Logger.getLogger(ContentFilter.class.getName());

    private void $init$() {
        this._lock = new Object();
    }

    ContentFilter(CopyOnWriteList helpers, Class type) {
        this.$init$();
        this._helpers = helpers;
        this._type = type;
        this._isProject = this._type == Project.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getChildren() {
        Object object = this._lock;
        synchronized (object) {
            if (this._children == null) {
                ArrayList children;
                this._children = children = new ArrayList();
                Context context = this.getContext();
                if (context != null) {
                    Object[] helpers = this._helpers.getItems();
                    int n = helpers.length;
                    int i = 0;
                    while (i < n) {
                        ChildFilterHelper helper = (ChildFilterHelper)helpers[i];
                        try {
                            helper.initChildren(context, children);
                        }
                        catch (Exception e) {
                            LOG.log(Level.SEVERE, "", e);
                        }
                        ++i;
                    }
                }
            }
            Iterator iterator = this._children != null ? this._children.iterator() : Collections.EMPTY_LIST.iterator();
            return iterator;
        }
    }

    private Context getContext() {
        TNode ownerNode = this.getOwner();
        if (ownerNode != null) {
            Element ownerElem = (Element)ownerNode.getData().getData();
            TreeExplorer treeExplorer = ownerNode.getOwner();
            Context context = treeExplorer.getContext();
            if (ownerElem instanceof Project) {
                context.setProject((Project)ownerElem);
            } else if (ownerElem instanceof Workspace) {
                context.setWorkspace((Workspace)ownerElem);
            } else {
                context.setElement(ownerElem);
            }
            View view = treeExplorer.owner();
            if (view instanceof ContentFilterCustomizer) {
                ContentFilterCustomizer prefs = (ContentFilterCustomizer)((Object)view);
                prefs.copyPreferencesTo(context);
            }
            return context;
        }
        return null;
    }

    private void getChildrenImpl(Context context) {
    }

    public TNode childrenAdded(UpdateMessage message, TNode parent, TreeExplorer tree) {
        ArrayList added = new ArrayList();
        added.addAll(message.getAddObjects());
        return this.childrenAddedRemoved(message, added, parent, tree, true);
    }

    public TNode childrenRemoved(UpdateMessage message, TNode parent, TreeExplorer tree) {
        ArrayList removed = new ArrayList();
        removed.addAll(message.getRemoveObjects());
        return this.childrenAddedRemoved(message, removed, parent, tree, false);
    }

    public void refresh(TNode[] nodes) {
        this.closeChildren();
    }

    public boolean canRefresh(TNode[] nodes) {
        return true;
    }

    public TNode update(TNode node, UpdateMessage change) {
        System.out.println("**** ContentFilter.update(..) not implemented.");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeChildren() {
        Object object = this._lock;
        synchronized (object) {
            this._children = null;
        }
    }

    private TNode childrenAddedRemoved(UpdateMessage message, List children, TNode parent, TreeExplorer tree, boolean added) {
        if (this._isProject) {
            this.refreshDirs(message, children, parent, tree, added);
        } else if (!this.callChildFilterHelpers(children, parent, tree, added)) {
            this.forceRefresh(parent);
        }
        return parent;
    }

    private void refreshDirs(UpdateMessage message, List children, TNode parent, TreeExplorer tree, boolean added) {
        int n;
        int messageID;
        if (!(added || (messageID = message.getMessageID()) != UpdateMessage.OBJECT_RENAMED && messageID != UpdateMessage.CHILD_RENAMED)) {
            for (Object nextObj : message.getModifyObjects()) {
                if (!(nextObj instanceof URL)) continue;
                children.add(new 1(this, nextObj));
            }
        }
        if ((n = children.size()) == 1) {
            Object child = children.get(0);
            if (child instanceof Locatable) {
                URL url = ((Locatable)child).getURL();
                URL dir = URLFileSystem.getParent((URL)url);
                this.refreshDir(dir, children, parent, tree, added);
            }
        } else if (n > 1) {
            HashMap dirToChildren = new HashMap();
            for (Object child : children) {
                if (!(child instanceof Locatable)) continue;
                URL childURL = ((Locatable)child).getURL();
                URL dirURL = URLFileSystem.getParent((URL)childURL);
                ArrayList mappedChildren = (ArrayList)dirToChildren.get(dirURL);
                if (mappedChildren == null) {
                    mappedChildren = new ArrayList();
                    dirToChildren.put(dirURL, mappedChildren);
                }
                mappedChildren.add(child);
            }
            for (Map.Entry entry : dirToChildren.entrySet()) {
                URL dirURL = (URL)entry.getKey();
                ArrayList childList = (ArrayList)entry.getValue();
                this.refreshDir(dirURL, childList, parent, tree, added);
            }
        }
    }

    private void refreshDir(URL dir, List children, TNode parent, TreeExplorer tree, boolean added) {
        TNode tnodeToRefresh = this.findExactDirTNode(dir, parent);
        if (tnodeToRefresh != null) {
            while (true) {
                TreeNode nextParent;
                Element elem;
                if ((elem = tnodeToRefresh.getData()) instanceof ContentLevelFolder) {
                    ContentLevelFolder clf = (ContentLevelFolder)elem;
                    clf.prepareRefresh();
                }
                tree.refresh(tnodeToRefresh);
                if (tnodeToRefresh.getChildCount() == 0 && (nextParent = tnodeToRefresh.getParent()) instanceof TNode) {
                    tnodeToRefresh = (TNode)nextParent;
                    continue;
                }
                break;
            }
        } else {
            this.callChildFilterHelpers(children, parent, tree, added);
        }
    }

    private boolean callChildFilterHelpers(List children, TNode parent, TreeExplorer tree, boolean added) {
        Context context = this.getContext();
        Object[] helpers = this._helpers.getItems();
        int n = helpers.length;
        int i = 0;
        while (i < n) {
            ChildFilterHelper helper = (ChildFilterHelper)helpers[i];
            try {
                if (added) {
                    if (helper.handleChildrenAdded(context, children, parent, tree)) {
                        this.forceRepaint(parent, tree);
                        boolean bl = true;
                        return bl;
                    }
                } else if (helper.handleChildrenRemoved(context, children, parent, tree)) {
                    this.forceRepaint(parent, tree);
                    boolean bl = true;
                    return bl;
                }
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                LOG.log(Level.SEVERE, "", t);
            }
            ++i;
        }
        return false;
    }

    private void forceRepaint(TNode tnode, TreeExplorer tree) {
        List expandedSet = ExplorerContext.storeExpansionState(tnode, tree);
        tree.collapse(tnode, false);
        tree.getTreeModel().reload(tnode);
        ExplorerContext.restoreExpansionState(tnode, tree, expandedSet);
    }

    private void forceRefresh(TNode tnode) {
        tnode.getOwner().refresh(tnode, this._type);
    }

    private TNode findExactDirTNode(URL dir, TNode parent) {
        if (parent.isSet(TNodeConstants.IS_OPENED)) {
            Enumeration iter = parent.getChildTNodes();
            while (iter.hasMoreElements()) {
                RelativeDirectoryContextFolder rdcf;
                URLPath rootDirs;
                String relPath;
                TNode child = (TNode)iter.nextElement();
                Element element = child.getData();
                if (!(element instanceof RelativeDirectoryContextFolder) || (relPath = (rootDirs = (rdcf = (RelativeDirectoryContextFolder)element).getRootDirectories()).toRelativePath(dir)) == null) continue;
                if (relPath.endsWith("/")) {
                    relPath = relPath.substring(0, relPath.length() - 1);
                }
                if (relPath.equals(rdcf.getRelativePath())) {
                    if (relPath.equals("")) {
                        return parent;
                    }
                    return child;
                }
                TNode recursiveResult = this.findExactDirTNode(dir, child);
                if (recursiveResult == null) continue;
                return recursiveResult;
            }
        }
        return null;
    }

    final class 1
    implements Locatable {
        private final /* synthetic */ Object v$nextObj;
        final /* synthetic */ ContentFilter this$0;

        public URL getURL() {
            return (URL)this.v$nextObj;
        }

        public void setURL(URL url) {
        }

        public 1(ContentFilter contentFilter, Object object) {
            this.v$nextObj = object;
            this.this$0 = contentFilter;
        }
    }
}

