/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.migration;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import oracle.ide.marshal.xml.Object2Dom;
import oracle.ide.marshal.xml.Object2DomLogger;
import oracle.ide.migration.Migrator;
import oracle.ide.net.URLFactory;
import oracle.ide.resource.IdeArb;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLParseException;
import org.xml.sax.SAXParseException;

public abstract class XMLMigrator
implements Migrator {
    private int[] categories;
    private boolean[] selections;
    private Object2Dom o2d;
    private MigrationLogger log;

    protected XMLMigrator(int[] categories) {
        this.categories = new int[categories.length];
        this.selections = new boolean[categories.length];
        System.arraycopy(categories, 0, this.categories, 0, categories.length);
        int i = 0;
        while (i < this.selections.length) {
            this.selections[i] = true;
            ++i;
        }
    }

    public final int[] getMigrationCategories() {
        return this.categories;
    }

    public void setSelected(int category, boolean selected) {
        int index = this.categoryToIndex(category);
        if (index >= 0) {
            this.selections[index] = selected;
        }
    }

    public final boolean isSelected(int category) {
        int index = this.categoryToIndex(category);
        if (index >= 0) {
            return this.selections[index];
        }
        return false;
    }

    public boolean canMigrate(int category, File sourceDir) {
        File file;
        return this.isValidCategory(category) && sourceDir != null && sourceDir.exists() && (file = new File(sourceDir, this.getFileName())) != null && file.exists() && file.canRead();
    }

    public String[] migrate(File sourceDir, File destDir) {
        if (!this.isAnyCategorySelected()) {
            return null;
        }
        try {
            this.prepareToMigrate();
            Object settings = this.readObject(sourceDir, destDir);
            Object object = settings = settings != null ? this.adjustObject(sourceDir, destDir, settings) : null;
            if (settings != null) {
                this.writeObject(sourceDir, destDir, settings);
            }
        }
        catch (Exception e) {
            this.getLogger().logOtherException(e);
        }
        return this.getLogger().getErrors();
    }

    protected abstract String getFileName();

    protected abstract String getNamespaceURI();

    protected abstract String getRootTag();

    protected final boolean isValidCategory(int category) {
        int i = 0;
        while (i < this.categories.length) {
            if (category == this.categories[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected final int categoryToIndex(int category) {
        int i = 0;
        while (i < this.categories.length) {
            if (this.categories[i] == category) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected final boolean isAnyCategorySelected() {
        int i = 0;
        while (i < this.selections.length) {
            if (this.selections[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void prepareToMigrate() {
    }

    protected Object readObject(File sourceDir, File destDir) throws Exception {
        File file = this.getSourceFile(sourceDir, destDir);
        URL url = URLFactory.newFileURL((File)file);
        return this.getObjectStore().toObject(url);
    }

    protected void writeObject(File sourceDir, File destDir, Object settings) throws Exception {
        File file = this.getDestFile(sourceDir, destDir);
        URL url = URLFactory.newFileURL((File)file);
        this.getObjectStore().setNamespaceURI(this.getNamespaceURI());
        this.getObjectStore().toDocument(settings, this.getRootTag(), url);
    }

    protected Object adjustObject(File sourceDir, File destDir, Object obj) throws Exception {
        return obj;
    }

    protected File getSourceFile(File sourceDir, File destDir) {
        return new File(sourceDir, this.getFileName());
    }

    protected File getDestFile(File sourceDir, File destDir) {
        return new File(destDir, this.getFileName());
    }

    protected final synchronized MigrationLogger getLogger() {
        if (this.log == null) {
            this.log = new MigrationLogger(this);
        }
        return this.log;
    }

    protected final synchronized Object2Dom getObjectStore() {
        if (this.o2d == null) {
            this.o2d = Object2Dom.newInstance();
            this.o2d.setLogger(2, (Object2DomLogger)this.getLogger());
        }
        return this.o2d;
    }

    static int[] ra$categories(XMLMigrator xMLMigrator) {
        return xMLMigrator.categories;
    }

    public static final class MigrationLogger
    implements Object2DomLogger {
        final ArrayList errors;
        final XMLMigrator migrator;

        private void $init$() {
            this.errors = new ArrayList();
        }

        public MigrationLogger(XMLMigrator migrator) {
            this.$init$();
            this.migrator = migrator;
        }

        private void logMessage(Throwable t, int line, int col) {
            this.logMessage(t.getLocalizedMessage(), line, col);
        }

        private void logMessage(String mesg, int line, int col) {
            if (this.errors.size() == 0) {
                StringBuffer categories = new StringBuffer();
                int i = 0;
                while (i < XMLMigrator.ra$categories(this.migrator).length) {
                    if (this.migrator.isSelected(XMLMigrator.ra$categories(this.migrator)[i])) {
                        if (categories.length() > 0) {
                            categories.append(", ");
                        }
                        categories.append(this.migrator.getDescription(XMLMigrator.ra$categories(this.migrator)[i]));
                    }
                    ++i;
                }
                this.errors.add(IdeArb.format(344, new String[]{categories.toString(), this.migrator.getFileName()}));
            }
            StringBuffer msg = new StringBuffer();
            if (mesg != null) {
                msg.append(mesg);
            }
            if (line >= 0) {
                msg.append(" ");
                msg.append(IdeArb.getString(192));
                msg.append(" ");
                msg.append(line);
                msg.append(".");
            }
            if (col >= 0) {
                msg.append(" ");
                msg.append(IdeArb.getString(199));
                msg.append(" ");
                msg.append(col);
                msg.append(".");
            }
            this.errors.add(msg.toString());
        }

        public String[] getErrors() {
            if (this.errors.size() == 0) {
                return null;
            }
            String[] result = new String[this.errors.size()];
            this.errors.toArray(result);
            return result;
        }

        public void logXMLParseException(XMLParseException e) {
            this.logMessage((Throwable)e, e.getLineNumber(), e.getColumnNumber());
        }

        public void logSAXParseException(SAXParseException e) {
            this.logMessage(e, e.getLineNumber(), e.getColumnNumber());
        }

        public void logUnmarshalException(int line, int col, Throwable t) {
            this.logMessage(t, line, col);
        }

        public void logOtherException(Throwable t) {
            this.logMessage(t, -1, -1);
        }

        public void logMessage(String mesg) {
        }

        public void logXMLDocument(XMLDocument document) {
        }

        public void logInformation(String info) {
            this.logMessage(info, -1, -1);
        }
    }
}

