/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.migration;

import java.awt.Component;
import java.io.IOException;
import java.net.URL;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.accessibility.Accessible;
import javax.naming.Context;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import oracle.ide.Ide;
import oracle.ide.Version;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.dialogs.ProgressBar;
import oracle.ide.log.LogManager;
import oracle.ide.log.LogPage;
import oracle.ide.migration.MigrationInfo;
import oracle.ide.migration.MigrationWizard;
import oracle.ide.migration.NodeMigratorHelper;
import oracle.ide.model.Node;
import oracle.ide.model.ProjectVersion;
import oracle.ide.net.NameGenerator;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.TraversableContext;
import oracle.ide.performance.PerformanceLogger;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.AccessibleUtils;
import oracle.ide.util.Namespace;
import oracle.ide.util.VersionNumber;
import oracle.javatools.compare.CompareUtils;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.jndi.Names;
import oracle.javatools.util.SwingUtils;

public abstract class NodeMigrator {
    public static final String MIGRATOR_MAP_DATA = "node-migrator-data";
    private static final String MIGRATOR_MSG_DATA = "node-migrator-errors";
    private static final Boolean BACKUPS_ENABLED = Boolean.getBoolean("ide.enable.NodeMigrator.backups");
    private List _helpers;
    private ProgressBar _progressBar;
    private TraversableContext _context;

    private void $init$() {
        this._helpers = new ArrayList();
    }

    public static NodeMigrator getNodeMigrator(String name) {
        return (NodeMigrator)Names.lookup((Context)Names.newInitialContext(), (String)name);
    }

    public static String getLookupKey(Node node) {
        return node.getClass().getName();
    }

    public abstract MigrationInfo getMigrationInfo(Node var1);

    public final MigrationInfo[] migrate(MigrationInfo[] infos) {
        this._context = new TraversableContext(new Namespace(), 1);
        int oldCompareUtilsLimit = CompareUtils.setLimit((int)0);
        try {
            this.preMigrate(infos, this._context);
            List pages = this.getPages(infos, this._context);
            MigrationInfo.MigrationStatus result = this.invokeWizard(this._context, pages, infos);
            if (result == MigrationInfo.MIGRATION_PENDING) {
                NodeMigrator.logTimestampedMessage(436);
                List infoList = null;
                try {
                    ArrayList msgs = new ArrayList();
                    this._context.putDesignTimeObject(MIGRATOR_MSG_DATA, msgs);
                    infoList = this.doMigration(this._context);
                    ArrayList<String> migrationFailed = new ArrayList<String>();
                    ArrayList<String> filesNotBackedUp = new ArrayList<String>();
                    ArrayList<String> migrationDoneButNotSaved = new ArrayList<String>();
                    ArrayList<String> migrationDone = new ArrayList<String>();
                    for (MigrationInfo info : infoList) {
                        Node node = info.getNode();
                        URL url = node.getURL();
                        String pathname = URLFileSystem.getPlatformPathName((URL)url);
                        MigrationInfo.MigrationStatus status = info.getMigrationStatus();
                        if (status == MigrationInfo.MIGRATION_DONE) {
                            migrationDone.add(pathname);
                        } else if (status == MigrationInfo.MIGRATION_DONE_BUT_NOT_SAVED) {
                            migrationDoneButNotSaved.add(pathname);
                            info.setMigrationStatus(MigrationInfo.MIGRATION_DONE);
                        } else {
                            migrationFailed.add(pathname);
                        }
                        if (!BACKUPS_ENABLED.booleanValue() || info.getBackupURL() != null) continue;
                        filesNotBackedUp.add(pathname);
                    }
                    NodeMigrator.emitMessages(migrationFailed, msgs, 299);
                    NodeMigrator.emitMessages(filesNotBackedUp, msgs, 84);
                    NodeMigrator.emitMessages(migrationDoneButNotSaved, msgs, 492);
                    NodeMigrator.emitMessages(migrationDone, msgs, 59);
                    this.displayMessages(msgs);
                }
                catch (Throwable t) {
                    NodeMigrator.logTimestampedMessage(172);
                    if (t instanceof ThreadDeath) {
                        throw (ThreadDeath)t;
                    }
                    t.printStackTrace();
                }
                MigrationInfo[] migrationInfoArray = infoList != null ? infoList.toArray(new MigrationInfo[infoList.size()]) : null;
                return migrationInfoArray;
            }
            MigrationInfo[] migrationInfoArray = infos;
            return migrationInfoArray;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            this.postMigrate(infos, this._context);
            CompareUtils.setLimit((int)oldCompareUtilsLimit);
            this._context = null;
        }
    }

    public TraversableContext getTraversableContext() {
        return this._context;
    }

    protected void preMigrate(MigrationInfo[] infos, TraversableContext context) {
    }

    protected void postMigrate(MigrationInfo[] infos, TraversableContext context) {
    }

    private static void emitMessages(ArrayList pathnames, ArrayList msgs, int resourceKey) {
        if (!pathnames.isEmpty()) {
            if (!msgs.isEmpty()) {
                msgs.add("");
            }
            msgs.add(IdeArb.getString(resourceKey));
            for (Object next : pathnames) {
                if (next == null) continue;
                msgs.add("      " + next.toString());
            }
        }
    }

    public MigrationInfo[] getMigrationInfos(Node[] nodes) {
        ArrayList<MigrationInfo> infos = new ArrayList<MigrationInfo>(nodes.length);
        int i = 0;
        int n = nodes.length;
        while (i < n) {
            infos.add(this.getMigrationInfo(nodes[i]));
            ++i;
        }
        return infos.toArray(new MigrationInfo[infos.size()]);
    }

    public List getPages(MigrationInfo[] infos, TraversableContext context) {
        Map map = this.getInfoToMigratorMap(context);
        int i = 0;
        int n = infos.length;
        while (i < n) {
            this.mapInfoToMigrator(this, infos[i], map);
            ++i;
        }
        HashSet<NodeMigratorHelper> allHelpersWhosePagesAreRelevant = new HashSet<NodeMigratorHelper>();
        ArrayList pages = new ArrayList();
        MigrationInfo[] migrationInfoArray = infos;
        int n2 = 0;
        while (n2 < migrationInfoArray.length) {
            NodeMigratorHelper[] helpers;
            MigrationInfo migrationInfo = migrationInfoArray[n2];
            NodeMigratorHelper[] nodeMigratorHelperArray = helpers = migrationInfo.getHelpers();
            int n3 = 0;
            while (n3 < nodeMigratorHelperArray.length) {
                NodeMigratorHelper helper = nodeMigratorHelperArray[n3];
                if (!allHelpersWhosePagesAreRelevant.contains(helper)) {
                    allHelpersWhosePagesAreRelevant.add(helper);
                    pages.addAll(helper.getPages(infos, context));
                }
                ++n3;
            }
            ++n2;
        }
        return pages;
    }

    public final MigrationInfo migrate(MigrationInfo info) {
        MigrationInfo[] infos = new MigrationInfo[]{info};
        this.migrate(infos);
        return infos[0];
    }

    public List doMigration(TraversableContext context) {
        ArrayList infoList = new ArrayList();
        1 runnable = new 1(this, context, infoList);
        this._progressBar = new ProgressBar((Component)((Object)Ide.getMainWindow()), IdeArb.getString(94), runnable, true);
        this._progressBar.setCancelable(false);
        this._progressBar.start(IdeArb.format(340, Version.NAME_SHORT, Version.VER), null);
        this._progressBar.waitUntilDone();
        this._progressBar = null;
        return infoList;
    }

    public List doMigration(List list, TraversableContext context) {
        MigrationInfo[] infos = list.toArray(new MigrationInfo[list.size()]);
        if (BACKUPS_ENABLED.booleanValue()) {
            this.backup(infos);
        }
        int i = 0;
        while (i < infos.length) {
            MigrationInfo info = infos[i];
            this.callHelpersMigrate(info, context);
            ++i;
        }
        return list;
    }

    protected void callHelpersMigrate(MigrationInfo info, TraversableContext context) {
        NodeMigratorHelper[] helpers = this.getHelpers(info);
        int j = 0;
        while (j < helpers.length) {
            NodeMigratorHelper helper = helpers[j];
            this.callHelperMigrate(helper, info, context);
            ++j;
        }
    }

    protected final void callHelperMigrate(NodeMigratorHelper helper, MigrationInfo info, TraversableContext context) {
        long start;
        long end = start = System.nanoTime();
        try {
            try {
                MigrationInfo[] infos = new MigrationInfo[]{info};
                helper.migrate(infos, context);
                end = System.nanoTime();
                Node node = info.getNode();
                if (node instanceof PropertyStorage) {
                    PropertyStorage project = (PropertyStorage)info.getNode();
                    ProjectVersion projectVersion = new ProjectVersion(project);
                    String helperKey = helper.getNodeMigratorHelperKey();
                    if (helperKey != null) {
                        String helperVersion = helper.getNodeMigratorHelperVersion();
                        projectVersion.addVersion(helperKey, new VersionNumber(helperVersion));
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        finally {
            PerformanceLogger.get().log("NodeMigratorHelper.migrate", helper.getClass().getName(), end - start);
        }
    }

    public final void addHelper(NodeMigratorHelper helper) {
        this._helpers.add(helper);
    }

    public final void removeHelper(NodeMigratorHelper helper) {
        this._helpers.remove(helper);
    }

    public MigrationInfo.MigrationStatus checkVersions(MigrationInfo[] infos) {
        int count = 0;
        int i = 0;
        int n = infos.length;
        while (i < n) {
            MigrationInfo.MigrationStatus status = infos[i].getMigrationStatus();
            if (status == MigrationInfo.MIGRATION_NOT_POSSIBLE) {
                URL url = infos[i].getNode().getURL();
                String msg = IdeArb.format(375, Version.NAME_SHORT, URLFileSystem.getPlatformPathName((URL)url), infos[i].getVersion());
                MessageDialog.error((Component)SwingUtils.getToplevelWindow(), (Object)msg, (String)IdeArb.getString(25), null);
                return status;
            }
            if (status == MigrationInfo.MIGRATION_NOT_NEEDED) {
                ++count;
            }
            ++i;
        }
        return count != infos.length ? MigrationInfo.MIGRATION_PENDING : MigrationInfo.MIGRATION_NOT_NEEDED;
    }

    protected abstract String getTitle();

    protected abstract String getMsg(MigrationInfo[] var1);

    protected abstract String getSummaryMsg(MigrationInfo[] var1);

    protected MigrationInfo.MigrationStatus invokeWizard(TraversableContext context, List pages, MigrationInfo[] infos) {
        MigrationInfo.MigrationStatus status = this.checkVersions(infos);
        if (status == MigrationInfo.MIGRATION_PENDING) {
            String summaryMsg;
            String welcomeMsg;
            String title = this.getTitle();
            boolean ok = MigrationWizard.runWizard(title, welcomeMsg = this.getMsg(infos), summaryMsg = this.getSummaryMsg(infos), context, pages);
            if (!ok) {
                status = MigrationInfo.MIGRATION_CANCELED;
            } else {
                boolean noMigrate;
                Boolean canceled = (Boolean)context.get("user-canceled-migration");
                boolean bl = noMigrate = canceled != null ? canceled : false;
                if (noMigrate) {
                    status = MigrationInfo.MIGRATION_CANCELED;
                }
            }
        }
        return status;
    }

    public NodeMigratorHelper[] getHelpers() {
        return this._helpers.toArray(new NodeMigratorHelper[this._helpers.size()]);
    }

    protected NodeMigratorHelper[] getHelpers(MigrationInfo info) {
        return this.getHelpers();
    }

    protected Map getInfoToMigratorMap(TraversableContext context) {
        HashMap map = (HashMap)context.find(MIGRATOR_MAP_DATA);
        if (map == null) {
            map = new HashMap();
            context.put(MIGRATOR_MAP_DATA, map);
        }
        return map;
    }

    protected void mapInfoToMigrator(NodeMigrator key, MigrationInfo info, Map map) {
        if (info.getMigrationStatus() == MigrationInfo.MIGRATION_PENDING) {
            ArrayList<MigrationInfo> infos = (ArrayList<MigrationInfo>)map.get(key);
            if (infos == null) {
                infos = new ArrayList<MigrationInfo>(1);
                map.put(key, infos);
            }
            if (!infos.contains(info)) {
                infos.add(info);
            }
        }
    }

    protected final void finishMigration(List infos) {
        int i = 0;
        int n = infos.size();
        while (i < n) {
            MigrationInfo info = (MigrationInfo)infos.get(i);
            if (info.getMigrationStatus() == MigrationInfo.MIGRATION_PENDING) {
                info.setMigrationStatus(MigrationInfo.MIGRATION_DONE_BUT_NOT_SAVED);
                if (!BACKUPS_ENABLED.booleanValue() || info.getBackupURL() != null) {
                    try {
                        Node node = info.getNode();
                        if (node.isDirty()) {
                            URL url = node.getURL();
                            if (!URLFileSystem.isReadOnly((URL)url) || URLFileSystem.setReadOnly((URL)url, (boolean)false)) {
                                node.save();
                                info.setMigrationStatus(MigrationInfo.MIGRATION_DONE);
                                node.close();
                            }
                        } else {
                            info.setMigrationStatus(MigrationInfo.MIGRATION_DONE);
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            ++i;
        }
    }

    private void backup(MigrationInfo[] infos) {
        int i = 0;
        int n = infos.length;
        while (i < n) {
            MigrationInfo info = infos[i];
            URL url = info.getNode().getURL();
            if (URLFileSystem.exists((URL)url)) {
                URL dir = URLFileSystem.getParent((URL)url);
                String fname = URLFileSystem.getName((URL)url);
                String ext = URLFileSystem.getSuffix((URL)url);
                BackupNameGenerator namegen = new BackupNameGenerator(fname, ext);
                URL backupURL = URLFactory.newUniqueURL((URL)dir, (NameGenerator)namegen);
                MigrationInfo.MigrationStatus oldStatus = this.updateStatus(info, MigrationInfo.MIGRATION_IO_ERROR);
                try {
                    URLFileSystem.copy((URL)url, (URL)backupURL);
                    info.setBackupURL(backupURL);
                }
                catch (IOException e) {
                    info.setBackupURL(null);
                }
                this.updateStatus(info, oldStatus);
            }
            ++i;
        }
    }

    private MigrationInfo.MigrationStatus updateStatus(MigrationInfo info, MigrationInfo.MigrationStatus newStatus) {
        MigrationInfo.MigrationStatus oldStatus = info.getMigrationStatus();
        info.setMigrationStatus(newStatus);
        return oldStatus;
    }

    private void displayMessages(ArrayList msgs) {
        Iterator i;
        Iterator iterator = i = msgs != null ? msgs.iterator() : null;
        if (i != null) {
            StringBuffer output = new StringBuffer();
            while (i.hasNext()) {
                output.append(i.next().toString());
                output.append("\n");
            }
            if (output.length() > 0) {
                LogPage logPage;
                String outputString = output.toString();
                LogManager logManager = LogManager.getLogManager();
                if (logManager != null && (logPage = logManager.getMsgPage()) != null) {
                    logPage.log(outputString);
                    NodeMigrator.logTimestampedMessage(252);
                }
                JMultiLineLabel jMultiLabel = new JMultiLineLabel(outputString);
                jMultiLabel.setAllowFocus(true);
                AccessibleUtils.updateAccessibleName((Accessible)((Object)jMultiLabel), (String)IdeArb.getString(94), (boolean)false);
                JScrollPane jScrollPane = new JScrollPane((Component)((Object)jMultiLabel));
                jScrollPane.setBorder(BorderFactory.createEmptyBorder());
                MessageDialog.information((Component)((Object)Ide.getMainWindow()), (Object)jScrollPane, (String)IdeArb.getString(94), null);
            }
        }
    }

    private static void logTimestampedMessage(int resourceKey) {
        LogPage logPage;
        LogManager logManager = LogManager.getLogManager();
        if (logManager != null && (logPage = logManager.getMsgPage()) != null) {
            logPage.log(IdeArb.format(resourceKey, NodeMigrator.getFormattedTimestamp()));
            logPage.log("\n");
        }
    }

    private static String getFormattedTimestamp() {
        DateFormat timeFormatter = DateFormat.getTimeInstance();
        return timeFormatter.format(new Date());
    }

    public NodeMigrator() {
        this.$init$();
    }

    static ProgressBar ra$_progressBar(NodeMigrator nodeMigrator) {
        return nodeMigrator._progressBar;
    }

    final class 1
    implements Runnable {
        private final /* synthetic */ TraversableContext v$context;
        private final /* synthetic */ List v$infoList;
        final /* synthetic */ NodeMigrator this$0;

        public void run() {
            try {
                Map map = this.this$0.getInfoToMigratorMap(this.v$context);
                for (NodeMigrator migrator : map.keySet()) {
                    this.v$infoList.addAll(migrator.doMigration((List)map.get(migrator), this.v$context));
                }
                this.this$0.finishMigration(this.v$infoList);
            }
            finally {
                NodeMigrator.ra$_progressBar(this.this$0).setDoneStatus();
            }
        }

        public 1(NodeMigrator nodeMigrator, TraversableContext traversableContext, List list) {
            this.v$infoList = list;
            this.v$context = traversableContext;
            this.this$0 = nodeMigrator;
        }
    }

    static class BackupNameGenerator
    implements NameGenerator {
        private static final String BAK = ".bak";
        private int _counter;
        private String _baseName;
        private String _extension;
        private String _nextName;

        private void $init$() {
            this._counter = 0;
        }

        public BackupNameGenerator(String baseName, String extension) {
            this.$init$();
            this._baseName = baseName;
            this._extension = extension;
            this._nextName = this._baseName + this._extension + BAK;
        }

        public String nextName() {
            String tmp = this._nextName;
            this._nextName = this._baseName + this._extension + "." + Integer.toString(this._counter++) + BAK;
            return tmp;
        }
    }
}

