/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.log;

import javax.swing.text.AttributeSet;

public class StyledMessage {
    private final AttributeSet _attributeSet;
    private String _text;
    private int _startOffset;
    private int _length;

    public StyledMessage(AttributeSet attributeSet, String text) {
        this._attributeSet = attributeSet;
        this._text = text;
        this._length = this._text.length();
    }

    public StyledMessage(AttributeSet attributeSet, int startOffset, int endOffset) {
        this._attributeSet = attributeSet;
        this._startOffset = startOffset;
        this._length = endOffset - startOffset;
    }

    public final String getText() {
        return this._text;
    }

    public final void clearText() {
        this._text = null;
    }

    public final AttributeSet getAttributes() {
        return this._attributeSet;
    }

    public final void setStartOffset(int startOffset) {
        this._startOffset = startOffset;
    }

    public final int getStartOffset() {
        return this._startOffset;
    }

    public final void setLength(int length) {
        this._length = length;
    }

    public final int getLength() {
        return this._length;
    }

    public final void setEndOffset(int endOffset) {
        this._length = endOffset - this._startOffset;
    }

    public final int getEndOffset() {
        return this._startOffset + this._length;
    }

    public final void updateOffsets(int delta) {
        this._startOffset += delta;
    }

    public String toString() {
        return this._text != null ? this._text : "";
    }
}

