/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.log;

import java.awt.Component;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleHyperlink;
import javax.accessibility.AccessibleHypertext;
import javax.accessibility.AccessibleText;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JEditorPane;
import javax.swing.JMenuItem;
import javax.swing.JScrollBar;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.MouseInputAdapter;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import javax.swing.text.StyledDocument;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.EnvironOptions;
import oracle.ide.config.Preferences;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controls.JAutoScrollPane;
import oracle.ide.controls.WaitCursor;
import oracle.ide.controls.WrappingTextPane;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.help.HelpInfo;
import oracle.ide.keyboard.KeyUtil;
import oracle.ide.layout.ViewId;
import oracle.ide.log.AbstractLogPage;
import oracle.ide.log.Href;
import oracle.ide.log.LogManager;
import oracle.ide.log.StyledMessage;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.resource.EnvironOptionsArb;
import oracle.ide.resource.LogArb;
import oracle.javatools.dialogs.MessageDialog;

public class MessagePage
extends AbstractLogPage {
    public static final String MESSAGE_PAGE_ID = "MessagePage";
    private static final SimpleDateFormat logDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
    private static final String NAME = LogArb.getString(4);
    private static URL _lastSaveToFileURL = null;
    private static final int WRAP_LOG_LINE_CMD_ID = Ide.findOrCreateCmdID("WRAP_LOG_LINE_CMD_ID");
    private static final char EOL = '\n';
    private final boolean _showStyledText;
    protected JTextComponent _textComponent;
    private int _lineCount;
    private int _deletedLines;
    protected JAutoScrollPane _scrollPane;
    private Timer _timer;
    private Controller _baseController;
    private PrintStream _diskLogFile;
    private String _diskLogFileName;
    private Object _lock;
    private StringBuffer _currentBuffer;
    private String _toAppend;
    private List _styles;
    private List _hrefs;
    private static Comparator _styleComparator = new 3();
    private Map _hrefsToHyperlink;

    public MessagePage() {
        this(new ViewId(MESSAGE_PAGE_ID, NAME));
    }

    protected MessagePage(ViewId viewId) {
        this(viewId, null);
    }

    protected MessagePage(ViewId viewId, Icon icon) {
        this(viewId, icon, true);
    }

    protected MessagePage(ViewId viewId, Icon icon, boolean addPage) {
        this(viewId, icon, addPage, false);
    }

    protected MessagePage(ViewId viewId, Icon icon, boolean addPage, boolean showStyledText) {
        super(viewId, icon, addPage);
        this.$init$();
        this._showStyledText = showStyledText;
        if (this._showStyledText && this._textComponent != null && !(this._textComponent instanceof WrappingTextPane)) {
            this.createTextComponent();
            this._scrollPane.setViewportView(this._textComponent);
        }
        this._timer = new Timer(250, new TimerListener(null));
        this._timer.setRepeats(false);
        this._baseController = new MessagePaneBaseController(null);
        ContextMenu cm = LogManager.getLogManager().getContextMenu();
        IdeAction action = IdeAction.get(WRAP_LOG_LINE_CMD_ID, null, LogArb.getString(7), null, LogArb.getInteger(27), LogArb.getIcon(3), null, true);
        action.putValue("Check", Boolean.TRUE);
        cm.addContextMenuListener(new 1());
    }

    private void saveToFile(Context context) {
        URL url;
        String title = LogArb.getString(34);
        URLChooser chooser = DialogUtil.newURLChooser(context);
        chooser.setHelpID("f1_idedsaveasrename_html");
        if (_lastSaveToFileURL != null) {
            chooser.setSelectedURL(_lastSaveToFileURL);
        }
        if (chooser.showSaveDialog((Component)((Object)Ide.getMainWindow()), title) == 0 && (url = chooser.getSelectedURL()) != null) {
            _lastSaveToFileURL = url;
            WaitCursor wc = Ide.getWaitCursor();
            wc.show();
            try {
                String encoding = EnvironOptions.getInstance(Preferences.getPreferences()).getEncoding();
                OutputStream os = URLFileSystem.openOutputStream((URL)url);
                PrintStream ps = encoding == null ? new PrintStream(os) : new PrintStream(os, false, encoding);
                int start = this._textComponent.getSelectionStart();
                int end = this._textComponent.getSelectionEnd();
                if (end - start > 0) {
                    String str = this._textComponent.getText(start, end - start);
                    ps.print(str);
                } else {
                    ps.print(this._textComponent.getText());
                }
                ps.flush();
                ps.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            wc.hide();
        }
    }

    public ContextMenu getContextMenu() {
        ContextMenu cm = LogManager.getLogManager().getContextMenu();
        return cm;
    }

    private void openLogFile() {
        String realName = this._diskLogFileName + "_" + logDateFormat.format(new Date()) + ".log";
        try {
            if (this._diskLogFile != null) {
                this._diskLogFile.close();
            }
            String encoding = EnvironOptions.getInstance(Preferences.getPreferences()).getEncoding();
            OutputStream os = URLFileSystem.openOutputStream((URL)URLFactory.newFileURL((String)realName));
            this._diskLogFile = encoding == null ? new PrintStream(os) : new PrintStream(os, false, encoding);
        }
        catch (IOException e) {
            this._diskLogFileName = null;
            MessageDialog.error((Component)((Object)Ide.getMainWindow()), (Object)EnvironOptionsArb.format(18, realName), (String)EnvironOptionsArb.getString(11), null);
        }
    }

    private void closeLogFile() {
        if (this._diskLogFile != null) {
            this._diskLogFile.close();
        }
        this._diskLogFile = null;
    }

    protected boolean checkLogOpen() {
        if (this._diskLogFileName == null) {
            return false;
        }
        if (this._diskLogFile == null) {
            this.openLogFile();
        }
        return this._diskLogFileName != null;
    }

    protected void setLogFileName(String fn) {
        if (!fn.equals(this._diskLogFileName)) {
            this.closeLogFile();
        }
        this._diskLogFileName = fn;
    }

    public void clearAll() {
        if (this._scrollPane == null) {
            return;
        }
        this.closeLogFile();
        this.clearTextComponent();
    }

    public void addMouseListener(MouseListener listener) {
        this.getGUI();
        this._textComponent.addMouseListener(listener);
    }

    public void removeMouseListener(MouseListener listener) {
        if (this._textComponent != null) {
            this._textComponent.removeMouseListener(listener);
        }
    }

    public Component getGUI() {
        if (this._scrollPane == null) {
            this.createTextComponent();
            this._scrollPane = new JAutoScrollPane(this._textComponent);
            this._scrollPane.setBorder(BorderFactory.createEmptyBorder());
            this._scrollPane.setOpaque(false);
            this._scrollPane.getViewport().setOpaque(false);
        }
        return this._scrollPane;
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_idelogwindowgen_html");
    }

    public Controller getController() {
        return this._baseController;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void logMsg(Object msg) {
        Object object = this._lock;
        synchronized (object) {
            if (msg instanceof StyledMessage) {
                StyledMessage styledMessage = (StyledMessage)msg;
                int startOffset = this.getTextLength();
                styledMessage.setStartOffset(startOffset);
                this.addStyle(styledMessage);
                msg = styledMessage.getText();
                styledMessage.clearText();
            }
            this._currentBuffer.append(msg);
        }
        if (!this._timer.isRunning()) {
            this._timer.start();
        }
    }

    private void createTextComponent() {
        if (!this._showStyledText) {
            MTextArea textArea = new MTextArea(null);
            textArea.setDocument(new PlainDocument());
            textArea.setEditable(false);
            textArea.setLineWrap(EnvironOptions.getInstance(Preferences.getPreferences()).isWrapLogLines());
            this._textComponent = textArea;
        } else {
            CustomTextPane textPane = this.createStyledTextPane();
            textPane.setDocument(new DefaultStyledDocument());
            textPane.setEditable(false);
            textPane.setLineWrap(EnvironOptions.getInstance(Preferences.getPreferences()).isWrapLogLines());
            2 mouseInputListener = new 2(this, textPane);
            textPane.addMouseListener(mouseInputListener);
            textPane.addMouseMotionListener(mouseInputListener);
            this._textComponent = textPane;
        }
        KeyUtil.removeCtrlTabFromTraversalKeys(this._textComponent);
        this._textComponent.setToolTipText(this.getToolTip());
        this._textComponent.setOpaque(false);
        Font oldFont = new JTextArea().getFont();
        this._textComponent.setFont(new Font("DialogInput", oldFont.getStyle(), oldFont.getSize()));
    }

    protected CustomTextPane createStyledTextPane() {
        return new CustomTextPane();
    }

    protected void updateToolTipText() {
        this._textComponent.setToolTipText(this.getToolTip());
    }

    protected boolean getWrapLines() {
        if (this._textComponent instanceof JTextArea) {
            JTextArea textArea = (JTextArea)this._textComponent;
            return textArea.getLineWrap();
        }
        WrappingTextPane textPane = (WrappingTextPane)this._textComponent;
        return textPane.getLineWrap();
    }

    protected void setWrapLines(boolean wrap) {
        if (this._textComponent instanceof JTextArea) {
            JTextArea textArea = (JTextArea)this._textComponent;
            textArea.setLineWrap(wrap);
            EnvironOptions.getInstance(Preferences.getPreferences()).setWrapLogLines(wrap);
        } else {
            WrappingTextPane textPane = (WrappingTextPane)this._textComponent;
            textPane.setLineWrap(wrap);
            EnvironOptions.getInstance(Preferences.getPreferences()).setWrapLogLines(wrap);
        }
    }

    protected final String getText() {
        try {
            Document document = this._textComponent.getDocument();
            int documentLength = document.getLength();
            String string = document.getText(0, documentLength);
            return string;
        }
        catch (BadLocationException badLocationException) {
            return this._textComponent.getText();
        }
    }

    protected void appendToTextComponent(String msg, int maxLogLines) {
        if (this._textComponent instanceof JTextArea) {
            JTextArea textArea = (JTextArea)this._textComponent;
            textArea.append(msg);
            this._lineCount = textArea.getLineCount();
            if (this._lineCount > maxLogLines) {
                try {
                    int linesToDelete = this._lineCount - maxLogLines;
                    int offset = textArea.getLineStartOffset(linesToDelete);
                    this.deleteFromStartOfTextComponent(linesToDelete, offset);
                }
                catch (BadLocationException e) {}
            }
        } else {
            WrappingTextPane textPane = (WrappingTextPane)this._textComponent;
            Document document = textPane.getDocument();
            int oldDocumentLength = document.getLength();
            try {
                document.insertString(oldDocumentLength, msg, null);
            }
            catch (BadLocationException e) {
                // empty catch block
            }
            if (msg.length() > 0) {
                if (oldDocumentLength == 0) {
                    ++this._lineCount;
                }
                int eol = msg.indexOf(10);
                while (eol != -1) {
                    ++this._lineCount;
                    eol = msg.indexOf(10, eol + 1);
                }
            }
            int newDocumentLength = document.getLength();
            this.setRecentAttributes(oldDocumentLength, newDocumentLength);
            if (this._lineCount > maxLogLines) {
                int linesToDelete = this._lineCount - maxLogLines;
                String text = this.getText();
                int length = text.length();
                int offset = 0;
                int count = 0;
                while (count < linesToDelete) {
                    if ((offset = text.indexOf(10, offset + 1)) == -1) {
                        offset = length;
                        break;
                    }
                    ++count;
                }
                this.deleteFromStartOfTextComponent(linesToDelete, ++offset);
            }
        }
        if (!msg.endsWith("\n")) {
            String text = this.getText();
            int caret = text.lastIndexOf(10) + 1;
            this._textComponent.setCaretPosition(caret);
        }
    }

    protected void deleteFromStartOfTextComponent(int linesToDelete, int offset) {
        if (this._textComponent instanceof JTextArea) {
            JTextArea textArea = (JTextArea)this._textComponent;
            try {
                textArea.replaceRange(null, 0, offset);
                this._lineCount = textArea.getLineCount();
                this._deletedLines += linesToDelete;
                if (this._deletedLines > 5000) {
                    this.replaceTextComponentDocument();
                }
            }
            catch (Exception e) {}
        } else {
            WrappingTextPane textPane = (WrappingTextPane)this._textComponent;
            try {
                Document document = textPane.getDocument();
                document.remove(0, offset);
                this._lineCount -= linesToDelete;
                this._deletedLines += linesToDelete;
                if (this._deletedLines > 5000) {
                    this.replaceTextComponentDocument();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        JScrollBar sb = this._scrollPane.getVerticalScrollBar();
        sb.setValue(sb.getMaximum());
        String text = this.getText();
        int caret = text.lastIndexOf(10) + 1;
        this._textComponent.setCaretPosition(caret);
        this.adjustAttributes(offset);
    }

    protected void replaceTextComponentDocument() {
        String text = this.getText();
        AbstractDocument document = this._textComponent instanceof JTextArea ? new PlainDocument() : new DefaultStyledDocument();
        this._textComponent.setDocument(document);
        this._textComponent.setText(text);
        this.replaceAttributes();
        this._deletedLines = 0;
    }

    protected void clearTextComponent() {
        this._textComponent.setText("");
        this._textComponent.setCaretPosition(0);
        this._lineCount = 0;
        this.clearAttributes();
    }

    public void addHref(Href href) {
        this.addStyle(href);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStyle(StyledMessage styledMessage) {
        Object object = this._lock;
        synchronized (object) {
            StyledMessage smBefore;
            int stBeforeEnd;
            int start = styledMessage.getStartOffset();
            int end = styledMessage.getEndOffset();
            int i = Collections.binarySearch(this._styles, styledMessage, _styleComparator);
            if (i < 0) {
                i = -i - 1;
            }
            if (i > 0 && (stBeforeEnd = (smBefore = (StyledMessage)this._styles.get(i - 1)).getEndOffset()) > start) {
                smBefore.setEndOffset(start);
                if (stBeforeEnd > end) {
                    this._styles.add(i, new StyledMessage(smBefore.getAttributes(), end, stBeforeEnd));
                }
            }
            while (i < this._styles.size() - 1) {
                boolean styleRemoved = false;
                StyledMessage smAtPoint = (StyledMessage)this._styles.get(i);
                int stAtPointStart = smAtPoint.getStartOffset();
                int stAtPointEnd = smAtPoint.getEndOffset();
                if (end > stAtPointStart) {
                    if (end > stAtPointEnd) {
                        this._styles.remove(i);
                        if (smAtPoint instanceof Href) {
                            this.removeHref((Href)smAtPoint);
                        }
                        styleRemoved = true;
                    } else {
                        smAtPoint.setStartOffset(end);
                    }
                }
                if (!styleRemoved) break;
            }
            this._styles.add(i, styledMessage);
            if (styledMessage instanceof Href) {
                i = Collections.binarySearch(this._hrefs, styledMessage, _styleComparator);
                if (i < 0) {
                    i = -i - 1;
                }
                this._hrefs.add(i, styledMessage);
            }
            this.setAttributes(styledMessage);
        }
    }

    private static JAutoScrollPane getJAutoScrollPane(Component comp) {
        Component c = comp;
        while (c != null && !(c instanceof JAutoScrollPane)) {
            c = c.getParent();
        }
        if (c instanceof JAutoScrollPane) {
            return (JAutoScrollPane)c;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRecentAttributes(int oldDocumentLength, int newDocumentLength) {
        Object object = this._lock;
        synchronized (object) {
            int i = this._styles.size() - 1;
            while (i >= 0) {
                StyledMessage styledMessage = (StyledMessage)this._styles.get(i);
                if (styledMessage.getStartOffset() < newDocumentLength) {
                    if (styledMessage.getEndOffset() < oldDocumentLength) break;
                    this.setAttributes(styledMessage);
                }
                --i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void adjustAttributes(int offset) {
        Object object = this._lock;
        synchronized (object) {
            int i = this._styles.size() - 1;
            while (i >= 0) {
                StyledMessage styledMessage = (StyledMessage)this._styles.get(i);
                if (styledMessage.getStartOffset() >= offset) {
                    styledMessage.updateOffsets(-offset);
                } else {
                    this._styles.remove(i);
                    if (styledMessage instanceof Href) {
                        this.removeHref((Href)styledMessage);
                    }
                }
                --i;
            }
        }
    }

    private void removeHref(Href href) {
        this._hrefs.remove(href);
        Hyperlink hyperlink = (Hyperlink)this._hrefsToHyperlink.remove(href);
        if (hyperlink != null) {
            hyperlink.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceAttributes() {
        Object object = this._lock;
        synchronized (object) {
            this.replaceAttributes(this._styles);
        }
    }

    private void replaceAttributes(List list) {
        int i = list.size() - 1;
        while (i >= 0) {
            StyledMessage styledMessage = (StyledMessage)list.get(i);
            this.setAttributes(styledMessage);
            --i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearAttributes() {
        Object object = this._lock;
        synchronized (object) {
            this._styles.clear();
            this._hrefs.clear();
            this._hrefsToHyperlink.clear();
        }
    }

    private void setAttributes(StyledMessage styledMessage) {
        Document document = this._textComponent.getDocument();
        if (document instanceof StyledDocument) {
            int docLength = document.getLength();
            int start = styledMessage.getStartOffset();
            if (start < docLength) {
                AttributeSet attributeSet;
                int end = styledMessage.getEndOffset();
                if (end > docLength) {
                    end = docLength;
                }
                if ((attributeSet = styledMessage.getAttributes()) != null) {
                    StyledDocument styledDocument = (StyledDocument)document;
                    styledDocument.setCharacterAttributes(start, end - start, attributeSet, true);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Href findHrefByOffset(int offset) {
        Object object = this._lock;
        synchronized (object) {
            Href href;
            Href href2;
            int i = Collections.binarySearch(this._hrefs, offset, _styleComparator);
            if (i < 0) {
                i = -i - 1;
            }
            if (i > 0 && offset >= (href2 = (Href)this._hrefs.get(i - 1)).getStartOffset() && offset < href2.getEndOffset()) {
                Href href3 = href2;
                return href3;
            }
            if (i < this._hrefs.size() && offset >= (href = (Href)this._hrefs.get(i)).getStartOffset() && offset < href.getEndOffset()) {
                Href href4 = href;
                return href4;
            }
        }
        return null;
    }

    private void $init$() {
        this._lock = new Object();
        this._currentBuffer = new StringBuffer();
        this._toAppend = null;
        this._styles = new ArrayList();
        this._hrefs = new ArrayList();
        this._hrefsToHyperlink = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getTextLength() {
        Object object = this._lock;
        synchronized (object) {
            int length = this._textComponent.getDocument().getLength();
            if (this._toAppend != null) {
                length += this._toAppend.length();
            }
            int n = length += this._currentBuffer.length();
            return n;
        }
    }

    static int ra$WRAP_LOG_LINE_CMD_ID() {
        return WRAP_LOG_LINE_CMD_ID;
    }

    static void mav$saveToFile(MessagePage messagePage, Context context) {
        messagePage.saveToFile(context);
    }

    static PrintStream ra$_diskLogFile(MessagePage messagePage) {
        return messagePage._diskLogFile;
    }

    static String ra$_toAppend(MessagePage messagePage) {
        return messagePage._toAppend;
    }

    static Object ra$_lock(MessagePage messagePage) {
        return messagePage._lock;
    }

    static void wa$_toAppend(MessagePage messagePage, String string) {
        messagePage._toAppend = string;
    }

    static StringBuffer ra$_currentBuffer(MessagePage messagePage) {
        return messagePage._currentBuffer;
    }

    static void wa$_currentBuffer(MessagePage messagePage, StringBuffer stringBuffer) {
        messagePage._currentBuffer = stringBuffer;
    }

    static JAutoScrollPane maS$getJAutoScrollPane(Component component) {
        return MessagePage.getJAutoScrollPane(component);
    }

    static List ra$_hrefs(MessagePage messagePage) {
        return messagePage._hrefs;
    }

    static Map ra$_hrefsToHyperlink(MessagePage messagePage) {
        return messagePage._hrefsToHyperlink;
    }

    final class 1
    implements ContextMenuListener {
        public void menuWillShow(ContextMenu popup) {
            Context ctxt;
            if (popup != null && (ctxt = popup.getContext()) != null && ctxt.getView() == MessagePage.this) {
                JMenuItem copyMenu = popup.createMenuItem(IdeAction.find(18), MenuConstants.WEIGHT_EDIT_COPY);
                JMenuItem selectAllMenu = popup.createMenuItem(IdeAction.find(22), MenuConstants.WEIGHT_EDIT_SELECT_ALL);
                JMenuItem wrapLines = popup.createMenuItem(IdeAction.find(MessagePage.ra$WRAP_LOG_LINE_CMD_ID()), 1.0f);
                JMenuItem saveAsMenu = popup.createMenuItem(IdeAction.find(12), MenuConstants.WEIGHT_LOG_WINDOW_SAVE_AS);
                popup.add((Component)copyMenu, MenuConstants.SECTION_EDIT_CTXT_MENU);
                popup.add((Component)selectAllMenu, MenuConstants.SECTION_EDIT_CTXT_MENU);
                popup.add((Component)wrapLines, MenuConstants.SECTION_LOG_WINDOW_CTXT_MENU);
                popup.add((Component)saveAsMenu, MenuConstants.SECTION_LOG_WINDOW_CTXT_MENU);
            }
        }

        public void menuWillHide(ContextMenu popup) {
        }

        public boolean handleDefaultAction(Context context) {
            return false;
        }
    }

    private class MessagePaneBaseController
    implements Controller {
        public boolean handleEvent(IdeAction action, Context context) {
            int cmdId = action.getCommandId();
            if (cmdId == 18) {
                if (MessagePage.this._textComponent != null) {
                    MessagePage.this._textComponent.copy();
                }
            } else if (cmdId == 22) {
                if (MessagePage.this._textComponent != null) {
                    MessagePage.this._textComponent.selectAll();
                    MessagePage.this._textComponent.copy();
                }
            } else if (cmdId == 12) {
                MessagePage.mav$saveToFile(MessagePage.this, context);
            } else if (cmdId == MessagePage.ra$WRAP_LOG_LINE_CMD_ID()) {
                MessagePage.this.setWrapLines(action.getState());
            } else {
                return false;
            }
            return true;
        }

        public boolean update(IdeAction action, Context context) {
            int cmdId = action.getCommandId();
            if (cmdId == 17) {
                action.setEnabled(false);
            } else if (cmdId == 18) {
                boolean enabled = false;
                if (MessagePage.this._textComponent != null) {
                    enabled = MessagePage.this._textComponent.getSelectionEnd() - MessagePage.this._textComponent.getSelectionStart() > 0;
                }
                action.setEnabled(enabled);
            } else if (cmdId == 22) {
                boolean enabled = MessagePage.this._textComponent != null && MessagePage.this._textComponent.getDocument().getLength() > 0;
                action.setEnabled(enabled);
            } else if (cmdId == 12) {
                boolean enabled = MessagePage.this._textComponent != null && MessagePage.this._textComponent.getDocument().getLength() > 0;
                action.setEnabled(enabled);
            } else if (cmdId == MessagePage.ra$WRAP_LOG_LINE_CMD_ID()) {
                action.setEnabled(true);
                action.setState(MessagePage.this.getWrapLines());
            } else {
                return false;
            }
            return true;
        }

        private MessagePaneBaseController() {
        }

        MessagePaneBaseController(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    final class 2
    extends MouseInputAdapter {
        private final /* synthetic */ WrappingTextPane v$textPane;
        final /* synthetic */ MessagePage this$0;

        public void mouseMoved(MouseEvent e) {
            Href href = null;
            try {
                int offset = this.v$textPane.getUI().viewToModel(this.v$textPane, e.getPoint());
                href = this.this$0.findHrefByOffset(offset);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (href != null) {
                this.v$textPane.setCursor(href.getCursor());
            } else {
                this.v$textPane.setCursor(null);
            }
        }

        public void mouseClicked(MouseEvent e) {
            try {
                int offset;
                Href href;
                if ((e.getModifiers() & 0x10) != 0 && e.getClickCount() == 1 && (href = this.this$0.findHrefByOffset(offset = this.v$textPane.getUI().viewToModel(this.v$textPane, e.getPoint()))) != null) {
                    href.go();
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }

        public 2(MessagePage messagePage, WrappingTextPane wrappingTextPane) {
            this.v$textPane = wrappingTextPane;
            this.this$0 = messagePage;
        }
    }

    private class Hyperlink
    extends AccessibleHyperlink {
        private Href _href;

        Hyperlink(Href href) {
            this._href = href;
        }

        void clear() {
            this._href = null;
        }

        public boolean isValid() {
            return this._href != null;
        }

        public int getAccessibleActionCount() {
            if (this._href != null) {
                return 1;
            }
            return 0;
        }

        public boolean doAccessibleAction(int i) {
            if (this._href != null && i == 0) {
                this._href.go();
                return true;
            }
            return false;
        }

        public String getAccessibleActionDescription(int i) {
            if (this._href != null && i == 0) {
                return this._href.getText();
            }
            return null;
        }

        public Object getAccessibleActionObject(int i) {
            if (this._href != null && i == 0) {
                return this._href.getURL();
            }
            return null;
        }

        public Object getAccessibleActionAnchor(int i) {
            if (this._href != null && i == 0) {
                return this._href.getText();
            }
            return null;
        }

        public int getStartIndex() {
            if (this._href != null) {
                return this._href.getStartOffset();
            }
            return 0;
        }

        public int getEndIndex() {
            if (this._href != null) {
                return this._href.getEndOffset();
            }
            return 0;
        }
    }

    static final class 3
    implements Comparator {
        public int compare(Object o1, Object o2) {
            return this.getSortValue(o1) - this.getSortValue(o2);
        }

        private int getSortValue(Object o) {
            if (o instanceof StyledMessage) {
                return ((StyledMessage)o).getStartOffset();
            }
            if (o instanceof Integer) {
                return (Integer)o;
            }
            return 0;
        }
    }

    private class TimerListener
    implements ActionListener,
    Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            Object object = MessagePage.ra$_lock(MessagePage.this);
            synchronized (object) {
                if (MessagePage.ra$_currentBuffer(MessagePage.this).length() != 0) {
                    MessagePage.wa$_toAppend(MessagePage.this, MessagePage.ra$_currentBuffer(MessagePage.this).toString());
                    if (MessagePage.ra$_currentBuffer(MessagePage.this).capacity() > 1024) {
                        MessagePage.wa$_currentBuffer(MessagePage.this, new StringBuffer(1024));
                    } else {
                        MessagePage.ra$_currentBuffer(MessagePage.this).delete(0, Integer.MAX_VALUE);
                    }
                }
                if (MessagePage.ra$_toAppend(MessagePage.this) != null) {
                    SwingUtilities.invokeLater(this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (MessagePage.this._scrollPane == null) {
                MessagePage.this.getGUI();
            }
            if (MessagePage.this.checkLogOpen()) {
                MessagePage.ra$_diskLogFile(MessagePage.this).print(MessagePage.ra$_toAppend(MessagePage.this));
            }
            Object object = MessagePage.ra$_lock(MessagePage.this);
            synchronized (object) {
                MessagePage.this.appendToTextComponent(MessagePage.ra$_toAppend(MessagePage.this), EnvironOptions.getInstance(Preferences.getPreferences()).getMaxLogLines());
                MessagePage.wa$_toAppend(MessagePage.this, null);
            }
        }

        private TimerListener() {
        }

        TimerListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    protected class CustomTextPane
    extends WrappingTextPane {
        private AccessibleContextWithHypertext a;

        private void $init$() {
            this.a = null;
        }

        public void scrollRectToVisible(Rectangle aRect) {
            JAutoScrollPane jautoScrollPane = MessagePage.maS$getJAutoScrollPane(this);
            if (jautoScrollPane == null || !jautoScrollPane.isAutoScrollDisabled()) {
                super.scrollRectToVisible(aRect);
            }
        }

        public AccessibleContext getAccessibleContext() {
            if (this.a == null) {
                this.a = new AccessibleContextWithHypertext();
            }
            return this.a;
        }

        protected CustomTextPane() {
            this.$init$();
        }

        class AccessibleContextWithHypertext
        extends JEditorPane.AccessibleJEditorPane
        implements AccessibleHypertext {
            public AccessibleText getAccessibleText() {
                return this;
            }

            public int getLinkCount() {
                return MessagePage.ra$_hrefs(MessagePage.this).size();
            }

            public AccessibleHyperlink getLink(int linkIndex) {
                Href href = (Href)MessagePage.ra$_hrefs(MessagePage.this).get(linkIndex);
                if (href != null) {
                    AccessibleHyperlink accessibleHyperlink = (AccessibleHyperlink)MessagePage.ra$_hrefsToHyperlink(MessagePage.this).get(href);
                    if (accessibleHyperlink == null) {
                        accessibleHyperlink = new Hyperlink(href);
                        MessagePage.ra$_hrefsToHyperlink(MessagePage.this).put(href, accessibleHyperlink);
                    }
                    return accessibleHyperlink;
                }
                return null;
            }

            public int getLinkIndex(int charIndex) {
                Href href = MessagePage.this.findHrefByOffset(charIndex);
                if (href != null) {
                    return MessagePage.ra$_hrefs(MessagePage.this).indexOf(href);
                }
                return -1;
            }

            AccessibleContextWithHypertext() {
                super(CustomTextPane.this);
            }
        }
    }

    private class MTextArea
    extends JTextArea {
        public void scrollRectToVisible(Rectangle aRect) {
            JAutoScrollPane jautoScrollPane = MessagePage.maS$getJAutoScrollPane(this);
            if (jautoScrollPane == null || !jautoScrollPane.isAutoScrollDisabled()) {
                super.scrollRectToVisible(aRect);
            }
        }

        private MTextArea() {
        }

        MTextArea(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

