/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.log;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import javax.accessibility.Accessible;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controls.WaitCursor;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.layout.ViewId;
import oracle.ide.log.AbstractLogPage;
import oracle.ide.log.LogManager;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFileSystem;
import oracle.ide.resource.IdeArb;
import oracle.ide.resource.LogArb;
import oracle.ide.util.AccessibleUtils;
import oracle.ide.util.BitField;

public class DefaultLogPage
extends AbstractLogPage {
    private static int _shift = 0;
    public static final int HIDE_NO_MENUS = 0;
    public static final int HIDE_COPY_MENU = 1 << _shift++;
    public static final int HIDE_SAVE_AS_MENU = 1 << _shift++;
    public static final int HIDE_GOTO_SOURCE_MENU = 1 << _shift++;
    public static final int HIDE_FIX_SOURCE_MENU = 1 << _shift++;
    public static final int HIDE_ALL_MENUS = HIDE_COPY_MENU | HIDE_SAVE_AS_MENU | HIDE_GOTO_SOURCE_MENU | HIDE_FIX_SOURCE_MENU;
    protected static final int GOTO_SOURCE_CMD_ID = Ide.findOrCreateCmdID("GOTO_SOURCE_CMD_ID");
    protected static final int FIX_SOURCE_CMD_ID = Ide.findOrCreateCmdID("FIX_SOURCE_CMD_ID");
    private static URL _lastSaveToFileURL = null;
    protected MouseAdapter mouseAdapter;
    protected KeyAdapter keyAdapter;
    private Controller _controller;
    private JMenuItem _copyMenu;
    private JMenuItem _saveAsMenu;
    private JMenuItem _gotoSourceMenu;
    private JMenuItem _fixSourceMenu;
    private boolean _popupMenuItemsInitialized;
    private JTree tree;
    private JTextArea textArea;
    private JScrollPane scrollPane;

    private void $init$() {
        this.mouseAdapter = new DefaultAdapter(null);
        this.keyAdapter = new DefaultKeyAdapter(null);
        this.textArea = new JTextArea();
    }

    protected DefaultLogPage(ViewId id, Icon icon, boolean addPage, int menuOptions) {
        super(id, icon, false);
        this.$init$();
        this.tree = this.getTree();
        this.scrollPane = new JScrollPane(this.tree);
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.initPopupMenuItems(menuOptions);
        this.textArea.setEditable(false);
        this.textArea.setToolTipText(this.getToolTip());
        this.tree.addMouseListener(this.mouseAdapter);
        this.tree.addKeyListener(this.keyAdapter);
        this.tree.setRootVisible(false);
        this.tree.setToolTipText(this.getToolTip());
        this.tree.getSelectionModel().setSelectionMode(1);
        ToolTipManager.sharedInstance().registerComponent(this.tree);
        if (addPage) {
            LogManager.getLogManager().addPage(this);
        }
    }

    protected DefaultLogPage(ViewId id, Icon icon, boolean addPage) {
        this(id, icon, false, HIDE_FIX_SOURCE_MENU);
    }

    protected void setModel(TreeModel model) {
        if (this.tree == null || model == null) {
            return;
        }
        this.tree.setModel(model);
        int rowCount = this.tree.getRowCount();
        if (rowCount > 0) {
            if (this.tree.isRootVisible()) {
                this.tree.setSelectionRow(0);
            } else if (rowCount > 1) {
                this.tree.setSelectionRow(1);
            }
        }
    }

    private void initPopupMenuItems(int options) {
        if (!this._popupMenuItemsInitialized) {
            this._popupMenuItemsInitialized = true;
            ContextMenu cm = LogManager.getLogManager().getContextMenu();
            IdeAction action = null;
            if (!BitField.isSet(options, HIDE_COPY_MENU)) {
                action = IdeAction.find(18);
                this._copyMenu = cm.createMenuItem(action, MenuConstants.WEIGHT_EDIT_COPY);
            }
            if (!BitField.isSet(options, HIDE_SAVE_AS_MENU)) {
                action = IdeAction.find(12);
                this._saveAsMenu = cm.createMenuItem(action, MenuConstants.WEIGHT_LOG_WINDOW_SAVE_AS);
            }
            if (!BitField.isSet(options, HIDE_GOTO_SOURCE_MENU)) {
                action = IdeAction.get(GOTO_SOURCE_CMD_ID, null, LogArb.getString(8), (String)null, LogArb.getInteger(25), LogArb.getInstance(), 30, null, true);
                this._gotoSourceMenu = cm.createMenuItem(action, MenuConstants.WEIGHT_NAVIGATE_GO_TO_CLASS);
                action.addController(this.getController());
            }
            if (!BitField.isSet(options, HIDE_FIX_SOURCE_MENU)) {
                action = IdeAction.get(FIX_SOURCE_CMD_ID, null, LogArb.getString(10), (String)null, LogArb.getInteger(0), LogArb.getInstance(), 29, null, true);
                this._fixSourceMenu = cm.createMenuItem(action);
                action.addController(this.getController());
            }
            if (action != null) {
                cm.addContextMenuListener(new PrivateContextMenuListener(null));
            }
        }
    }

    private Object getNextLeaf(int direction) {
        int pos = -1;
        if (this.tree.getSelectionPath() != null) {
            pos = this.tree.getRowForPath(this.tree.getSelectionPath());
        }
        while ((pos += direction) >= 0 && pos < this.tree.getRowCount()) {
            TreePath path = this.tree.getPathForRow(pos);
            Object lastPath = path.getLastPathComponent();
            if (!this.tree.getModel().isLeaf(lastPath)) continue;
            this.tree.setSelectionPath(path);
            return lastPath;
        }
        return null;
    }

    public String getTitleName() {
        String s = super.getTitleName();
        AccessibleUtils.updateAccessibleName((Accessible)this.getTree(), (String)s, (boolean)true);
        AccessibleUtils.updateAccessibleName((Accessible)this.getTextArea(), (String)s, (boolean)true);
        return s;
    }

    public Component getGUI() {
        return this.scrollPane;
    }

    protected final DefaultMutableTreeNode getSelectedTreeNode() {
        Object c;
        TreePath path = this.tree.getSelectionPath();
        if (path != null && (c = path.getLastPathComponent()) instanceof DefaultMutableTreeNode) {
            return (DefaultMutableTreeNode)c;
        }
        return null;
    }

    protected String treeNodeToString(Object treeNode) {
        return String.valueOf(treeNode);
    }

    private final void copy(Object treeNode) {
        StringSelection text = new StringSelection(this.treeNodeToString(treeNode));
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(text, null);
    }

    protected void saveToFile(Context context) {
        URL url;
        if (this.tree == null || this.tree.getRowCount() <= 0) {
            return;
        }
        String title = LogArb.getString(34);
        URLChooser chooser = DialogUtil.newURLChooser(context);
        chooser.setHelpID("f1_idedsaveasrename_html");
        if (_lastSaveToFileURL != null) {
            chooser.setSelectedURL(_lastSaveToFileURL);
        }
        if (chooser.showSaveDialog((Component)((Object)Ide.getMainWindow()), title) == 0 && (url = chooser.getSelectedURL()) != null) {
            _lastSaveToFileURL = url;
            WaitCursor wc = Ide.getWaitCursor();
            wc.show();
            try {
                String encoding = Ide.getEnvironOptions().getEncoding();
                OutputStream os = URLFileSystem.openOutputStream((URL)url);
                PrintStream ps = encoding == null ? new PrintStream(os) : new PrintStream(os, false, encoding);
                int firstPC = 0;
                int i = 0;
                while (i < this.tree.getRowCount()) {
                    TreePath path = this.tree.getPathForRow(i);
                    if (path != null) {
                        Object obj;
                        if (i == 0) {
                            firstPC = path.getPathCount();
                        }
                        if ((obj = path.getLastPathComponent()) != null) {
                            int spaceCount = (path.getPathCount() - firstPC) * 4;
                            int j = 0;
                            while (j < spaceCount) {
                                ps.print(" ");
                                ++j;
                            }
                            ps.println(this.treeNodeToString(obj));
                        }
                    }
                    ++i;
                }
                ps.flush();
                ps.close();
            }
            catch (Exception e) {
                String fileName = URLFileSystem.getPlatformPathName((URL)url);
                String msg = LogArb.format(2, fileName);
                JOptionPane.showMessageDialog((Component)((Object)Ide.getMainWindow()), msg, IdeArb.getString(170), 0);
            }
            wc.hide();
        }
    }

    public Controller getController() {
        if (this._controller == null) {
            this._controller = new DefaultLogPageController(null);
        }
        return this._controller;
    }

    public ContextMenu getContextMenu() {
        ContextMenu cm = LogManager.getLogManager().getContextMenu();
        return cm;
    }

    public void clearAll() {
        this.tree.setModel(null);
        this.textArea.setText("");
        this.textArea.setCaretPosition(this.textArea.getDocument().getLength());
        this.forceResizeNotification(this.textArea);
        this.forceResizeNotification(this.tree);
    }

    protected void forceResizeNotification(Component comp) {
        ComponentListener[] compListeners = comp.getComponentListeners();
        if (compListeners != null) {
            ComponentEvent ce = new ComponentEvent(this.textArea, 101);
            ComponentListener[] componentListenerArray = compListeners;
            int n = 0;
            while (n < componentListenerArray.length) {
                ComponentListener cl = componentListenerArray[n];
                cl.componentResized(ce);
                ++n;
            }
        }
    }

    public void addMouseListener(MouseListener listener) {
        if (listener != null) {
            this.textArea.addMouseListener(listener);
            this.tree.addMouseListener(listener);
        }
    }

    public void removeMouseListener(MouseListener listener) {
        if (listener != null) {
            this.tree.removeMouseListener(listener);
            this.textArea.removeMouseListener(listener);
        }
    }

    public void addKeyListener(KeyListener listener) {
        if (listener != null) {
            this.textArea.addKeyListener(listener);
            this.tree.addKeyListener(listener);
        }
    }

    public void removeKeyListener(KeyListener listener) {
        if (listener != null) {
            this.tree.removeKeyListener(listener);
            this.textArea.removeKeyListener(listener);
        }
    }

    protected void logMsg(Object msg) {
        if (msg instanceof Collection) {
            if (this.getCurrentView() != this.tree) {
                this.setCurrentView(this.tree);
            }
            this.updateTreeModel((Collection)msg);
        } else {
            this.logText(msg.toString());
        }
    }

    protected void logText(String msg) {
        if (this.getCurrentView() != this.textArea) {
            this.setCurrentView(this.textArea);
        }
        this.textArea.append(msg);
        this.textArea.setCaretPosition(this.textArea.getDocument().getLength());
    }

    protected final Component getCurrentView() {
        JViewport viewport = this.scrollPane.getViewport();
        return viewport != null ? viewport.getView() : null;
    }

    protected final void setCurrentView(Component view) {
        this.scrollPane.setViewportView(view);
    }

    protected JTree createTree() {
        1 tree = new 1(null);
        return tree;
    }

    protected final JTree getTree() {
        if (this.tree == null) {
            this.tree = this.createTree();
        }
        return this.tree;
    }

    protected final JTextArea getTextArea() {
        return this.textArea;
    }

    protected void activateObject(Object obj) {
    }

    protected void fixObject(Object obj) {
    }

    protected boolean canFixObject(DefaultMutableTreeNode node) {
        return false;
    }

    protected void updateTreeModel(Collection message) {
        try {
            SwingUtilities.invokeLater(new DefaultModelBuilder(message));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static JMenuItem ra$_gotoSourceMenu(DefaultLogPage defaultLogPage) {
        return defaultLogPage._gotoSourceMenu;
    }

    static JMenuItem ra$_fixSourceMenu(DefaultLogPage defaultLogPage) {
        return defaultLogPage._fixSourceMenu;
    }

    static JMenuItem ra$_copyMenu(DefaultLogPage defaultLogPage) {
        return defaultLogPage._copyMenu;
    }

    static JMenuItem ra$_saveAsMenu(DefaultLogPage defaultLogPage) {
        return defaultLogPage._saveAsMenu;
    }

    static JTree ra$tree(DefaultLogPage defaultLogPage) {
        return defaultLogPage.tree;
    }

    static Object mav$getNextLeaf(DefaultLogPage defaultLogPage, int n) {
        return defaultLogPage.getNextLeaf(n);
    }

    static void mav$copy(DefaultLogPage defaultLogPage, Object object) {
        defaultLogPage.copy(object);
    }

    private class PrivateContextMenuListener
    implements ContextMenuListener {
        public void menuWillShow(ContextMenu popup) {
            if (popup == null) {
                return;
            }
            Context ctxt = popup.getContext();
            if (ctxt == null || ctxt.getView() != DefaultLogPage.this) {
                return;
            }
            if (DefaultLogPage.ra$_gotoSourceMenu(DefaultLogPage.this) != null) {
                popup.add((Component)DefaultLogPage.ra$_gotoSourceMenu(DefaultLogPage.this), MenuConstants.SECTION_NAVIGATE_CTXT_MENU);
            }
            if (DefaultLogPage.ra$_fixSourceMenu(DefaultLogPage.this) != null) {
                popup.add((Component)DefaultLogPage.ra$_fixSourceMenu(DefaultLogPage.this), MenuConstants.SECTION_LOG_WINDOW_CTXT_MENU);
            }
            if (DefaultLogPage.ra$_copyMenu(DefaultLogPage.this) != null) {
                popup.add((Component)DefaultLogPage.ra$_copyMenu(DefaultLogPage.this), MenuConstants.SECTION_EDIT_CTXT_MENU);
            }
            if (DefaultLogPage.ra$_saveAsMenu(DefaultLogPage.this) != null) {
                popup.add((Component)DefaultLogPage.ra$_saveAsMenu(DefaultLogPage.this), MenuConstants.SECTION_LOG_WINDOW_CTXT_MENU);
            }
        }

        public void menuWillHide(ContextMenu popup) {
        }

        public boolean handleDefaultAction(Context context) {
            return false;
        }

        private PrivateContextMenuListener() {
        }

        PrivateContextMenuListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class DefaultLogPageController
    implements Controller {
        public boolean handleEvent(IdeAction action, Context context) {
            if (action != null) {
                int cmdId = action.getCommandId();
                if (cmdId == 30 || cmdId == 31) {
                    Object obj = DefaultLogPage.mav$getNextLeaf(DefaultLogPage.this, cmdId == 31 ? -1 : 1);
                    if (obj != null) {
                        DefaultLogPage.ra$tree(DefaultLogPage.this).scrollPathToVisible(DefaultLogPage.ra$tree(DefaultLogPage.this).getSelectionPath());
                        DefaultLogPage.this.activateObject(obj);
                    }
                    return true;
                }
                if (cmdId == 18 || cmdId == GOTO_SOURCE_CMD_ID || cmdId == FIX_SOURCE_CMD_ID) {
                    Object p;
                    TreePath path = DefaultLogPage.ra$tree(DefaultLogPage.this).getSelectionPath();
                    if (path != null && (p = path.getLastPathComponent()) != null) {
                        if (cmdId == GOTO_SOURCE_CMD_ID) {
                            DefaultLogPage.this.activateObject(p);
                        } else if (cmdId == FIX_SOURCE_CMD_ID) {
                            DefaultLogPage.this.fixObject(p);
                        } else {
                            DefaultLogPage.mav$copy(DefaultLogPage.this, p);
                        }
                    }
                    return true;
                }
                if (cmdId == 12) {
                    DefaultLogPage.this.saveToFile(context);
                    return true;
                }
            }
            return false;
        }

        public boolean update(IdeAction action, Context context) {
            if (action == null) {
                return true;
            }
            int cmdId = action.getCommandId();
            if (cmdId == 30 || cmdId == 31 || cmdId == 12) {
                action.setEnabled(DefaultLogPage.ra$tree(DefaultLogPage.this) != null && DefaultLogPage.ra$tree(DefaultLogPage.this).getRowCount() > 0);
                return true;
            }
            if (cmdId == 18) {
                TreePath path = DefaultLogPage.ra$tree(DefaultLogPage.this).getSelectionPath();
                action.setEnabled(path != null && path.getLastPathComponent() != null);
                return true;
            }
            if (cmdId == FIX_SOURCE_CMD_ID) {
                boolean enabled = false;
                DefaultMutableTreeNode tn = DefaultLogPage.this.getSelectedTreeNode();
                if (tn != null) {
                    enabled = !tn.isLeaf() ? false : DefaultLogPage.this.canFixObject(tn);
                }
                action.setEnabled(enabled);
                return true;
            }
            if (cmdId == GOTO_SOURCE_CMD_ID) {
                boolean enabled = false;
                DefaultMutableTreeNode tn = DefaultLogPage.this.getSelectedTreeNode();
                if (tn != null) {
                    enabled = tn.isLeaf();
                }
                action.setEnabled(enabled);
                return true;
            }
            return false;
        }

        private DefaultLogPageController() {
        }

        DefaultLogPageController(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    final class 1
    extends JTree {
        public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            return DefaultLogPage.this.treeNodeToString(value);
        }

        public 1(TreeModel treeModel) {
            super(treeModel);
        }
    }

    private final class DefaultAdapter
    extends MouseAdapter {
        public void mouseClicked(MouseEvent e) {
            if (e == null || e.getClickCount() != 2) {
                return;
            }
            TreePath path = DefaultLogPage.ra$tree(DefaultLogPage.this).getPathForLocation(e.getX(), e.getY());
            Object obj = path != null ? path.getLastPathComponent() : null;
            TreeModel model = DefaultLogPage.ra$tree(DefaultLogPage.this).getModel();
            if (obj != null && model != null && model.isLeaf(obj)) {
                DefaultLogPage.this.activateObject(obj);
            }
        }

        private DefaultAdapter() {
        }

        DefaultAdapter(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private final class DefaultKeyAdapter
    extends KeyAdapter {
        public void keyTyped(KeyEvent e) {
            if (e == null || e.isConsumed() || e.getKeyChar() != '\n') {
                return;
            }
            TreeModel model = DefaultLogPage.ra$tree(DefaultLogPage.this).getModel();
            Object obj = DefaultLogPage.ra$tree(DefaultLogPage.this).getLastSelectedPathComponent();
            if (obj != null && model != null && model.isLeaf(obj)) {
                DefaultLogPage.this.activateObject(obj);
            }
        }

        private DefaultKeyAdapter() {
        }

        DefaultKeyAdapter(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private final class DefaultModelBuilder
    implements Runnable {
        Collection message;

        DefaultModelBuilder(Collection message) {
            this.message = message;
        }

        public void run() {
            if (this.message == null) {
                DefaultLogPage.ra$tree(DefaultLogPage.this).setModel(null);
                return;
            }
            DefaultMutableTreeNode root = new DefaultMutableTreeNode();
            DefaultTreeModel model = new DefaultTreeModel(root);
            Iterator iter = this.message.iterator();
            while (iter.hasNext()) {
                DefaultMutableTreeNode node = new DefaultMutableTreeNode(iter.next());
                root.add(node);
            }
            DefaultLogPage.ra$tree(DefaultLogPage.this).setModel(model);
            int i = DefaultLogPage.ra$tree(DefaultLogPage.this).getRowCount() - 1;
            while (i >= 0) {
                DefaultLogPage.ra$tree(DefaultLogPage.this).expandRow(i);
                --i;
            }
        }
    }
}

