/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.layout;

import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.StringTokenizer;
import oracle.ide.net.URLFactory;

public final class URL2String {
    private static final String PART_DELIMETER = " ";
    private static final String NULL_PART = ";";

    private URL2String() {
    }

    public static String toString(URL url) {
        StringBuffer result = new StringBuffer();
        result.append(URL2String.encodeString(url.getProtocol()));
        result.append(PART_DELIMETER);
        result.append(URL2String.encodeString(url.getUserInfo()));
        result.append(PART_DELIMETER);
        result.append(URL2String.encodeString(url.getHost()));
        result.append(PART_DELIMETER);
        result.append(URL2String.encodeString(Integer.toString(url.getPort())));
        result.append(PART_DELIMETER);
        result.append(URL2String.encodeString(url.getPath()));
        result.append(PART_DELIMETER);
        result.append(URL2String.encodeString(url.getQuery()));
        result.append(PART_DELIMETER);
        result.append(URL2String.encodeString(url.getRef()));
        return result.toString();
    }

    public static URL toURL(String urlString) {
        StringTokenizer tokenizer = new StringTokenizer(urlString, PART_DELIMETER);
        String[] urlParts = new String[7];
        int index = 0;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token == null && index == 0) {
                return null;
            }
            urlParts[index++] = URL2String.decodeString(token);
        }
        URL url = URLFactory.newURL((String)urlParts[0], (String)urlParts[1], (String)urlParts[2], (int)URL2String.getIntValue(urlParts[3]), (String)urlParts[4], (String)urlParts[5], (String)urlParts[6]);
        return url;
    }

    private static int getIntValue(String intStr) {
        if (intStr == null || intStr.length() == 0) {
            return -1;
        }
        return Integer.parseInt(intStr);
    }

    private static String encodeString(String string) {
        if (string != null && string.length() > 0) {
            try {
                String string2 = URLEncoder.encode(string, "UTF-8");
                return string2;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return NULL_PART;
    }

    private static String decodeString(String string) {
        if (!string.equals(NULL_PART)) {
            try {
                String string2 = URLDecoder.decode(string, "UTF-8");
                return string2;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return null;
    }
}

