/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.keyboard;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.KeyStroke;
import javax.swing.event.EventListenerList;
import oracle.ide.keyboard.KeyStrokes;

final class KeyStrokeModel {
    private final ArrayList _ks;
    private final EventListenerList _listenerList;
    private ActionEvent _actionEvent;
    private static final int _nMaxKeySequence = 2;

    private void $init$() {
        this._ks = new ArrayList(2);
        this._listenerList = new EventListenerList();
        this._actionEvent = null;
    }

    public void addActionListener(ActionListener l) {
        this._listenerList.add(ActionListener.class, l);
    }

    public void removeActionListener(ActionListener l) {
        this._listenerList.remove(ActionListener.class, l);
    }

    protected void fireActionEvent() {
        Object[] listeners = this._listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == ActionListener.class) {
                if (this._actionEvent == null) {
                    this._actionEvent = new ActionEvent(this, 0, null);
                }
                ActionListener l = (ActionListener)listeners[i + 1];
                l.actionPerformed(this._actionEvent);
            }
            i -= 2;
        }
    }

    KeyStrokes getKeyStrokes() {
        switch (this._ks.size()) {
            case 0: {
                return new KeyStrokes();
            }
            case 1: {
                return new KeyStrokes(this.get(0));
            }
            case 2: {
                return new KeyStrokes(this.get(0), this.get(1));
            }
        }
        return null;
    }

    KeyStroke get(int i) {
        return (KeyStroke)this._ks.get(i);
    }

    KeyStroke top() {
        KeyStroke ks = null;
        int n = this.size();
        if (n != 0) {
            ks = this.get(n - 1);
        }
        return ks;
    }

    void add(KeyStroke ks) {
        this._ks.add(ks);
        this.fireActionEvent();
    }

    void pop() {
        int n = this._ks.size();
        if (n != 0) {
            this._ks.remove(n - 1);
            this.fireActionEvent();
        }
    }

    void clear() {
        this._ks.clear();
        this.fireActionEvent();
    }

    int size() {
        return this._ks.size();
    }

    boolean isEmpty() {
        return this._ks.isEmpty();
    }

    boolean authorizeNewKeys() {
        return this.size() < 2;
    }

    KeyStrokeModel() {
        this.$init$();
    }
}

