/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.keyboard;

import java.awt.event.KeyEvent;
import java.util.BitSet;
import javax.swing.KeyStroke;
import oracle.ide.keyboard.KeyUtil;

public final class KeyStrokeFilter {
    private final BitSet _bs;
    private KeyStroke _ks;
    private int _lastKeyCode;
    private int _lastMod;

    private void $init$() {
        this._bs = new BitSet();
    }

    public void clear() {
        this._bs.andNot(this._bs);
        this._ks = null;
        this._lastKeyCode = 0;
        this._lastMod = 0;
    }

    public boolean keyPressed(int nKeyCode, int nKeyMod) {
        boolean bRet = false;
        this._lastMod = nKeyMod;
        if (nKeyCode != 0) {
            if (!KeyUtil.isModifierKey(nKeyCode)) {
                this._ks = KeyStroke.getKeyStroke(nKeyCode, this._lastMod);
                this._lastKeyCode = nKeyCode;
                bRet = true;
            }
            this._bs.set(nKeyCode);
        }
        return bRet;
    }

    boolean isRepeat(KeyStroke ks) {
        int nKeyCode = ks.getKeyCode();
        boolean bIsDown = this._bs.get(nKeyCode);
        return bIsDown;
    }

    public void keyReleased(int nKeyCode, int nKeyMod) {
        this._lastMod = nKeyMod;
        this._bs.clear(nKeyCode);
        this._lastKeyCode = 0;
    }

    public boolean keyPressed(KeyEvent e) {
        return this.keyPressed(e.getKeyCode(), e.getModifiers());
    }

    public void keyReleased(KeyEvent e) {
        this.keyReleased(e.getKeyCode(), e.getModifiers());
    }

    public boolean keyStroke(KeyStroke ks) {
        if (ks.isOnKeyRelease()) {
            this.keyReleased(ks.getKeyCode(), ks.getModifiers());
            return false;
        }
        return this.keyPressed(ks.getKeyCode(), ks.getModifiers());
    }

    public KeyStroke getKeyStroke() {
        return this._ks;
    }

    boolean areAllKeysUp() {
        return this._bs.length() == 0;
    }

    public String toString(boolean bWithModifiers) {
        StringBuffer sb = null;
        if (bWithModifiers && this._lastMod != 0) {
            sb = new StringBuffer();
            sb.append(KeyEvent.getKeyModifiersText(this._lastMod));
            sb.append("+");
        }
        if (this._lastKeyCode != 0) {
            if (sb == null) {
                sb = new StringBuffer();
            }
            sb.append(KeyEvent.getKeyText(this._lastKeyCode));
        }
        return sb == null ? null : sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("[_bs=");
        int n = this._bs.length();
        int i = 0;
        while (i < n) {
            if (this._bs.get(i)) {
                sb.append(KeyEvent.getKeyText(i));
                sb.append(" ");
            }
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }

    public KeyStrokeFilter() {
        this.$init$();
    }
}

