/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.keyboard;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import oracle.ide.keyboard.KeyStrokeContext;
import oracle.ide.keyboard.ResKeystrokeContext;
import oracle.ide.keyboard.ResKeystrokeReader;
import oracle.ide.keyboard.XMLKeyStrokeContext;
import oracle.ide.keyboard.XMLKeystrokeContextDefs;
import oracle.ide.util.CollectionEvent;
import oracle.ide.util.CollectionListener;
import oracle.javatools.util.ModelUtil;
import org.xml.sax.SAXException;

public final class KeyStrokeContextRegistry {
    private final ArrayList _allContexts;
    private ArrayList _listeners;
    private ArrayList _resContexts;
    private boolean _acceleratorDefinitionFilesLoaded;

    private void $init$() {
        this._allContexts = new ArrayList();
        this._resContexts = new ArrayList(50);
        this._acceleratorDefinitionFilesLoaded = false;
    }

    public KeyStrokeContextRegistry() {
        this.$init$();
    }

    public void addListener(CollectionListener l) {
        if (this._listeners == null) {
            this._listeners = new ArrayList(1);
        }
        this._listeners.add(l);
    }

    public void removeListener(CollectionListener l) {
        this._listeners.remove(l);
    }

    private void fireEvent(int nID, KeyStrokeContext ksc) {
        if (this._listeners != null) {
            CollectionEvent e = null;
            int n = this._listeners.size();
            int i = 0;
            while (i < n) {
                CollectionListener l = (CollectionListener)this._listeners.get(i);
                if (e == null) {
                    e = new CollectionEvent(nID, this, ksc);
                }
                switch (nID) {
                    case 1: {
                        l.elementAdded(e);
                        break;
                    }
                    case 2: {
                        l.elementRemoved(e);
                        break;
                    }
                }
                ++i;
            }
        }
    }

    public void addContext(KeyStrokeContext ksc) {
        block1: {
            XMLKeyStrokeContext xmlKeyStrokeContext;
            String filename;
            if (this.isContextInAllContextList(ksc)) break block1;
            this._allContexts.add(ksc);
            if (ksc instanceof XMLKeyStrokeContext && (filename = (xmlKeyStrokeContext = (XMLKeyStrokeContext)ksc).getAcceleratorFile()) != null) {
                XMLKeystrokeContextDefs instance = XMLKeystrokeContextDefs.getInstance();
                Class<?> cls = xmlKeyStrokeContext.getClass();
                ClassLoader classLoader = cls.getClassLoader();
                instance.addAcceleratorFile(classLoader, filename);
            }
            this.fireEvent(1, ksc);
        }
    }

    public void removeContext(KeyStrokeContext ksc) {
        if (this._allContexts.contains(ksc)) {
            this._allContexts.remove(ksc);
            this.fireEvent(2, ksc);
        }
    }

    public void addAcceleratorDefinitionFile(ClassLoader classLoader, String fileName) {
        ResKeystrokeContext resKeystrokeContext = new ResKeystrokeContext(classLoader, fileName);
        this._resContexts.add(resKeystrokeContext);
        this.addContext(resKeystrokeContext);
        this._acceleratorDefinitionFilesLoaded = false;
    }

    public void removeAcceleratorDefinitionFile(ClassLoader classLoader, String fileName) {
        int i = this._resContexts.size() - 1;
        while (i >= 0) {
            ResKeystrokeContext resKeystrokeContext = (ResKeystrokeContext)this._resContexts.get(i);
            if (resKeystrokeContext.getClassLoader() == classLoader && ModelUtil.areEqual((Object)resKeystrokeContext.getName(), (Object)fileName)) {
                ResKeystrokeContext foundContext = (ResKeystrokeContext)this._resContexts.remove(i);
                this.removeContext(foundContext);
                return;
            }
            --i;
        }
    }

    void loadAcceleratorDefinitionFiles() {
        if (!this._acceleratorDefinitionFilesLoaded) {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(false);
            try {
                SAXParser saxParser = factory.newSAXParser();
                ResKeystrokeReader resKeystrokeReader = new ResKeystrokeReader(saxParser);
                int i = 0;
                while (i < this._resContexts.size()) {
                    ResKeystrokeContext resKeystrokeContext = (ResKeystrokeContext)this._resContexts.get(i);
                    resKeystrokeContext.load(resKeystrokeReader);
                    ++i;
                }
                this._acceleratorDefinitionFilesLoaded = true;
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
        }
    }

    public KeyStrokeContext getContext(String sName) {
        int n = this._allContexts.size();
        int i = 0;
        while (i < n) {
            KeyStrokeContext ksc = (KeyStrokeContext)this._allContexts.get(i);
            if (sName.equalsIgnoreCase(ksc.getName())) {
                return ksc;
            }
            ++i;
        }
        return null;
    }

    public Iterator getAllContexts() {
        return this._allContexts.iterator();
    }

    public Set getAllPresets() {
        HashSet<String> set = new HashSet<String>();
        int n = this._allContexts.size();
        int i = 0;
        while (i < n) {
            KeyStrokeContext ksc = (KeyStrokeContext)this._allContexts.get(i);
            List lKscPresets = ksc.getAllPresets();
            if (lKscPresets != null) {
                Iterator j = lKscPresets.iterator();
                while (j.hasNext()) {
                    String sPreset = j.next().toString();
                    set.add(sPreset);
                }
            }
            ++i;
        }
        return set;
    }

    static Object searchPreset(KeyStrokeContext ksc, String sName) {
        Object ret = null;
        List list = ksc.getAllPresets();
        if (list != null) {
            int n = list.size();
            int i = 0;
            while (ret == null && i < n) {
                Object o = list.get(i);
                if (o.equals(sName)) {
                    ret = o;
                }
                ++i;
            }
        }
        return ret;
    }

    private boolean isContextInAllContextList(KeyStrokeContext ksc) {
        if (this._allContexts != null) {
            String sKscName = ksc.getName();
            int n = this._allContexts.size();
            int i = 0;
            while (i < n) {
                KeyStrokeContext kscList = (KeyStrokeContext)this._allContexts.get(i);
                String sKscListName = kscList.getName();
                if (sKscName.equals(sKscListName)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }
}

