/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.help;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.URL;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Version;
import oracle.ide.config.EnvironOptions;
import oracle.ide.config.Preferences;
import oracle.ide.controls.MenuToolButton;
import oracle.ide.controls.ToggleAction;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.editor.EditorUtil;
import oracle.ide.help.AboutBoxModel;
import oracle.ide.help.AboutBoxPage;
import oracle.ide.help.HelpSystem;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFileSystem;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;

final class AboutBox
extends JPanel
implements Accessible {
    private JTabbedPane tabbedPane;
    private JLabel lblTitle;
    private Icon iconTitle;
    private JTextField lblVersion;
    private JTextField lblBuild;
    private JTextField lblCopyright;
    private MenuToolButton mtbExport;
    private AccessibleAboutBox aAboutBox;
    private Container _mainPanel;
    private AboutBoxModel _model;

    private void $init$() {
        this.tabbedPane = new JTabbedPane();
        this.lblTitle = new JLabel();
        this.lblVersion = new JTextField();
        this.lblBuild = new JTextField();
        this.lblCopyright = new JTextField();
    }

    AboutBox(AboutBoxModel model) {
        this.$init$();
        if (model == null) {
            throw new NullPointerException("Null about box model");
        }
        this.addControls();
        this.setModel(model);
        this.configureTextField(this.lblBuild);
        this.configureTextField(this.lblCopyright);
        this.configureTextField(this.lblVersion);
    }

    PageContainer addPage(AboutBoxPage page) {
        PageContainer pc = new PageContainer(page);
        this.tabbedPane.addTab(page.getName(), pc);
        return pc;
    }

    private void configureTextField(JTextField tf) {
        tf.setBorder(null);
        tf.setEditable(false);
        tf.setOpaque(false);
    }

    private void setModel(AboutBoxModel model) {
        this._model = model;
        this.lblVersion.setText(this.getVersionString());
        this.lblBuild.setText(this.getBuildString());
        this.lblCopyright.setText(this._model.getCopyrightMessage());
        this.iconTitle = this._model.getBannerImage();
        if (this.iconTitle != null) {
            this.lblTitle.setIcon(this.iconTitle);
        }
        this._mainPanel.validate();
    }

    private void addControls() {
        this.lblVersion.setFont(this.lblVersion.getFont().deriveFont(1));
        this.lblBuild.setFont(this.lblBuild.getFont().deriveFont(1));
        1 mainPage = new 1();
        mainPage.setComponent(this.createMainPanel());
        mainPage.setInitialFocus(null);
        mainPage.setName(IdeArb.getString(241));
        this.addPage(mainPage).selected();
        this.add((Component)this.tabbedPane, "Center");
        this.createExportDropDown();
        this.add(this.mtbExport);
        this.setComponentZOrder(this.mtbExport, 0);
        this.setComponentZOrder(this.tabbedPane, 1);
        this.tabbedPane.addChangeListener(new 2());
        HelpSystem helpSystem = HelpSystem.getHelpSystem();
        if (helpSystem != null) {
            helpSystem.registerTopic(this, "f1_helpaboutjdev_html");
        }
    }

    private void createExportDropDown() {
        3 action = new 3("", null);
        this.mtbExport = new MenuToolButton(action);
        this.mtbExport.setFocusable(true);
        this.mtbExport.setFocusPainted(true);
        4 save = new 4("", null);
        this.resToggleAction(save, 234);
        this.mtbExport.getPopupMenu().add(save);
        5 copy = new 5("", null);
        this.resToggleAction(copy, 464);
        this.mtbExport.getPopupMenu().add(copy);
        6 copyBuildToClipboard = new 6("", null);
        this.resToggleAction(copyBuildToClipboard, 394);
        this.mtbExport.getPopupMenu().add(copyBuildToClipboard);
        ResourceUtils.resButton((AbstractButton)this.mtbExport, (String)IdeArb.getString(222));
    }

    private void saveDataToFile() {
        this.forcePopulateAllPages();
        String data = this.dumpAll();
        URLChooser u = DialogUtil.newURLChooser();
        int result = u.showSaveDialog(this);
        if (result != 0) {
            return;
        }
        URL url = u.getSelectedURL();
        if (URLFileSystem.exists((URL)url) && !MessageDialog.confirm((Component)this, (Object)IdeArb.getString(232), (String)IdeArb.getString(259), null, (boolean)true)) {
            return;
        }
        OutputStreamWriter pw = null;
        try {
            try {
                pw = new OutputStreamWriter(URLFileSystem.openOutputStream((URL)url), "UTF-8");
                pw.write(data, 0, data.length());
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
        finally {
            if (pw != null) {
                try {
                    pw.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (URLFileSystem.exists((URL)url)) {
            EditorUtil.openDefaultEditorInFrame(url);
        }
    }

    private void copyToClipboard(String text) {
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(text), new 7());
    }

    private void saveBuildToClipboard() {
        String buildNumber = this._model.getBuildString();
        if (buildNumber == null) {
            return;
        }
        int lastSpace = buildNumber.lastIndexOf(" ");
        if (lastSpace >= 0 && lastSpace < buildNumber.length() - 1) {
            buildNumber = buildNumber.substring(lastSpace + 1);
        }
        this.copyToClipboard(buildNumber);
    }

    private void saveDataToClipboard() {
        this.forcePopulateAllPages();
        this.copyToClipboard(this.dumpAll());
    }

    private void forcePopulateAllPages() {
        int currentSelection = this.tabbedPane.getSelectedIndex();
        int i = 0;
        while (i < this.tabbedPane.getTabCount()) {
            Component c = this.tabbedPane.getComponent(i);
            if (c instanceof PageContainer) {
                ((PageContainer)c).selected();
            }
            ++i;
        }
        ((PageContainer)this.tabbedPane.getComponent(currentSelection)).selected();
    }

    private String dumpAll() {
        String lf = EnvironOptions.getInstance(Preferences.getPreferences()).getLineBreakSequence();
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < this.tabbedPane.getTabCount()) {
            String title = this.tabbedPane.getTitleAt(i);
            if (title == null) {
                title = "";
            }
            sb.append(title);
            sb.append(lf);
            int j = 0;
            while (j < title.length()) {
                sb.append('-');
                ++j;
            }
            sb.append(lf);
            sb.append(lf);
            PageContainer pc = (PageContainer)this.tabbedPane.getComponent(i);
            sb.append(PageContainer.ra$_page(pc).dump());
            sb.append(lf);
            ++i;
        }
        return sb.toString();
    }

    private void resToggleAction(ToggleAction a, int key) {
        String value = IdeArb.getString(key);
        a.putValue("Name", StringUtils.stripMnemonic((String)value));
        a.putValue("MnemonicKey", StringUtils.getMnemonicKeyCode((String)value));
    }

    private Component createMainPanel() {
        JPanel aboutPanel = new JPanel();
        aboutPanel.setLayout(new GridBagLayout());
        aboutPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.lblTitle.setHorizontalAlignment(0);
        this.lblVersion.setHorizontalAlignment(0);
        this.lblBuild.setHorizontalAlignment(0);
        this.lblCopyright.setHorizontalAlignment(0);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 2;
        gbc.anchor = 10;
        gbc.insets = new Insets(0, 0, 0, 0);
        aboutPanel.add((Component)this.lblTitle, gbc);
        ++gbc.gridy;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(0, 0, 5, 0);
        aboutPanel.add((Component)this.lblVersion, gbc);
        ++gbc.gridy;
        gbc.insets = new Insets(0, 0, 10, 0);
        aboutPanel.add((Component)this.lblBuild, gbc);
        ++gbc.gridy;
        aboutPanel.add((Component)this.lblCopyright, gbc);
        this._mainPanel = aboutPanel;
        return aboutPanel;
    }

    JComponent getInitialFocusedComponent() {
        return this.tabbedPane;
    }

    private final String getVersionString() {
        return this._model.getVersionString();
    }

    private final String getBuildString() {
        return this._model.getBuildString();
    }

    public AccessibleContext getAccessibleContext() {
        if (this.aAboutBox == null) {
            this.aAboutBox = new AccessibleAboutBox();
        }
        return this.aAboutBox;
    }

    public void doLayout() {
        super.doLayout();
        Insets i = this.getInsets();
        int w = this.getWidth() - (i.left + i.right);
        int h = this.getHeight() - (i.top + i.bottom);
        this.tabbedPane.setBounds(i.left, i.top, w, h);
        Dimension exportPs = this.mtbExport.getPreferredSize();
        this.mtbExport.setBounds(w - exportPs.width, i.top, exportPs.width, exportPs.height);
    }

    static void mav$saveDataToFile(AboutBox aboutBox) {
        aboutBox.saveDataToFile();
    }

    static void mav$saveDataToClipboard(AboutBox aboutBox) {
        aboutBox.saveDataToClipboard();
    }

    static void mav$saveBuildToClipboard(AboutBox aboutBox) {
        aboutBox.saveBuildToClipboard();
    }

    static AboutBoxModel ra$_model(AboutBox aboutBox) {
        return aboutBox._model;
    }

    static JTextField ra$lblVersion(AboutBox aboutBox) {
        return aboutBox.lblVersion;
    }

    static JTextField ra$lblBuild(AboutBox aboutBox) {
        return aboutBox.lblBuild;
    }

    static JTextField ra$lblCopyright(AboutBox aboutBox) {
        return aboutBox.lblCopyright;
    }

    static JTabbedPane ra$tabbedPane(AboutBox aboutBox) {
        return aboutBox.tabbedPane;
    }

    final class 1
    extends AboutBoxPage {
        protected void populate() {
        }

        public String dump() {
            StringBuilder sb = new StringBuilder();
            sb.append(AboutBox.ra$_model(AboutBox.this).getProductName() + " " + AboutBox.ra$_model(AboutBox.this).getProductVersion());
            sb.append('\n');
            sb.append(AboutBox.ra$lblVersion(AboutBox.this).getText());
            sb.append('\n');
            sb.append(AboutBox.ra$lblBuild(AboutBox.this).getText());
            sb.append('\n');
            sb.append(AboutBox.ra$lblCopyright(AboutBox.this).getText());
            sb.append('\n');
            sb.append("IDE Version: " + ExtensionRegistry.getExtensionRegistry().findExtension("oracle.ide").getVersion());
            if (Version.DEBUG_BUILD == 1) {
                sb.append(" (DEBUG BUILD)");
            }
            sb.append('\n');
            sb.append("Product ID: " + System.getProperty("ide.product"));
            sb.append('\n');
            sb.append("Product Version: " + ExtensionRegistry.getExtensionRegistry().findExtension(System.getProperty("ide.product")).getVersion());
            sb.append('\n');
            return sb.toString();
        }
    }

    final class 2
    implements ChangeListener {
        public void stateChanged(ChangeEvent e) {
            PageContainer container = (PageContainer)AboutBox.ra$tabbedPane(AboutBox.this).getSelectedComponent();
            container.selected();
            container.validate();
            Component c = container.getPage().getInitialFocus();
            if (c != null) {
                c.requestFocus();
            }
        }
    }

    final class 3
    extends ToggleAction {
        public void actionPerformed(ActionEvent e) {
        }

        public 3(String string, Icon icon) {
            super(string, icon);
        }
    }

    final class 4
    extends ToggleAction {
        public void actionPerformed(ActionEvent e) {
            AboutBox.mav$saveDataToFile(AboutBox.this);
        }

        public 4(String string, Icon icon) {
            super(string, icon);
        }
    }

    final class 5
    extends ToggleAction {
        public void actionPerformed(ActionEvent e) {
            AboutBox.mav$saveDataToClipboard(AboutBox.this);
        }

        public 5(String string, Icon icon) {
            super(string, icon);
        }
    }

    final class 6
    extends ToggleAction {
        public void actionPerformed(ActionEvent e) {
            AboutBox.mav$saveBuildToClipboard(AboutBox.this);
        }

        public 6(String string, Icon icon) {
            super(string, icon);
        }
    }

    final class 7
    implements ClipboardOwner {
        public void lostOwnership(Clipboard clipboard, Transferable contents) {
        }
    }

    protected class AccessibleAboutBox
    extends JPanel.AccessibleJPanel {
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.TABLE;
        }

        protected AccessibleAboutBox() {
            super(AboutBox.this);
        }
    }

    private static class PageContainer
    extends JPanel {
        private final AboutBoxPage _page;

        PageContainer(AboutBoxPage page) {
            this._page = page;
            this.setLayout(new BorderLayout());
        }

        void selected() {
            if (this.getComponentCount() == 0) {
                this.add(this._page.getComponent(), "Center");
                this._page.populate();
            }
        }

        AboutBoxPage getPage() {
            return this._page;
        }

        static AboutBoxPage ra$_page(PageContainer pageContainer) {
            return pageContainer._page;
        }
    }
}

