/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.explorer;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.WeakHashMap;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import oracle.ide.Ide;
import oracle.ide.IdeAdapter;
import oracle.ide.IdeEvent;
import oracle.ide.explorer.IconOverlay;
import oracle.ide.explorer.IconOverlayCache;
import oracle.ide.explorer.IconOverlayConsumer;
import oracle.ide.model.Element;
import oracle.javatools.util.NamedTimer;

public abstract class IconOverlayTracker {
    private static final long THREAD_DELAY_TIME = 500L;
    private final int _overlayBatchSize;
    private final Map<IconOverlayConsumer, NodeWatcher> _nodeWatchers;
    private final Map<IconOverlayConsumer, LinkedList> _pendingNodes;
    private final Map<Element, Object> _validOverlayElements;
    private final Object _timerLock;
    private Timer _timer;
    private TimerTask _updateTask;
    private IconOverlayCache _overlayCache;
    private ChangeListener _consumerChangeListener;
    private boolean _started;
    private boolean _exited;
    private IdeAdapter _ideListener;
    private final String _infoTypeId;
    private final ChangeListener _viewChangeListener;

    private void $init$() {
        this._nodeWatchers = new HashMap<IconOverlayConsumer, NodeWatcher>();
        this._pendingNodes = new HashMap<IconOverlayConsumer, LinkedList>();
        this._validOverlayElements = new WeakHashMap<Element, Object>();
        this._timerLock = new Object();
        this._viewChangeListener = new 1();
    }

    public IconOverlayTracker(String infoTypeId, IconOverlayCache cache) {
        this(infoTypeId, cache, 10);
    }

    public IconOverlayTracker(String infoTypeId, IconOverlayCache cache, int batchSize) {
        this.$init$();
        this._infoTypeId = infoTypeId;
        this._overlayCache = cache;
        this._overlayBatchSize = batchSize;
        this._consumerChangeListener = new 2();
        this._overlayCache.addConsumerChangeListener(this._consumerChangeListener);
        Iterator itr = this._overlayCache.getOverlayConsumers().iterator();
        while (itr.hasNext()) {
            this.registerOverlayConsumer((IconOverlayConsumer)itr.next());
        }
    }

    public IconOverlayCache getOverlayCache() {
        return this._overlayCache;
    }

    protected abstract boolean isControlled(Element var1);

    protected abstract IconOverlay[] getOverlays(Element[] var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Element[] getValidElements() {
        LinkedHashSet<Element> validElements = new LinkedHashSet<Element>();
        validElements.addAll(Arrays.asList(this._overlayCache.getElementKeys(this._infoTypeId)));
        Map<Element, Object> map = this._validOverlayElements;
        synchronized (map) {
            validElements.addAll(this._validOverlayElements.keySet());
        }
        return validElements.toArray(new Element[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerOverlayConsumer(IconOverlayConsumer consumer) {
        this.startTracking();
        Map<IconOverlayConsumer, NodeWatcher> map = this._nodeWatchers;
        synchronized (map) {
            if (this._nodeWatchers.containsKey(consumer)) {
                return;
            }
            NodeWatcher watcher = new NodeWatcher(consumer, null);
            NodeWatcher.mav$addVisibleNodeListener(watcher, this._viewChangeListener);
            this._nodeWatchers.put(consumer, watcher);
        }
        Map<IconOverlayConsumer, LinkedList> map2 = this._pendingNodes;
        synchronized (map2) {
            this._pendingNodes.put(consumer, null);
        }
        this.repaintConsumerOverlays(consumer, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deregisterOverlayConsumer(IconOverlayConsumer consumer) {
        this.startTracking();
        Map<IconOverlayConsumer, NodeWatcher> map = this._nodeWatchers;
        synchronized (map) {
            if (!this._nodeWatchers.containsKey(consumer)) {
                return;
            }
            NodeWatcher watcher = this._nodeWatchers.get(consumer);
            NodeWatcher.mav$removeVisibleNodeListener(watcher, this._viewChangeListener);
            this._nodeWatchers.remove(consumer);
            NodeWatcher.mav$performCleanup(watcher);
        }
        Map<IconOverlayConsumer, LinkedList> map2 = this._pendingNodes;
        synchronized (map2) {
            this._pendingNodes.remove(consumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateOverlay(Element e) {
        this.startTracking();
        Map<Element, Object> map = this._validOverlayElements;
        synchronized (map) {
            if (this.isControlled(e)) {
                this._validOverlayElements.remove(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateOverlays() {
        this.startTracking();
        Map<Element, Object> map = this._validOverlayElements;
        synchronized (map) {
            Element[] elementArray = this.getValidElements();
            int n = 0;
            while (n < elementArray.length) {
                Element e = elementArray[n];
                this.validateOverlay(e);
                ++n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repaintOverlays() {
        HashSet<IconOverlayConsumer> c;
        this.startTracking();
        Map<IconOverlayConsumer, NodeWatcher> map = this._nodeWatchers;
        synchronized (map) {
            c = new HashSet<IconOverlayConsumer>(this._nodeWatchers.keySet());
        }
        this.repaintConsumerOverlays(c, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopTracking() {
        if (!this._started) {
            return;
        }
        Ide.removeIdeListener(this._ideListener);
        this._overlayCache.removeConsumerChangeListener(this._consumerChangeListener);
        this._ideListener = null;
        Object object = this._timerLock;
        synchronized (object) {
            if (this._exited) {
                return;
            }
            this._exited = true;
        }
        3 task = new 3();
        Object object2 = this._timerLock;
        synchronized (object2) {
            this.getTimer().schedule((TimerTask)task, 0L);
        }
    }

    protected void startTracking() {
        if (this._started) {
            return;
        }
        this._started = true;
        this._ideListener = new 4();
        Ide.addIdeListener(this._ideListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void repaintConsumerOverlays(Collection consumers, long delay) {
        Map<IconOverlayConsumer, LinkedList> map = this._pendingNodes;
        synchronized (map) {
            Iterator itr = consumers.iterator();
            while (itr.hasNext()) {
                this.repaintConsumerOverlaysImpl((IconOverlayConsumer)itr.next());
            }
        }
        this.scheduleUpdateTask(delay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void repaintConsumerOverlays(IconOverlayConsumer consumer, long delay) {
        Map<IconOverlayConsumer, LinkedList> map = this._pendingNodes;
        synchronized (map) {
            this.repaintConsumerOverlaysImpl(consumer);
        }
        this.scheduleUpdateTask(delay);
    }

    private void repaintConsumerOverlaysImpl(IconOverlayConsumer consumer) {
        if (!this._pendingNodes.containsKey(consumer)) {
            return;
        }
        this._pendingNodes.put(consumer, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleUpdateTask(long delay) {
        Object object = this._timerLock;
        synchronized (object) {
            if (this._exited) {
                return;
            }
            if (this._updateTask != null) {
                this._updateTask.cancel();
            }
            this._updateTask = new 5();
            try {
                this.getTimer().schedule(this._updateTask, delay);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Timer getTimer() {
        Object object = this._timerLock;
        synchronized (object) {
            if (this._timer == null) {
                this._timer = new NamedTimer("IconOverlayTracker Timer");
            }
        }
        return this._timer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPendingNodes() {
        Collection nodes;
        while ((nodes = this.getPendingNodeBatch()) != null) {
            Map<Element, Object> map = this._validOverlayElements;
            synchronized (map) {
                for (Element e : nodes) {
                    this._validOverlayElements.put(e, null);
                }
            }
            List<IconOverlay> overlays = Arrays.asList(this.getOverlays(nodes.toArray(new Element[0])));
            EventQueue.invokeLater(new 6(this, nodes, overlays));
        }
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection getPendingNodeBatch() {
        IconOverlayConsumer _consumer;
        while ((_consumer = this.findPendingConsumer()) != null) {
            Map<IconOverlayConsumer, LinkedList> map = this._pendingNodes;
            synchronized (map) {
                List queue = this._pendingNodes.get(_consumer);
                if (queue != null) {
                    int n = Math.min(queue.size(), this._overlayBatchSize);
                    ArrayList nodes = new ArrayList(n);
                    int i = 0;
                    while (i < n) {
                        nodes.add(queue.remove(0));
                        ++i;
                    }
                    ArrayList arrayList = nodes;
                    return arrayList;
                }
            }
            this.updateQueue(_consumer);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final IconOverlayConsumer findPendingConsumer() {
        Map<IconOverlayConsumer, LinkedList> map = this._pendingNodes;
        synchronized (map) {
            for (IconOverlayConsumer o : this._pendingNodes.keySet()) {
                List queue = this._pendingNodes.get(o);
                if (queue != null && queue.size() <= 0) continue;
                IconOverlayConsumer iconOverlayConsumer = o;
                return iconOverlayConsumer;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void updateQueue(IconOverlayConsumer consumer) {
        Collection visible;
        Map<IconOverlayConsumer, NodeWatcher> map = this._nodeWatchers;
        synchronized (map) {
            if (!this._nodeWatchers.containsKey(consumer)) {
                return;
            }
            NodeWatcher watcher = this._nodeWatchers.get(consumer);
            visible = NodeWatcher.mav$getVisibleNodes(watcher);
        }
        LinkedList<Element> queue = new LinkedList<Element>();
        Map<Element, Object> map2 = this._validOverlayElements;
        synchronized (map2) {
            Iterator itr = visible.iterator();
            while (itr.hasNext()) {
                Element e = consumer.getElement(itr.next());
                if (e == null || !this.isControlled(e) || this._validOverlayElements.containsKey(e)) continue;
                queue.add(e);
            }
        }
        Map<IconOverlayConsumer, LinkedList> map3 = this._pendingNodes;
        synchronized (map3) {
            if (!this._pendingNodes.containsKey(consumer)) {
                return;
            }
            this._pendingNodes.put(consumer, queue);
        }
    }

    static boolean ra$_started(IconOverlayTracker iconOverlayTracker) {
        return iconOverlayTracker._started;
    }

    static Timer mav$getTimer(IconOverlayTracker iconOverlayTracker) {
        return iconOverlayTracker.getTimer();
    }

    static void mav$repaintConsumerOverlays(IconOverlayTracker iconOverlayTracker, IconOverlayConsumer iconOverlayConsumer, long l) {
        iconOverlayTracker.repaintConsumerOverlays(iconOverlayConsumer, l);
    }

    static String ra$_infoTypeId(IconOverlayTracker iconOverlayTracker) {
        return iconOverlayTracker._infoTypeId;
    }

    static void mav$processPendingNodes(IconOverlayTracker iconOverlayTracker) {
        iconOverlayTracker.processPendingNodes();
    }

    static Map ra$_nodeWatchers(IconOverlayTracker iconOverlayTracker) {
        return iconOverlayTracker._nodeWatchers;
    }

    static ChangeListener ra$_viewChangeListener(IconOverlayTracker iconOverlayTracker) {
        return iconOverlayTracker._viewChangeListener;
    }

    static Object ra$_timerLock(IconOverlayTracker iconOverlayTracker) {
        return iconOverlayTracker._timerLock;
    }

    static IconOverlayCache ra$_overlayCache(IconOverlayTracker iconOverlayTracker) {
        return iconOverlayTracker._overlayCache;
    }

    static void mav$registerOverlayConsumer(IconOverlayTracker iconOverlayTracker, IconOverlayConsumer iconOverlayConsumer) {
        iconOverlayTracker.registerOverlayConsumer(iconOverlayConsumer);
    }

    static void mav$deregisterOverlayConsumer(IconOverlayTracker iconOverlayTracker, IconOverlayConsumer iconOverlayConsumer) {
        iconOverlayTracker.deregisterOverlayConsumer(iconOverlayConsumer);
    }

    final class 1
    implements ChangeListener {
        public void stateChanged(ChangeEvent e) {
            IconOverlayTracker.mav$repaintConsumerOverlays(IconOverlayTracker.this, (IconOverlayConsumer)e.getSource(), 500L);
        }
    }

    final class 2
    implements ChangeListener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void stateChanged(ChangeEvent e) {
            Map map = IconOverlayTracker.ra$_nodeWatchers(IconOverlayTracker.this);
            synchronized (map) {
                HashSet<Object> c = new HashSet(IconOverlayTracker.ra$_overlayCache(IconOverlayTracker.this).getOverlayConsumers());
                c.removeAll(IconOverlayTracker.ra$_nodeWatchers(IconOverlayTracker.this).keySet());
                Iterator itr = c.iterator();
                while (itr.hasNext()) {
                    IconOverlayTracker.mav$registerOverlayConsumer(IconOverlayTracker.this, (IconOverlayConsumer)itr.next());
                }
                c = new HashSet(IconOverlayTracker.ra$_nodeWatchers(IconOverlayTracker.this).keySet());
                c.removeAll(IconOverlayTracker.ra$_overlayCache(IconOverlayTracker.this).getOverlayConsumers());
                Iterator itr2 = c.iterator();
                while (itr2.hasNext()) {
                    IconOverlayTracker.mav$deregisterOverlayConsumer(IconOverlayTracker.this, (IconOverlayConsumer)itr2.next());
                }
            }
        }
    }

    final class 3
    extends TimerTask {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Map map = IconOverlayTracker.ra$_nodeWatchers(IconOverlayTracker.this);
            synchronized (map) {
                for (NodeWatcher watcher : IconOverlayTracker.ra$_nodeWatchers(IconOverlayTracker.this).values()) {
                    NodeWatcher.mav$removeVisibleNodeListener(watcher, IconOverlayTracker.ra$_viewChangeListener(IconOverlayTracker.this));
                    NodeWatcher.mav$performCleanup(watcher);
                }
            }
            Object object = IconOverlayTracker.ra$_timerLock(IconOverlayTracker.this);
            synchronized (object) {
                IconOverlayTracker.mav$getTimer(IconOverlayTracker.this).cancel();
            }
            this.timerStopped();
        }

        private void timerStopped() {
            IconOverlayTracker.this.validateOverlays();
            EventQueue.invokeLater(new 1());
        }

        final class 1
        implements Runnable {
            public final void run() {
                IconOverlayCache cache = IconOverlayTracker.this.getOverlayCache();
                if (cache == null) {
                    return;
                }
                cache.clearOverlays(IconOverlayTracker.ra$_infoTypeId(IconOverlayTracker.this));
                cache.fireOverlaysChanged();
            }
        }
    }

    final class 4
    extends IdeAdapter {
        public void mainWindowClosing(IdeEvent e) {
            IconOverlayTracker.this.stopTracking();
            Ide.removeIdeListener(this);
        }
    }

    final class 5
    extends TimerTask {
        public void run() {
            try {
                IconOverlayTracker.mav$processPendingNodes(IconOverlayTracker.this);
            }
            catch (RuntimeException re) {
                re.printStackTrace();
            }
        }
    }

    final class 6
    implements Runnable {
        private final /* synthetic */ Collection v$nodes;
        private final /* synthetic */ Collection v$overlays;
        final /* synthetic */ IconOverlayTracker this$0;

        public final void run() {
            IconOverlayCache cache = this.this$0.getOverlayCache();
            if (cache == null) {
                return;
            }
            Iterator itr = this.v$nodes.iterator();
            Iterator itr2 = this.v$overlays.iterator();
            while (itr.hasNext()) {
                Element e = (Element)itr.next();
                IconOverlay overlay = (IconOverlay)itr2.next();
                if (e == null) continue;
                if (overlay == null) {
                    cache.removeOverlay(IconOverlayTracker.ra$_infoTypeId(this.this$0), e);
                    continue;
                }
                cache.putOverlay(IconOverlayTracker.ra$_infoTypeId(this.this$0), e, overlay);
            }
            cache.fireOverlaysChanged();
        }

        public 6(IconOverlayTracker iconOverlayTracker, Collection collection, Collection collection2) {
            this.v$overlays = collection2;
            this.v$nodes = collection;
            this.this$0 = iconOverlayTracker;
        }
    }

    private final class NodeWatcher {
        private final JTree _tree;
        private final Object _source;
        private final ChangeListener _scrollListener;
        private final TreeModelListener _modelListener;
        private final TreeExpansionListener _nodeListener;
        private final ParentListener _parentListener;
        private Collection _nodes;
        private Collection _listeners;
        private boolean _cleanup;

        private void $init$() {
            this._scrollListener = new ScrollPaneListener(null);
            this._modelListener = new NodeModelListener(null);
            this._nodeListener = new NodeUserListener(null);
            this._parentListener = new ParentListener(null);
            this._nodes = new ArrayList();
            this._listeners = new ArrayList();
        }

        private NodeWatcher(IconOverlayConsumer consumer) {
            this.$init$();
            this._tree = consumer.getJTree();
            this._source = consumer;
            this._tree.addAncestorListener(this._parentListener);
            if (this.isComponentVisible(this._tree)) {
                EventQueue.invokeLater(new 1());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addVisibleNodeListener(ChangeListener l) {
            Collection collection = this._listeners;
            synchronized (collection) {
                this._listeners.remove(l);
                this._listeners.add(l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeVisibleNodeListener(ChangeListener l) {
            Collection collection = this._listeners;
            synchronized (collection) {
                this._listeners.remove(l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Collection getVisibleNodes() {
            Collection collection = this._nodes;
            synchronized (collection) {
                ArrayList arrayList = new ArrayList(this._nodes);
                return arrayList;
            }
        }

        private void performCleanup() {
            this._cleanup = true;
            EventQueue.invokeLater(new 2());
        }

        private final void updateVisibleNodes() {
            if (!IconOverlayTracker.ra$_started(IconOverlayTracker.this)) {
                return;
            }
            this._updateVisibleNodes();
            IconOverlayTracker.mav$getTimer(IconOverlayTracker.this).schedule((TimerTask)new 3(), 500L);
        }

        private final void _updateVisibleNodes() {
            EventQueue.invokeLater(new 4());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void setVisibleNodes(Collection c) {
            Collection collection = this._nodes;
            synchronized (collection) {
                boolean changed = Arrays.equals(this._nodes.toArray(), c.toArray()) ^ true;
                this._nodes = c;
                if (!changed) {
                    return;
                }
            }
            ChangeEvent e = new ChangeEvent(this._source);
            ChangeListener[] l = null;
            Collection collection2 = this._listeners;
            synchronized (collection2) {
                l = this._listeners.toArray(new ChangeListener[0]);
            }
            int i = l.length - 1;
            while (i >= 0) {
                l[i].stateChanged(e);
                --i;
            }
        }

        private final void addInternalListeners() {
            if (this._cleanup) {
                return;
            }
            this.removeInternalListenersImpl();
            this.addInternalListenersImpl();
            this.updateVisibleNodes();
        }

        private final void removeInternalListeners() {
            this.removeInternalListenersImpl();
            this.setVisibleNodes(new ArrayList());
        }

        private final void addInternalListenersImpl() {
            this._tree.getModel().addTreeModelListener(this._modelListener);
            this._tree.addTreeExpansionListener(this._nodeListener);
            if (!(this._tree.getParent() instanceof JViewport)) {
                return;
            }
            JViewport viewport = (JViewport)this._tree.getParent();
            viewport.addChangeListener(this._scrollListener);
        }

        private final void removeInternalListenersImpl() {
            this._tree.getModel().removeTreeModelListener(this._modelListener);
            this._tree.removeTreeExpansionListener(this._nodeListener);
            if (!(this._tree.getParent() instanceof JViewport)) {
                return;
            }
            JViewport viewport = (JViewport)this._tree.getParent();
            viewport.removeChangeListener(this._scrollListener);
        }

        private final JTree getTree() {
            return this._tree;
        }

        private final boolean isComponentVisible(Component c) {
            while (c != null) {
                if (!c.isVisible()) {
                    return false;
                }
                if (c instanceof Window) {
                    return true;
                }
                c = c.getParent();
            }
            return false;
        }

        static Collection mav$getVisibleNodes(NodeWatcher nodeWatcher) {
            return nodeWatcher.getVisibleNodes();
        }

        static void mav$removeVisibleNodeListener(NodeWatcher nodeWatcher, ChangeListener changeListener) {
            nodeWatcher.removeVisibleNodeListener(changeListener);
        }

        static void mav$performCleanup(NodeWatcher nodeWatcher) {
            nodeWatcher.performCleanup();
        }

        NodeWatcher(IconOverlayConsumer iconOverlayConsumer, 4 var3_3) {
            this(iconOverlayConsumer);
        }

        static void mav$addVisibleNodeListener(NodeWatcher nodeWatcher, ChangeListener changeListener) {
            nodeWatcher.addVisibleNodeListener(changeListener);
        }

        static void mav$removeInternalListeners(NodeWatcher nodeWatcher) {
            nodeWatcher.removeInternalListeners();
        }

        static void mav$addInternalListeners(NodeWatcher nodeWatcher) {
            nodeWatcher.addInternalListeners();
        }

        static JTree mav$getTree(NodeWatcher nodeWatcher) {
            return nodeWatcher.getTree();
        }

        static void mav$updateVisibleNodes(NodeWatcher nodeWatcher) {
            nodeWatcher.updateVisibleNodes();
        }

        static JTree ra$_tree(NodeWatcher nodeWatcher) {
            return nodeWatcher._tree;
        }

        static void mav$setVisibleNodes(NodeWatcher nodeWatcher, Collection collection) {
            nodeWatcher.setVisibleNodes(collection);
        }

        static void mav$_updateVisibleNodes(NodeWatcher nodeWatcher) {
            nodeWatcher._updateVisibleNodes();
        }

        static ParentListener ra$_parentListener(NodeWatcher nodeWatcher) {
            return nodeWatcher._parentListener;
        }

        final class 1
        implements Runnable {
            public final void run() {
                NodeWatcher.mav$addInternalListeners(NodeWatcher.this);
            }
        }

        final class 2
        implements Runnable {
            public final void run() {
                NodeWatcher.ra$_tree(NodeWatcher.this).removeAncestorListener(NodeWatcher.ra$_parentListener(NodeWatcher.this));
                NodeWatcher.mav$removeInternalListeners(NodeWatcher.this);
            }
        }

        final class 3
        extends TimerTask {
            public void run() {
                NodeWatcher.mav$_updateVisibleNodes(NodeWatcher.this);
            }
        }

        final class 4
        implements Runnable {
            public final void run() {
                NodeWatcher.mav$setVisibleNodes(NodeWatcher.this, IconOverlayCache.getVisibleNodes(NodeWatcher.ra$_tree(NodeWatcher.this)));
            }
        }

        private final class ParentListener
        implements AncestorListener {
            public final void ancestorAdded(AncestorEvent e) {
                NodeWatcher.mav$removeInternalListeners(NodeWatcher.this);
                NodeWatcher.mav$addInternalListeners(NodeWatcher.this);
            }

            public final void ancestorMoved(AncestorEvent e) {
            }

            public final void ancestorRemoved(AncestorEvent e) {
                NodeWatcher.mav$removeInternalListeners(NodeWatcher.this);
            }

            private ParentListener() {
            }

            ParentListener(1 var2_2) {
                this();
            }

            public final class 1 {
            }
        }

        private final class ScrollPaneListener
        implements ChangeListener {
            private Rectangle _r;

            private void $init$() {
                this._r = null;
            }

            public final void stateChanged(ChangeEvent e) {
                Rectangle r = NodeWatcher.mav$getTree(NodeWatcher.this).getVisibleRect();
                if (this._r != null && r.equals(this._r)) {
                    return;
                }
                this._r = r;
                NodeWatcher.mav$updateVisibleNodes(NodeWatcher.this);
            }

            private ScrollPaneListener() {
                this.$init$();
            }

            ScrollPaneListener(1 var2_2) {
                this();
            }

            public final class 1 {
            }
        }

        private final class NodeModelListener
        implements TreeModelListener {
            public final void treeNodesChanged(TreeModelEvent e) {
            }

            public final void treeNodesInserted(TreeModelEvent e) {
                NodeWatcher.mav$updateVisibleNodes(NodeWatcher.this);
            }

            public final void treeNodesRemoved(TreeModelEvent e) {
                NodeWatcher.mav$updateVisibleNodes(NodeWatcher.this);
            }

            public final void treeStructureChanged(TreeModelEvent e) {
                NodeWatcher.mav$updateVisibleNodes(NodeWatcher.this);
            }

            private NodeModelListener() {
            }

            NodeModelListener(1 var2_2) {
                this();
            }

            public final class 1 {
            }
        }

        private final class NodeUserListener
        implements TreeExpansionListener {
            public final void treeCollapsed(TreeExpansionEvent event) {
                NodeWatcher.mav$updateVisibleNodes(NodeWatcher.this);
            }

            public final void treeExpanded(TreeExpansionEvent event) {
                NodeWatcher.mav$updateVisibleNodes(NodeWatcher.this);
            }

            private NodeUserListener() {
            }

            NodeUserListener(1 var2_2) {
                this();
            }

            public final class 1 {
            }
        }
    }
}

