/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.explorer;

import java.awt.EventQueue;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.ide.controls.OverlayIcon;
import oracle.ide.explorer.IconOverlay;
import oracle.ide.explorer.IconOverlayConsumer;
import oracle.ide.model.Displayable;
import oracle.ide.model.Element;

public class IconOverlayCache {
    private static IconOverlayCache _instance;
    private final Map _overlayCache;
    private final Map _dirtyOverlayElements;
    private final Set _overlayConsumers;
    private final Collection _consumerChangeListeners;

    private void $init$() {
        this._overlayCache = new WeakHashMap();
        this._dirtyOverlayElements = new WeakHashMap();
        this._overlayConsumers = new HashSet();
        this._consumerChangeListeners = new ArrayList();
    }

    public static final IconOverlayCache getInstance() {
        if (_instance == null) {
            _instance = new IconOverlayCache();
        }
        return _instance;
    }

    public void registerOverlayConsumer(IconOverlayConsumer consumer) {
        this._overlayConsumers.add(consumer);
        ChangeListener[] l = this._consumerChangeListeners.toArray(new ChangeListener[0]);
        if (l.length <= 0) {
            return;
        }
        ChangeEvent e = new ChangeEvent(this);
        int i = l.length - 1;
        while (i >= 0) {
            l[i].stateChanged(e);
            --i;
        }
    }

    public void deregisterOverlayConsumer(IconOverlayConsumer consumer) {
        this._overlayConsumers.remove(consumer);
        ChangeListener[] l = this._consumerChangeListeners.toArray(new ChangeListener[0]);
        if (l.length <= 0) {
            return;
        }
        ChangeEvent e = new ChangeEvent(this);
        int i = l.length - 1;
        while (i >= 0) {
            l[i].stateChanged(e);
            --i;
        }
    }

    public synchronized void fireOverlaysChanged() {
        EventQueue.invokeLater(new 1());
    }

    public synchronized void putOverlay(String infoTypeId, Element e, IconOverlay overlay) {
        OverlayItem item = (OverlayItem)this._overlayCache.get(e);
        if (item == null) {
            item = new OverlayItem(infoTypeId, overlay, null);
            this._overlayCache.put(e, item);
        } else {
            OverlayItem.mav$addOverlay(item, infoTypeId, overlay);
        }
        this._dirtyOverlayElements.put(e, null);
    }

    public synchronized IconOverlay getOverlay(String infoTypeId, Element e) {
        OverlayItem item = (OverlayItem)this._overlayCache.get(e);
        if (item != null) {
            return OverlayItem.mav$getOverlay(item, infoTypeId);
        }
        return null;
    }

    public synchronized void removeOverlay(String infoTypeId, Element e) {
        OverlayItem item = (OverlayItem)this._overlayCache.get(e);
        if (item != null) {
            OverlayItem.mav$removeOverlay(item, infoTypeId);
        }
        this._dirtyOverlayElements.put(e, null);
    }

    public synchronized void clearOverlays(String infoTypeId) {
        Iterator itr = this._overlayCache.keySet().iterator();
        while (itr.hasNext()) {
            this.removeOverlay(infoTypeId, (Element)itr.next());
        }
    }

    public synchronized Element[] getElementKeys(String infoTypeId) {
        return this._overlayCache.keySet().toArray(new Element[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Icon getRendererIcon(Element element, Icon baseObject) {
        if (baseObject == null) {
            return baseObject;
        }
        OverlayItem item = this.getOverlayItem(element);
        if (item == null) {
            return baseObject;
        }
        OverlayItem overlayItem = item;
        synchronized (overlayItem) {
            Icon icon = OverlayItem.mav$getOverlayIcon(item, baseObject);
            return icon;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRendererToolTipText(Element element, String baseObject) {
        OverlayItem item = this.getOverlayItem(element);
        if (item == null) {
            return baseObject;
        }
        OverlayItem overlayItem = item;
        synchronized (overlayItem) {
            if (!OverlayItem.mav$hasOverlay(item)) {
                String string = baseObject;
                return string;
            }
            StringBuffer tipBuffer = new StringBuffer();
            tipBuffer.append("<html><p>");
            tipBuffer.append(baseObject);
            Iterator i = OverlayItem.mav$getOverlays(item);
            while (i.hasNext()) {
                String tip;
                Displayable displayable;
                IconOverlay overlay = (IconOverlay)i.next();
                if (overlay == null || (displayable = overlay.getDisplayable()) == null || (tip = displayable.getToolTipText()) == null) continue;
                tipBuffer.append("<br>");
                tipBuffer.append(tip);
            }
            tipBuffer.append("</p></html>");
            String string = tipBuffer.toString();
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRendererShortLabel(Element element, String baseObject) {
        OverlayItem item = this.getOverlayItem(element);
        if (item == null) {
            return baseObject;
        }
        OverlayItem overlayItem = item;
        synchronized (overlayItem) {
            if (!OverlayItem.mav$hasOverlay(item)) {
                String string = baseObject;
                return string;
            }
            StringBuffer labelBuffer = new StringBuffer();
            labelBuffer.append(baseObject);
            Iterator i = OverlayItem.mav$getOverlays(item);
            while (i.hasNext()) {
                String label;
                Displayable displayable;
                IconOverlay overlay = (IconOverlay)i.next();
                if (overlay == null || (displayable = overlay.getDisplayable()) == null || (label = displayable.getShortLabel()) == null) continue;
                labelBuffer.append(" ");
                labelBuffer.append(label);
            }
            String string = labelBuffer.toString();
            return string;
        }
    }

    void addConsumerChangeListener(ChangeListener l) {
        this._consumerChangeListeners.add(l);
    }

    void removeConsumerChangeListener(ChangeListener l) {
        this._consumerChangeListeners.remove(l);
    }

    Set getOverlayConsumers() {
        return Collections.unmodifiableSet(this._overlayConsumers);
    }

    static final Collection getVisibleNodes(JTree tree) {
        ArrayList<Object> c = new ArrayList<Object>();
        Object root = tree.getModel().getRoot();
        if (root instanceof TreeNode) {
            c.add(root);
        }
        Rectangle r = tree.getVisibleRect();
        int firstVisibleRow = tree.getClosestRowForLocation(r.x, r.y);
        if (firstVisibleRow != -1) {
            int lastVisibleRow = tree.getClosestRowForLocation(r.x, r.y + r.height);
            if (lastVisibleRow == -1) {
                lastVisibleRow = firstVisibleRow;
            }
            int row = firstVisibleRow;
            while (row <= lastVisibleRow) {
                TreePath path = tree.getPathForRow(row);
                if (path != null) {
                    c.add(path.getLastPathComponent());
                }
                ++row;
            }
        }
        return c;
    }

    private void fireOverlaysChanged(IconOverlayConsumer consumer) {
        JTree tree = consumer.getJTree();
        if (!(tree.getModel() instanceof DefaultTreeModel)) {
            return;
        }
        DefaultTreeModel treeModel = (DefaultTreeModel)tree.getModel();
        for (TreeNode treeNode : IconOverlayCache.getVisibleNodes(tree)) {
            Element e = consumer.getElement(treeNode);
            if (e == null || !this._dirtyOverlayElements.containsKey(e)) continue;
            treeModel.nodeChanged(treeNode);
        }
    }

    private OverlayItem getOverlayItem(Element e) {
        return e != null ? (OverlayItem)this._overlayCache.get(e) : null;
    }

    public IconOverlayCache() {
        this.$init$();
    }

    static Set ra$_overlayConsumers(IconOverlayCache iconOverlayCache) {
        return iconOverlayCache._overlayConsumers;
    }

    static void mav$fireOverlaysChanged(IconOverlayCache iconOverlayCache, IconOverlayConsumer iconOverlayConsumer) {
        iconOverlayCache.fireOverlaysChanged(iconOverlayConsumer);
    }

    static Map ra$_dirtyOverlayElements(IconOverlayCache iconOverlayCache) {
        return iconOverlayCache._dirtyOverlayElements;
    }

    final class 1
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void run() {
            Iterator itr = IconOverlayCache.ra$_overlayConsumers(IconOverlayCache.this).iterator();
            while (itr.hasNext()) {
                IconOverlayCache.mav$fireOverlaysChanged(IconOverlayCache.this, (IconOverlayConsumer)itr.next());
            }
            IconOverlayCache iconOverlayCache = IconOverlayCache.this;
            synchronized (iconOverlayCache) {
                IconOverlayCache.ra$_dirtyOverlayElements(IconOverlayCache.this).clear();
            }
        }
    }

    private static final class OverlayItem {
        private LinkedHashMap _overlays = new LinkedHashMap();
        private Icon _baseIcon;
        private Icon _icon;

        private OverlayItem(String typeId, IconOverlay overlay) {
            this.addOverlay(typeId, overlay);
        }

        private synchronized void addOverlay(String typeId, IconOverlay overlay) {
            if (this._overlays == null) {
                this._overlays = new LinkedHashMap();
            }
            this._overlays.put(typeId, overlay);
            this._icon = null;
        }

        private synchronized void removeOverlay(String typeId) {
            if (this._overlays != null) {
                this._overlays.remove(typeId);
                if (this._overlays.isEmpty()) {
                    this._overlays = null;
                }
            }
            this._icon = null;
        }

        private synchronized Icon getOverlayIcon(Icon baseIcon) {
            if (this._overlays == null || this._overlays.isEmpty()) {
                return baseIcon;
            }
            if (this._icon == null || baseIcon != this._baseIcon) {
                this._baseIcon = baseIcon;
                Icon[] icons = new Icon[this._overlays.size() + 1];
                icons[0] = baseIcon;
                int iconNum = 1;
                Iterator i = this.getOverlays();
                while (i.hasNext()) {
                    Displayable displayable;
                    IconOverlay overlay = (IconOverlay)i.next();
                    if (overlay == null || (displayable = overlay.getDisplayable()) == null) continue;
                    icons[iconNum++] = displayable.getIcon();
                }
                this._icon = new OverlayIcon(icons);
            }
            return this._icon;
        }

        private synchronized boolean hasOverlay() {
            return this._overlays != null && this._overlays.size() > 0;
        }

        private synchronized IconOverlay getOverlay(String infoTypeId) {
            if (this._overlays != null) {
                return (IconOverlay)this._overlays.get(infoTypeId);
            }
            return null;
        }

        private synchronized Iterator getOverlays() {
            if (this._overlays == null) {
                return Collections.EMPTY_LIST.iterator();
            }
            ArrayList al = new ArrayList();
            Iterator itr = this._overlays.keySet().iterator();
            while (itr.hasNext()) {
                al.add(this._overlays.get(itr.next()));
            }
            return al.iterator();
        }

        static boolean mav$hasOverlay(OverlayItem overlayItem) {
            return overlayItem.hasOverlay();
        }

        static Iterator mav$getOverlays(OverlayItem overlayItem) {
            return overlayItem.getOverlays();
        }

        static Icon mav$getOverlayIcon(OverlayItem overlayItem, Icon icon) {
            return overlayItem.getOverlayIcon(icon);
        }

        static void mav$removeOverlay(OverlayItem overlayItem, String string) {
            overlayItem.removeOverlay(string);
        }

        static IconOverlay mav$getOverlay(OverlayItem overlayItem, String string) {
            return overlayItem.getOverlay(string);
        }

        OverlayItem(String string, IconOverlay iconOverlay, 1 var3_3) {
            this(string, iconOverlay);
        }

        static void mav$addOverlay(OverlayItem overlayItem, String string, IconOverlay iconOverlay) {
            overlayItem.addOverlay(string, iconOverlay);
        }

        public final class 1 {
        }
    }
}

