/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.explorer;

import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.Icon;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.IdeAction;
import oracle.ide.docking.DockableFactory;
import oracle.ide.docking.DockableView;
import oracle.ide.explorer.Explorer;
import oracle.ide.explorer.ExplorerInfo;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.layout.ViewId;
import oracle.ide.model.Element;
import oracle.ide.model.Folder;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.view.PinnableManager;
import oracle.ide.view.View;
import oracle.javatools.jndi.Names;

public abstract class ExplorerManager
extends PinnableManager {
    private static final String EXP_MGR_NAME = "ide/explorer-manager";
    public static final String SELECT_IN_STRUCTURE_CMD = "Explorer.SELECT_IN_STRUCTURE_CMD_ID";
    public static final int SELECT_IN_STRUCTURE_CMD_ID = Ide.findOrCreateCmdID("Explorer.SELECT_IN_STRUCTURE_CMD_ID");
    private static NullExplorerManager nullExplorerManager = null;

    public static ExplorerManager getExplorerManager() {
        if (!Ide.getIdeArgs().getCreateUI()) {
            if (nullExplorerManager == null) {
                nullExplorerManager = new NullExplorerManager(null);
            }
            return nullExplorerManager;
        }
        return (ExplorerManager)Names.lookup((javax.naming.Context)Names.newInitialContext(), (String)EXP_MGR_NAME);
    }

    public static void setExplorerManager(ExplorerManager explorerManager) {
        Names.bind((javax.naming.Context)Names.newInitialContext(), (String)EXP_MGR_NAME, (Object)explorerManager);
    }

    public abstract boolean supportsStructure(View var1);

    public abstract ContextMenu getContextMenu();

    public abstract void register(Class var1, Class var2, Class var3);

    public abstract void register(Class var1, Class var2, Class var3, String var4, ArrayResourceBundle var5, int var6);

    public abstract void register(Class var1, Class var2, Class var3, String var4, ResourceBundle var5, String var6);

    public abstract void register(Class var1, Class var2, Class var3, String var4, Icon var5);

    public abstract void registerDynamic(ExplorerInfo var1);

    public abstract void unregister(ExplorerInfo var1);

    public abstract List getExplorerTypes(Class var1);

    public abstract List getExplorerTypes(Element var1);

    public abstract Icon getExplorerIcon(Class var1, Class var2);

    public abstract String getExplorerCaption(Class var1, Class var2);

    public abstract Explorer getExplorerForHost(View var1, Context var2);

    public abstract TreeExplorer createTreeExplorer(Folder var1);

    private static class NullExplorerManager
    extends ExplorerManager {
        public boolean supportsStructure(View view) {
            return false;
        }

        public ContextMenu getContextMenu() {
            return null;
        }

        public void register(Class dataType, Class explorerType, Class viewType) {
        }

        public void register(Class dataType, Class explorerType, Class viewType, String caption, ArrayResourceBundle bundle, int key) {
        }

        public void register(Class dataType, Class explorerType, Class viewType, String caption, ResourceBundle bundle, String key) {
        }

        public void register(Class dataType, Class explorerType, Class viewType, String caption, Icon icon) {
        }

        public void registerDynamic(ExplorerInfo info) {
        }

        public void unregister(ExplorerInfo info) {
        }

        public List getExplorerTypes(Class dataType) {
            return Collections.EMPTY_LIST;
        }

        public List getExplorerTypes(Element document) {
            return Collections.EMPTY_LIST;
        }

        public Icon getExplorerIcon(Class explorerType, Class dataType) {
            return null;
        }

        public String getExplorerCaption(Class explorerType, Class dataType) {
            return null;
        }

        public Explorer getExplorerForHost(View host, Context context) {
            return null;
        }

        public TreeExplorer createTreeExplorer(Folder folder) {
            return null;
        }

        protected String getViewCategory() {
            return null;
        }

        protected String getDefaultName() {
            return null;
        }

        protected DockableView createDockableView(Context ctx, ViewId viewId) {
            return null;
        }

        protected IdeAction createShowAction() {
            return null;
        }

        protected DockableFactory getDockableFactory() {
            return null;
        }

        private NullExplorerManager() {
        }

        NullExplorerManager(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

