/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.editor;

import java.net.URL;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorAddin;
import oracle.ide.editor.EditorInfo;
import oracle.ide.editor.EditorListener;
import oracle.ide.editor.EditorPath;
import oracle.ide.editor.EditorUtil;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.layout.BaseLayoutListener;
import oracle.ide.layout.PreferredLayoutListener;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.javatools.jndi.Names;

public abstract class EditorManager
implements Controller,
Addin {
    public static final int SHOW_DROPDOWN_CMD_ID = Ide.findOrCreateCmdID("SHOW_DROPDOWN_CMD_ID");
    private static final String EDITOR_MANAGER_NAME = "ide/editor-manager";
    private static NullEditorManager nullEditorManager = null;

    public static EditorManager getEditorManager() {
        if (!Ide.getIdeArgs().getCreateUI()) {
            if (nullEditorManager == null) {
                nullEditorManager = new NullEditorManager(null);
            }
            return nullEditorManager;
        }
        return (EditorManager)Names.lookup((javax.naming.Context)Names.newInitialContext(), (String)EDITOR_MANAGER_NAME);
    }

    public static void setEditorManager(EditorManager editorManager) {
        Names.bind((javax.naming.Context)Names.newInitialContext(), (String)EDITOR_MANAGER_NAME, (Object)editorManager);
    }

    public abstract void register(EditorAddin var1, Class[] var2);

    public abstract void unregister(EditorAddin var1);

    public abstract void registerDynamic(EditorAddin var1);

    public abstract void unregisterDynamic(EditorAddin var1);

    public abstract void extend(EditorAddin var1, Class[] var2);

    public abstract boolean isEditorRegistered(Class var1);

    public abstract EditorAddin getEditorAddin(Class var1);

    public abstract EditorAddin getBestEditorAddin(Node var1);

    public abstract EditorAddin getDefaultAddin(Element var1);

    public abstract EditorAddin[] getStaticAddins(Class var1);

    public abstract Class[] getStaticElementTypes();

    public abstract void addEditorListener(EditorListener var1);

    public abstract void removeEditorListener(EditorListener var1);

    public abstract void activateCurrentEditorFrame();

    public Editor openDefaultEditorInFrame(URL url) {
        return EditorUtil.openDefaultEditorInFrame(url);
    }

    public abstract Editor openDefaultEditorInFrame(Context var1);

    public abstract Editor openEditorInFrame(Class var1, Context var2);

    public abstract Editor openEditor(OpenEditorOptions var1);

    public abstract void replaceEditors(Context var1, Context var2);

    public abstract List findEditors(Context var1);

    public abstract List getAllEditors();

    public abstract JComponent getDesktopComponent();

    public abstract Editor getCurrentEditor();

    public abstract void initialize();

    public abstract void addLayoutListener(String var1, BaseLayoutListener var2);

    public abstract void removeLayoutListener(String var1);

    public abstract ContextMenu getContextMenu();

    public abstract void closeEditors(List var1);

    public abstract List getEditorsInfo();

    public abstract void activateEditor(EditorInfo var1);

    public abstract void setExplicit(Editor var1, boolean var2);

    public abstract void registerPreferredLayoutListener(Class var1, Class var2, String var3, PreferredLayoutListener var4);

    public abstract EditorPath searchEditor(Node var1);

    public boolean hasEditors(Element element) {
        return false;
    }

    private static class NullEditorManager
    extends EditorManager {
        public void register(EditorAddin addin, Class[] types) {
        }

        public void unregister(EditorAddin editorAddin) {
        }

        public void registerDynamic(EditorAddin editorAddin) {
        }

        public void unregisterDynamic(EditorAddin editorAddin) {
        }

        public void extend(EditorAddin addin, Class[] types) {
        }

        public boolean isEditorRegistered(Class cls) {
            return false;
        }

        public EditorAddin getEditorAddin(Class cls) {
            return null;
        }

        public EditorAddin getBestEditorAddin(Node node) {
            return null;
        }

        public EditorAddin getDefaultAddin(Element element) {
            return null;
        }

        public EditorAddin[] getStaticAddins(Class elementClass) {
            return new EditorAddin[0];
        }

        public Class[] getStaticElementTypes() {
            return new Class[0];
        }

        public void addEditorListener(EditorListener listener) {
        }

        public void removeEditorListener(EditorListener listener) {
        }

        public void activateCurrentEditorFrame() {
        }

        public Editor openDefaultEditorInFrame(Context context) {
            return null;
        }

        public Editor openEditorInFrame(Class editorClass, Context context) {
            return null;
        }

        public Editor openEditor(OpenEditorOptions openEditorOptions) {
            return null;
        }

        public void replaceEditors(Context oldContext, Context newContext) {
        }

        public List findEditors(Context context) {
            return Collections.EMPTY_LIST;
        }

        public List getAllEditors() {
            return Collections.EMPTY_LIST;
        }

        public JComponent getDesktopComponent() {
            return null;
        }

        public Editor getCurrentEditor() {
            return null;
        }

        public void initialize() {
        }

        public void addLayoutListener(String editorId, BaseLayoutListener listener) {
        }

        public void removeLayoutListener(String editorId) {
        }

        public ContextMenu getContextMenu() {
            return null;
        }

        public void closeEditors(List listEditors) {
        }

        public List getEditorsInfo() {
            return Collections.EMPTY_LIST;
        }

        public void activateEditor(EditorInfo editorInfo) {
        }

        public void setExplicit(Editor editor, boolean bExplicit) {
        }

        public void registerPreferredLayoutListener(Class nodeClass, Class editorClass, String preferredLayoutBaseName, PreferredLayoutListener listener) {
        }

        public EditorPath searchEditor(Node node) {
            return null;
        }

        public boolean handleEvent(IdeAction action, Context context) {
            return false;
        }

        public boolean update(IdeAction action, Context context) {
            return false;
        }

        private NullEditorManager() {
        }

        NullEditorManager(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

