/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.editor;

import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.URL;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.border.Border;
import javax.swing.event.EventListenerList;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.editor.EditorManager;
import oracle.ide.layout.IdeLayout;
import oracle.ide.layout.Layout;
import oracle.ide.layout.LayoutSelector;
import oracle.ide.layout.Layouts;
import oracle.ide.layout.PreferredLayoutEvent;
import oracle.ide.layout.PreferredLayoutListener;
import oracle.ide.model.DefaultDirtyable;
import oracle.ide.model.Node;
import oracle.ide.model.Observer;
import oracle.ide.model.Project;
import oracle.ide.net.URLFileSystem;
import oracle.ide.performance.PerformanceLogger;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.GraphicsUtils;
import oracle.ide.util.StructuredPropertyAccess;
import oracle.ide.view.View;

public abstract class Editor
extends View
implements Observer,
LayoutSelector {
    public static final String ATTRIBUTE_SCROLLABLE = "scrollable";
    public static final String ATTRIBUTE_CUSTOM_HORIZONTAL_SCROLLBAR = "custom_horizontal_scrollbar";
    public static final String ATTRIBUTE_CUSTOM_VERTICAL_SCROLLBAR = "custom_vertical_scrollbar";
    public static final String ATTRIBUTE_HORIZONTAL_SCROLLBAR_POLICY = "horizontal_scrollbar_policy";
    public static final String ATTRIBUTE_VERTICAL_SCROLLBAR_POLICY = "vertical_scrollbar_policy";
    public static final String ATTRIBUTE_HORIZONTAL_UNIT_INCREMENT = "horizontal_unit_increment";
    public static final String ATTRIBUTE_VERTICAL_UNIT_INCREMENT = "vertical_unit_increment";
    public static final String ATTRIBUTE_HORIZONTAL_BLOCK_INCREMENT = "horizontal_block_increment";
    public static final String ATTRIBUTE_VERTICAL_BLOCK_INCREMENT = "vertical_block_increment";
    public static final String ATTRIBUTE_BACKGROUND_COLOR = "background_color";
    public static final String ATTRIBUTE_MENU_ID = "menu_id";
    public static final String ATTRIBUTE_OLD_EDITOR = "old_editor";
    private Map<String, Object> editorAttributes;
    private static final String EDITOR_ID = "Editor";
    private static int COUNTER = 0;
    protected static final Border CUSTOM_BORDER = null;
    protected Context _context;
    private final PropertyChangeSupport _listenerList;
    private static final Logger LOGGER = Logger.getLogger(Editor.class.getName());
    private static final Map _preferredLayoutMap = new HashMap();
    private String _type;
    private String _baseName;
    private final EventListenerList listenerList;

    private void $init$() {
        this.editorAttributes = new HashMap<String, Object>();
        this._listenerList = new PropertyChangeSupport(this);
        this.listenerList = new EventListenerList();
    }

    public abstract void open();

    public Editor() {
        this.$init$();
        try {
            this.initializeEditorAttributes();
            this.setOwner(Ide.getMainWindow().getIdeMainWindowView());
        }
        catch (NullPointerException npe) {
            LOGGER.log(Level.SEVERE, "NPE Initializing Editor", npe);
        }
    }

    public Component getDefaultFocusComponent() {
        Component gui = this.getGUI();
        JComponent defaultFocusable = GraphicsUtils.getFocusableComponentOrChild((Component)gui, (boolean)true);
        return defaultFocusable;
    }

    public String getTitleLabel() {
        Node node;
        Context ctxt = this.getContext();
        Node node2 = node = ctxt != null ? ctxt.getNode() : null;
        if (node == null) {
            return "";
        }
        String title = URLFileSystem.getPlatformPathName((URL)node.getURL());
        return DefaultDirtyable.dirtyLabel(node, title);
    }

    public String getTabLabel() {
        Node node;
        Context ctxt = this.getContext();
        Node node2 = node = ctxt != null ? ctxt.getNode() : null;
        if (node == null) {
            return "";
        }
        String title = node.getShortLabel();
        return DefaultDirtyable.dirtyLabel(node, title);
    }

    public synchronized Icon getTabIcon() {
        Context ctxt = this.getContext();
        Node node = ctxt != null ? ctxt.getNode() : null;
        return node != null ? node.getIcon() : IdeArb.getIcon(121);
    }

    public String getTabDescription() {
        Context ctxt = this.getContext();
        Node node = ctxt != null ? ctxt.getNode() : null;
        return node != null ? node.getShortLabel() : "";
    }

    public synchronized void setContext(Context context) {
        Node newNode;
        context = context == null ? Context.newIdeContext() : new Context(context);
        context.setView(this);
        Context oldContext = this.getContext();
        Node oldNode = null;
        Project oldPrj = null;
        if (oldContext != null) {
            oldNode = oldContext.getNode();
            oldPrj = oldContext.getProject();
            if (oldNode != null) {
                oldNode.detach(this);
            }
        }
        if ((newNode = context.getNode()) != null) {
            newNode.attach(this);
        }
        this._context = context;
        if (newNode != null) {
            this._context.setNode(newNode);
        }
        if (oldNode == newNode && oldPrj == context.getProject()) {
            this.getId();
        } else {
            this.setId(this.newId());
        }
    }

    public Node[] getDependentNodes() {
        return null;
    }

    public void editorShown() {
    }

    public void editorHidden() {
    }

    public Controller getController() {
        return EditorManager.getEditorManager();
    }

    public synchronized Context getContext(EventObject event) {
        if (this._context != null) {
            this._context.setSelection(this.getSelection());
            this._context.setEvent(event);
        }
        return this._context;
    }

    public ContextMenu getContextMenu() {
        return EditorManager.getEditorManager().getContextMenu();
    }

    public void close() {
        Node node;
        this.deactivate();
        Context ctxt = this.getContext();
        Node node2 = node = ctxt != null ? ctxt.getNode() : null;
        if (node != null) {
            node.detach(this);
        }
        super.close();
    }

    public Component getBottomComponent() {
        return null;
    }

    private void initializeEditorAttributes() {
        this.editorAttributes.put(ATTRIBUTE_HORIZONTAL_SCROLLBAR_POLICY, 32);
        this.editorAttributes.put(ATTRIBUTE_VERTICAL_SCROLLBAR_POLICY, 22);
    }

    public Object getEditorAttribute(String attribute) {
        Object value = this.editorAttributes.get(attribute);
        if (value == null) {
            if (attribute == ATTRIBUTE_HORIZONTAL_UNIT_INCREMENT) {
                value = this.getScrollBarIncrement(true, 0);
            } else if (attribute == ATTRIBUTE_HORIZONTAL_BLOCK_INCREMENT) {
                value = this.getScrollBarIncrement(false, 0);
            } else if (attribute == ATTRIBUTE_VERTICAL_UNIT_INCREMENT) {
                value = this.getScrollBarIncrement(true, 1);
            } else if (attribute == ATTRIBUTE_VERTICAL_BLOCK_INCREMENT) {
                value = this.getScrollBarIncrement(false, 1);
            }
        }
        return value;
    }

    public void setEditorAttribute(String attribute, Object value) {
        this.editorAttributes.put(attribute, value);
    }

    public Component getFixedLeftMargin() {
        return null;
    }

    public Component getFixedRightMargin() {
        return null;
    }

    public Component getFixedTopMargin() {
        return null;
    }

    public Component getFixedBottomMargin() {
        return null;
    }

    public Component getScrollableLeftMargin() {
        return null;
    }

    public Component getScrollableTopMargin() {
        return null;
    }

    public Component getMiniToolbar() {
        return null;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._listenerList.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._listenerList.removePropertyChangeListener(propertyChangeListener);
    }

    public void saveSettings(StructuredPropertyAccess element) {
    }

    public void loadSettings(StructuredPropertyAccess element) {
    }

    protected final void firePropertyChangeEvent(String propertyName, Object oldValue, Object newValue) {
        this._listenerList.firePropertyChange(propertyName, oldValue, newValue);
    }

    private int getScrollBarIncrement(boolean unit, int orientation) {
        int ret = 1;
        Component gui = this.getGUI();
        if (gui instanceof Scrollable) {
            Scrollable scrollable = (Scrollable)((Object)gui);
            Container parent = gui.getParent();
            if (parent instanceof JViewport) {
                JViewport viewport = (JViewport)parent;
                Rectangle viewRect = viewport.getVisibleRect();
                ret = unit ? scrollable.getScrollableUnitIncrement(viewRect, orientation, 1) : scrollable.getScrollableBlockIncrement(viewRect, orientation, 1);
            }
        } else if (!unit && gui.getParent() instanceof JViewport) {
            JViewport parent = (JViewport)gui.getParent();
            return orientation == 0 ? parent.getWidth() : parent.getHeight();
        }
        return ret;
    }

    public URL getPreferredLayoutURL() {
        String baseName = this.getPreferredLayoutBaseName();
        if (baseName == null) {
            return null;
        }
        Layouts layouts = Layouts.getLayouts();
        IdeLayout design = layouts.getDesignLayout();
        LayoutData layoutData = (LayoutData)_preferredLayoutMap.get(this.getType());
        if (layoutData == null || design.findLayout(LayoutData.ra$_url(layoutData)) == null) {
            layoutData = new LayoutData(layouts.buildLayoutURL(baseName));
            _preferredLayoutMap.put(this.getType(), layoutData);
        }
        if (design.findLayout(LayoutData.ra$_url(layoutData)) == null) {
            layouts.newDesignLayout(LayoutData.ra$_url(layoutData));
        }
        return LayoutData.ra$_url(layoutData);
    }

    public void setPreferredLayoutURL(URL layoutURL) {
        LayoutData data = (LayoutData)_preferredLayoutMap.get(this.getType());
        if (data != null && LayoutData.ra$_url(data).equals(layoutURL)) {
            return;
        }
        _preferredLayoutMap.put(this.getType(), new LayoutData(layoutURL));
    }

    public void initializeLayout(Layout layout) {
        PreferredLayoutEvent event = new PreferredLayoutEvent(1, this, layout);
        this.firePreferredLayoutEvent(event);
    }

    public void initializeActiveLayout() {
        LayoutData data = (LayoutData)_preferredLayoutMap.get(this.getType());
        if (data != null && !LayoutData.ra$_initialized(data)) {
            PreferredLayoutEvent event = new PreferredLayoutEvent(2, this, null);
            this.firePreferredLayoutEvent(event);
            LayoutData.wa$_initialized(data, true);
        }
    }

    public boolean isReady() {
        return this.owner().isVisible();
    }

    public String getDisplayName() {
        String name = this.getClass().getName();
        int i = name.lastIndexOf(".");
        if (i < 0) {
            return name;
        }
        return name.substring(i + 1, name.length());
    }

    public String getType() {
        if (this._type == null) {
            this._type = this.getClass().getName();
        }
        return this._type;
    }

    public void setType(String type) {
        this._type = type;
    }

    public String getPreferredLayoutBaseName() {
        if (this._baseName == null) {
            this._baseName = "Editing";
        }
        return this._baseName;
    }

    public void setPreferredLayoutBaseName(String name) {
        this._baseName = name;
    }

    public void addPreferredLayoutListener(PreferredLayoutListener l) {
        this.listenerList.add(PreferredLayoutListener.class, l);
    }

    public void removePreferredLayoutListener(PreferredLayoutListener l) {
        this.listenerList.remove(PreferredLayoutListener.class, l);
    }

    private void firePreferredLayoutEvent(PreferredLayoutEvent event) {
        PreferredLayoutListener[] listeners = (PreferredLayoutListener[])this.listenerList.getListeners(PreferredLayoutListener.class);
        int i = listeners.length - 1;
        while (i >= 0) {
            PreferredLayoutListener preferredLayoutListener = listeners[i];
            switch (event.getEventID()) {
                case 1: {
                    long startTime = System.nanoTime();
                    preferredLayoutListener.onInitializeLayout(event);
                    PerformanceLogger.get().log("PreferredLayoutListener.onInitializeLayout", preferredLayoutListener.getClass().getName(), System.nanoTime() - startTime);
                    break;
                }
                case 2: {
                    long startTime = System.nanoTime();
                    preferredLayoutListener.onPreferredLayoutActivate(event);
                    PerformanceLogger.get().log("PreferredLayoutListener.onPreferredLayoutActivate", preferredLayoutListener.getClass().getName(), System.nanoTime() - startTime);
                    break;
                }
            }
            --i;
        }
    }

    protected String newId() {
        return EDITOR_ID + ++COUNTER;
    }

    private static final class LayoutData {
        private final URL _url;
        private boolean _initialized;

        public LayoutData(URL url) {
            this._url = url;
        }

        static boolean ra$_initialized(LayoutData layoutData) {
            return layoutData._initialized;
        }

        static void wa$_initialized(LayoutData layoutData, boolean bl) {
            layoutData._initialized = bl;
        }

        static URL ra$_url(LayoutData layoutData) {
            return layoutData._url;
        }
    }
}

