/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.docking;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import oracle.ide.controls.Animator;
import oracle.ide.docking.Drawer;
import oracle.ide.docking.DrawerWindowUI;
import oracle.javatools.ui.themes.Painter;
import oracle.javatools.ui.themes.ThemeProperties;
import oracle.javatools.ui.themes.Themes;
import oracle.javatools.util.Pair;

final class DrawerWindowTray
extends JPanel {
    static final int THEME_MODE_HANDLE_HEIGHT = 14;
    private static final String PERMANENT_FOCUS_OWNER_PROPERTY = "permanentFocusOwner";
    private final Listeners listeners;
    private final DrawerWindowUI drawerWindowUI;
    private final JLayeredPane layeredPane;
    private final JScrollPane scrollPane;
    private final JList drawerList;
    private final DefaultListModel drawerListModel;
    private Handle drawerHandle;
    private boolean visible;
    private Component _savedFocusComponent;
    private AnimationRectangleCache animationCacheData;

    private void $init$() {
        this.listeners = new Listeners(null);
        this.drawerListModel = new DefaultListModel();
        this.animationCacheData = new AnimationRectangleCache(null);
    }

    boolean visible() {
        return this.visible;
    }

    DrawerWindowTray(DrawerWindowUI drawerWindowUI) {
        super(new BorderLayout());
        this.$init$();
        this.drawerWindowUI = drawerWindowUI;
        this.layeredPane = this.rootPaneContainer(drawerWindowUI).getLayeredPane();
        this.drawerList = new 1(this.drawerListModel);
        if (Themes.isThemed()) {
            this.drawerList.setOpaque(false);
        }
        this.scrollPane = new JScrollPane(this.drawerList);
        this.scrollPane.setOpaque(false);
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.registerListListeners();
        this.setBorders();
        this.drawerHandle = new Handle(0);
        this.add((Component)this.drawerHandle, "North");
        this.add((Component)this.content(), "Center");
    }

    private void registerListListeners() {
        this.drawerList.addMouseListener(this.listeners);
        if (Themes.isThemed()) {
            this.drawerList.setCellRenderer(new CellRenderer());
        }
        this.drawerList.addMouseMotionListener(new 2());
        this.drawerList.addKeyListener(this.listeners);
    }

    private void setBorders() {
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.scrollPane.setBorder(null);
    }

    protected void paintComponent(Graphics g) {
        if (Themes.isThemed()) {
            ThemeProperties properties = Themes.getActiveTheme().getStateProperties("minimized", "normal");
            Painter painter = properties.getPainter("bg");
            Insets insets = this.getInsets();
            painter.paint(g, insets.left, insets.top, this.getWidth(), this.getHeight());
        } else {
            super.paintComponent(g);
        }
    }

    private JPanel content() {
        3 panel = new 3(new GridBagLayout());
        Insets insets = new Insets(0, 0, 0, 0);
        panel.add((Component)this.minimizedLabel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 0, insets, 0, 0));
        panel.add((Component)this.scrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, insets, 0, 0));
        return panel;
    }

    private JLabel minimizedLabel() {
        JLabel label = new JLabel("Minimized");
        label.setBackground(Color.GRAY);
        label.setFont(label.getFont().deriveFont(1));
        label.setBorder(null);
        label.setAlignmentX(0.5f);
        return label;
    }

    void addEntry(Drawer drawer) {
        String label = drawer.tabName();
        this.drawerListModel.addElement(new DrawerPair(label, drawer));
    }

    private void onRestore() {
        Pair pair = (Pair)this.drawerList.getSelectedValue();
        if (pair != null) {
            Drawer drawer = (Drawer)pair.second;
            this.drawerListModel.removeElement(pair);
            this.drawerWindowUI.restoreFromMinimizedTray(drawer, this.isEmpty());
            this.collapse();
            drawer.drawerUI().requestFocus();
        }
    }

    void clear() {
        this.drawerListModel.removeAllElements();
    }

    boolean isEmpty() {
        return this.drawerList.getModel().getSize() == 0;
    }

    void collapse() {
        this.layeredPane.removeComponentListener(this.listeners);
        KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        focusManager.removePropertyChangeListener(PERMANENT_FOCUS_OWNER_PROPERTY, this.listeners);
        Rectangle from = this.getBounds();
        Rectangle to = new Rectangle(from.x, from.y + from.height, from.width, 0);
        if (!Themes.isThemed()) {
            Animator.animate(30, 500L, new AnimationListener(this.layeredPane, from, to));
        }
        this.layeredPane.remove(this);
        this.layeredPane.repaint();
        this.visible = false;
        if (this._savedFocusComponent != null) {
            this._savedFocusComponent.requestFocus();
        }
        this._savedFocusComponent = null;
        this.animationCacheData.clear();
    }

    final void expand() {
        this._savedFocusComponent = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
        this.visible = true;
        this.scrollPane.setVerticalScrollBarPolicy(21);
        this.layeredPane.add((Component)this, JLayeredPane.MODAL_LAYER);
        this.animateExpansion();
        KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        focusManager.addPropertyChangeListener(PERMANENT_FOCUS_OWNER_PROPERTY, this.listeners);
        this.layeredPane.addComponentListener(this.listeners);
        this.scrollPane.setVerticalScrollBarPolicy(20);
        this.drawerList.requestFocus();
    }

    private void animateExpansion() {
        Rectangles rectanglesWhenExpanded = new Rectangles();
        Animator.animate(30, 500L, new AnimationListener(this, rectanglesWhenExpanded.from, rectanglesWhenExpanded.to));
    }

    void updatePositionAndSize() {
        this.setBounds((DrawerWindowTray)this.new Rectangles().to);
    }

    private RootPaneContainer rootPaneContainer(Component parent) {
        return (RootPaneContainer)((Object)SwingUtilities.getAncestorOfClass(RootPaneContainer.class, parent));
    }

    static void mav$onRestore(DrawerWindowTray drawerWindowTray) {
        drawerWindowTray.onRestore();
    }

    static JList ra$drawerList(DrawerWindowTray drawerWindowTray) {
        return drawerWindowTray.drawerList;
    }

    static DrawerWindowUI ra$drawerWindowUI(DrawerWindowTray drawerWindowTray) {
        return drawerWindowTray.drawerWindowUI;
    }

    static DefaultListModel ra$drawerListModel(DrawerWindowTray drawerWindowTray) {
        return drawerWindowTray.drawerListModel;
    }

    static AnimationRectangleCache ra$animationCacheData(DrawerWindowTray drawerWindowTray) {
        return drawerWindowTray.animationCacheData;
    }

    static Handle ra$drawerHandle(DrawerWindowTray drawerWindowTray) {
        return drawerWindowTray.drawerHandle;
    }

    static JLayeredPane ra$layeredPane(DrawerWindowTray drawerWindowTray) {
        return drawerWindowTray.layeredPane;
    }

    private class Listeners
    implements PropertyChangeListener,
    ComponentListener,
    MouseListener,
    KeyListener {
        public void propertyChange(PropertyChangeEvent e) {
            if (!DrawerWindowTray.PERMANENT_FOCUS_OWNER_PROPERTY.equals(e.getPropertyName())) {
                return;
            }
            Component permanentFocusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
            if (permanentFocusOwner == null) {
                return;
            }
            if (SwingUtilities.isDescendingFrom(permanentFocusOwner, DrawerWindowTray.this)) {
                return;
            }
            DrawerWindowTray.this.collapse();
        }

        public void componentHidden(ComponentEvent e) {
        }

        public void componentMoved(ComponentEvent e) {
        }

        public void componentResized(ComponentEvent e) {
            DrawerWindowTray.ra$drawerWindowUI(DrawerWindowTray.this).doLayout();
        }

        public void componentShown(ComponentEvent e) {
        }

        public void mouseClicked(MouseEvent e) {
            DrawerWindowTray.mav$onRestore(DrawerWindowTray.this);
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            if (e.getButton() != 1) {
                int index = DrawerWindowTray.ra$drawerList(DrawerWindowTray.this).locationToIndex(e.getPoint());
                if (index < 0) {
                    return;
                }
                Rectangle r = DrawerWindowTray.ra$drawerList(DrawerWindowTray.this).getCellBounds(index, index);
                if (r.contains(e.getPoint())) {
                    DrawerWindowTray.ra$drawerList(DrawerWindowTray.this).setSelectedIndex(index);
                }
            }
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void keyPressed(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
        }

        public void keyTyped(KeyEvent e) {
            if ('\n' == e.getKeyChar()) {
                DrawerWindowTray.mav$onRestore(DrawerWindowTray.this);
            }
            if ('\u001b' == e.getKeyChar()) {
                DrawerWindowTray.this.collapse();
            }
        }

        private Listeners() {
        }

        Listeners(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class Handle
    extends JPanel {
        private final int orientation;
        private boolean mouseOver;

        public Handle(int orientation) {
            this.orientation = orientation;
            this.setPreferredSize(new Dimension(10, 14));
            if (Themes.isThemed()) {
                this.setPreferredSize(new Dimension(10, 14));
            } else {
                this.setPreferredSize(new Dimension(10, 10));
                this.setBorder(BorderFactory.createBevelBorder(0));
            }
            this.addMouseListener(new 1());
        }

        protected void paintComponent(Graphics g) {
            if (Themes.isThemed()) {
                this.paintWithTheme(g);
            } else {
                this.paintWithoutTheme(g);
            }
        }

        private void paintWithTheme(Graphics g) {
            String state = this.mouseOver ? "full_mouse_entered" : "full_mouse_exited";
            ThemeProperties properties = Themes.getActiveTheme().getStateProperties("handler", state);
            Painter painter = properties.getPainter("bg");
            Insets insets = this.getInsets();
            painter.paint(g, insets.left, insets.top, this.getWidth(), this.getHeight());
        }

        private void paintWithoutTheme(Graphics g) {
            g.setColor(this.getBackground());
            Insets insets = this.getInsets();
            int width = this.getWidth() - insets.left - insets.right;
            int height = this.getHeight() - insets.top - insets.bottom;
            g.fillRect(insets.left, insets.top, width, height);
            g.setColor(Color.GRAY);
            if (this.orientation == 0) {
                int d = height - 2;
                int i = -10;
                while (i <= 10) {
                    g.drawOval(insets.left + (width - d) / 2 + i, insets.top + (height - d) / 2, d, d);
                    i += 10;
                }
                return;
            }
            int d = width - 2;
            int i = -10;
            while (i <= 10) {
                g.fillOval(insets.left + (width - d) / 2, insets.top + (height - d) / 2 + i, d, d);
                i += 10;
            }
        }

        static void wa$mouseOver(Handle handle, boolean bl) {
            handle.mouseOver = bl;
        }

        final class 1
        implements MouseListener {
            public void mouseClicked(MouseEvent e) {
                DrawerWindowTray.this.collapse();
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
                Handle.wa$mouseOver(Handle.this, true);
                Handle.this.getParent().repaint();
            }

            public void mouseExited(MouseEvent e) {
                Handle.wa$mouseOver(Handle.this, false);
                Handle.this.getParent().repaint();
            }
        }
    }

    private class AnimationListener
    implements PropertyChangeListener {
        private final JComponent layeredPane;
        private final Rectangle from;
        private final Rectangle to;

        public AnimationListener(JComponent component, Rectangle from, Rectangle to) {
            this.layeredPane = component;
            this.from = from;
            this.to = to;
        }

        public void propertyChange(PropertyChangeEvent evt) {
            double v = (Double)evt.getNewValue();
            DrawerWindowTray.this.setBounds(Animator.getRectangle(v, this.from, this.to));
            Graphics g = this.layeredPane.getGraphics();
            this.layeredPane.paintAll(g);
            g.dispose();
        }
    }

    private static class CellRenderer
    extends JPanel
    implements ListCellRenderer {
        private final JLabel text;
        private boolean selected;
        private boolean mouseDown;

        private void $init$() {
            this.text = new JLabel();
        }

        CellRenderer() {
            super(new GridBagLayout());
            this.$init$();
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 18;
            c.weightx = 1.0;
            c.gridy = 0;
            c.gridx = 0;
            c.insets = new Insets(2, 2, 2, 2);
            this.text.setHorizontalAlignment(2);
            this.add((Component)this.text, c);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value != null) {
                this.text.setText(value.toString());
            }
            this.selected = isSelected;
            this.mouseDown = cellHasFocus;
            this.text.setFont(list.getFont());
            return this;
        }

        protected void paintComponent(Graphics g) {
            String state = null;
            state = this.selected ? (this.mouseDown ? "mousedown" : "mouseover") : "element";
            ThemeProperties properties = Themes.getActiveTheme().getStateProperties("minimized", state);
            Painter painter = properties.getPainter("bg");
            this.text.setForeground(properties.getColor("foreground"));
            Insets insets = this.getInsets();
            painter.paint(g, insets.left, insets.top, this.getWidth(), this.getHeight());
        }
    }

    final class 1
    extends JList {
        protected void paintComponent(Graphics g) {
            if (Themes.isThemed()) {
                ThemeProperties properties = Themes.getActiveTheme().getStateProperties("minimized", "normal");
                Painter painter = properties.getPainter("bg");
                Insets insets = this.getInsets();
                painter.paint(g, insets.left, insets.top, this.getWidth(), this.getHeight());
            }
            super.paintComponent(g);
        }

        public 1(ListModel listModel) {
            super(listModel);
        }
    }

    final class 2
    implements MouseMotionListener {
        public void mouseDragged(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
            int index = DrawerWindowTray.ra$drawerList(DrawerWindowTray.this).locationToIndex(e.getPoint());
            DrawerWindowTray.ra$drawerList(DrawerWindowTray.this).setSelectedIndex(index);
        }
    }

    final class 3
    extends JPanel {
        protected void paintComponent(Graphics g) {
            if (Themes.isThemed()) {
                ThemeProperties properties = Themes.getActiveTheme().getStateProperties("minimized", "normal");
                Painter painter = properties.getPainter("bg");
                Insets insets = this.getInsets();
                painter.paint(g, insets.left, insets.top, this.getWidth(), this.getHeight());
            } else {
                super.paintComponent(g);
            }
        }

        public 3(LayoutManager layoutManager) {
            super(layoutManager);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DrawerPair
    extends Pair<String, Drawer> {
        public DrawerPair(String label, Drawer drawer) {
            super((Object)label, (Object)drawer);
        }

        public String toString() {
            String stringResult = null;
            if ((String)this.first != null) {
                stringResult = (String)this.first;
            } else if ((Drawer)this.second != null) {
                stringResult = ((Drawer)this.second).toString();
            }
            return stringResult;
        }
    }

    private class AnimationRectangleCache {
        int rectangleHeight;
        int numberOfListElements;
        int singleCellHeight;

        private void $init$() {
            this.rectangleHeight = -1;
            this.numberOfListElements = -1;
            this.singleCellHeight = -1;
        }

        void clear() {
            this.rectangleHeight = -1;
            this.numberOfListElements = -1;
            this.singleCellHeight = -1;
        }

        boolean populated() {
            return this.rectangleHeight != -1;
        }

        boolean hasPrecomputedCellHeight() {
            return this.singleCellHeight != -1;
        }

        private AnimationRectangleCache() {
            this.$init$();
        }

        AnimationRectangleCache(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class Rectangles {
        final Rectangle from;
        final Rectangle to;

        Rectangles() {
            int theHeightToExpand;
            int dlm = DrawerWindowTray.ra$drawerListModel(DrawerWindowTray.this).size();
            if (!(DrawerWindowTray.ra$drawerListModel(DrawerWindowTray.this).size() == 0 || DrawerWindowTray.ra$animationCacheData(DrawerWindowTray.this).populated() && DrawerWindowTray.ra$animationCacheData((DrawerWindowTray)DrawerWindowTray.this).numberOfListElements == DrawerWindowTray.ra$drawerListModel(DrawerWindowTray.this).size())) {
                int singleCellHeight = DrawerWindowTray.ra$animationCacheData(DrawerWindowTray.this).hasPrecomputedCellHeight() ? DrawerWindowTray.ra$animationCacheData((DrawerWindowTray)DrawerWindowTray.this).singleCellHeight : DrawerWindowTray.ra$drawerList(DrawerWindowTray.this).getHeight() / DrawerWindowTray.ra$drawerListModel(DrawerWindowTray.this).size();
                int rowsToShow = Math.min(DrawerWindowTray.ra$drawerListModel(DrawerWindowTray.this).size(), 3);
                theHeightToExpand = (int)Math.ceil(singleCellHeight * (rowsToShow + 1) + DrawerWindowTray.ra$drawerHandle(DrawerWindowTray.this).getHeight());
                DrawerWindowTray.ra$animationCacheData((DrawerWindowTray)DrawerWindowTray.this).singleCellHeight = singleCellHeight;
                DrawerWindowTray.ra$animationCacheData((DrawerWindowTray)DrawerWindowTray.this).rectangleHeight = theHeightToExpand;
                DrawerWindowTray.ra$animationCacheData((DrawerWindowTray)DrawerWindowTray.this).numberOfListElements = DrawerWindowTray.ra$drawerListModel(DrawerWindowTray.this).size();
            } else {
                theHeightToExpand = DrawerWindowTray.ra$animationCacheData((DrawerWindowTray)DrawerWindowTray.this).rectangleHeight;
            }
            int preferredHeight = Math.min(DrawerWindowTray.ra$drawerWindowUI(DrawerWindowTray.this).getHeight(), theHeightToExpand);
            Point pt = SwingUtilities.convertPoint(DrawerWindowTray.ra$drawerWindowUI(DrawerWindowTray.this), 0, DrawerWindowTray.ra$drawerWindowUI(DrawerWindowTray.this).getHeight(), DrawerWindowTray.ra$layeredPane(DrawerWindowTray.this));
            this.from = new Rectangle(pt.x, pt.y, DrawerWindowTray.ra$drawerWindowUI(DrawerWindowTray.this).getWidth(), 0);
            this.to = new Rectangle(pt.x, pt.y - preferredHeight, DrawerWindowTray.ra$drawerWindowUI(DrawerWindowTray.this).getWidth(), preferredHeight);
        }
    }
}

