/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.docking;

import java.awt.Insets;
import java.util.List;
import oracle.ide.docking.DrawerUI;
import oracle.ide.docking.DrawerWindowUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DrawerWindowLayout {
    private static final int FEEDBACK_HEIGHT = 100;
    private final DrawerWindowUI drawerWindow;

    DrawerWindowLayout(DrawerWindowUI drawerWindow) {
        this.drawerWindow = drawerWindow;
    }

    void resizedLayout(int delta) {
        Insets insets = this.drawerWindow.getInsets();
        List<DrawerUI> visibleDrawers = this.drawerWindow.visibleDrawers();
        int availableWidth = this.drawerWindow.getWidth() - (insets.left + insets.right);
        double y = insets.top;
        boolean firstVisited = false;
        int i = 0;
        while (i < visibleDrawers.size()) {
            if (i == this.drawerWindow.dropFeedbackPos()) {
                y += (double)100;
            }
            DrawerUI drawer = visibleDrawers.get(i);
            int drawerHeight = drawer.titlebarHeight();
            if (drawer.expanded()) {
                if (!firstVisited) {
                    drawerHeight = drawer.getHeight() + delta;
                    firstVisited = true;
                    if (drawerHeight <= drawer.titlebarHeight()) {
                        drawerHeight = drawer.titlebarHeight();
                        drawer.expansionRatio(0.0);
                        firstVisited = false;
                    }
                } else {
                    drawerHeight = drawer.getHeight();
                }
            }
            drawer.setBounds(insets.left, (int)Math.ceil(y), availableWidth, drawerHeight);
            y += (double)drawerHeight;
            ++i;
        }
        DrawersInfo drawersInfo = this.drawersInfo(visibleDrawers);
        Heights heights = this.calculateHeights(insets, drawersInfo);
        int i2 = 0;
        while (i2 < visibleDrawers.size()) {
            double newRatio = 1.0;
            DrawerUI drawer = visibleDrawers.get(i2);
            heights.remaining -= drawer.getHeight();
            if (heights.allocatable > 0) {
                newRatio = (double)(drawer.getHeight() - drawer.titlebarHeight()) / (double)heights.allocatable;
            }
            drawer.ratio(newRatio);
            ++i2;
        }
    }

    void normalLayout() {
        Insets insets = this.drawerWindow.getInsets();
        List<DrawerUI> visibleDrawers = this.drawerWindow.visibleDrawers();
        DrawersInfo drawersInfo = this.drawersInfo(visibleDrawers);
        Heights heights = this.calculateHeights(insets, drawersInfo);
        int expandedToVisit = drawersInfo.expandedDrawerCount;
        int availableWidth = this.drawerWindow.getWidth() - (insets.left + insets.right);
        double y = insets.top;
        boolean isAnimating = false;
        double[] newRatios = new double[visibleDrawers.size()];
        int i = 0;
        while (i < visibleDrawers.size()) {
            if (i == this.drawerWindow.dropFeedbackPos()) {
                y += (double)100;
            }
            double newRatio = 1.0;
            DrawerUI drawer = visibleDrawers.get(i);
            int drawerHeight = drawer.titlebarHeight();
            if (drawer.expanded()) {
                if (--expandedToVisit != 0) {
                    double ratio = drawer.ratio();
                    if (drawersInfo.totalDrawerElementRatio > 0.0) {
                        int componentHeight = (int)Math.round((double)heights.remaining * ratio / drawersInfo.totalDrawerElementRatio);
                        drawerHeight += componentHeight;
                        heights.remaining -= componentHeight;
                        drawersInfo.totalDrawerElementRatio -= ratio;
                        if (heights.allocatable > 0) {
                            newRatio = (double)componentHeight / (double)heights.allocatable;
                        }
                    }
                } else {
                    newRatio = (double)heights.remaining / (double)heights.allocatable;
                    drawerHeight += heights.remaining;
                }
                if (drawer.expansionRatio() != 1.0) {
                    isAnimating = true;
                }
            }
            drawer.setBounds(insets.left, (int)Math.ceil(y), availableWidth, drawerHeight);
            y += (double)drawerHeight;
            newRatios[i] = newRatio;
            ++i;
        }
        if (!isAnimating) {
            int i2 = 0;
            while (i2 < visibleDrawers.size()) {
                double newRatio = newRatios[i2];
                DrawerUI drawer = visibleDrawers.get(i2);
                drawer.ratio(newRatio);
                ++i2;
            }
        }
    }

    private DrawersInfo drawersInfo(List<DrawerUI> drawers) {
        DrawersInfo drawersInfo = new DrawersInfo(null);
        for (DrawerUI drawer : drawers) {
            if (drawer.expanded()) {
                drawersInfo.totalDrawerElementRatio += drawer.ratio();
                ++drawersInfo.expandedDrawerCount;
            }
            drawersInfo.totalTitlebarHeight += drawer.titlebarHeight();
        }
        return drawersInfo;
    }

    private Heights calculateHeights(Insets insets, DrawersInfo drawerInfo) {
        Heights heights = new Heights(null);
        heights.allocatable = this.allocatableHeight(insets, drawerInfo);
        heights.remaining = this.remainingHeight(heights.allocatable);
        return heights;
    }

    private int allocatableHeight(Insets insets, DrawersInfo drawerInfo) {
        int bottomComponentHeight = this.drawerWindow.bottomComponent().getPreferredSize().height;
        int availableHeight = this.drawerWindow.getHeight() - (insets.top + bottomComponentHeight + insets.bottom);
        return availableHeight - drawerInfo.totalTitlebarHeight;
    }

    private int remainingHeight(int allocatableHeight) {
        int remainingHeight = allocatableHeight;
        if (this.drawerWindow.dropFeedbackPos() >= 0) {
            remainingHeight -= 100;
        }
        return remainingHeight;
    }

    private class DrawersInfo {
        int expandedDrawerCount;
        double totalDrawerElementRatio;
        int totalTitlebarHeight;

        private DrawersInfo() {
        }

        DrawersInfo(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class Heights {
        int allocatable;
        int remaining;

        private Heights() {
        }

        Heights(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

