/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.docking;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.docking.BaseDockableFactory;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.DockableFactory;
import oracle.ide.docking.DockableWindow;
import oracle.ide.docking.Drawer;
import oracle.ide.docking.DrawerConfig;
import oracle.ide.docking.DrawerUI;
import oracle.ide.docking.DrawerWindowConfig;
import oracle.ide.docking.DrawerWindowModel;
import oracle.ide.docking.DrawerWindowUI;
import oracle.ide.layout.ViewId;
import oracle.ide.model.UpdateMessage;
import oracle.ide.util.DefaultStructuredPropertyAccess;
import oracle.ide.util.PropertyAccess;
import oracle.ide.util.StructuredPropertyAccess;
import oracle.ide.view.View;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DrawerWindow
extends DockableWindow {
    private static final String DRAWER_PROPERTY = "DrawerModel.Entry";
    private static final String VIEW_PROPERTY = "Layout";
    private static final String PANEL_PROPERTY = "PanelLayout";
    private static final String USER_PROPERTY = "user";
    private static final String HIDE_HANDLE_IF_ONLY_ONE_DRAWER_SHOWN_PROPERTY = "HideHandleIfOnlyOneDrawerShown";
    private static final String EXPAND_DRAWER_ON_ACTIVATION = "ExpandDrawerOnActivation";
    public static final int DROP_DOWN_ACTION_ID;
    public static final int RESTORE_ACTION_ID;
    public static final int MOVE_ACTION_ID;
    public static final int SIZE_ACTION_ID;
    public static final int FLOAT_ACTION_ID;
    public static final int MINIMIZE_ACTION_ID;
    public static final int MAXIMIZE_ACTION_ID;
    public static final int CLOSE_ACTION_ID;
    private final DrawerWindowModel model;
    private final List<Controller> delegates;
    private final Controller controller;
    private DrawerWindowUI drawerWindowUI;
    private JPanel ui;
    private String tabName;
    private Icon tabIcon;
    private String titleName;
    private JComponent topComponent;
    private StructuredPropertyAccess savedPanelLayout;
    private final View decorated;
    private boolean expandOneDrawerAtATime;
    private boolean hideHandleIfOnlyOneDrawerShown;
    private boolean expandDrawerOnActivation;
    static final /* synthetic */ boolean $assertionsDisabled;

    private void $init$() {
        this.delegates = new ArrayList<Controller>();
        this.controller = new DrawerController(null);
    }

    public DrawerWindow(String viewId, View decorated, DrawerWindowConfig config) {
        super(viewId);
        this.$init$();
        this.decorated = this.validate(decorated);
        this.addDelegateControllers(this.decorated.getController());
        this.applyConfig(this.validate(config));
        this.model = new DrawerWindowModel(this);
        this.mustExpandDrawerOnActivation(true);
    }

    private View validate(View decorated) {
        if (decorated == null) {
            throw new IllegalArgumentException("The decorated view should not be null");
        }
        return decorated;
    }

    private DrawerWindowConfig validate(DrawerWindowConfig config) {
        if (config == null) {
            throw new IllegalArgumentException("The drawer configuration should not be null");
        }
        return config;
    }

    public void expandOneDrawerAtATime() {
        this.expandOneDrawerAtATime = true;
        if (this.drawerWindowUI != null) {
            this.drawerWindowUI.expandOneDrawerAtATime();
        }
    }

    public void hideHandleIfOnlyOneDrawerShown() {
        this.mustHideHandle(true);
    }

    private void mustHideHandle(boolean newValue) {
        this.hideHandleIfOnlyOneDrawerShown = newValue;
        if (this.hideHandleIfOnlyOneDrawerShown && this.drawerWindowUI != null) {
            this.drawerWindowUI.hideHandleIfOnlyOneDrawerShown();
        }
    }

    private void mustExpandDrawerOnActivation(boolean newValue) {
        this.expandDrawerOnActivation = newValue;
        if (this.expandDrawerOnActivation && this.drawerWindowUI != null) {
            this.drawerWindowUI.expandDrawerOnActivation();
        }
    }

    private void applyConfig(DrawerWindowConfig config) {
        this.tabName = config.tabName();
        this.titleName = config.titleName();
        this.topComponent = config.topComponent();
        this.tabIcon = config.icon();
        this.setType(config.type());
    }

    public void topComponent(JComponent topComponent) {
        this.topComponent = topComponent;
    }

    @Override
    public Toolbar getToolbar() {
        return this.decorated.getToolbar();
    }

    private boolean moreThanOneVisibleDrawer() {
        return this.drawerWindowUI.visibleDrawers().size() > 1;
    }

    public void addDrawer(View view, DrawerConfig config) {
        this.model.addDrawer(view, config);
    }

    public void addDrawer(DockableWindow view) {
        this.model.addDrawer(view);
    }

    public void addDrawerThatCanHideHandle(DockableWindow view) {
        this.model.addDrawerThatCanHideHandle(view);
    }

    public void addCloseableDrawer(DockableWindow view, int index) {
        this.model.addCloseableDrawer(view, index);
    }

    public void addDrawer(DockableWindow view, int index) {
        this.model.addDrawer(view, index);
    }

    public void updateDrawerHandlesVisibility() {
        if (this.drawerWindowUI == null) {
            return;
        }
        this.drawerWindowUI.updateDrawerHandlesVisibility();
    }

    public void addDelegateControllers(Controller ... delegates) {
        this.delegates.addAll(Arrays.asList(delegates));
    }

    @Override
    public Controller getController() {
        return this.controller;
    }

    @Override
    public Component getGUI() {
        if (this.ui == null) {
            this.createGUI();
        }
        return this.ui;
    }

    private void createGUI() {
        this.drawerWindowUI = new DrawerWindowUI(this);
        if (this.expandOneDrawerAtATime) {
            this.drawerWindowUI.expandOneDrawerAtATime();
        }
        if (this.hideHandleIfOnlyOneDrawerShown) {
            this.drawerWindowUI.hideHandleIfOnlyOneDrawerShown();
        }
        if (this.expandDrawerOnActivation) {
            this.drawerWindowUI.expandDrawerOnActivation();
        }
        this.ui = new JPanel(new BorderLayout());
        this.ui.setOpaque(false);
        if (this.topComponent != null) {
            this.ui.add((Component)this.topComponent, "North");
        }
        this.ui.add((Component)this.drawerWindowUI, "Center");
        this.loadLayoutIfNecessary();
    }

    private void loadLayoutIfNecessary() {
        if (this.savedPanelLayout == null) {
            return;
        }
        this.drawerWindowUI.loadLayout(this.savedPanelLayout);
        this.savedPanelLayout = null;
    }

    @Override
    public String getTabName() {
        return this.tabName;
    }

    @Override
    public Icon getTabIcon() {
        return this.tabIcon;
    }

    @Override
    public String getTitleName() {
        return this.titleName;
    }

    DrawerWindowModel model() {
        return this.model;
    }

    DockableWindow view(DrawerUI drawer) {
        int i = this.model.indexOf(drawer);
        return this.model.drawerAt(i).view();
    }

    static {
        $assertionsDisabled = DrawerWindow.class.desiredAssertionStatus() ^ true;
        DROP_DOWN_ACTION_ID = Ide.createCmdID("DDW.dropDown");
        RESTORE_ACTION_ID = Ide.createCmdID("DDW.Restore");
        MOVE_ACTION_ID = Ide.createCmdID("DDW.Move");
        SIZE_ACTION_ID = Ide.createCmdID("DDW.Size");
        FLOAT_ACTION_ID = Ide.createCmdID("DDW.Float");
        MINIMIZE_ACTION_ID = Ide.createCmdID("DDW.Minimize");
        MAXIMIZE_ACTION_ID = Ide.createCmdID("DDW.Maximize");
        CLOSE_ACTION_ID = Ide.createCmdID("DDW.Close");
    }

    public void minimize(View view) {
        Drawer drawer = this.drawerFrom(view);
        if (drawer != null) {
            DrawerUI drawerUI = drawer.drawerUI();
            if (!$assertionsDisabled && drawerUI == null) {
                throw new AssertionError();
            }
            drawer.state(DrawerConfig.State.MINIMIZED);
            this.drawerWindowUI.minimizeWithAnimation(drawerUI);
            this.updateDrawerHandlesVisibility();
        }
    }

    public void expand(View view) {
        int index = this.model.indexOf(view);
        this.assertKnownView(index);
        this.drawerWindowUI.expand(this.model.drawerAt(index).drawerUI());
    }

    public void activate(View view, boolean whetherToActivate) {
        int index = this.model.indexOf(view);
        this.assertKnownView(index);
        int drawerIndex = 0;
        while (drawerIndex < this.model.drawerCount()) {
            Drawer nextDrawer = this.model.drawerAt(drawerIndex);
            if (drawerIndex != index && nextDrawer.drawerUI().active()) {
                nextDrawer.drawerUI().deactivate();
            }
            ++drawerIndex;
        }
        if (whetherToActivate) {
            this.drawerWindowUI.activate(this.model.drawerAt(index).drawerUI());
        } else {
            this.drawerWindowUI.deactivate(this.model.drawerAt(index).drawerUI());
        }
    }

    public void removeIfPresent(View view) {
        Drawer removed = this.model.removeDrawerIfPresent(view);
        if (removed == null) {
            return;
        }
        this.updateDrawerHandlesVisibility();
        this.drawerWindowUI.doLayout();
        for (DrawerUI drawerUI : this.drawerWindowUI.expandedDrawers()) {
            drawerUI.revalidate();
        }
    }

    private void assertKnownView(int viewIndex) {
        if (!$assertionsDisabled && viewIndex < 0) {
            throw new AssertionError();
        }
    }

    public void restore(View view) {
        Drawer drawer = this.drawerFrom(view);
        if (drawer != null) {
            this.drawerWindowUI.restoreWithoutAnimation(drawer);
        }
    }

    public Component getMinimizerTray() {
        return this.drawerWindowUI.bottomComponent();
    }

    public boolean showing(View view) {
        Drawer drawer = this.drawerFrom(view);
        return drawer != null && !drawer.state().equals((Object)DrawerConfig.State.HIDDEN) && !drawer.state().equals((Object)DrawerConfig.State.HIDDEN_AND_MINIMIZED) && !drawer.state().equals((Object)DrawerConfig.State.MINIMIZED);
    }

    public void show(View view) {
        Drawer drawer = this.drawerFrom(view);
        if (drawer != null) {
            this.drawerWindowUI.show(drawer);
        }
    }

    public void hide(View view) {
        Drawer drawer = this.drawerFrom(view);
        if (this.drawerWindowUI != null && drawer != null) {
            this.drawerWindowUI.hide(drawer);
        }
    }

    private Drawer drawerFrom(View view) {
        int index = this.model.indexOf(view);
        return index >= 0 ? this.model.drawerAt(index) : null;
    }

    public View undecorateIfNecessary(DockableWindow dockable) {
        Drawer drawer = this.drawerFrom(dockable);
        if (drawer == null) {
            return null;
        }
        return drawer.viewWithoutDecoration();
    }

    public void togglePanelsWithAnimation(List<View> toExpand, List<View> toCollapse) {
        this.drawerWindowUI.toggleWithAnimation(this.drawers(toExpand), this.drawers(toCollapse));
    }

    public void togglePanelsWithoutAnimation(View toExpand, View toCollapse) {
        this.togglePanelsWithoutAnimation(Collections.singletonList(toExpand), Collections.singletonList(toCollapse));
    }

    public void togglePanelsWithoutAnimation(List<View> toExpand, List<View> toCollapse) {
        this.drawerWindowUI.toggleWithoutAnimation(this.drawers(toExpand), this.drawers(toCollapse));
    }

    private List<DrawerUI> drawers(List<View> views) {
        this.assertNotNewViews(views);
        if (views == null) {
            return null;
        }
        ArrayList<DrawerUI> drawers = new ArrayList<DrawerUI>();
        for (View view : views) {
            DrawerUI drawerUI = this.drawerUIFrom(view);
            if (drawerUI == null) continue;
            drawers.add(drawerUI);
        }
        return drawers;
    }

    private DrawerUI drawerUIFrom(View view) {
        Drawer drawer = this.drawerFrom(view);
        return drawer != null ? drawer.drawerUI() : null;
    }

    private void assertNotNewViews(List<View> views) {
        if (!$assertionsDisabled && views != null && !this.model.views().containsAll(views)) {
            throw new AssertionError();
        }
    }

    public boolean accessibleDrawer() {
        for (Drawer drawer : this.model.drawers()) {
            if (!drawer.accessible()) continue;
            return true;
        }
        return false;
    }

    public List<Integer> drawerDockableStatuses(Object view) {
        ArrayList<Integer> l = new ArrayList<Integer>();
        for (Drawer drawer : this.model.drawers()) {
            if (!view.equals(drawer.view())) continue;
            l.add(drawer.dockableStatus());
        }
        return l;
    }

    public void clientVisible(Object view, boolean visible, int flags) {
        for (Drawer drawer : this.model.drawers()) {
            if (!view.equals(drawer.view())) continue;
            drawer.clientVisible(visible, flags);
        }
    }

    @Override
    public void saveLayout(PropertyAccess p) {
        StructuredPropertyAccess root = (StructuredPropertyAccess)p;
        root.setBooleanProperty(HIDE_HANDLE_IF_ONLY_ONE_DRAWER_SHOWN_PROPERTY, this.hideHandleIfOnlyOneDrawerShown);
        root.setBooleanProperty(EXPAND_DRAWER_ON_ACTIVATION, this.expandDrawerOnActivation);
        for (Drawer drawer : this.model.drawers()) {
            root.appendChild(this.drawerProperties(drawer));
        }
        if (this.drawerWindowUI != null) {
            root.appendChild(this.panelProperties());
        } else if (this.savedPanelLayout != null) {
            root.appendChild(this.savedPanelLayout);
        }
        StructuredPropertyAccess userProperties = this.newPropertyAccess(USER_PROPERTY);
        this.decorated.saveLayout(userProperties);
        root.appendChild(userProperties);
    }

    private StructuredPropertyAccess drawerProperties(Drawer drawer) {
        StructuredPropertyAccess p = this.newPropertyAccess(DRAWER_PROPERTY);
        drawer.saveLayout(p);
        p.appendChild(this.viewProperties(drawer.view()));
        return p;
    }

    private StructuredPropertyAccess viewProperties(View view) {
        StructuredPropertyAccess p = this.newPropertyAccess(VIEW_PROPERTY);
        view.saveLayout(p);
        return p;
    }

    private StructuredPropertyAccess panelProperties() {
        StructuredPropertyAccess p = this.newPropertyAccess(PANEL_PROPERTY);
        this.drawerWindowUI.beStored(p);
        return p;
    }

    @Override
    public void loadLayout(PropertyAccess p) {
        StructuredPropertyAccess root = (StructuredPropertyAccess)p;
        this.mustHideHandle(root.getBooleanProperty(HIDE_HANDLE_IF_ONLY_ONE_DRAWER_SHOWN_PROPERTY, false));
        this.mustExpandDrawerOnActivation(root.getBooleanProperty(EXPAND_DRAWER_ON_ACTIVATION, false));
        Iterator children = root.getChildNodes(DRAWER_PROPERTY);
        while (children.hasNext()) {
            ViewId viewId;
            View view;
            StructuredPropertyAccess drawerProperties = (StructuredPropertyAccess)children.next();
            DrawerConfig drawerConfig = Drawer.loadConfig(drawerProperties);
            if (drawerConfig.uniqueName() == null || (view = this.view(viewId = new ViewId(drawerConfig.uniqueName()))) == null) continue;
            view.loadLayout(this.viewProperties(drawerProperties));
            this.model.addDrawer(view, drawerConfig).loadLayout(drawerProperties);
        }
        this.savedPanelLayout = root.getChildNode(PANEL_PROPERTY);
        StructuredPropertyAccess userProperties = root.getChildNode(USER_PROPERTY);
        if (userProperties != null) {
            this.decorated.loadLayout(userProperties);
        }
    }

    private View view(ViewId viewId) {
        DockableFactory factory = DockStation.getDockStation().lookupFactory(viewId);
        if (factory == null) {
            return null;
        }
        if (factory instanceof BaseDockableFactory) {
            return ((BaseDockableFactory)factory).lookupView(viewId);
        }
        return (View)((Object)factory.getDockable(viewId));
    }

    private StructuredPropertyAccess viewProperties(StructuredPropertyAccess drawerProperties) {
        StructuredPropertyAccess p = drawerProperties.getChildNode(VIEW_PROPERTY);
        if (p == null) {
            p = this.newPropertyAccess(VIEW_PROPERTY);
        }
        return p;
    }

    private StructuredPropertyAccess newPropertyAccess(String name) {
        return new DefaultStructuredPropertyAccess(name);
    }

    public List<View> drawerViews() {
        ArrayList<View> views = new ArrayList<View>();
        for (Drawer drawer : this.model.drawers()) {
            views.add(drawer.viewWithoutDecoration());
        }
        return views;
    }

    @Override
    public void updateVisibleActions(UpdateMessage updateMessage) {
        List<View> views = this.drawerViews();
        for (View v : views) {
            v.updateVisibleActions(updateMessage);
        }
    }

    static boolean mav$moreThanOneVisibleDrawer(DrawerWindow drawerWindow) {
        return drawerWindow.moreThanOneVisibleDrawer();
    }

    static List ra$delegates(DrawerWindow drawerWindow) {
        return drawerWindow.delegates;
    }

    private class DrawerController
    implements Controller {
        public boolean handleEvent(IdeAction action, Context context) {
            if (this.eventHandledByDelegates(action, context)) {
                return true;
            }
            if (this.unimplementedHandled(action)) {
                return true;
            }
            if (this.minimizeHandled(action, context)) {
                return true;
            }
            return this.closeHandled(action, context);
        }

        private boolean unimplementedHandled(IdeAction action) {
            if (!this.isUnimplementedAction(action)) {
                return false;
            }
            action.setEnabled(false);
            return true;
        }

        private boolean minimizeHandled(IdeAction action, Context context) {
            if (!this.isMinimizeAction(action)) {
                return false;
            }
            DrawerWindow.this.minimize(this.view(context));
            return true;
        }

        private boolean closeHandled(IdeAction action, Context context) {
            if (!this.isCloseAction(action)) {
                return false;
            }
            DrawerWindow.this.removeIfPresent(this.view(context));
            return true;
        }

        private View view(Context context) {
            return context.getView();
        }

        private boolean eventHandledByDelegates(IdeAction action, Context context) {
            if (DrawerWindow.ra$delegates(DrawerWindow.this).isEmpty()) {
                return false;
            }
            for (Controller delegate : DrawerWindow.ra$delegates(DrawerWindow.this)) {
                if (delegate == null || !delegate.handleEvent(action, context)) continue;
                return true;
            }
            return false;
        }

        public boolean update(IdeAction action, Context context) {
            if (this.updateHandledByDelegates(action, context)) {
                return true;
            }
            if (this.unimplementedUpdated(action)) {
                return true;
            }
            if (this.minimizeUpdated(action)) {
                return true;
            }
            return this.closeUpdated(action);
        }

        private boolean updateHandledByDelegates(IdeAction action, Context context) {
            if (DrawerWindow.ra$delegates(DrawerWindow.this).isEmpty()) {
                return false;
            }
            for (Controller delegate : DrawerWindow.ra$delegates(DrawerWindow.this)) {
                if (delegate == null || !delegate.update(action, context)) continue;
                return true;
            }
            return false;
        }

        private boolean unimplementedUpdated(IdeAction action) {
            if (!this.isUnimplementedAction(action)) {
                return false;
            }
            action.setEnabled(false);
            return true;
        }

        private boolean minimizeUpdated(IdeAction action) {
            if (!this.isMinimizeAction(action)) {
                return false;
            }
            this.disableIfOnlyOneVisibleDrawer(action);
            return true;
        }

        private boolean closeUpdated(IdeAction action) {
            if (!this.isCloseAction(action)) {
                return false;
            }
            this.disableIfOnlyOneVisibleDrawer(action);
            return true;
        }

        private void disableIfOnlyOneVisibleDrawer(IdeAction action) {
            action.setEnabled(DrawerWindow.mav$moreThanOneVisibleDrawer(DrawerWindow.this));
        }

        private boolean isUnimplementedAction(IdeAction action) {
            int commandId = action.getCommandId();
            return commandId == RESTORE_ACTION_ID || commandId == MOVE_ACTION_ID || commandId == SIZE_ACTION_ID || commandId == MAXIMIZE_ACTION_ID || commandId == FLOAT_ACTION_ID;
        }

        private boolean isMinimizeAction(IdeAction action) {
            return action.getCommandId() == MINIMIZE_ACTION_ID;
        }

        private boolean isCloseAction(IdeAction action) {
            return action.getCommandId() == CLOSE_ACTION_ID;
        }

        private DrawerController() {
        }

        DrawerController(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

