/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.dialogs;

import java.awt.Dimension;
import javax.swing.JDialog;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.dialogs.DialogRunnerCallback;
import oracle.ide.dialogs.DialogSizeKeeper;

public class SizeKeeperCallback
implements DialogRunnerCallback {
    private final String _key;

    public SizeKeeperCallback(String key) {
        this._key = key;
    }

    public void dialogAboutToRun(JDialog dlg) {
        DialogSizeKeeper.attachToComponent(dlg, this._key);
        if (dlg instanceof JEWTDialog) {
            JEWTDialog jewtDialog = (JEWTDialog)dlg;
            String swidth = Ide.getProperty(this._key + ".width");
            String sheight = Ide.getProperty(this._key + ".height");
            if (swidth != null && sheight != null) {
                Dimension initialSize = new Dimension(Integer.parseInt(swidth), Integer.parseInt(sheight));
                jewtDialog.setMaximumInitialSize(initialSize);
                jewtDialog.setMinimumSize(jewtDialog.getPreferredSize());
                jewtDialog.setPreferredSize(initialSize);
            }
        }
    }

    public String getKey() {
        return this._key;
    }
}

