/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.dialogs;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.Timer;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.dialogs.DialogUtil;
import oracle.javatools.util.ModelUtil;

public class ProgressBar
implements ActionListener,
Runnable {
    private Component _parent;
    private final JLabel _progressLabel;
    private String _progressText;
    private final JLabel _stepLabel;
    private String _stepText;
    private JProgressBar _progressBar;
    private boolean _useBusyBar;
    private JEWTDialog _statusDialog;
    private String _dialogTitle;
    private int _completionStatus;
    private final Timer _labelTimer;
    private final Timer _completionTimer;
    private boolean _userCancelled;
    private Runnable _runnable;
    private long _current;
    private long _lastPause;
    private boolean _done;
    private boolean _canCancel;
    private final JPanel _statusPanel;

    private void $init$() {
        this._progressLabel = new JLabel();
        this._stepLabel = new JLabel();
        this._labelTimer = new Timer(1, null);
        this._completionTimer = new Timer(1, null);
        this._current = 0L;
        this._lastPause = 0L;
        this._done = false;
        this._canCancel = true;
        this._statusPanel = new JPanel(new GridBagLayout());
    }

    public ProgressBar(Component parent, String dialogTitle, Runnable runnable, boolean useBusyBar) {
        this.$init$();
        this._parent = parent;
        this._dialogTitle = dialogTitle;
        this._runnable = runnable;
        this._useBusyBar = useBusyBar;
    }

    public void setRunnable(Runnable runnable) {
        this._runnable = runnable;
    }

    public void setCancelable(boolean canCancel) {
        this._canCancel = canCancel;
    }

    public boolean isCancelable() {
        return this._canCancel;
    }

    public void start(String initialText, String stepText) {
        this.start(initialText, stepText, 0, 100);
    }

    public void start(String initialText, String stepText, int delay) {
        this.start(initialText, stepText, 0, 100, delay);
    }

    public void start(String initialText, String stepText, int min, int max) {
        this.start(initialText, stepText, min, max, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(String initialText, String stepText, int min, int max, int delay) {
        ProgressBar progressBar = this;
        synchronized (progressBar) {
            this._done = false;
        }
        this._progressText = initialText;
        this._stepText = stepText;
        this._progressLabel.setText(this._progressText);
        this._progressLabel.setLabelFor(this._progressBar);
        this._stepLabel.setText(this._stepText);
        this._progressBar = new JProgressBar(min, max);
        if (!this._useBusyBar) {
            this._progressBar.setValue(0);
        }
        GridBagConstraints constraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0);
        this._statusPanel.add((Component)this._progressLabel, constraints);
        constraints.gridy = 1;
        this._statusPanel.add((Component)this._progressBar, constraints);
        if (this._useBusyBar) {
            this._progressBar.setIndeterminate(true);
        } else {
            this._progressBar.setIndeterminate(false);
        }
        constraints.gridy = 2;
        this._statusPanel.add((Component)this._stepLabel, constraints);
        constraints.gridy = 3;
        this._statusPanel.add(Box.createHorizontalStrut(300), constraints);
        this._labelTimer.addActionListener(this);
        this._labelTimer.setRepeats(true);
        this._completionTimer.addActionListener(this);
        this._completionTimer.setRepeats(false);
        this._userCancelled = false;
        try {
            this._statusDialog = ProgressDialog.createDialog(this._parent, this._dialogTitle, this._canCancel);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this._statusDialog == null) {
            return;
        }
        this._statusDialog.setContent((Component)this._statusPanel);
        Thread thread = new Thread((Runnable)this, "ProgressBarThread");
        thread.setPriority(5);
        this._statusDialog.addWindowListener((WindowListener)new 1());
        thread.start();
        boolean done = false;
        if (delay > 0) {
            ProgressBar progressBar2 = this;
            synchronized (progressBar2) {
                try {
                    this.wait(delay);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                done = this._done;
            }
        }
        if (!done) {
            this._userCancelled = this._statusDialog.runDialog() ^ true;
        }
        this.setDoneStatus();
        this._statusDialog.dispose();
        this._statusPanel.removeAll();
        this._statusDialog = null;
    }

    public void updateProgress(int completionStatus, String progressText, String stepText) {
        if (this._userCancelled) {
            return;
        }
        if (this._progressBar == null) {
            return;
        }
        this._completionStatus = completionStatus;
        if (ModelUtil.hasLength((String)progressText)) {
            this._progressText = progressText;
        }
        if (ModelUtil.hasLength((String)stepText)) {
            this._stepText = stepText;
        }
        this._labelTimer.start();
    }

    public int getCompletionStatus() {
        return this._completionStatus;
    }

    public void updateProgress(String progressText, String stepText) {
        if (!this._userCancelled) {
            if (ModelUtil.hasLength((String)progressText)) {
                this._progressText = progressText;
            }
            if (ModelUtil.hasLength((String)stepText)) {
                this._stepText = stepText;
            }
            this._labelTimer.start();
        }
    }

    public boolean hasUserCancelled() {
        if (this._userCancelled) {
            this.setDoneStatus();
        }
        return this._userCancelled;
    }

    public void sleepForUIToRepaint() {
        if (this._lastPause == 0L) {
            this._current = this._lastPause = System.currentTimeMillis();
        } else {
            this._current = System.currentTimeMillis();
            long elapsed = this._current - this._lastPause;
            if (elapsed > 1000L) {
                try {
                    Thread.sleep(100);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this._lastPause = this._current;
            }
        }
    }

    public synchronized void waitUntilDone() {
        while (!this._done) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.notifyAll();
    }

    public synchronized void setDoneStatus() {
        this._done = true;
        this.notifyAll();
        this.end();
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this._labelTimer) {
            if (ModelUtil.hasLength((String)this._progressText)) {
                this._progressLabel.setText(this._progressText);
            }
            if (ModelUtil.hasLength((String)this._stepText)) {
                this._stepLabel.setText(this._stepText);
            }
            if (this._progressBar != null) {
                this._progressBar.setValue(this._completionStatus);
            }
        } else if (source == this._completionTimer) {
            if (this._statusDialog != null && this._statusDialog.isVisible()) {
                this._statusDialog.setVisible(false);
            }
            this.stopAndDetach(this._labelTimer);
            this.stopAndDetach(this._completionTimer);
        }
    }

    private void stopAndDetach(Timer timer) {
        timer.stop();
        timer.removeActionListener(this);
    }

    public void run() {
        if (this._userCancelled) {
            return;
        }
        this._runnable.run();
    }

    private void end() {
        this._completionTimer.start();
    }

    static JEWTDialog ra$_statusDialog(ProgressBar progressBar) {
        return progressBar._statusDialog;
    }

    static boolean ra$_done(ProgressBar progressBar) {
        return progressBar._done;
    }

    final class 1
    extends WindowAdapter {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void windowOpened(WindowEvent e) {
            JEWTDialog dialog = ProgressBar.ra$_statusDialog(ProgressBar.this);
            ProgressBar progressBar = ProgressBar.this;
            synchronized (progressBar) {
                if (ProgressBar.ra$_done(ProgressBar.this) && dialog != null) {
                    dialog.setVisible(false);
                }
            }
            e.getWindow().removeWindowListener(this);
        }
    }

    private static class ProgressDialog
    extends JEWTDialog {
        static ProgressDialog createDialog(Component parent, String title, boolean canCancel) {
            ProgressDialog dlg = null;
            Dialog dialog = DialogUtil.getAncestorDialog(parent);
            if (dialog != null) {
                dlg = new ProgressDialog(dialog, title, canCancel);
            } else {
                Frame frame = DialogUtil.getAncestorFrame(parent);
                if (frame != null) {
                    dlg = new ProgressDialog(frame, title, canCancel);
                }
            }
            return dlg;
        }

        private static int _getButtonMask(boolean canCancel) {
            return canCancel ? 2 : 0;
        }

        private ProgressDialog(Dialog dlg, String title, boolean canCancel) {
            super(dlg, title, ProgressDialog._getButtonMask(canCancel));
            this._init(canCancel);
        }

        private ProgressDialog(Frame frame, String title, boolean canCancel) {
            super(frame, title, ProgressDialog._getButtonMask(canCancel));
            this._init(canCancel);
        }

        private void _init(boolean canCancel) {
            this.setDefaultButton(ProgressDialog._getButtonMask(canCancel));
            if (!canCancel) {
                this.setDefaultCloseOperation(0);
            }
        }

        protected void dismissDialog(boolean cancelled) {
            if (this.getDefaultCloseOperation() != 0) {
                super.dismissDialog(cancelled);
            }
        }

        public void dispose() {
            super.dispose();
        }

        public void removeNotify() {
            super.removeNotify();
        }
    }
}

