/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls.customtab;

import java.awt.Rectangle;
import javax.swing.Icon;
import oracle.ide.util.BitField;

public abstract class CustomTabPage {
    private static final int FLAG_COMPRESSED = 1;
    private static final int FLAG_ENABLED = 2;
    private static final int FLAG_DIRTY = 4;
    private static final int FLAG_HIGHLIGHTED = 8;
    private static final int FLAG_VISIBLE = 16;
    private static final int FLAG_CONDENSED = 32;
    private static final int FLAG_CLOSEABLE = 64;
    private final Rectangle _rectangle;
    private int _flags;

    private void $init$() {
        this._rectangle = new Rectangle();
        this._flags = 82;
    }

    public abstract Icon getIcon();

    public abstract String getLabel();

    public abstract String getLongLabel();

    public abstract String getTooltip();

    public CustomTabPage() {
        this.$init$();
    }

    public final Rectangle getBounds() {
        return this._rectangle;
    }

    public final void setBounds(int x, int y, int width, int height) {
        this._rectangle.setBounds(x, y, width, height);
    }

    private int getFlags() {
        return this._flags;
    }

    public void setFlags(int flags) {
        this._flags = flags;
    }

    private boolean hasFlag(int flag) {
        return BitField.isSet(this.getFlags(), flag);
    }

    private void setFlag(int mask, boolean set) {
        int flags = this.getFlags();
        int newFlags = set ? BitField.set(flags, mask) : BitField.unset(flags, mask);
        this.setFlags(newFlags);
    }

    public boolean isCompressed() {
        return this.hasFlag(1);
    }

    public void setCompressed(boolean compressed) {
        this.setFlag(1, compressed);
    }

    public void setEnabled(boolean enabled) {
        this.setFlag(2, enabled);
    }

    public boolean isEnabled() {
        return this.hasFlag(2);
    }

    public void setDirty(boolean dirty) {
        this.setFlag(4, dirty);
    }

    public boolean isDirty() {
        return this.hasFlag(4);
    }

    public void setHighlighted(boolean highlighted) {
        this.setFlag(8, highlighted);
    }

    public boolean isHighlighted() {
        return this.hasFlag(8);
    }

    public boolean isVisible() {
        return this.hasFlag(16);
    }

    public void setVisible(boolean visible) {
        this.setFlag(16, visible);
    }

    public boolean isCondensed() {
        return this.hasFlag(32);
    }

    public void setCondensed(boolean condensed) {
        this.setFlag(32, condensed);
    }

    public boolean isCloseable() {
        return this.hasFlag(64);
    }

    public void setCloseable(boolean closeable) {
        this.setFlag(64, closeable);
    }
}

