/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.TreePath;
import oracle.ide.controls.TreeTableModel;

public class TreeTableModelAdapter
extends AbstractTableModel {
    JTree tree;
    TreeTableModel treeTableModel;
    private boolean coalescingEnabled;
    private boolean scheduled;

    public TreeTableModelAdapter(TreeTableModel treeTableModel, JTree tree) {
        this.tree = tree;
        this.treeTableModel = treeTableModel;
        tree.addTreeExpansionListener(new 1());
        treeTableModel.addTreeModelListener(new 2());
    }

    public int getColumnCount() {
        return this.treeTableModel.getColumnCount();
    }

    public String getColumnName(int column) {
        return this.treeTableModel.getColumnName(column);
    }

    public Class getColumnClass(int column) {
        return this.treeTableModel.getColumnClass(column);
    }

    public int getRowCount() {
        return this.tree.getRowCount();
    }

    protected Object nodeForRow(int row) {
        TreePath treePath = this.tree.getPathForRow(row);
        if (treePath == null) {
            return null;
        }
        return treePath.getLastPathComponent();
    }

    public Object getValueAt(int row, int column) {
        Object node = this.nodeForRow(row);
        if (node == null) {
            return null;
        }
        return this.treeTableModel.getValueAt(node, column);
    }

    public boolean isCellEditable(int row, int column) {
        Object node = this.nodeForRow(row);
        if (node == null) {
            return false;
        }
        return this.treeTableModel.isCellEditable(node, column);
    }

    public void setValueAt(Object value, int row, int column) {
        Object node = this.nodeForRow(row);
        if (node == null) {
            return;
        }
        this.treeTableModel.setValueAt(value, node, column);
    }

    protected void delayedFireTableDataChanged() {
        if (!this.coalescingEnabled || !this.scheduled) {
            this.scheduled = true;
            SwingUtilities.invokeLater(new 3());
        }
    }

    public void setCoalescingEnabled(boolean coalesce) {
        this.coalescingEnabled = coalesce;
    }

    public boolean isCoalescingEnabled() {
        return this.coalescingEnabled;
    }

    static void wa$scheduled(TreeTableModelAdapter treeTableModelAdapter, boolean bl) {
        treeTableModelAdapter.scheduled = bl;
    }

    final class 1
    implements TreeExpansionListener {
        public void treeExpanded(TreeExpansionEvent event) {
            TreeTableModelAdapter.this.fireTableDataChanged();
        }

        public void treeCollapsed(TreeExpansionEvent event) {
            TreeTableModelAdapter.this.fireTableDataChanged();
        }
    }

    final class 2
    implements TreeModelListener {
        public void treeNodesChanged(TreeModelEvent e) {
            TreeTableModelAdapter.this.delayedFireTableDataChanged();
        }

        public void treeNodesInserted(TreeModelEvent e) {
            TreeTableModelAdapter.this.delayedFireTableDataChanged();
        }

        public void treeNodesRemoved(TreeModelEvent e) {
            TreeTableModelAdapter.this.delayedFireTableDataChanged();
        }

        public void treeStructureChanged(TreeModelEvent e) {
            TreeTableModelAdapter.this.delayedFireTableDataChanged();
        }
    }

    final class 3
    implements Runnable {
        public void run() {
            TreeTableModelAdapter.wa$scheduled(TreeTableModelAdapter.this, false);
            TreeTableModelAdapter.this.fireTableRowsUpdated(0, TreeTableModelAdapter.this.getRowCount() - 1);
        }
    }
}

