/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.ide.controls.SortedTableModel;
import oracle.ide.resource.ControlsArb;

public class SortedJTable
extends JTable {
    private static Icon arrowUp;
    private static Icon arrowDown;
    private int _curcol;
    private boolean _curascending;
    private final TableModelListener tableModelListener;

    private void $init$() {
        this.tableModelListener = new 1();
    }

    public SortedJTable(SortedTableModel model, int col, boolean ascending) {
        super(model);
        this.$init$();
        2 listMouseListener = new 2();
        3 headerRenderer = new 3();
        headerRenderer.setHorizontalAlignment(0);
        JTableHeader th = this.getTableHeader();
        th.addMouseListener(listMouseListener);
        th.setDefaultRenderer(headerRenderer);
        this.sortData(col, ascending);
    }

    public SortedJTable(SortedTableModel model, int col) {
        this(model, col, true);
    }

    public SortedJTable(SortedTableModel model) {
        this(model, 0, true);
    }

    public void setModel(TableModel model) {
        TableModel oldModel = this.getModel();
        if (oldModel instanceof SortedTableModel) {
            oldModel.removeTableModelListener(this.tableModelListener);
        }
        super.setModel(model);
        if (model instanceof SortedTableModel) {
            model.addTableModelListener(this.tableModelListener);
        }
    }

    protected int getSortColumn() {
        return this._curcol;
    }

    protected void setSortColumn(int col) {
        this._curcol = col;
    }

    protected boolean isAscending() {
        return this._curascending;
    }

    protected void setAscending(boolean ascending) {
        this._curascending = ascending;
    }

    protected Icon getColumnSortIcon(int col) {
        if (col != this._curcol) {
            return this.getUnsortedIcon();
        }
        return this._curascending ? this.getSortAscendingIcon() : this.getSortDescendingIcon();
    }

    protected Icon getUnsortedIcon() {
        return null;
    }

    protected Icon getSortAscendingIcon() {
        if (arrowUp == null) {
            arrowUp = ControlsArb.getIcon(12);
        }
        return arrowUp;
    }

    protected Icon getSortDescendingIcon() {
        if (arrowDown == null) {
            arrowDown = ControlsArb.getIcon(13);
        }
        return arrowDown;
    }

    protected void sortData(int col, boolean ascending) {
        this._curcol = col;
        this._curascending = ascending;
        if (this.sortByColumn(this._curcol, this._curascending)) {
            this.fireTableDataChanged();
        }
    }

    private boolean sortByColumn(int col, boolean ascending) {
        TableModel model = this.getModel();
        if (model instanceof SortedTableModel) {
            return ((SortedTableModel)model).sortByColumn(col, ascending);
        }
        return false;
    }

    private String getToolTipText(int col) {
        TableModel model = this.getModel();
        if (model instanceof SortedTableModel) {
            return ((SortedTableModel)model).getToolTipText(col);
        }
        return null;
    }

    private void fireTableDataChanged() {
        TableModel model = this.getModel();
        if (model instanceof AbstractTableModel) {
            ((AbstractTableModel)model).fireTableDataChanged();
        }
    }

    static int ra$_curcol(SortedJTable sortedJTable) {
        return sortedJTable._curcol;
    }

    static boolean ra$_curascending(SortedJTable sortedJTable) {
        return sortedJTable._curascending;
    }

    static boolean mav$sortByColumn(SortedJTable sortedJTable, int n, boolean bl) {
        return sortedJTable.sortByColumn(n, bl);
    }

    static String mav$getToolTipText(SortedJTable sortedJTable, int n) {
        return sortedJTable.getToolTipText(n);
    }

    final class 1
    implements TableModelListener {
        public void tableChanged(TableModelEvent e) {
            SortedJTable.mav$sortByColumn(SortedJTable.this, SortedJTable.ra$_curcol(SortedJTable.this), SortedJTable.ra$_curascending(SortedJTable.this));
        }
    }

    final class 2
    extends MouseAdapter {
        public void mouseClicked(MouseEvent e) {
            TableColumnModel columnModel = SortedJTable.this.getColumnModel();
            int viewColumn = columnModel.getColumnIndexAtX(e.getX());
            int column = SortedJTable.this.convertColumnIndexToModel(viewColumn);
            if (e.getClickCount() % 2 == 1 && column != -1) {
                SortedJTable.this.sortData(column, column == SortedJTable.ra$_curcol(SortedJTable.this) ? SortedJTable.ra$_curascending(SortedJTable.this) ^ true : true);
            }
        }
    }

    final class 3
    extends DefaultTableCellRenderer {
        private int _col;

        public String getToolTipText(MouseEvent event) {
            String tip = SortedJTable.mav$getToolTipText(SortedJTable.this, this._col);
            return tip != null ? tip : super.getToolTipText(event);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            int col;
            JTableHeader header = SortedJTable.this.getTableHeader();
            if (header != null) {
                this.setForeground(header.getForeground());
                this.setBackground(header.getBackground());
                this.setFont(header.getFont());
            }
            this._col = col = SortedJTable.this.convertColumnIndexToModel(column);
            this.setIcon(SortedJTable.this.getColumnSortIcon(col));
            this.setText((String)value);
            this.setHorizontalTextPosition(10);
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            return this;
        }
    }
}

