/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JViewport;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.ide.IdeConstants;
import oracle.ide.controls.DropDownMenuButton;
import oracle.ide.controls.SmallSquareButton;
import oracle.ide.controls.SmallSquareDropDownMenuButton;
import oracle.ide.controls.customtab.AutoRepeatButtonModel;
import oracle.ide.controls.customtab.CustomTab;
import oracle.ide.controls.customtab.CustomTabPage;
import oracle.ide.controls.customtab.DefaultCustomTabPage;
import oracle.ide.editor.EditorManager;
import oracle.ide.keyboard.KeyUtil;
import oracle.ide.util.ModelUtil;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.themes.Themes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ScrollableTabBar
extends JComponent {
    private static final int GAP_BEFORE_BUTTONS = 4;
    private static final int MIN_BUTTON_HEIGHT = 3;
    private static final int GAP_BETWEEN_BUTTONS = 1;
    private static final int GAP_AFTER_BUTTONS = 3;
    private static final int GAP_ABOVE_BUTTONS = 2;
    private static final Dimension DIM_ZERO = new Dimension(0, 0);
    private static final Color SCROLL_BUTTON_FG_COLOR;
    private final CustomTab _tabs;
    private final JViewport _viewport;
    private final Box _buttonBox;
    private final AbstractButton _leftButton;
    private final AbstractButton _rightButton;
    private final AbstractButton _dropDownButton;
    private Component _customComponent;
    private ScrollMode _scrollMode;
    private boolean _hideSingleTab;

    static {
        Color textColor = Color.BLACK;
        SCROLL_BUTTON_FG_COLOR = new Color(textColor.getRed(), textColor.getGreen(), textColor.getBlue(), 100);
    }

    private void $init$() {
        this._scrollMode = ScrollMode.SWITCH_TABS;
        this._hideSingleTab = false;
    }

    public ScrollableTabBar() {
        this.$init$();
        this._tabs = this.createTabs();
        this._viewport = this.createViewport();
        this._viewport.setView(this._tabs);
        this._leftButton = this.createButton(7);
        this._rightButton = this.createButton(3);
        this._dropDownButton = this.createButton(5);
        this._buttonBox = this.createButtonBox();
        this.layoutButtonBox();
        this.updateButtonsAndTabVisibility();
        this.setLayout(null);
        this.add(this._buttonBox);
        this.add(this._viewport);
        this.createButtonListeners();
        this.createTabListeners();
    }

    public void removeScrollButtons() {
        this.remove(this._buttonBox);
    }

    public void setHideSingleTab(boolean hideSingleTab) {
        if (this._hideSingleTab != hideSingleTab) {
            this._hideSingleTab = hideSingleTab;
            this.updateButtonsAndTabVisibility();
            this.firePropertyChange("hideSingleTab", hideSingleTab ^ true, hideSingleTab);
        }
    }

    public boolean getHideSingleTab() {
        return this._hideSingleTab;
    }

    public void setCustomComponent(Component customComponent) {
        if (this._customComponent != null) {
            this.remove(this._customComponent);
            this._customComponent = null;
        }
        if (customComponent != null) {
            this.add(customComponent);
            this._customComponent = customComponent;
        }
        this.revalidate();
    }

    public Component getCustomComponent() {
        return this._customComponent;
    }

    public CustomTab getTabs() {
        return this._tabs;
    }

    public void setScrollMode(ScrollMode mode) {
        if (this._scrollMode != mode) {
            ScrollMode old = this._scrollMode;
            this._scrollMode = mode;
            this.firePropertyChange("scrollMode", (Object)old, (Object)mode);
        }
    }

    public ScrollMode getScrollMode() {
        return this._scrollMode;
    }

    public void showDropDownMenu() {
        this._dropDownButton.doClick();
    }

    private JViewport createViewport() {
        JViewport viewport = new JViewport();
        viewport.setOpaque(false);
        viewport.setFocusable(false);
        viewport.addComponentListener(new 1());
        return viewport;
    }

    private CustomTab createTabs() {
        CustomTab tabs = new CustomTab(3);
        tabs.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        tabs.setGapBetweenTabs(-1);
        tabs.setOffsetSelected(0);
        tabs.setOpaque(false);
        tabs.setPreferredSize(null);
        tabs.setCtrlClickCloseEnabled(true);
        tabs.setCompressible(true);
        return tabs;
    }

    private AbstractButton createButton(int direction) {
        AbstractButton scrollButton = direction == 5 ? new SmallSquareDropDownMenuButton() : new SmallSquareButton();
        scrollButton.setFocusable(false);
        scrollButton.setRolloverEnabled(false);
        scrollButton.setOpaque(false);
        scrollButton.setAlignmentY(1.0f);
        scrollButton.setMargin(new Insets(0, 0, 0, 0));
        scrollButton.setForeground(SCROLL_BUTTON_FG_COLOR);
        String tooltip = null;
        Icon icon = null;
        switch (direction) {
            case 7: {
                icon = OracleIcons.getIcon((String)"extras/left.gif");
                tooltip = KeyUtil.buildTooltip(70);
                break;
            }
            case 3: {
                icon = OracleIcons.getIcon((String)"extras/right.gif");
                tooltip = KeyUtil.buildTooltip(71);
                break;
            }
            case 5: {
                icon = OracleIcons.getIcon((String)"extras/down.gif");
                tooltip = KeyUtil.buildTooltip(EditorManager.SHOW_DROPDOWN_CMD_ID);
            }
        }
        scrollButton.setIcon(icon);
        scrollButton.setToolTipText(tooltip);
        if (direction == 3 || direction == 7) {
            scrollButton.setModel(new AutoRepeatButtonModel(400, 100));
        }
        return scrollButton;
    }

    private Box createButtonBox() {
        Box buttonBox = new Box(0);
        buttonBox.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
        buttonBox.setOpaque(false);
        buttonBox.setFocusable(false);
        return buttonBox;
    }

    private void layoutButtonBox() {
        this._buttonBox.add(Box.createHorizontalStrut(4));
        this._buttonBox.add(Box.createVerticalStrut(3));
        this._buttonBox.add(this._leftButton);
        this._buttonBox.add(Box.createHorizontalStrut(1));
        this._buttonBox.add(this._rightButton);
        this._buttonBox.add(Box.createHorizontalStrut(1));
        this._buttonBox.add(this._dropDownButton);
        this._buttonBox.add(Box.createHorizontalStrut(3));
    }

    public void ensureSelectedTabVisible() {
        int selectedPage = this._tabs.getSelectedPage();
        if (selectedPage != -1) {
            DefaultCustomTabPage page = (DefaultCustomTabPage)this._tabs.getPage(selectedPage);
            Dimension preferredSize = this._tabs.getPreferredSize();
            if (preferredSize != null) {
                Rectangle pageBounds = page.getBounds();
                Rectangle viewRect = this._viewport.getViewRect();
                if (pageBounds.x < viewRect.x) {
                    this._viewport.setViewPosition(new Point(Math.max(pageBounds.x, 0), 0));
                } else if (pageBounds.x + pageBounds.width > viewRect.x + viewRect.width) {
                    this._viewport.setViewPosition(new Point(pageBounds.x + pageBounds.width - viewRect.width, 0));
                }
            }
        }
    }

    private void updateButtonsAndTabVisibility() {
        boolean tabsVisible = this._tabs.getPageCount() >= (this._hideSingleTab ? 2 : 1);
        this._buttonBox.setVisible(tabsVisible);
        this._tabs.setVisible(tabsVisible);
        if (tabsVisible) {
            int selectedPage = this._tabs.getSelectedPage();
            if (selectedPage != -1) {
                this._leftButton.setEnabled(selectedPage > 0);
                this._rightButton.setEnabled(selectedPage < this._tabs.getPageCount() - 1);
            }
            this._dropDownButton.setEnabled(this._tabs.getPageCount() > 1);
        }
    }

    private void createButtonListeners() {
        this._leftButton.addActionListener(new 2());
        this._rightButton.addActionListener(new 3());
        this._dropDownButton.addItemListener(new 4());
    }

    private void createTabListeners() {
        this._tabs.addListDataListener(new 5());
        this._tabs.addPropertyChangeListener("model", new 6());
        this._tabs.addSelectionListener(new 7());
    }

    private void scroll(int direction) {
        if (this.getScrollMode() == ScrollMode.SCROLL) {
            this.scrollViewport(direction);
        } else {
            this.switchPage(direction);
        }
    }

    private void scrollViewport(int direction) {
        int pageAt;
        Point viewPosition = this._viewport.getViewPosition();
        int n = pageAt = direction == 2 ? this._tabs.getPageBefore(viewPosition.x) : this._tabs.getPageAfter(viewPosition.x);
        if (pageAt >= 0) {
            CustomTabPage page = this._tabs.getPage(pageAt);
            Rectangle pageBounds = page.getBounds();
            int newX = 0;
            if (direction == 2) {
                newX = pageBounds.x;
            } else {
                Dimension extentSize = this._viewport.getExtentSize();
                Dimension viewSize = this._viewport.getViewSize();
                newX = Math.min(pageBounds.x, viewSize.width - extentSize.width);
            }
            this._viewport.setViewPosition(new Point(newX, 0));
        }
    }

    private void switchPage(int direction) {
        int newPage = this._tabs.getSelectedPage() + (direction == 2 ? -1 : 1);
        if (newPage >= 0 && (direction == 2 || newPage < this._tabs.getPageCount())) {
            this._tabs.setSelectedPage(newPage);
            this.ensureSelectedTabVisible();
        }
    }

    private void setDropDownVisible(boolean visible) {
        block6: {
            DropDownMenuButton b = (DropDownMenuButton)this._dropDownButton;
            b.removeAllPopupItems();
            if (!visible) break block6;
            Dimension sizeScreen = this._dropDownButton.getToolkit().getScreenSize();
            List<JMenuItem> items = this.getTabPopupItems();
            int n = items.size();
            int nItemsMenuHeight = 0;
            for (JMenuItem item : items) {
                int nHeight = item.getPreferredSize().height;
                nItemsMenuHeight += nHeight;
            }
            if (nItemsMenuHeight < sizeScreen.height * 9 / 10) {
                n = items.size();
                int i = 0;
                while (i < n) {
                    JMenuItem item = items.get(i);
                    b.addPopupItem(item);
                    ++i;
                }
            } else {
                n = items.size();
                int nAvailableHeight = sizeScreen.height * 9 / 10;
                int nNbrSubMenus = nItemsMenuHeight / nAvailableHeight + 1;
                int nNbrElementsPerMenu = items.size() / nNbrSubMenus + 1;
                int nElementsInThisMenu = nNbrElementsPerMenu + 1;
                JMenu subMenu = null;
                int i = 0;
                while (i < n) {
                    JMenuItem item = items.get(i);
                    if (nElementsInThisMenu >= nNbrElementsPerMenu) {
                        String sFrom = item.getText();
                        int nTo = Math.min(i + nNbrElementsPerMenu, n) - 1;
                        JMenuItem itemTo = items.get(nTo);
                        String sTo = itemTo.getText();
                        subMenu = new JMenu(sFrom + " - " + sTo);
                        b.addPopupItem(subMenu);
                        nElementsInThisMenu = 0;
                    }
                    subMenu.add(item);
                    ++nElementsInThisMenu;
                    ++i;
                }
            }
        }
    }

    private List<JMenuItem> getTabPopupItems() {
        ArrayList<JMenuItem> list = new ArrayList<JMenuItem>();
        int tabCount = this._tabs.getPageCount();
        int i = 0;
        while (i < tabCount) {
            CustomTabPage tabPage = this._tabs.getPage(i);
            String text = tabPage.getLongLabel();
            if (!ModelUtil.hasLength((String)text)) {
                text = tabPage.getLabel();
            }
            8 action = new 8(text, tabPage.getIcon());
            action.putValue("pageNum", i);
            JMenuItem item = new JMenuItem(action);
            list.add(item);
            ++i;
        }
        Collections.sort(list, new 9());
        return list;
    }

    @Override
    public void doLayout() {
        Dimension size = this.getSize();
        Insets insets = this.getInsets();
        int w = size.width - (insets.left + insets.right);
        int h = size.height - (insets.top + insets.bottom);
        Dimension psTabs = this._tabs.isVisible() ? this._tabs.getPreferredSize() : DIM_ZERO;
        Dimension psButtons = this._buttonBox.isVisible() ? this._buttonBox.getPreferredSize() : DIM_ZERO;
        Dimension psCustom = this._customComponent == null || !this._customComponent.isVisible() ? DIM_ZERO : this._customComponent.getPreferredSize();
        Dimension msCustom = this._customComponent == null || !this._customComponent.isVisible() ? DIM_ZERO : this._customComponent.minimumSize();
        int wTabsViewport = psTabs.width;
        int wCustomComponent = psCustom.width;
        if (psTabs.width + psButtons.width + psCustom.width > w) {
            int wForCustom = w - psTabs.width - psButtons.width;
            if (wForCustom < msCustom.width) {
                wForCustom = msCustom.width;
            }
            wCustomComponent = wForCustom;
            wTabsViewport = w - psButtons.width - wCustomComponent;
        } else {
            wCustomComponent = w - psTabs.width - psButtons.width;
        }
        int y = insets.top;
        if (psTabs.height > 0 && h > psTabs.height && this._tabs.getPosition() == 3) {
            y = this.getHeight() - insets.bottom - psTabs.height;
        }
        this._viewport.setBounds(insets.left, y, wTabsViewport, psTabs.height);
        this._buttonBox.setBounds(this.getWidth() - insets.right - psButtons.width, y, psButtons.width, psButtons.height);
        if (this._customComponent != null) {
            this._customComponent.setBounds(insets.left + wTabsViewport, y, wCustomComponent, psCustom.height);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension ps = new Dimension();
        Insets insets = this.getInsets();
        Dimension psTabs = this._tabs.isVisible() ? this._tabs.getPreferredSize() : DIM_ZERO;
        Dimension psButtons = this._buttonBox.isVisible() ? this._buttonBox.getPreferredSize() : DIM_ZERO;
        Dimension psCustom = this._customComponent == null || !this._customComponent.isVisible() ? DIM_ZERO : this._customComponent.getPreferredSize();
        ps.width = insets.left + psTabs.width + psCustom.width + psButtons.width + insets.right;
        ps.height = insets.top + insets.bottom + Math.max(psTabs.height, Math.max(psCustom.height, psButtons.height));
        return ps;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Color c = IdeConstants.COLOR_IDE_LINES;
        if (Themes.isThemed()) {
            c = this._tabs.isFocused() ? Themes.getActiveTheme().getStateProperties("view", "active").getColor("bordercolor") : Themes.getActiveTheme().getStateProperties("view", "inactive").getColor("bordercolor");
        }
        Insets insets = this.getInsets();
        int y = insets.top;
        if (this._tabs.getPosition() == 1) {
            y = this._viewport.getHeight() - 1;
        }
        int x = insets.left + this._viewport.getWidth();
        if (this._customComponent != null) {
            x += this._customComponent.getWidth();
        }
        int x2 = this.getWidth() - insets.right;
        int y2 = y;
        g.setColor(c);
        g.drawLine(x, y, x2, y2);
    }

    static CustomTab ra$_tabs(ScrollableTabBar scrollableTabBar) {
        return scrollableTabBar._tabs;
    }

    static void mav$updateButtonsAndTabVisibility(ScrollableTabBar scrollableTabBar) {
        scrollableTabBar.updateButtonsAndTabVisibility();
    }

    static void mav$scroll(ScrollableTabBar scrollableTabBar, int n) {
        scrollableTabBar.scroll(n);
    }

    static void mav$setDropDownVisible(ScrollableTabBar scrollableTabBar, boolean bl) {
        scrollableTabBar.setDropDownVisible(bl);
    }

    final class 1
    extends ComponentAdapter {
        public void componentResized(ComponentEvent ce) {
            ScrollableTabBar.this.ensureSelectedTabVisible();
        }
    }

    final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent ae) {
            ScrollableTabBar.mav$scroll(ScrollableTabBar.this, 2);
        }
    }

    final class 3
    implements ActionListener {
        public void actionPerformed(ActionEvent ae) {
            ScrollableTabBar.mav$scroll(ScrollableTabBar.this, 4);
        }
    }

    final class 4
    implements ItemListener {
        public void itemStateChanged(ItemEvent e) {
            ScrollableTabBar.mav$setDropDownVisible(ScrollableTabBar.this, e.getStateChange() == 1);
        }
    }

    final class 5
    implements ListDataListener {
        public void contentsChanged(ListDataEvent e) {
            ScrollableTabBar.mav$updateButtonsAndTabVisibility(ScrollableTabBar.this);
        }

        public void intervalRemoved(ListDataEvent e) {
            ScrollableTabBar.mav$updateButtonsAndTabVisibility(ScrollableTabBar.this);
        }

        public void intervalAdded(ListDataEvent e) {
            ScrollableTabBar.mav$updateButtonsAndTabVisibility(ScrollableTabBar.this);
        }
    }

    final class 6
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {
            ScrollableTabBar.mav$updateButtonsAndTabVisibility(ScrollableTabBar.this);
        }
    }

    final class 7
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent e) {
            ScrollableTabBar.mav$updateButtonsAndTabVisibility(ScrollableTabBar.this);
        }
    }

    final class 8
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            JMenuItem mItem = (JMenuItem)e.getSource();
            AbstractAction aAction = (AbstractAction)mItem.getAction();
            int selPageNum = (Integer)aAction.getValue("pageNum");
            ScrollableTabBar.ra$_tabs(ScrollableTabBar.this).setSelectedPage(selPageNum);
            ScrollableTabBar.this.ensureSelectedTabVisible();
        }

        public 8(String string, Icon icon) {
            super(string, icon);
        }
    }

    final class 9
    implements Comparator {
        public int compare(JMenuItem item1, JMenuItem item2) {
            return String.CASE_INSENSITIVE_ORDER.compare(item1.getText(), item2.getText());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ScrollMode
    extends Enum<ScrollMode> {
        private static final /* synthetic */ ScrollMode[] $v;
        public static final /* enum */ ScrollMode SWITCH_TABS;
        public static final /* enum */ ScrollMode SCROLL;

        public static ScrollMode valueOf(String string) {
            return Enum.valueOf(ScrollMode.class, string);
        }

        public static final ScrollMode[] values() {
            return (ScrollMode[])$v.clone();
        }

        static {
            ScrollMode[] scrollModeArray = new ScrollMode[2];
            scrollModeArray[1] = SCROLL = new ScrollMode("SCROLL", 1);
            scrollModeArray[0] = SWITCH_TABS = new ScrollMode("SWITCH_TABS", 0);
            $v = scrollModeArray;
        }

        private ScrollMode(String string2, int n2) {
        }
    }
}

