/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.MenuElement;
import javax.swing.UIManager;
import oracle.ide.controls.MenuItem;
import oracle.ide.controls.ToggleAction;
import oracle.javatools.controls.PropertyChangeAdapter;

public class RadioMenuItem
extends JRadioButtonMenuItem {
    private boolean checkedForIcon;
    private boolean checkedForDisabledIcon;

    public RadioMenuItem(ToggleAction action) {
        super(action);
        this.setSelected(action.getState());
        action.listenForItemEvent(this);
    }

    protected void configurePropertiesFromAction(Action a) {
        Integer i;
        this.checkedForIcon = false;
        this.checkedForDisabledIcon = false;
        this.setText(a != null ? (String)a.getValue("Name") : null);
        this.setEnabled(a != null ? a.isEnabled() : true);
        if (a != null && (i = (Integer)a.getValue("MnemonicKey")) != null) {
            this.setMnemonic(i);
        }
    }

    protected PropertyChangeListener createActionPropertyChangeListener(Action a) {
        return new InnerPropertyChangeAdaptor(this, a);
    }

    public Icon getIcon() {
        Action a;
        if (!this.checkedForIcon && (a = this.getAction()) != null) {
            this.checkedForIcon = true;
            this.setIcon((Icon)a.getValue("SmallIcon"));
        }
        return super.getIcon();
    }

    public void setIcon(Icon icon) {
        this.checkedForIcon = true;
        super.setIcon(icon);
    }

    public void setPressedIcon(Icon icon) {
        if (!this.checkedForIcon) {
            this.getIcon();
        }
        super.setPressedIcon(icon);
    }

    public Icon getDisabledIcon() {
        Action a;
        if (!this.checkedForIcon) {
            this.getIcon();
        }
        if (!this.checkedForDisabledIcon && (a = this.getAction()) != null) {
            this.checkedForDisabledIcon = true;
            this.setDisabledIcon((Icon)a.getValue("DisabledIcon"));
        }
        return super.getDisabledIcon();
    }

    public void setDisabledIcon(Icon icon) {
        this.checkedForDisabledIcon = true;
        super.setDisabledIcon(icon);
    }

    public static Icon getRadioButtonMenuItemIcon() {
        return UIManager.getIcon("RadioButtonMenuItem.checkIcon");
    }

    public MenuElement[] getSubElements() {
        return MenuItem.EMPTY_MENU_ELEMENTS;
    }

    private static class InnerPropertyChangeAdaptor
    extends PropertyChangeAdapter {
        public InnerPropertyChangeAdaptor(AbstractButton adaptee, Action action) {
            super(adaptee, action);
        }

        protected void stateChanged(PropertyChangeEvent e) {
            RadioMenuItem adaptee = (RadioMenuItem)this.getAdaptee();
            Boolean toggledState = (Boolean)e.getNewValue();
            1 runnable = new 1(this, adaptee, toggledState);
            runnable.run();
        }

        final class 1
        implements Runnable {
            private final /* synthetic */ RadioMenuItem v$adaptee;
            private final /* synthetic */ Boolean v$toggledState;
            final /* synthetic */ InnerPropertyChangeAdaptor this$0;

            public void run() {
                if (this.v$adaptee.isSelected() != this.v$toggledState.booleanValue()) {
                    this.v$adaptee.setSelected(this.v$toggledState);
                }
            }

            public 1(InnerPropertyChangeAdaptor innerPropertyChangeAdaptor, RadioMenuItem radioMenuItem, Boolean bl) {
                this.v$toggledState = bl;
                this.v$adaptee = radioMenuItem;
                this.this$0 = innerPropertyChangeAdaptor;
            }
        }
    }
}

