/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;

public final class PentaLayout
implements LayoutManager2 {
    private static final int nCENTER = 0;
    private static final int nNORTH = 1;
    private static final int nSOUTH = 2;
    private static final int nWEST = 3;
    private static final int nEAST = 4;
    public static final Integer CENTER = 0;
    public static final Integer NORTH = 1;
    public static final Integer SOUTH = 2;
    public static final Integer WEST = 3;
    public static final Integer EAST = 4;
    public static final byte CORNER_NORTH_WEST = 8;
    public static final byte CORNER_NORTH_EAST = 4;
    public static final byte CORNER_SOUTH_WEST = 2;
    public static final byte CORNER_SOUTH_EAST = 1;
    public static final byte HORIZONTAL_STYLE = 15;
    public static final byte VERTICAL_STYLE = 0;
    public static final byte C_STYLE = 5;
    public static final byte T_STYLE = 12;
    private static final String[] BORDERLAYOUT_EQUIV = new String[]{"Center", "North", "South", "West", "East"};
    private int _hgap;
    private int _vgap;
    private Component[] _components;
    private byte _style;

    private void $init$() {
        this._components = new Component[5];
    }

    public PentaLayout() {
        this(15, 0, 0);
    }

    public PentaLayout(int hgap, int vgap) {
        this(15, hgap, vgap);
    }

    public PentaLayout(byte style, int hgap, int vgap) {
        this.$init$();
        this._style = style;
        this._hgap = hgap;
        this._vgap = vgap;
    }

    public int getHgap() {
        return this._hgap;
    }

    public void setHgap(int hgap) {
        this._hgap = hgap;
    }

    public int getVgap() {
        return this._vgap;
    }

    public void setVgap(int vgap) {
        this._vgap = vgap;
    }

    public void setStyle(byte style) {
        this._style = style;
    }

    public byte getStyle() {
        return this._style;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLayoutComponent(Component comp, Object constraints) {
        Object object = comp.getTreeLock();
        synchronized (object) {
            if (constraints != CENTER && constraints != NORTH && constraints != SOUTH && constraints != WEST && constraints != EAST) {
                throw new IllegalArgumentException("cannot add to layout: constraint must be one of the 5 predefined constraints");
            }
            this._components[((Integer)constraints).intValue()] = comp;
        }
    }

    public void addLayoutComponent(String name, Component comp) {
        this.addLayoutComponent(comp, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLayoutComponent(Component comp) {
        Object object = comp.getTreeLock();
        synchronized (object) {
            int i = 0;
            while (i < this._components.length) {
                if (this._components[i] == comp) {
                    this._components[i] = null;
                }
                ++i;
            }
        }
    }

    public Dimension minimumLayoutSize(Container target) {
        return this.getLayoutSize(target, 0);
    }

    public Dimension preferredLayoutSize(Container target) {
        return this.getLayoutSize(target, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dimension getLayoutSize(Container target, int nType) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Dimension d = new Dimension(0, 0);
            int i = 1;
            while (i < 5) {
                Component c = this._components[i];
                if (c != null && c.isVisible()) {
                    Dimension dComp;
                    switch (nType) {
                        case 0: {
                            dComp = c.getMinimumSize();
                            break;
                        }
                        case 1: {
                            dComp = c.getPreferredSize();
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException();
                        }
                    }
                    switch (i) {
                        case 1: 
                        case 2: {
                            d.height += dComp.height + this._vgap;
                            d.width = Math.max(d.width, dComp.width);
                            break;
                        }
                        case 3: 
                        case 4: {
                            d.width += dComp.width + this._hgap;
                            d.height = Math.max(d.height, dComp.height);
                            break;
                        }
                        case 0: {
                            d.width += dComp.width;
                            d.height += dComp.height;
                            break;
                        }
                    }
                }
                ++i;
            }
            Insets insets = target.getInsets();
            d.width += insets.left + insets.right;
            d.height += insets.top + insets.bottom;
            Dimension dimension = d;
            return dimension;
        }
    }

    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public float getLayoutAlignmentX(Container parent) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container parent) {
        return 0.5f;
    }

    public void invalidateLayout(Container target) {
    }

    private boolean hasStyle(byte mask) {
        return (this._style & mask) == mask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            boolean isCenterVisible;
            Dimension d;
            Insets insets = target.getInsets();
            int left = insets.left;
            int top = insets.top;
            int right = target.getWidth() - insets.right;
            int bottom = target.getHeight() - insets.bottom;
            int left2 = left;
            int top2 = top;
            int right2 = right;
            int bottom2 = bottom;
            int northGap = 0;
            int southGap = 0;
            int westGap = 0;
            int eastGap = 0;
            Component cNorth = this._components[1];
            Component cSouth = this._components[2];
            Component cWest = this._components[3];
            Component cEast = this._components[4];
            Component cCenter = this._components[0];
            if (cNorth != null && cNorth.isVisible()) {
                d = cNorth.getPreferredSize();
                top2 += d.height;
                northGap = this._vgap;
            }
            if (cSouth != null && cSouth.isVisible()) {
                d = cSouth.getPreferredSize();
                bottom2 -= d.height;
                southGap = this._vgap;
            }
            if (cWest != null && cWest.isVisible()) {
                d = cWest.getPreferredSize();
                left2 += d.width;
                westGap = this._hgap;
            }
            if (cEast != null && cEast.isVisible()) {
                d = cEast.getPreferredSize();
                right2 -= d.width;
                eastGap = this._hgap;
            }
            if (left2 >= right2) {
                right2 = left2;
            }
            if (top2 >= bottom2) {
                bottom2 = top2;
            }
            boolean bl = isCenterVisible = cCenter != null && cCenter.isVisible();
            if (!isCenterVisible) {
                if (top != top2) {
                    top2 = bottom2;
                } else if (left != left2) {
                    left2 = right2;
                } else if (bottom != bottom2) {
                    bottom2 = top2;
                } else if (right != right2) {
                    right2 = left2;
                }
            }
            if (cNorth != null && cNorth.isVisible()) {
                int x1 = this.hasStyle((byte)8) ? left : left2 + westGap;
                int x2 = this.hasStyle((byte)4) ? right : right2 - eastGap;
                cNorth.setBounds(x1, top, x2 - x1, top2 - top);
            }
            if (cSouth != null && cSouth.isVisible()) {
                int x1 = this.hasStyle((byte)2) ? left : left2 + westGap;
                int x2 = this.hasStyle((byte)1) ? right : right2 - eastGap;
                cSouth.setBounds(x1, bottom2, x2 - x1, bottom - bottom2);
            }
            if (cWest != null && cWest.isVisible()) {
                int y1 = this.hasStyle((byte)8) ? top2 + northGap : top;
                int y2 = this.hasStyle((byte)2) ? bottom2 - southGap : bottom;
                cWest.setBounds(left, y1, left2 - left, y2 - y1);
            }
            if (cEast != null && cEast.isVisible()) {
                int y1 = this.hasStyle((byte)4) ? top2 + northGap : top;
                int y2 = this.hasStyle((byte)1) ? bottom2 - southGap : bottom;
                cEast.setBounds(right2, y1, right - right2, y2 - y1);
            }
            if (isCenterVisible) {
                cCenter.setBounds(left2 + westGap, top2 + northGap, right2 - left2 - westGap - eastGap, bottom2 - top2 - northGap - southGap);
            }
        }
    }

    public static String getBorderLayoutEquivalent(Integer constraint) {
        return BORDERLAYOUT_EQUIV[constraint];
    }

    public static Integer reverseConstraint(Integer constraint) {
        switch (constraint) {
            case 1: {
                return SOUTH;
            }
            case 2: {
                return NORTH;
            }
            case 3: {
                return EAST;
            }
            case 4: {
                return WEST;
            }
        }
        return null;
    }

    public String toString() {
        return this.getClass().getName() + "[hgap=" + this._hgap + ",vgap=" + this._vgap + "]";
    }
}

