/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JToolTip;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.JWindow;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.TreePath;
import oracle.ide.resource.ExplorerArb;

public class KeyNavigationManager
implements MouseListener,
ComponentListener,
FocusListener {
    private static final boolean NEW_BEHAVIOR = true;
    private static final int X_TOOLTIP_PADDING = 5;
    private static final int Y_TOOLTIP_PADDING = 5;
    private static final int GOTO_PREV = -1;
    private static final int GOTO_NEXT = 0;
    private static final int GOTO_AFTER = 1;
    private StringBuffer _keys;
    private ArrayList _history;
    private JToolTip _tip;
    private JWindow _tipWindow;
    private KeyComponentAdapter _kca;

    private void $init$() {
        this._keys = new StringBuffer(50);
        this._history = new ArrayList(5);
    }

    public KeyNavigationManager() {
        this(null);
    }

    public KeyNavigationManager(KeyComponentAdapter kca) {
        this.$init$();
        this.setKeyComponentAdapter(kca);
    }

    public void setKeyComponentAdapter(KeyComponentAdapter kca) {
        JComponent jc;
        JComponent jc2;
        if (this._kca != null && (jc2 = this._kca.getComponent()) != null) {
            jc2.removeMouseListener(this);
        }
        this._kca = kca;
        if (this._kca != null && (jc = this._kca.getComponent()) != null) {
            jc.addMouseListener(this);
            if (jc instanceof JTree) {
                JTree tree = (JTree)jc;
                KeyListener[] listeners = (KeyListener[])jc.getListeners(KeyListener.class);
                int i = 0;
                while (i < listeners.length) {
                    KeyListener eventListener = listeners[i];
                    if (eventListener instanceof BasicTreeUI.KeyHandler) {
                        tree.removeKeyListener(eventListener);
                    }
                    ++i;
                }
            }
        }
    }

    public KeyComponentAdapter getKeyComponentAdapter() {
        return this._kca;
    }

    private boolean isVisible() {
        return this._tipWindow != null;
    }

    private void _updateLabel() {
        if (this._keys.length() > 0) {
            if (this._tip == null) {
                this._tip = new JToolTip();
            }
            this._tip.setTipText(ExplorerArb.format(2, this._keys.toString()));
            this._showWindow();
            this._tip.revalidate();
            if (this._tipWindow != null) {
                this._tipWindow.pack();
            }
        } else {
            this._hideWindow();
        }
    }

    private void _clearAll() {
        this._keys.setLength(0);
        this._history.clear();
        this._updateLabel();
    }

    private void _removeLast() {
        int len = this._keys.length() - 1;
        if (len >= 0) {
            this._keys.deleteCharAt(len);
            int nHistLen = this._history.size();
            if (nHistLen != 0) {
                Object sel = this._history.remove(nHistLen - 1);
                this._kca.setSelection(sel);
            }
            this._updateLabel();
        }
    }

    private void _addChar(char c) {
        this._keys.append(c);
        Object selSave = this._kca.getSelection();
        if (this._gotoMatch(0)) {
            this._updateLabel();
            this._history.add(selSave);
        } else {
            if (this._keys.toString().trim().length() > 0) {
                Toolkit.getDefaultToolkit().beep();
            }
            this._keys = this._keys.deleteCharAt(this._keys.length() - 1);
        }
    }

    private boolean _gotoMatch(int nDir) {
        Object selRow = this._kca.getSelection();
        int sel = this._kca.getRowPosition(selRow);
        int numRows = this._kca.getRowCount();
        int nRow = sel + numRows;
        int nInc = 1;
        switch (nDir) {
            case -1: {
                --nRow;
                nInc = -1;
                break;
            }
            case 0: {
                if (sel != -1) break;
                nRow = 0;
                break;
            }
            case 1: {
                ++nRow;
                break;
            }
        }
        boolean bRegExp = this._keys.charAt(0) == '*';
        String name = bRegExp ? this._keys.toString().substring(1) : this._keys.toString();
        int nameLen = name.length();
        int i = 0;
        while (i < numRows) {
            int j = nRow % numRows;
            Object row = this._kca.getRow(j);
            String rowName = this._kca.toString(row);
            if (bRegExp ? KeyNavigationManager._contains(rowName, name) : rowName.regionMatches(true, 0, name, 0, nameLen)) {
                this._kca.setSelection(row);
                return true;
            }
            nRow += nInc;
            ++i;
        }
        return false;
    }

    private static boolean _contains(String s, String sSub) {
        int n;
        int nLen = s.length();
        int nSubLen = sSub.length();
        int i = n = nLen - nSubLen;
        while (i >= 0) {
            if (s.regionMatches(true, i, sSub, 0, nSubLen)) {
                return true;
            }
            --i;
        }
        return false;
    }

    private void _hideWindow() {
        if (this._tipWindow != null) {
            this._tipWindow.setVisible(false);
            this._tipWindow.getOwner().removeComponentListener(this);
            this._tipWindow.dispose();
            this._tipWindow = null;
        }
        this._tip = null;
    }

    private void _showWindow() {
        if (this._tipWindow == null) {
            JComponent jc = this._kca.getComponent();
            jc.addFocusListener(this);
            Window parentWin = SwingUtilities.getWindowAncestor(jc);
            if (parentWin != null) {
                this._tipWindow = new JWindow(parentWin);
                parentWin.addComponentListener(this);
                this._tipWindow.getContentPane().add(this._tip);
                this._tipWindow.pack();
                this._updateWindowLocation();
                this._tipWindow.setVisible(true);
            }
        }
    }

    private void _updateWindowLocation() {
        if (this._tipWindow != null) {
            JComponent jc = this._kca.getComponent();
            Point pt = jc.getLocationOnScreen();
            Container c = jc.getParent();
            if (c instanceof JViewport) {
                Point viewPos = ((JViewport)c).getViewPosition();
                pt.x += viewPos.x;
                pt.y += viewPos.y;
            }
            int h = this._tipWindow.getHeight();
            int x = pt.x + 5;
            int y = pt.y - h + 5;
            this._tipWindow.setLocation(x, y);
        }
    }

    public void preProcessKeyEvent(KeyEvent e) {
        if (e.isConsumed()) {
            return;
        }
        switch (e.getID()) {
            case 401: {
                this.preKeyPressed(e);
                break;
            }
            case 400: {
                this.preKeyTyped(e);
                break;
            }
            case 402: {
                this.preKeyReleased(e);
                break;
            }
        }
    }

    public void postProcessKeyEvent(KeyEvent e) {
        if (e.isConsumed()) {
            return;
        }
        switch (e.getID()) {
            case 401: {
                this.postKeyPressed(e);
                break;
            }
            case 400: {
                this.postKeyTyped(e);
                break;
            }
            case 402: {
                this.postKeyReleased(e);
                break;
            }
        }
    }

    public void preKeyTyped(KeyEvent e) {
    }

    public void postKeyTyped(KeyEvent e) {
        char keyChar = e.getKeyChar();
        if (!(e.isAltDown() || e.isControlDown() || Character.isISOControl(keyChar))) {
            e.consume();
            this._addChar(keyChar);
        } else if (keyChar != '\b' && this._keys.length() > 0) {
            this._clearAll();
        }
    }

    public void preKeyPressed(KeyEvent e) {
        if (this.isVisible()) {
            int keyCode = e.getKeyCode();
            switch (keyCode) {
                case 27: {
                    e.consume();
                    this._clearAll();
                    break;
                }
                case 10: {
                    this._clearAll();
                    break;
                }
                case 37: 
                case 39: 
                case 226: 
                case 227: {
                    this._clearAll();
                    break;
                }
                case 38: 
                case 224: {
                    e.consume();
                    this._gotoMatch(-1);
                    break;
                }
                case 40: 
                case 225: {
                    e.consume();
                    this._gotoMatch(1);
                    break;
                }
                case 8: 
                case 127: {
                    e.consume();
                    this._removeLast();
                    break;
                }
            }
        }
    }

    public void postKeyPressed(KeyEvent e) {
    }

    public void preKeyReleased(KeyEvent e) {
    }

    public void postKeyReleased(KeyEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
        this._clearAll();
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void focusLost(FocusEvent e) {
        this._clearAll();
    }

    public void focusGained(FocusEvent e) {
    }

    public void componentResized(ComponentEvent e) {
        this._updateWindowLocation();
    }

    public void componentMoved(ComponentEvent e) {
        this._updateWindowLocation();
    }

    public void componentShown(ComponentEvent e) {
    }

    public void componentHidden(ComponentEvent e) {
    }

    public static JTree createNavigableTree() {
        return new 1();
    }

    public static interface KeyComponentAdapter {
        public JComponent getComponent();

        public int getRowCount();

        public Object getRow(int var1);

        public int getRowPosition(Object var1);

        public String toString(Object var1);

        public Object getSelection();

        public void setSelection(Object var1);
    }

    public static class TreeKeyAdapter
    implements KeyComponentAdapter {
        private JTree _tree;

        public TreeKeyAdapter(JTree tree) {
            this._tree = tree;
        }

        public JComponent getComponent() {
            return this._tree;
        }

        public int getRowCount() {
            return this._tree.getRowCount();
        }

        public Object getRow(int i) {
            TreePath path = this._tree.getPathForRow(i);
            return path;
        }

        public int getRowPosition(Object row) {
            TreePath path = (TreePath)row;
            return this._tree.getRowForPath(path);
        }

        public String toString(Object row) {
            TreePath path = (TreePath)row;
            return path.getLastPathComponent().toString();
        }

        public Object getSelection() {
            return this._tree.getSelectionPath();
        }

        public void setSelection(Object row) {
            TreePath path = (TreePath)row;
            this._tree.setSelectionPath(path);
            this._tree.scrollPathToVisible(path);
        }
    }

    public static class TableKeyAdapter
    implements KeyComponentAdapter {
        private JTable _table;

        public TableKeyAdapter(JTable table) {
            this._table = table;
        }

        public JComponent getComponent() {
            return this._table;
        }

        public int getRowCount() {
            return this._table.getRowCount();
        }

        public Object getRow(int i) {
            return i;
        }

        public int getRowPosition(Object row) {
            return (Integer)row;
        }

        public String toString(Object row) {
            int nRow = this.getRowPosition(row);
            int nCol = Math.max(this._table.getSelectedColumn(), 0);
            Object obj = this._table.getModel().getValueAt(nRow, nCol);
            return obj != null ? obj.toString() : "";
        }

        public Object getSelection() {
            return this._table.getSelectedRow();
        }

        public void setSelection(Object row) {
            int nRow = this.getRowPosition(row);
            Rectangle rect = this._table.getCellRect(nRow, 0, true);
            this._table.getSelectionModel().setSelectionInterval(nRow, nRow);
            this._table.scrollRectToVisible(rect);
        }
    }

    public static class ListKeyAdapter
    implements KeyComponentAdapter {
        private JList _list;

        public ListKeyAdapter(JList table) {
            this._list = table;
        }

        public JComponent getComponent() {
            return this._list;
        }

        public int getRowCount() {
            return this._list.getModel().getSize();
        }

        public Object getRow(int i) {
            return i;
        }

        public int getRowPosition(Object row) {
            return (Integer)row;
        }

        public String toString(Object row) {
            int nRow = this.getRowPosition(row);
            ListModel listModel = this._list.getModel();
            Object obj = listModel.getElementAt(nRow);
            return obj != null ? obj.toString() : "";
        }

        public Object getSelection() {
            ListSelectionModel selectionModel = this._list.getSelectionModel();
            int leadSelectionIndex = selectionModel.getLeadSelectionIndex();
            return leadSelectionIndex;
        }

        public void setSelection(Object row) {
            int nRow = this.getRowPosition(row);
            Rectangle rect = this._list.getCellBounds(nRow, nRow);
            this._list.getSelectionModel().setSelectionInterval(nRow, nRow);
            this._list.scrollRectToVisible(rect);
        }
    }

    static final class 1
    extends JTree {
        KeyNavigationManager knm;

        private void $init$() {
            this.knm = new KeyNavigationManager(new TreeKeyAdapter(this));
        }

        protected void processKeyEvent(KeyEvent e) {
            this.knm.preProcessKeyEvent(e);
            super.processKeyEvent(e);
            this.knm.postProcessKeyEvent(e);
        }

        public 1() {
            this.$init$();
        }
    }
}

