/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.EventObject;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import oracle.ide.controls.AbstractCellEditor;
import oracle.ide.controls.KeyNavigationManager;
import oracle.ide.controls.TreeTableModel;
import oracle.ide.controls.TreeTableModelAdapter;

public class JFastTreeTable
extends JTable {
    protected TreeTableCellRenderer tree;
    protected KeyNavigationManager _knm;
    protected int treeColumnModelIndex;
    static final /* synthetic */ boolean $assertionsDisabled;

    private void $init$() {
        this.treeColumnModelIndex = -1;
    }

    public JFastTreeTable(TreeTableModel treeTableModel) {
        this.$init$();
        int i = 0;
        while (i < treeTableModel.getColumnCount()) {
            if (treeTableModel.getColumnClass(i).isAssignableFrom(TreeTableModel.class)) {
                this.treeColumnModelIndex = i;
                break;
            }
            ++i;
        }
        this.tree = new TreeTableCellRenderer(treeTableModel);
        super.setModel(new TreeTableModelAdapter(treeTableModel, this.tree));
        ListToTreeSelectionModelWrapper selectionWrapper = new ListToTreeSelectionModelWrapper();
        this.tree.setSelectionModel(selectionWrapper);
        this.setSelectionModel(selectionWrapper.getListSelectionModel());
        this.setDefaultRenderer(TreeTableModel.class, this.tree);
        this.setDefaultEditor(TreeTableModel.class, new TreeTableCellEditor());
        this.setShowGrid(false);
        this.setIntercellSpacing(new Dimension(0, 0));
        if (this.tree.getRowHeight() < 1) {
            this.setRowHeight(18);
        } else {
            this.setRowHeight(this.getRowHeight());
        }
        this.addMouseListener(new 1());
    }

    public void paint(Graphics g) {
        int treeColumn;
        Rectangle clip = g.getClipBounds();
        Point point = new Point(clip.x, clip.y);
        int firstColumn = this.columnAtPoint(point);
        if (firstColumn == -1) {
            firstColumn = 0;
        }
        point.translate(clip.width - 1, clip.height - 1);
        int lastColumn = this.columnAtPoint(point);
        if (lastColumn == -1) {
            lastColumn = this.getColumnCount() - 1;
        }
        if ((treeColumn = this.getTreeColumn()) < firstColumn || treeColumn > lastColumn) {
            super.paint(g);
        } else {
            int[] selection;
            TableColumn draggedColumn;
            Rectangle treeBounds = this.getCellRect(0, treeColumn, false);
            treeBounds.y = clip.y;
            treeBounds.height = clip.height;
            JTableHeader header = this.getTableHeader();
            if (header != null && (draggedColumn = header.getDraggedColumn()) != null && this.isTreeColumn(draggedColumn)) {
                treeBounds.x += header.getDraggedDistance();
            }
            if (clip.x < treeBounds.x) {
                Rectangle r = new Rectangle(clip);
                r.width = treeBounds.x - clip.x;
                g.setClip(r);
                super.paint(g);
            }
            if (treeBounds.x + treeBounds.width < clip.x + clip.width) {
                Rectangle r = new Rectangle(clip);
                r.x = treeBounds.x + treeBounds.width;
                r.width = clip.x + clip.width - r.x;
                g.setClip(r);
                super.paint(g);
            }
            if ((selection = this.getSelectedRows()) != null && selection.length > 0) {
                Arrays.sort(selection);
                int y = clip.y;
                int i = 0;
                while (i < selection.length) {
                    Rectangle selectionBounds = this.getCellRect(selection[i], treeColumn, false);
                    selectionBounds.x = treeBounds.x;
                    Rectangle above = new Rectangle(treeBounds.x, y, treeBounds.width, selectionBounds.y - y);
                    if (above.intersects(clip)) {
                        this.tree.setBackground(this.getBackground());
                        Rectangle r = above.intersection(clip);
                        g.setClip(r);
                        this.tree.setBounds(above);
                        TreeTableCellRenderer.mav$paintFullColumn(this.tree, g, treeBounds.x);
                    }
                    if (selectionBounds.intersects(clip)) {
                        this.tree.setBackground(this.getSelectionBackground());
                        Rectangle r = selectionBounds.intersection(clip);
                        g.setClip(r);
                        this.tree.setBounds(selectionBounds);
                        TreeTableCellRenderer.mav$paintFullColumn(this.tree, g, treeBounds.x);
                    }
                    y = selectionBounds.y + selectionBounds.height;
                    ++i;
                }
                Rectangle below = new Rectangle(treeBounds.x, y, treeBounds.width, clip.y + clip.height - y);
                if (below.intersects(clip)) {
                    this.tree.setBackground(this.getBackground());
                    Rectangle r = below.intersection(clip);
                    g.setClip(r);
                    this.tree.setBounds(below);
                    TreeTableCellRenderer.mav$paintFullColumn(this.tree, g, treeBounds.x);
                }
                if (this.isEditing() && this.getEditingColumn() == treeColumn) {
                    int row = this.editingRow;
                    Rectangle editingCell = this.getCellRect(row, this.getEditingColumn(), false);
                    Rectangle r = editingCell.intersection(clip);
                    g.setClip(r);
                    super.paint(g);
                    Rectangle bounds = this.tree.getRowBounds(row);
                    editingCell.width = bounds.x;
                    r = editingCell.intersection(clip);
                    g.setClip(r);
                    this.tree.paint(g);
                }
            } else if (this.isEditing() && this.getEditingColumn() == treeColumn) {
                if (this.getCellEditor() == null) {
                    this.repaint(clip);
                } else {
                    int row = this.editingRow;
                    Rectangle editingCell = this.getCellRect(row, this.getEditingColumn(), false);
                    Rectangle r = editingCell.intersection(clip);
                    g.setClip(r);
                    super.paint(g);
                    Rectangle bounds = this.tree.getRowBounds(row);
                    editingCell.width = bounds.x;
                    r = editingCell.intersection(clip);
                    g.setClip(r);
                    this.tree.paint(g);
                }
            } else {
                this.tree.setBackground(this.getBackground());
                Rectangle r = treeBounds.intersection(clip);
                g.setClip(r);
                this.tree.setBounds(treeBounds);
                TreeTableCellRenderer.mav$paintFullColumn(this.tree, g, treeBounds.x);
            }
        }
    }

    protected void paintUnoptimized(Graphics g) {
        super.paint(g);
    }

    public void tableChanged(TableModelEvent e) {
        this.revalidate();
        super.tableChanged(e);
    }

    public void updateUI() {
        super.updateUI();
        if (this.tree != null) {
            this.tree.updateUI();
        }
        LookAndFeel.installColorsAndFont(this, "Tree.background", "Tree.foreground", "Tree.font");
    }

    public void setKeySearchNavigable(boolean bSet) {
        if (this._knm != null) {
            this._knm.setKeyComponentAdapter(null);
            this._knm = null;
        }
        if (bSet) {
            this._knm = new KeyNavigationManager(new KeyNavigationManager.TableKeyAdapter(this));
        }
    }

    public void setShowGrid(boolean showGrid) {
        if (this.tree != null) {
            this.tree.setShowGrid(showGrid);
        }
        super.setShowGrid(showGrid);
    }

    public int getEditingRow() {
        return this.isTreeColumn(this.editingColumn) ? -1 : this.editingRow;
    }

    public void setRowHeight(int rowHeight) {
        super.setRowHeight(rowHeight);
        if (this.tree != null && this.tree.getRowHeight() != rowHeight) {
            this.tree.setRowHeight(this.getRowHeight());
        }
    }

    public JTree getTree() {
        return this.tree;
    }

    public void scrollToVisible(int nRow, int nCol) {
        Rectangle rect = this.getCellRect(nRow, nCol, true);
        this.scrollRectToVisible(rect);
    }

    protected void processKeyEvent(KeyEvent e) {
        if (this._knm != null) {
            this._knm.preProcessKeyEvent(e);
        }
        if (!this.processTreeKey(e)) {
            super.processKeyEvent(e);
            if (this._knm != null) {
                this._knm.postProcessKeyEvent(e);
            }
        }
    }

    protected boolean processTreeKey(KeyEvent e) {
        if (!e.isConsumed() && e.getID() == 401 && this.isVisible()) {
            int keyCode = e.getKeyCode();
            boolean nomodifiers = (e.getModifiers() & 0xB) == 0;
            switch (keyCode) {
                case 37: {
                    int selectedColumn = this.getSelectedColumn();
                    if (!this.isTreeColumn(selectedColumn) || !nomodifiers) break;
                    int row = this.getSelectedRow();
                    if (row != -1) {
                        TreePath path = this.tree.getPathForRow(row);
                        Object lastPathComponent = path.getLastPathComponent();
                        if (this.tree.getModel().isLeaf(lastPathComponent)) {
                            this.moveSelectionToParent(path);
                        } else if (this.tree.isCollapsed(path)) {
                            this.moveSelectionToParent(path);
                        } else {
                            this.tree.collapsePath(path);
                            this.tree.setSelectionPath(path);
                            this.setColumnSelectionInterval(selectedColumn, selectedColumn);
                        }
                    }
                    e.consume();
                    return true;
                }
                case 39: {
                    int row;
                    int selectedColumn = this.getSelectedColumn();
                    if (!this.isTreeColumn(selectedColumn) || !nomodifiers || (row = this.getSelectedRow()) == -1) break;
                    TreePath path = this.tree.getPathForRow(row);
                    Object lastPathComponent = path.getLastPathComponent();
                    if (this.tree.getModel().isLeaf(lastPathComponent) || !this.tree.isCollapsed(path)) break;
                    this.tree.expandPath(path);
                    this.tree.setSelectionPath(path);
                    this.setColumnSelectionInterval(selectedColumn, selectedColumn);
                    e.consume();
                    return true;
                }
            }
        }
        return false;
    }

    private void moveSelectionToParent(TreePath path) {
        TreePath parentPath = path.getParentPath();
        if (parentPath != null && (this.tree.isRootVisible() || parentPath.getPathCount() != 1)) {
            int parentRow = this.tree.getRowForPath(parentPath);
            this.setRowSelectionInterval(parentRow, parentRow);
        }
    }

    static {
        $assertionsDisabled = JFastTreeTable.class.desiredAssertionStatus() ^ true;
    }

    private int getTreeColumn() {
        int column = this.convertColumnIndexToView(this.treeColumnModelIndex);
        if (!$assertionsDisabled && this.getColumnClass(column) != TreeTableModel.class) {
            throw new AssertionError();
        }
        return column;
    }

    private boolean isTreeColumn(TableColumn column) {
        boolean is;
        if (column == null) {
            return false;
        }
        boolean bl = is = column.getModelIndex() == this.treeColumnModelIndex;
        if (!$assertionsDisabled && is != (this.getModel().getColumnClass(column.getModelIndex()) == TreeTableModel.class)) {
            throw new AssertionError();
        }
        return is;
    }

    private boolean isTreeColumn(int viewColumn) {
        boolean is;
        if (viewColumn < 0) {
            return false;
        }
        boolean bl = is = this.getColumnModel().getColumn(viewColumn).getModelIndex() == this.treeColumnModelIndex;
        if (!$assertionsDisabled && is != (this.getColumnClass(viewColumn) == TreeTableModel.class)) {
            throw new AssertionError();
        }
        return is;
    }

    static int mav$getTreeColumn(JFastTreeTable jFastTreeTable) {
        return jFastTreeTable.getTreeColumn();
    }

    final class 1
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            if (!JFastTreeTable.this.isEditing()) {
                JFastTreeTable.this.requestFocus();
            }
        }
    }

    public class TreeTableCellRenderer
    extends JTree
    implements TableCellRenderer {
        protected JTable table;
        protected boolean hasFocus;
        protected boolean isSelected;
        protected int currentRow;
        protected int currentColumn;
        protected boolean showGrid;

        private void $init$() {
            this.showGrid = false;
        }

        public TreeTableCellRenderer(TreeModel model) {
            super(model);
            this.$init$();
            this.setFocusable(false);
        }

        public void updateUI() {
            super.updateUI();
            TreeCellRenderer tcr = this.getCellRenderer();
            if (tcr instanceof DefaultTreeCellRenderer) {
                DefaultTreeCellRenderer dtcr = (DefaultTreeCellRenderer)tcr;
                dtcr.setTextSelectionColor(UIManager.getColor("Table.selectionForeground"));
                dtcr.setBackgroundSelectionColor(UIManager.getColor("Table.selectionBackground"));
            }
        }

        public void setRowHeight(int rowHeight) {
            if (rowHeight > 0) {
                super.setRowHeight(rowHeight);
                if (JFastTreeTable.this != null && JFastTreeTable.this.getRowHeight() != rowHeight) {
                    JFastTreeTable.this.setRowHeight(this.getRowHeight());
                }
            }
        }

        public void setBounds(int x, int y, int w, int h) {
            super.setBounds(x, 0, w, JFastTreeTable.this.getHeight());
        }

        private void paintFullColumn(Graphics g, int xTranslate) {
            Graphics scratch = g.create();
            scratch.translate(xTranslate, 0);
            super.paint(scratch);
            if (JFastTreeTable.this.hasFocus() && JFastTreeTable.this.getColumnModel().getSelectionModel().getLeadSelectionIndex() == JFastTreeTable.this.treeColumnModelIndex) {
                this.paintFocus(JFastTreeTable.this, JFastTreeTable.this.getSelectionModel().getLeadSelectionIndex(), JFastTreeTable.this.treeColumnModelIndex, scratch);
            }
            scratch.dispose();
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setBackground(table.getBackground());
            }
            this.table = table;
            this.hasFocus = hasFocus;
            this.isSelected = isSelected;
            this.currentRow = row;
            this.currentColumn = column;
            return this;
        }

        public void paint(Graphics g) {
            g.translate(0, -this.currentRow * this.getRowHeight());
            super.paint(g);
            if (this.hasFocus) {
                this.paintFocus(this.table, this.currentRow, this.currentColumn, g);
            }
            if (this.showGrid) {
                Rectangle r = JFastTreeTable.this.getCellRect(this.currentRow, this.currentColumn, false);
                g.setColor(JFastTreeTable.this.getGridColor());
                g.drawRect(r.x - 1, r.y - 1, r.width, r.height);
            }
        }

        private void paintFocus(JTable table, int row, int column, Graphics g) {
            Border border = UIManager.getBorder("Table.focusCellHighlightBorder");
            if (border != null) {
                Rectangle focusBounds = JFastTreeTable.this.getCellRect(row, column, false);
                focusBounds.x = 0;
                if (table.getSelectionModel().isSelectedIndex(row) && table.getColumnModel().getSelectionModel().isSelectedIndex(column)) {
                    g.setColor(JFastTreeTable.this.getSelectionForeground());
                } else {
                    g.setColor(this.getForeground());
                }
                border.paintBorder(this, g, focusBounds.x, focusBounds.y, focusBounds.width, focusBounds.height);
            }
        }

        public String getToolTipText(MouseEvent event) {
            Point p = event.getPoint();
            p.translate(0, this.currentRow * this.getRowHeight());
            MouseEvent newEvent = new MouseEvent(this, event.getID(), event.getWhen(), event.getModifiers(), p.x, p.y, event.getClickCount(), event.isPopupTrigger());
            return super.getToolTipText(newEvent);
        }

        void setShowGrid(boolean showGrid) {
            this.showGrid = showGrid;
        }

        public AccessibleContext getAccessibleContext() {
            Accessible aChild;
            int count;
            AccessibleContext ac = super.getAccessibleContext();
            if (this.accessibleContext instanceof JTree.AccessibleJTree && (count = ac.getAccessibleChildrenCount()) == 1 && (aChild = ac.getAccessibleChild(0)) != null) {
                AccessibleContext acChild = aChild.getAccessibleContext();
                return acChild;
            }
            return ac;
        }

        static void mav$paintFullColumn(TreeTableCellRenderer treeTableCellRenderer, Graphics graphics, int n) {
            treeTableCellRenderer.paintFullColumn(graphics, n);
        }
    }

    public class TreeTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int r, int c) {
            return JFastTreeTable.this.tree;
        }

        public boolean isCellEditable(EventObject e) {
            int y;
            MouseEvent me;
            int x;
            if (e instanceof MouseEvent && JFastTreeTable.this.tree.getPathForLocation(x = (me = (MouseEvent)e).getX() - JFastTreeTable.this.getCellRect((int)0, (int)JFastTreeTable.mav$getTreeColumn((JFastTreeTable)JFastTreeTable.this), (boolean)true).x, y = me.getY()) == null) {
                JFastTreeTable.this.add(JFastTreeTable.this.tree);
                try {
                    JFastTreeTable.this.tree.dispatchEvent(new MouseEvent(JFastTreeTable.this.tree, me.getID(), me.getWhen(), me.getModifiers(), x, y, me.getClickCount(), me.isPopupTrigger()));
                    JFastTreeTable.this.tree.dispatchEvent(new MouseEvent(JFastTreeTable.this.tree, 502, me.getWhen(), me.getModifiers(), x, y, me.getClickCount(), me.isPopupTrigger()));
                }
                finally {
                    JFastTreeTable.this.remove(JFastTreeTable.this.tree);
                }
            }
            return false;
        }
    }

    class ListToTreeSelectionModelWrapper
    extends DefaultTreeSelectionModel {
        protected boolean updatingListSelectionModel;

        public ListToTreeSelectionModelWrapper() {
            this.getListSelectionModel().addListSelectionListener(this.createListSelectionListener());
        }

        ListSelectionModel getListSelectionModel() {
            return this.listSelectionModel;
        }

        public void resetRowSelection() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    super.resetRowSelection();
                }
                finally {
                    this.updatingListSelectionModel = false;
                }
            }
        }

        protected ListSelectionListener createListSelectionListener() {
            return new ListSelectionHandler();
        }

        protected void updateSelectedPathsFromSelectedRows() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    int min = this.listSelectionModel.getMinSelectionIndex();
                    int max = this.listSelectionModel.getMaxSelectionIndex();
                    this.clearSelection();
                    if (min != -1 && max != -1) {
                        int row = min;
                        while (row <= max) {
                            TreePath selPath;
                            if (this.listSelectionModel.isSelectedIndex(row) && (selPath = JFastTreeTable.this.tree.getPathForRow(row)) != null) {
                                this.addSelectionPath(selPath);
                            }
                            ++row;
                        }
                    }
                }
                finally {
                    this.updatingListSelectionModel = false;
                }
            }
        }

        class ListSelectionHandler
        implements ListSelectionListener {
            public void valueChanged(ListSelectionEvent e) {
                ListToTreeSelectionModelWrapper.this.updateSelectedPathsFromSelectedRows();
            }

            ListSelectionHandler() {
            }
        }
    }
}

