/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.ide.controls.GridBagConstants;

public class JComboCardPanel
extends JPanel
implements GridBagConstants {
    private final JPanel _titlePanel;
    private final JPanel _cardPanel;
    private final ComboCardLayout _cardLayout;
    private int _curIndex;

    private void $init$() {
        this._titlePanel = new JPanel();
        this._cardPanel = new JPanel();
    }

    public JComboCardPanel(JLabel label, JComponent comboBox) {
        this.$init$();
        if (comboBox == null) {
            throw new IllegalArgumentException("Combo box must not be null.");
        }
        this._titlePanel.setLayout(new GridBagLayout());
        if (label != null) {
            this._titlePanel.add((Component)label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        }
        this._titlePanel.add((Component)comboBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        int labelHeight = JComboCardPanel.getJComponentHeight(label);
        int comboBoxHeight = JComboCardPanel.getJComponentHeight(comboBox);
        int topInset = Math.max(labelHeight, comboBoxHeight) / 2;
        if (labelHeight < comboBoxHeight && labelHeight % 2 == 1 && comboBoxHeight % 2 == 0) {
            --topInset;
        }
        this._cardLayout = new ComboCardLayout(topInset, 0, 0, 0);
        this._cardPanel.setLayout(this._cardLayout);
        this._cardPanel.setBorder(BorderFactory.createEtchedBorder(1));
        this.setLayout(new GridBagLayout());
        this.add((Component)this._titlePanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 10, 0, 0), 0, 0));
        this.add((Component)this._cardPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(topInset, 0, 0, 0), 0, 0));
    }

    public void showSubPanel(JComponent subPanel) {
        Object key = subPanel.getClientProperty("combo-card-panel-key");
        if (key == null) {
            key = this._curIndex++;
            subPanel.putClientProperty("combo-card-panel-key", key);
            this._cardPanel.add((Component)subPanel, key.toString());
        }
        this._cardLayout.show(this._cardPanel, key.toString());
    }

    public static int getJComponentHeight(JComponent comp) {
        Dimension dim;
        if (comp != null && (dim = comp.getPreferredSize()) != null) {
            return dim.height;
        }
        return 0;
    }

    private static class ComboCardLayout
    extends CardLayout {
        private final int _topInset;
        private final int _leftInset;
        private final int _bottomInset;
        private final int _rightInset;

        ComboCardLayout(int topInset, int leftInset, int bottomInset, int rightInset) {
            super((leftInset + rightInset) / 2, (topInset + bottomInset) / 2);
            this._topInset = topInset;
            this._leftInset = leftInset;
            this._bottomInset = bottomInset;
            this._rightInset = rightInset;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void layoutContainer(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Insets insets = parent.getInsets();
                int ncomponents = parent.getComponentCount();
                int i = 0;
                while (i < ncomponents) {
                    Component comp = parent.getComponent(i);
                    if (comp.isVisible()) {
                        comp.setBounds(this._leftInset + insets.left, this._topInset + insets.top, parent.getWidth() - (this._leftInset + this._rightInset + insets.left + insets.right), parent.getHeight() - (this._topInset + this._bottomInset + insets.top + insets.bottom));
                    }
                    ++i;
                }
            }
        }
    }
}

